/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.core;

import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.algo.AlgoException;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.DataSetX;
import kd.bos.algox.core.AbstractDataSetX;
import kd.bos.algox.core.JobContext;

public class AddFieldsDataSetX
extends AbstractDataSetX {
    private Field[] fields;
    private Object[] values;

    public AddFieldsDataSetX(JobContext context, DataSetX source, Field[] fields, Object[] values) {
        super(context, source);
        this.fields = fields;
        this.values = values;
    }

    public Field[] getAddFields() {
        return this.fields;
    }

    public Object[] getValues() {
        return this.values;
    }

    @Override
    protected RowMeta createRowMeta() {
        RowMeta rowMeta = ((AbstractDataSetX)this.getSource()).getRowMeta();
        if (this.fields.length != this.values.length) {
            throw new AlgoException("fields length (" + this.fields.length + ") must equals values length(" + this.values.length + ")");
        }
        ArrayList<Field> fieldList = new ArrayList<Field>();
        HashSet<String> orginalFieldNames = new HashSet<String>();
        for (Field field : rowMeta.getFields()) {
            fieldList.add(field);
            orginalFieldNames.add(field.getName());
        }
        for (Field field : this.fields) {
            if (orginalFieldNames.contains(field.getName())) {
                throw new AlgoException("the field already exists:" + field.getName());
            }
            fieldList.add(field);
        }
        return new RowMeta(fieldList.toArray(new Field[0]));
    }
}

