/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.core;

import java.util.HashSet;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.ExprParser;
import kd.bos.algo.sql.resolve.ColumnAliasTransformer;
import kd.bos.algo.sql.tree.Alias;
import kd.bos.algo.sql.tree.Expr;
import kd.bos.algo.sql.tree.bind.ColumnRef;
import kd.bos.algox.DataSetX;
import kd.bos.algox.core.AbstractDataSetX;
import kd.bos.algox.core.JobContext;

public class SelectDataSetX
extends AbstractDataSetX {
    private String[] fields;

    public SelectDataSetX(JobContext context, DataSetX source, String[] fields) {
        super(context, source);
        this.fields = fields;
    }

    public String[] getFields() {
        return this.fields;
    }

    @Override
    protected RowMeta createRowMeta() {
        RowMeta rowMeta = ((AbstractDataSetX)this.getSource()).getRowMeta();
        ExprParser executor = new ExprParser(rowMeta);
        Expr[] exprs = new Expr[this.fields.length];
        for (int i = 0; i < this.fields.length; ++i) {
            exprs[i] = executor.parse(this.fields[i]);
        }
        Field[] targetFields = new Field[this.fields.length];
        String[] fieldRefs = new String[this.fields.length];
        Alias[] newExprs = new Alias[this.fields.length];
        boolean hasExpr = false;
        for (int i = 0; i < this.fields.length; ++i) {
            Expr ex = exprs[i];
            newExprs[i] = (Alias)ex.resolve(ColumnAliasTransformer.instance);
            Expr child = newExprs[i].getChild();
            if (child instanceof ColumnRef) {
                fieldRefs[i] = ((ColumnRef)child).getName();
            } else {
                hasExpr = true;
            }
            DataType dataType = ex.getDataType();
            targetFields[i] = new Field(newExprs[i].getAlias(), dataType);
        }
        if (hasExpr) {
            throw new AlgoException("Algox don't support expression in select(), only field reference supported.");
        }
        this.checkDuplicateName(targetFields);
        return new RowMeta(targetFields);
    }

    private void checkDuplicateName(Field[] targetFields) {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < targetFields.length; ++i) {
            if (set.add(targetFields[i].getAlias())) continue;
            throw new AlgoException("Duplicated field alias: " + targetFields[i].getAlias());
        }
    }
}

