/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.cube.local;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.util.Aggregator;
import kd.bos.algo.util.bitset.BitSetFactory;
import kd.bos.algo.util.bitset.IntBitSet;
import kd.bos.algox.cube.Cube;
import kd.bos.algox.cube.CubeMeta;
import kd.bos.algox.cube.CubeRow;
import kd.bos.algox.cube.CubeSet;
import kd.bos.algox.cube.DimUsage;
import kd.bos.algox.cube.Dimension;
import kd.bos.algox.cube.MeasureMeta;
import kd.bos.algox.cube.Member;
import kd.bos.algox.cube.a.ArrayCubeRow;
import kd.bos.algox.cube.a.MemberContext;
import kd.bos.algox.cube.local.MemCubeSetBuilder;

public class MemCubeEngine0 {
    private final Cube cube;
    private DataSet dataSet;
    private final RowMeta rowMeta;
    private final CubeMeta cubeMeta;
    private final Dimension[] dimensions;
    private final DimUsage[] dimUsages;
    private final MeasureMeta[] measureMetas;
    private final int[] dimFieldIndexInDataSets;
    private final int[] measureFieldIndexInDataSets;
    private final int dimCount;
    private final int measureCount;
    private final IntBitSet[] memberHasDataBitSets;
    private final Aggregator[] aggregators;
    private int pkIdNotFoundCount = 0;
    private int memberNotFoundCount = 0;
    private int ignoreRowCount = 0;
    private boolean throwExceptionWhenMemberNotFound = false;
    private boolean throwExceptionWhenPkIdNotFound = false;
    private CubeData cubeData;

    public MemCubeEngine0(Cube cube, DataSet dataSet) {
        int i;
        this.cube = cube;
        this.dataSet = dataSet;
        this.cubeMeta = cube.getMeta();
        this.dimUsages = this.cubeMeta.getDimUsages();
        this.rowMeta = dataSet.getRowMeta();
        this.measureMetas = this.cubeMeta.getMeasures();
        this.dimCount = this.dimUsages.length;
        this.measureCount = this.measureMetas.length;
        this.dimensions = new Dimension[this.dimCount];
        this.memberHasDataBitSets = new IntBitSet[this.dimCount];
        this.dimFieldIndexInDataSets = new int[this.dimCount];
        this.measureFieldIndexInDataSets = new int[this.measureCount];
        this.aggregators = new Aggregator[this.measureCount];
        for (i = 0; i < this.dimCount; ++i) {
            this.dimensions[i] = cube.getDimension(this.dimUsages[i].getDimId());
            this.memberHasDataBitSets[i] = this.createIntBitSet();
            this.dimFieldIndexInDataSets[i] = this.rowMeta.getFieldIndex(this.dimUsages[i].getField());
        }
        for (i = 0; i < this.measureCount; ++i) {
            this.measureFieldIndexInDataSets[i] = this.rowMeta.getFieldIndex(this.measureMetas[i].getField());
            this.aggregators[i] = Aggregator.getAggregator(this.measureMetas[i].getFunc());
        }
    }

    private IntBitSet createIntBitSet() {
        return BitSetFactory.createInt();
    }

    public void build() {
        Iterable<Row> iterable = null;
        ArrayList<CubeData> cubeDataList = new ArrayList<CubeData>();
        while ((iterable = this.nextIterable(this.dataSet)) != null) {
            cubeDataList.add(this.build(iterable));
        }
        this.cubeData = (CubeData)cubeDataList.get(0);
        this.finish();
    }

    private CubeData createCubeData() {
        return new SimpleCubeData();
    }

    private Iterable<Row> nextIterable(DataSet dataSet) {
        if (dataSet.hasNext()) {
            return dataSet;
        }
        return null;
    }

    private CubeData build(Iterable<Row> iterable) {
        CubeData cubeData = this.createCubeData();
        for (Row row : iterable) {
            this.appendRow(cubeData, row);
        }
        cubeData.finish();
        return cubeData;
    }

    private void appendRow(CubeData cubeData, Row row) {
        int i;
        Member[] members = new Member[this.dimCount];
        for (i = 0; i < this.dimCount; ++i) {
            Object pkId = row.get(this.dimFieldIndexInDataSets[i]);
            if (pkId == null) {
                this.pkIdIsNull(i, pkId);
                ++this.ignoreRowCount;
                return;
            }
            members[i] = this.lookupMember(i, pkId);
            if (members[i] != null) continue;
            ++this.ignoreRowCount;
            return;
        }
        for (i = 0; i < this.dimCount; ++i) {
            this.memberHasDataBitSets[i].set(members[i].getGlobalOrder());
        }
        Object[] values = new Object[this.measureCount];
        for (int i2 = 0; i2 < this.measureCount; ++i2) {
            values[i2] = row.get(this.measureFieldIndexInDataSets[i2]);
        }
        this.addRowData(cubeData, members, values);
    }

    private void addRowData(CubeData cubeData, Member[] members, Object[] values) {
        cubeData.addRowData(members, values);
    }

    private Member lookupMember(int dimIndex, Object pkId) {
        Member member;
        if (pkId == null) {
            this.pkIdIsNull(dimIndex, pkId);
        }
        if ((member = this.dimensions[dimIndex].getMember(pkId)) == null) {
            this.memberIsNull(dimIndex, pkId);
        }
        return member;
    }

    private void pkIdIsNull(int dimIndex, Object pkId) {
        if (this.throwExceptionWhenPkIdNotFound) {
            throw new AlgoException("Value of " + this.dimUsages[dimIndex].getField() + " is null in dimension " + this.dimUsages[dimIndex].getDimId() + ".");
        }
        ++this.pkIdNotFoundCount;
    }

    private void memberIsNull(int dimIndex, Object pkId) {
        if (this.throwExceptionWhenMemberNotFound) {
            throw new AlgoException("Value " + pkId + "of " + this.dimUsages[dimIndex].getField() + " not found in dimension " + this.dimUsages[dimIndex].getDimId() + ".");
        }
        ++this.memberNotFoundCount;
    }

    private void finish() {
    }

    public CubeSet toCubeSet() {
        MemCubeSetBuilder builder = new MemCubeSetBuilder(this.cubeMeta);
        Iterator<CubeRow> iter = this.createIterator();
        while (iter.hasNext()) {
            builder.addCubeRow(iter.next());
        }
        return builder.build();
    }

    private Iterator<CubeRow> createIterator() {
        final Scan scan = new Scan();
        return new Iterator<CubeRow>(){
            CubeRow row = null;
            boolean got = false;

            @Override
            public boolean hasNext() {
                if (!this.got) {
                    this.getOne();
                }
                return this.row != null;
            }

            @Override
            public CubeRow next() {
                if (!this.got) {
                    this.getOne();
                }
                if (this.row == null) {
                    throw new AlgoException("Eof of CubeSet");
                }
                CubeRow r = this.row;
                this.got = false;
                this.row = null;
                return r;
            }

            private void getOne() {
                this.row = scan.next();
                this.got = true;
            }
        };
    }

    class SimpleCubeData
    implements CubeData {
        HashMap<MemberContext, Object[]> valueMap = new HashMap();
        HashMap<MemberContext, Object[]> rollupValueMap = new HashMap();

        SimpleCubeData() {
        }

        @Override
        public void addRowData(Member[] members, Object[] values) {
            MemberContext context = new MemberContext(members);
            Object[] aggValues = this.valueMap.get(context);
            if (aggValues == null) {
                aggValues = new Object[values.length];
                for (int i = 0; i < aggValues.length; ++i) {
                    aggValues[i] = MemCubeEngine0.this.aggregators[i].appendValue(null, values[i]);
                }
                this.valueMap.put(context, aggValues);
            } else {
                for (int i = 0; i < aggValues.length; ++i) {
                    aggValues[i] = MemCubeEngine0.this.aggregators[i].appendValue(aggValues[i], values[i]);
                }
            }
            this.rollupParent(members, values);
            this.rollupTotal(members, values);
        }

        @Override
        public void finish() {
        }

        private void rollupParent(Member[] members, Object[] values) {
            HashSet<MemberContext> excludeMap = new HashSet<MemberContext>();
            Object parentId = null;
            Member parentMember = null;
            for (int i = members.length - 1; i >= 0; --i) {
                parentId = members[i].getParentId();
                if (parentId != null) {
                    parentMember = MemCubeEngine0.this.dimensions[i].getMember(parentId);
                }
                if (parentMember == null) continue;
                Member[] tempMembers = new Member[members.length];
                System.arraycopy(members, 0, tempMembers, 0, members.length);
                tempMembers[i] = parentMember;
                MemCubeEngine0.this.memberHasDataBitSets[i].set(parentMember.getGlobalOrder());
                this._rollupParent(tempMembers, values, excludeMap);
            }
        }

        private void rollupTotal(Member[] members, Object[] values) {
            members = Arrays.copyOf(members, members.length);
            for (int i = members.length - 1; i >= 0; --i) {
                Member parentMember;
                members[i] = parentMember = MemCubeEngine0.this.dimensions[i].getTotalMember();
                Member[] tempMembers = Arrays.copyOf(members, members.length);
                this._rollupTotal(tempMembers, values);
            }
        }

        private void _rollupTotal(Member[] members, Object[] values) {
            MemberContext context = new MemberContext(members);
            Object[] aggValues = this.rollupValueMap.get(context);
            if (aggValues == null) {
                aggValues = new Object[values.length];
                for (int i = 0; i < aggValues.length; ++i) {
                    aggValues[i] = MemCubeEngine0.this.aggregators[i].appendValue(null, values[i]);
                }
                this.rollupValueMap.put(context, aggValues);
            } else {
                for (int i = 0; i < aggValues.length; ++i) {
                    aggValues[i] = MemCubeEngine0.this.aggregators[i].appendValue(aggValues[i], values[i]);
                }
            }
        }

        private void _rollupParent(Member[] members, Object[] values, HashSet<MemberContext> excludeMap) {
            int i;
            MemberContext context = new MemberContext(members);
            if (!excludeMap.add(context)) {
                return;
            }
            Object[] aggValues = this.rollupValueMap.get(context);
            if (aggValues == null) {
                aggValues = new Object[values.length];
                for (i = 0; i < aggValues.length; ++i) {
                    aggValues[i] = MemCubeEngine0.this.aggregators[i].appendValue(null, values[i]);
                }
                this.rollupValueMap.put(context, aggValues);
            } else {
                for (i = 0; i < aggValues.length; ++i) {
                    aggValues[i] = MemCubeEngine0.this.aggregators[i].appendValue(aggValues[i], values[i]);
                }
            }
            Object parentId = null;
            Member parentMember = null;
            for (int i2 = 0; i2 < members.length; ++i2) {
                parentId = members[i2].getParentId();
                if (parentId != null) {
                    parentMember = MemCubeEngine0.this.dimensions[i2].getMember(members[i2]);
                }
                if (parentMember == null) continue;
                Member[] tempMembers = new Member[members.length];
                System.arraycopy(members, 0, tempMembers, 0, members.length);
                tempMembers[i2] = parentMember;
                MemCubeEngine0.this.memberHasDataBitSets[i2].set(parentMember.getGlobalOrder());
                this._rollupParent(tempMembers, values, excludeMap);
            }
        }

        @Override
        public Object[] getData(Member[] members) {
            MemberContext context = new MemberContext(members);
            Object[] values = this.rollupValueMap.get(context);
            if (values == null) {
                values = this.valueMap.get(context);
            }
            return values;
        }
    }

    static interface CubeData {
        public void addRowData(Member[] var1, Object[] var2);

        public Object[] getData(Member[] var1);

        public void finish();
    }

    class Vector {
        private Iterator<Member> iter;
        Supplier<Iterator<Member>> iterProvider;
        Vector nextVector;

        Vector() {
        }

        Iterator<Member> getIterator(boolean create) {
            if (create && (this.iter == null || !this.iter.hasNext())) {
                this.iter = this.iterProvider.get();
            }
            return this.iter;
        }
    }

    private class Scan {
        ArrayList<Vector> vectors = new ArrayList();
        Member[] currentMembers;
        Object[] currentValues;
        boolean first;
        int n = MemCubeEngine0.access$000(MemCubeEngine0.this).length;
        boolean eof = false;

        public Scan() {
            for (int i = 0; i < this.n; ++i) {
                Vector v = new Vector();
                this.vectors.add(v);
                final int index = i;
                v.iterProvider = new Supplier<Iterator<Member>>(){

                    @Override
                    public Iterator<Member> get() {
                        return MemCubeEngine0.this.dimensions[index].createMemberIterator(MemCubeEngine0.this.dimUsages[index].isShowTotal(), true, new Predicate<Member>(){

                            @Override
                            public boolean test(Member t) {
                                return MemCubeEngine0.this.memberHasDataBitSets[index].get(t.getGlobalOrder());
                            }
                        });
                    }
                };
                if (i <= 0) continue;
                this.vectors.get((int)(i - 1)).nextVector = v;
            }
            this.first = true;
        }

        private void moveNextMembers() {
            if (this.first) {
                this.first = false;
                this.currentMembers = new Member[this.n];
                for (int i = 0; i < this.n; ++i) {
                    Iterator<Member> iter = this.vectors.get(i).getIterator(true);
                    if (!iter.hasNext()) continue;
                    this.currentMembers[i] = iter.next();
                }
                if (this.checkAvailable()) {
                    return;
                }
            }
            this.seekAvailable();
        }

        private void seekAvailable() {
            int probeCol = this.n - 1;
            while (probeCol >= 0) {
                Member next;
                boolean hasNext = this.vectors.get(probeCol).getIterator(false).hasNext();
                if (!hasNext) {
                    if (probeCol > 0) {
                        --probeCol;
                        continue;
                    }
                    this.eof = true;
                    return;
                }
                this.currentMembers[probeCol] = next = this.vectors.get(probeCol).getIterator(false).next();
                for (int i = probeCol + 1; i < this.n; ++i) {
                    this.currentMembers[i] = this.vectors.get(i).getIterator(true).next();
                }
                if (this.checkAvailable()) {
                    return;
                }
                probeCol = this.n - 1;
            }
        }

        boolean checkAvailable() {
            this.currentValues = MemCubeEngine0.this.cubeData.getData(this.currentMembers);
            return this.currentValues != null;
        }

        public ArrayCubeRow next() {
            this.moveNextMembers();
            if (this.eof) {
                return null;
            }
            Member[] members = Arrays.copyOf(this.currentMembers, this.n);
            return new ArrayCubeRow(members, this.currentValues);
        }
    }
}

