/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.datachannel;

import java.util.HashMap;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoException;
import kd.bos.algo.DataSet;
import kd.bos.algox.datachannel.AbstractChannelFactory;
import kd.bos.algox.datachannel.ChannelDataSetOutput;
import kd.bos.algox.datachannel.ChannelFactory;
import kd.bos.algox.datachannel.ChannelInput;
import kd.bos.algox.datachannel.ChannelInputDataSet;
import kd.bos.algox.datachannel.ChannelRowOutput;
import kd.bos.algox.datachannel.TypedIdSerde;
import kd.bos.algox.datachannel.cacheadapter.CacheAdapterChannelFactory;
import kd.bos.algox.datachannel.mem.MemChannelFactory;

public class DataChannels {
    private static HashMap<String, ChannelFactory> factors = new HashMap();
    private static AbstractChannelFactory defaultChannelFactory = new CacheAdapterChannelFactory();
    private static MemChannelFactory memChannelFactory;

    private static void registerChannelFactory(AbstractChannelFactory factory) {
        factors.put(factory.getType(), factory);
    }

    private static ChannelFactory getChannelFactory() {
        return defaultChannelFactory;
    }

    private static ChannelFactory getChannelFactory(String type) {
        if (type == null) {
            return defaultChannelFactory;
        }
        ChannelFactory factory = factors.get(type);
        if (factory == null) {
            throw new AlgoException("Unknow channel factory type:" + type);
        }
        return factory;
    }

    public static ChannelFactory getMemChannelFactory() {
        return memChannelFactory;
    }

    public static String createMemChannelId() {
        return memChannelFactory.createChannelId();
    }

    public static String createChannelId() {
        return DataChannels.getChannelFactory().createChannelId();
    }

    public static ChannelDataSetOutput createChannelDataSetOutput(String channelId) {
        String type = TypedIdSerde.decodeType(channelId);
        return DataChannels.getChannelFactory(type).createChannelDataSetOutput(channelId);
    }

    public static ChannelRowOutput createChannelRowOutput(String channelId) {
        String type = TypedIdSerde.decodeType(channelId);
        return DataChannels.getChannelFactory(type).createChannelRowOutput(channelId);
    }

    public static ChannelInput openChannelInput(String channelId) {
        String type = TypedIdSerde.decodeType(channelId);
        return DataChannels.getChannelFactory(type).openChannelInput(channelId);
    }

    public static String writeDataSet(DataSet dataSet) {
        String channelId = DataChannels.createChannelId();
        ChannelDataSetOutput output = DataChannels.createChannelDataSetOutput(channelId);
        output.open(dataSet.getRowMeta());
        output.write(dataSet);
        output.close();
        return channelId;
    }

    public static String writeDataSetToMem(DataSet dataSet) {
        String channelId = DataChannels.createMemChannelId();
        ChannelDataSetOutput output = memChannelFactory.createChannelDataSetOutput(channelId);
        output.open(dataSet.getRowMeta());
        output.write(dataSet);
        output.close();
        return channelId;
    }

    public static String writeDataSet(String channelId, DataSet dataSet) {
        ChannelDataSetOutput output = DataChannels.createChannelDataSetOutput(channelId);
        output.open(dataSet.getRowMeta());
        output.write(dataSet);
        output.close();
        return channelId;
    }

    public static DataSet readDataSet(String algoKey, String channelId) {
        ChannelInput input = DataChannels.openChannelInput(channelId);
        input.open();
        return new ChannelInputDataSet(Algo.create(algoKey), input);
    }

    public static String toDataSetCacheId(String channelId) {
        String type = TypedIdSerde.decodeType(channelId);
        return DataChannels.getChannelFactory(type).getInnerId(channelId);
    }

    static {
        DataChannels.registerChannelFactory(defaultChannelFactory);
        memChannelFactory = new MemChannelFactory();
        DataChannels.registerChannelFactory(memChannelFactory);
    }
}

