/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.datachannel.cacheadapter;

import kd.bos.algo.AlgoException;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.cache.CachedDataSetBuilder;
import kd.bos.algox.datachannel.ChannelDataSetOutput;
import kd.bos.algox.datachannel.ChannelRowOutput;

public class CacheAdapterOutput
implements ChannelDataSetOutput,
ChannelRowOutput {
    CachedDataSet.Builder builder;
    private String cacheId;
    private String storageType;

    public CacheAdapterOutput(String cacheId) {
        this.cacheId = cacheId;
    }

    public CacheAdapterOutput(String cacheId, String storageType) {
        this.cacheId = cacheId;
        this.storageType = storageType;
    }

    private CacheHint getCacheHint() {
        CacheHint hint = CacheHint.getDefault();
        hint.setCacheId(this.cacheId);
        if (this.storageType != null) {
            hint.setStorageType(this.storageType);
        }
        return hint;
    }

    @Override
    public void open(RowMeta rowMeta) {
        this.builder = new CachedDataSetBuilder(rowMeta, this.getCacheHint());
    }

    @Override
    public void write(DataSet dataSet) {
        if (this.builder == null) {
            throw new AlgoException("Channel output must call open(RowMeta rowMeta) before write rows.");
        }
        for (Row row : dataSet) {
            this.builder.append(row);
        }
    }

    @Override
    public void close() {
        CachedDataSet cds = this.builder.build();
        this.cacheId = cds.getCacheId();
    }

    @Override
    public String getId() {
        return this.cacheId;
    }

    @Override
    public void write(Row row) {
        this.builder.append(row);
    }
}

