/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.type;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.List;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.algox.RowX;
import kd.bos.algox.flink.type.NullMaskUtils;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompatibilityResult;
import org.apache.flink.api.common.typeutils.CompatibilityUtil;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.TypeDeserializerAdapter;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.UnloadableDummyTypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;

@Internal
public final class RowXSerializer
extends TypeSerializer<RowX> {
    private static final long serialVersionUID = 1L;
    private final TypeSerializer<Object>[] fieldSerializers;
    private final int arity;
    private transient boolean[] nullMask;
    private RowMeta rowMeta;
    private DataType[] dataTypes;
    private boolean convertValue;

    public RowXSerializer(TypeSerializer<?>[] fieldSerializers) {
        this(null, fieldSerializers, false);
    }

    public RowXSerializer(RowMeta rowMeta, TypeSerializer<?>[] fieldSerializers) {
        this(rowMeta, fieldSerializers, true);
    }

    public RowXSerializer(RowMeta rowMeta, TypeSerializer<?>[] fieldSerializers, boolean convertValue) {
        this.convertValue = convertValue;
        this.fieldSerializers = (TypeSerializer[])Preconditions.checkNotNull(fieldSerializers);
        this.arity = fieldSerializers.length;
        this.nullMask = new boolean[fieldSerializers.length];
        this.rowMeta = rowMeta;
        if (rowMeta != null) {
            this.dataTypes = rowMeta.getDataTypes();
        }
    }

    public boolean isImmutableType() {
        return false;
    }

    public TypeSerializer<RowX> duplicate() {
        TypeSerializer[] duplicateFieldSerializers = new TypeSerializer[this.fieldSerializers.length];
        for (int i = 0; i < this.fieldSerializers.length; ++i) {
            duplicateFieldSerializers[i] = this.fieldSerializers[i].duplicate();
        }
        return new RowXSerializer(this.rowMeta, duplicateFieldSerializers, this.convertValue);
    }

    public RowX createInstance() {
        return new RowX(this.fieldSerializers.length);
    }

    public RowX copy(RowX from) {
        int len = this.fieldSerializers.length;
        if (from.size() != len) {
            throw new RuntimeException("RowX arity of from does not match serializers.");
        }
        RowX result = new RowX(len);
        for (int i = 0; i < len; ++i) {
            Object fromField = from.get(i);
            if (fromField != null) {
                Object copy = this.fieldSerializers[i].copy(fromField);
                result.set(i, copy);
                continue;
            }
            result.set(i, null);
        }
        return result;
    }

    public RowX copy(RowX from, RowX reuse) {
        int len = this.fieldSerializers.length;
        if (reuse == null) {
            return this.copy(from);
        }
        if (from.size() != len || reuse.size() != len) {
            throw new RuntimeException("RowX arity of reuse or from is incompatible with this RowSerializer.");
        }
        for (int i = 0; i < len; ++i) {
            Object fromField = from.get(i);
            if (fromField != null) {
                Object copy;
                Object reuseField = reuse.get(i);
                if (reuseField != null) {
                    copy = this.fieldSerializers[i].copy(fromField, reuseField);
                    reuse.set(i, copy);
                    continue;
                }
                copy = this.fieldSerializers[i].copy(fromField);
                reuse.set(i, copy);
                continue;
            }
            reuse.set(i, null);
        }
        return reuse;
    }

    public int getLength() {
        return -1;
    }

    public int size() {
        return this.arity;
    }

    public void serialize(RowX record, DataOutputView target) throws IOException {
        int len = this.fieldSerializers.length;
        if (record.size() != len) {
            throw new RuntimeException("RowX arity of from does not match serializers.");
        }
        NullMaskUtils.writeNullMask(len, record, target);
        for (int i = 0; i < len; ++i) {
            Object o = record.get(i);
            if (o == null) continue;
            if (this.convertValue && this.dataTypes != null) {
                o = DataType.convertValue(this.dataTypes[i], o);
            }
            this.fieldSerializers[i].serialize(o, target);
        }
    }

    public RowX deserialize(DataInputView source) throws IOException {
        int len = this.fieldSerializers.length;
        RowX result = new RowX(len);
        NullMaskUtils.readIntoNullMask(len, source, this.nullMask);
        for (int i = 0; i < len; ++i) {
            if (this.nullMask[i]) {
                result.set(i, null);
                continue;
            }
            result.set(i, this.fieldSerializers[i].deserialize(source));
        }
        return result;
    }

    public RowX deserialize(RowX reuse, DataInputView source) throws IOException {
        int len = this.fieldSerializers.length;
        if (reuse.size() != len) {
            throw new RuntimeException("RowX arity of from does not match serializers.");
        }
        NullMaskUtils.readIntoNullMask(len, source, this.nullMask);
        for (int i = 0; i < len; ++i) {
            if (this.nullMask[i]) {
                reuse.set(i, null);
                continue;
            }
            Object reuseField = reuse.get(i);
            if (reuseField != null) {
                reuse.set(i, this.fieldSerializers[i].deserialize(reuseField, source));
                continue;
            }
            reuse.set(i, this.fieldSerializers[i].deserialize(source));
        }
        return reuse;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int len = this.fieldSerializers.length;
        NullMaskUtils.readIntoAndCopyNullMask(len, source, target, this.nullMask);
        for (int i = 0; i < len; ++i) {
            if (this.nullMask[i]) continue;
            this.fieldSerializers[i].copy(source, target);
        }
    }

    public boolean equals(Object obj) {
        if (this.canEqual(obj)) {
            RowXSerializer other = (RowXSerializer)((Object)obj);
            if (this.fieldSerializers.length == other.fieldSerializers.length) {
                for (int i = 0; i < this.fieldSerializers.length; ++i) {
                    if (this.fieldSerializers[i].equals(other.fieldSerializers[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public boolean canEqual(Object obj) {
        return obj instanceof RowXSerializer;
    }

    public int hashCode() {
        return Arrays.hashCode(this.fieldSerializers);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.nullMask = new boolean[this.fieldSerializers.length];
    }

    public RowSerializerConfigSnapshot snapshotConfiguration() {
        return new RowSerializerConfigSnapshot(this.fieldSerializers);
    }

    public CompatibilityResult<RowX> ensureCompatibility(TypeSerializerConfigSnapshot configSnapshot) {
        List previousFieldSerializersAndConfigs;
        if (configSnapshot instanceof RowSerializerConfigSnapshot && (previousFieldSerializersAndConfigs = ((RowSerializerConfigSnapshot)configSnapshot).getNestedSerializersAndConfigs()).size() == this.fieldSerializers.length) {
            boolean requireMigration = false;
            TypeSerializer[] convertDeserializers = new TypeSerializer[this.fieldSerializers.length];
            int i = 0;
            for (Tuple2 f : previousFieldSerializersAndConfigs) {
                CompatibilityResult compatResult = CompatibilityUtil.resolveCompatibilityResult((TypeSerializer)((TypeSerializer)f.f0), UnloadableDummyTypeSerializer.class, (TypeSerializerConfigSnapshot)((TypeSerializerConfigSnapshot)f.f1), this.fieldSerializers[i]);
                if (compatResult.isRequiresMigration()) {
                    requireMigration = true;
                    if (compatResult.getConvertDeserializer() == null) {
                        return CompatibilityResult.requiresMigration();
                    }
                    convertDeserializers[i] = new TypeDeserializerAdapter(compatResult.getConvertDeserializer());
                }
                ++i;
            }
            if (requireMigration) {
                return CompatibilityResult.requiresMigration((TypeSerializer)new RowXSerializer(this.rowMeta, convertDeserializers));
            }
            return CompatibilityResult.compatible();
        }
        return CompatibilityResult.requiresMigration();
    }

    public static final class RowSerializerConfigSnapshot
    extends CompositeTypeSerializerConfigSnapshot {
        private static final int VERSION = 1;

        public RowSerializerConfigSnapshot() {
        }

        public RowSerializerConfigSnapshot(TypeSerializer[] fieldSerializers) {
            super(fieldSerializers);
        }

        public int getVersion() {
            return 1;
        }
    }
}

