/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.flink.type;

import kd.bos.algo.AlgoException;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.algox.flink.type.NullTypeInfo;
import kd.bos.algox.flink.type.RowXTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;

public class TypeUtil {
    public static BasicTypeInfo<?> toBasicType(DataType dataType) {
        switch (dataType.ordinal) {
            case 0: {
                return BasicTypeInfo.BOOLEAN_TYPE_INFO;
            }
            case 1: {
                return BasicTypeInfo.NSTRING_TYPE_INFO;
            }
            case 2: {
                return BasicTypeInfo.INT_TYPE_INFO;
            }
            case 3: {
                return BasicTypeInfo.LONG_TYPE_INFO;
            }
            case 4: {
                return BasicTypeInfo.DOUBLE_TYPE_INFO;
            }
            case 5: {
                return BasicTypeInfo.BIG_DEC_TYPE_INFO;
            }
            case 6: {
                return BasicTypeInfo.DATE_TYPE_INFO;
            }
            case 7: {
                return BasicTypeInfo.DATE_TYPE_INFO;
            }
            case 8: {
                return NullTypeInfo.INSTANCE;
            }
        }
        throw new AlgoException("Not support dataType in flink type system:" + dataType.getName());
    }

    public static RowXTypeInfo toRowXType(RowMeta rowMeta) {
        BasicTypeInfo[] types = new BasicTypeInfo[rowMeta.getFieldCount()];
        String[] fieldNames = new String[rowMeta.getFieldCount()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = TypeUtil.toBasicType(rowMeta.getFieldDataType(i));
            fieldNames[i] = rowMeta.getFieldAlias(i);
        }
        return new RowXTypeInfo((TypeInformation<?>[])types, fieldNames);
    }

    public static RowXTypeInfo toRowXType(DataType[] dataTypes) {
        BasicTypeInfo[] types = new BasicTypeInfo[dataTypes.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = TypeUtil.toBasicType(dataTypes[i]);
        }
        return new RowXTypeInfo((TypeInformation<?>[])types);
    }

    public static <T extends Tuple> TupleTypeInfo<T> toTupleType(RowMeta rowMeta) {
        BasicTypeInfo[] types = new BasicTypeInfo[rowMeta.getFieldCount()];
        String[] fieldNames = new String[rowMeta.getFieldCount()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = TypeUtil.toBasicType(rowMeta.getFieldDataType(i));
            fieldNames[i] = rowMeta.getFieldAlias(i);
        }
        return new TupleTypeInfo((TypeInformation[])types, fieldNames);
    }

    public static <T extends Tuple> TupleTypeInfo<T> toTupleType(DataType[] dataTypes) {
        BasicTypeInfo[] types = new BasicTypeInfo[dataTypes.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = TypeUtil.toBasicType(dataTypes[i]);
        }
        return new TupleTypeInfo((TypeInformation[])types);
    }

    public static <T extends Tuple> TupleTypeInfo<T> toTupleType(DataType[] dataTypes, String[] fieldNames) {
        BasicTypeInfo[] types = new BasicTypeInfo[dataTypes.length];
        for (int i = 0; i < types.length; ++i) {
            types[i] = TypeUtil.toBasicType(dataTypes[i]);
        }
        return new TupleTypeInfo((TypeInformation[])types, fieldNames);
    }
}

