/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.jobman;

import kd.bos.algo.AlgoException;
import kd.bos.algox.JobNotFoundException;
import kd.bos.algox.RunningTimeoutException;
import kd.bos.algox.cluster.ClusterClient;
import kd.bos.algox.cluster.ClusterFactory;
import kd.bos.algox.jobman.JobDetail;
import kd.bos.algox.jobman.JobStatus;
import kd.bos.util.ConfigurationUtil;

public abstract class JobMan {
    private static int waitInterval = ConfigurationUtil.getInteger((String)"algox.job.await.interval", (Integer)100);

    public static void syncWaitJob(Object jobId, long timeoutMills) {
        ClusterClient cluster = ClusterFactory.getFactory().getClusterClient();
        long endTime = timeoutMills + System.currentTimeMillis();
        do {
            block9: {
                try {
                    JobDetail jobDetail = cluster.getJobDetail(jobId);
                    if (jobDetail != null) {
                        JobStatus status = jobDetail.getStatus();
                        if (status == JobStatus.FININISHED) {
                            return;
                        }
                        if (status == JobStatus.FAILED) {
                            if (jobDetail.getException() instanceof AlgoException) {
                                throw (AlgoException)jobDetail.getException();
                            }
                            throw new AlgoException("Error when execute Job " + jobId, jobDetail.getException());
                        }
                    }
                }
                catch (RuntimeException e) {
                    if (JobMan.isJobNotFoundException(e)) break block9;
                    throw e;
                }
            }
            try {
                Thread.sleep(waitInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (System.currentTimeMillis() < endTime);
        throw new RunningTimeoutException("Timeout when execute Job " + jobId);
    }

    private static boolean isJobNotFoundException(Throwable e) {
        do {
            if (!(e instanceof JobNotFoundException)) continue;
            return true;
        } while ((e = e.getCause()) != null);
        return false;
    }
}

