/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algox.rollup;

import kd.bos.algo.AlgoException;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.cube.Cube;
import kd.bos.algox.cube.CubeEngine;
import kd.bos.algox.cube.CubeFactory;
import kd.bos.algox.cube.CubeSet;
import kd.bos.algox.cube.DimUsage;
import kd.bos.algox.cube.Dimension;
import kd.bos.algox.cube.DimensionBuilder;
import kd.bos.algox.cube.MeasureMeta;
import kd.bos.algox.cube.a.AMeasureMeta;
import kd.bos.algox.rollup.CubeRollupResult;
import kd.bos.algox.rollup.RollupQuery;
import kd.bos.algox.rollup.RollupResult;

public class RollupEngine {
    private RollupQuery query;
    private DataSet factDataset;

    public static RollupResult execute(DataSet dataset, RollupQuery query) {
        RollupEngine engine = new RollupEngine(dataset, query);
        return engine.execute();
    }

    public RollupEngine(DataSet dataset, RollupQuery query) {
        this.factDataset = dataset;
        this.query = query;
        this.check(query);
    }

    private void check(RollupQuery query) {
        query.check();
    }

    public RollupResult execute() {
        Dimension[] dimensions = this.buildDims();
        DimUsage[] dimUsages = this.buildDimUsages();
        MeasureMeta[] measures = this.buildMeasures();
        Cube cube = CubeFactory.createCube(dimUsages, measures, dimensions);
        CubeEngine engine = CubeFactory.createCubeEngine();
        CubeSet cubeSet = engine.execute(cube, this.factDataset);
        return new CubeRollupResult(cube, cubeSet, this.query);
    }

    private MeasureMeta[] buildMeasures() {
        RollupQuery.AggInfo[] aggInfos = this.query.getAggList();
        MeasureMeta[] measures = new MeasureMeta[aggInfos.length];
        for (int i = 0; i < measures.length; ++i) {
            measures[i] = new AMeasureMeta(aggInfos[i].getField(), aggInfos[i].getFunc(), aggInfos[i].getAlias());
        }
        return measures;
    }

    private DimUsage[] buildDimUsages() {
        DimUsage[] usages = new DimUsage[this.query.getGroupList().length];
        for (int i = 0; i < usages.length; ++i) {
            RollupQuery.GroupInfo info = this.query.getGroupList()[i];
            usages[i] = CubeFactory.createDimUsage(info.getIdField(), ((RollupQuery.DimGroupInfo)info).getDimId(), info.isSubTotal(), false);
        }
        return usages;
    }

    private Dimension[] buildDims() {
        Dimension[] dimensions = new Dimension[this.query.getDimList().length];
        for (int i = 0; i < dimensions.length; ++i) {
            dimensions[i] = this.buildDim(this.query.getDimList()[i]);
        }
        return dimensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension buildDim(RollupQuery.DimInfo di) {
        if (di instanceof RollupQuery.DimInfoByDataSet) {
            RollupQuery.DimInfoByDataSet ddi = (RollupQuery.DimInfoByDataSet)di;
            DataSet dataset = ddi.getDataSet();
            RowMeta rowMeta = dataset.getRowMeta();
            String idField = ddi.getIdField();
            int idFieldIndex = dataset.getRowMeta().getFieldIndex(idField);
            DimensionBuilder builder = null;
            int parentIdFieldIndex = -1;
            if (ddi.getParentIdField() != null) {
                parentIdFieldIndex = dataset.getRowMeta().getFieldIndex(ddi.getParentIdField());
            }
            int[] attFieldIndexes = new int[ddi.getAttFields().length];
            for (int i = 0; i < attFieldIndexes.length; ++i) {
                attFieldIndexes[i] = rowMeta.getFieldIndex(ddi.getAttFields()[i]);
            }
            builder = parentIdFieldIndex >= 0 ? CubeFactory.createTreeDimensionBuilder(ddi.getDimId(), idField, ddi.getParentIdField(), ddi.getAttFields(), ddi.getSortAttIndex()) : CubeFactory.createPlainDimensionBuilder(ddi.getDimId(), idField, ddi.getAttFields(), ddi.getSortAttIndex());
            try {
                Dimension dim;
                Object parentId = null;
                for (Row row : dataset) {
                    Object id = row.get(idFieldIndex);
                    if (parentIdFieldIndex >= 0) {
                        parentId = row.get(parentIdFieldIndex);
                    }
                    Object[] attValues = new Object[attFieldIndexes.length];
                    for (int i = 0; i < attFieldIndexes.length; ++i) {
                        attValues[i] = row.get(attFieldIndexes[i]);
                    }
                    builder.add(id, parentId, attValues);
                }
                Dimension dimension = dim = builder.build();
                return dimension;
            }
            finally {
                dataset.close();
            }
        }
        throw new AlgoException("not support");
    }
}

