/*
 * Decompiled with CFR 0.152.
 */
package kobetool.dshowwrapper;

import java.nio.ByteBuffer;

public class GUID {
    public static final GUID RGB24 = new GUID("0xe436eb7d, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70");
    public static final GUID RGB32 = new GUID("0xe436eb7e, 0x524f, 0x11ce, 0x9f, 0x53, 0x00, 0x20, 0xaf, 0x0b, 0xa7, 0x70");
    public static final GUID IYUV = new GUID("0x56555949, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71");
    public static final GUID I420 = new GUID("0x30323449, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71");
    public static final GUID YUYV = new GUID("0x56595559, 0x0000, 0x0010, 0x80, 0x00, 0x00, 0xaa, 0x00, 0x38, 0x9b, 0x71");
    private ByteBuffer buf;

    public GUID(String fmt) {
        fmt = fmt.replaceAll("0x", "").replaceAll(",", "").replaceAll("\\s", "");
        if (fmt.length() != 32) {
            throw new IllegalArgumentException();
        }
        this.buf = ByteBuffer.allocateDirect(16);
        int[] lens = new int[]{4, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1};
        int i = 0;
        int j = 0;
        do {
            int len = lens[j];
            int k = 0;
            while (k < len) {
                int p = (len - k - 1 + i) * 2;
                this.buf.put(Integer.valueOf(fmt.substring(p, p + 2), 16).byteValue());
                ++k;
            }
            i += len;
        } while (++j != lens.length);
    }

    public GUID(ByteBuffer buf) {
        if (buf == null || !buf.isDirect()) {
            throw new IllegalArgumentException();
        }
        this.buf = buf;
    }

    public ByteBuffer getBuf() {
        return this.buf.asReadOnlyBuffer();
    }

    public String getFourcc() {
        byte[] bytes = new byte[4];
        int i = 0;
        while (i < 4) {
            bytes[i] = this.buf.get(i);
            ++i;
        }
        return new String(bytes);
    }

    private void appendHex(StringBuilder sb, int start, int len) {
        sb.append("0x");
        int i = len - 1;
        while (i >= 0) {
            String hs = Integer.toHexString(0xFF & this.buf.get(start + i));
            if (hs.length() == 1) {
                sb.append("0");
            }
            sb.append(hs);
            --i;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("(" + this.getFourcc() + ")");
        int[] lens = new int[]{4, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1};
        int i = 0;
        int j = 0;
        while (true) {
            int len = lens[j];
            this.appendHex(sb, i, len);
            if (++j == lens.length) break;
            sb.append(", ");
            i += len;
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GUID guid = (GUID)o;
        if (this.buf.capacity() != guid.buf.capacity()) {
            return false;
        }
        int i = 0;
        while (i < this.buf.capacity()) {
            if (this.buf.get(i) != guid.buf.get(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.buf.hashCode();
    }
}

