/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication;

import com.github.inspektr.audit.annotation.Audit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.aspect.LogAspect;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.AuthenticationManager;
import org.jasig.cas.authentication.AuthenticationMetaDataPopulator;
import org.jasig.cas.authentication.ImmutableAuthentication;
import org.jasig.cas.authentication.MutableAuthentication;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.handler.AuthenticationHandler;
import org.jasig.cas.authentication.handler.NamedAuthenticationHandler;
import org.jasig.cas.authentication.handler.UncategorizedAuthenticationException;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.Principal;
import org.perf4j.aop.Profiled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthenticationManager
implements AuthenticationManager {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private List<AuthenticationMetaDataPopulator> authenticationMetaDataPopulators = new ArrayList<AuthenticationMetaDataPopulator>();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Override
    @Audit(action="AUTHENTICATION", actionResolverName="AUTHENTICATION_RESOLVER", resourceResolverName="AUTHENTICATION_RESOURCE_RESOLVER")
    @Profiled(tag="AUTHENTICATE", logFailuresSeparately=false)
    public final Authentication authenticate(Credentials credentials) throws AuthenticationException {
        Credentials credentials2 = credentials;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)credentials2);
        return (Authentication)AbstractAuthenticationManager.authenticate_aroundBody1$advice(this, credentials2, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    public final void setAuthenticationMetaDataPopulators(List<AuthenticationMetaDataPopulator> authenticationMetaDataPopulators) {
        this.authenticationMetaDataPopulators = authenticationMetaDataPopulators;
    }

    protected abstract Pair<AuthenticationHandler, Principal> authenticateAndObtainPrincipal(Credentials var1) throws AuthenticationException;

    protected void handleError(String handlerName, Credentials credentials, Exception e) throws AuthenticationException {
        if (e instanceof AuthenticationException) {
            this.log.info("{} failed authenticating {}", (Object)handlerName, (Object)credentials);
            throw (AuthenticationException)e;
        }
        this.log.error("{} threw error authenticating {}", new Object[]{handlerName, credentials, e});
        throw new UncategorizedAuthenticationException(e.getClass().getName(), e){};
    }

    static {
        AbstractAuthenticationManager.ajc$preClinit();
    }

    private static final /* synthetic */ Authentication authenticate_aroundBody0(AbstractAuthenticationManager ajc$this, Credentials credentials, JoinPoint joinPoint) {
        Pair<AuthenticationHandler, Principal> pair = ajc$this.authenticateAndObtainPrincipal(credentials);
        Principal p = pair.getSecond();
        ajc$this.log.info("{} authenticated {} with credential {}.", new Object[]{pair.getFirst(), p, credentials});
        ajc$this.log.debug("Attribute map for {}: {}", (Object)p.getId(), p.getAttributes());
        Authentication authentication = new MutableAuthentication(p);
        if (pair.getFirst() instanceof NamedAuthenticationHandler) {
            NamedAuthenticationHandler a = (NamedAuthenticationHandler)pair.getFirst();
            authentication.getAttributes().put("authenticationMethod", a.getName());
        }
        for (AuthenticationMetaDataPopulator authenticationMetaDataPopulator : ajc$this.authenticationMetaDataPopulators) {
            authentication = authenticationMetaDataPopulator.populateAttributes(authentication, credentials);
        }
        return new ImmutableAuthentication(authentication.getPrincipal(), authentication.getAttributes());
    }

    private static final /* synthetic */ Object authenticate_aroundBody1$advice(AbstractAuthenticationManager ajc$this, Credentials credentials, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        Authentication authentication;
        Authentication returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            authentication = returnVal = AbstractAuthenticationManager.authenticate_aroundBody0(ajc$this, credentials, (JoinPoint)proceedingJoinPoint2);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return authentication;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractAuthenticationManager.java", AbstractAuthenticationManager.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("11", "authenticate", "org.jasig.cas.authentication.AbstractAuthenticationManager", "org.jasig.cas.authentication.principal.Credentials", "credentials", "org.jasig.cas.authentication.handler.AuthenticationException", "org.jasig.cas.authentication.Authentication"), 55);
    }

    protected static class Pair<A, B> {
        private final A first;
        private final B second;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

        public Pair(A first, B second) {
            this.first = first;
            this.second = second;
        }

        public A getFirst() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            return (A)Pair.getFirst_aroundBody1$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
        }

        public B getSecond() {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
            return (B)Pair.getSecond_aroundBody3$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
        }

        static {
            Pair.ajc$preClinit();
        }

        private static final /* synthetic */ Object getFirst_aroundBody1$advice(Pair ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
            Object object;
            Object returnVal = null;
            Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
            String methodName = proceedingJoinPoint.getSignature().getName();
            try {
                if (log.isTraceEnabled()) {
                    Object[] args = proceedingJoinPoint.getArgs();
                    String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                    log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
                }
                ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
                object = returnVal = ajc$this.first;
            }
            catch (Throwable throwable) {
                if (log.isTraceEnabled()) {
                    log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
                }
                throw throwable;
            }
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            return object;
        }

        private static final /* synthetic */ Object getSecond_aroundBody3$advice(Pair ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
            Object object;
            Object returnVal = null;
            Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
            String methodName = proceedingJoinPoint.getSignature().getName();
            try {
                if (log.isTraceEnabled()) {
                    Object[] args = proceedingJoinPoint.getArgs();
                    String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                    log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
                }
                ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
                object = returnVal = ajc$this.second;
            }
            catch (Throwable throwable) {
                if (log.isTraceEnabled()) {
                    log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
                }
                throw throwable;
            }
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            return object;
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("AbstractAuthenticationManager.java", Pair.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFirst", "org.jasig.cas.authentication.AbstractAuthenticationManager$Pair", "", "", "", "java.lang.Object"), 130);
            ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSecond", "org.jasig.cas.authentication.AbstractAuthenticationManager$Pair", "", "", "", "java.lang.Object"), 135);
        }
    }
}

