/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.monitor;

import java.util.Arrays;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.aspect.LogAspect;
import org.jasig.cas.monitor.AbstractNamedMonitor;
import org.jasig.cas.monitor.CacheStatistics;
import org.jasig.cas.monitor.CacheStatus;
import org.jasig.cas.monitor.StatusCode;
import org.slf4j.Logger;

public abstract class AbstractCacheMonitor
extends AbstractNamedMonitor<CacheStatus> {
    public static final int DEFAULT_WARN_FREE_THRESHOLD = 10;
    public static final long DEFAULT_EVICTION_THRESHOLD = 0L;
    private int warnFreeThreshold = 10;
    private long evictionThreshold = 0L;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public void setWarnFreeThreshold(int percent) {
        this.warnFreeThreshold = percent;
    }

    public void setEvictionThreshold(long count) {
        this.evictionThreshold = count;
    }

    @Override
    public CacheStatus observe() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        return (CacheStatus)AbstractCacheMonitor.observe_aroundBody1$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    protected abstract CacheStatistics[] getStatistics();

    protected StatusCode status(CacheStatistics statistics) {
        StatusCode code = statistics.getEvictions() > this.evictionThreshold ? StatusCode.WARN : (statistics.getPercentFree() < this.warnFreeThreshold ? StatusCode.WARN : StatusCode.OK);
        return code;
    }

    static {
        AbstractCacheMonitor.ajc$preClinit();
    }

    private static final /* synthetic */ CacheStatus observe_aroundBody0(AbstractCacheMonitor ajc$this, JoinPoint joinPoint) {
        CacheStatus status;
        try {
            CacheStatistics[] statistics = ajc$this.getStatistics();
            if (statistics == null || statistics.length == 0) {
                return new CacheStatus(StatusCode.ERROR, "Cache statistics not available.", new CacheStatistics[0]);
            }
            StatusCode overall = StatusCode.OK;
            CacheStatistics[] cacheStatisticsArray = statistics;
            int n = statistics.length;
            int n2 = 0;
            while (n2 < n) {
                CacheStatistics stats = cacheStatisticsArray[n2];
                StatusCode code = ajc$this.status(stats);
                if (code.value() > overall.value()) {
                    overall = code;
                }
                ++n2;
            }
            status = new CacheStatus(overall, null, statistics);
        }
        catch (Exception e) {
            status = new CacheStatus(e);
        }
        return status;
    }

    private static final /* synthetic */ Object observe_aroundBody1$advice(AbstractCacheMonitor ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
        CacheStatus cacheStatus;
        CacheStatus returnVal = null;
        Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
        String methodName = proceedingJoinPoint.getSignature().getName();
        try {
            if (log.isTraceEnabled()) {
                Object[] args = proceedingJoinPoint.getArgs();
                String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
            }
            ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
            cacheStatus = returnVal = AbstractCacheMonitor.observe_aroundBody0(ajc$this, (JoinPoint)proceedingJoinPoint2);
        }
        catch (Throwable throwable) {
            if (log.isTraceEnabled()) {
                log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
            }
            throw throwable;
        }
        if (log.isTraceEnabled()) {
            log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
        }
        return cacheStatus;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractCacheMonitor.java", AbstractCacheMonitor.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "observe", "org.jasig.cas.monitor.AbstractCacheMonitor", "", "", "", "org.jasig.cas.monitor.CacheStatus"), 63);
    }
}

