/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.support;

import com.github.inspektr.audit.AuditActionContext;
import com.github.inspektr.audit.AuditPointRuntimeInfo;
import com.github.inspektr.audit.AuditTrailManager;
import com.github.inspektr.common.web.ClientInfo;
import com.github.inspektr.common.web.ClientInfoHolder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.aspect.LogAspect;
import org.jasig.cas.web.support.AbstractThrottledSubmissionHandlerInterceptorAdapter;
import org.slf4j.Logger;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class InspektrThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter
extends AbstractThrottledSubmissionHandlerInterceptorAdapter {
    private static final String DEFAULT_APPLICATION_CODE = "CAS";
    private static final String DEFAULT_AUTHN_FAILED_ACTION = "AUTHENTICATION_FAILED";
    private static final String INSPEKTR_ACTION = "THROTTLED_LOGIN_ATTEMPT";
    private final AuditTrailManager auditTrailManager;
    private final JdbcTemplate jdbcTemplate;
    private String applicationCode = "CAS";
    private String authenticationFailureCode = "AUTHENTICATION_FAILED";

    public InspektrThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter(AuditTrailManager auditTrailManager, DataSource dataSource) {
        this.auditTrailManager = auditTrailManager;
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    @Override
    protected boolean exceedsThreshold(HttpServletRequest request) {
        String userToUse = this.constructUsername(request, this.getUsernameParameter());
        Calendar cutoff = Calendar.getInstance();
        cutoff.add(13, -1 * this.getFailureRangeInSeconds());
        List failures = this.jdbcTemplate.query("SELECT AUD_DATE FROM COM_AUDIT_TRAIL WHERE AUD_CLIENT_IP = ? AND AUD_USER = ? AND AUD_ACTION = ? AND APPLIC_CD = ? AND AUD_DATE >= ? ORDER BY AUD_DATE DESC", new Object[]{request.getRemoteAddr(), userToUse, this.authenticationFailureCode, this.applicationCode, cutoff.getTime()}, new int[]{12, 12, 12, 12, 93}, (RowMapper)new RowMapper<Timestamp>(){
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

            public Timestamp mapRow(ResultSet resultSet, int i) throws SQLException {
                ResultSet resultSet2 = resultSet;
                int n = i;
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)resultSet2, (Object)Conversions.intObject((int)n));
                return (Timestamp)1.mapRow_aroundBody1$advice(this, resultSet2, n, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
            }

            static {
                1.ajc$preClinit();
            }

            private static final /* synthetic */ Object mapRow_aroundBody1$advice(1 ajc$this, ResultSet resultSet, int i, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
                Timestamp timestamp;
                Timestamp returnVal = null;
                Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
                String methodName = proceedingJoinPoint.getSignature().getName();
                try {
                    if (log.isTraceEnabled()) {
                        Object[] args = proceedingJoinPoint.getArgs();
                        String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                        log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
                    }
                    ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
                    timestamp = returnVal = resultSet.getTimestamp(1);
                }
                catch (Throwable throwable) {
                    if (log.isTraceEnabled()) {
                        log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? ((Object)returnVal).toString() : "null") + "].");
                    }
                    throw throwable;
                }
                if (log.isTraceEnabled()) {
                    log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? ((Object)returnVal).toString() : "null") + "].");
                }
                return timestamp;
            }

            private static /* synthetic */ void ajc$preClinit() {
                Factory factory = new Factory("InspektrThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter.java", 1.class);
                ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "mapRow", "org.jasig.cas.web.support.InspektrThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter$1", "java.sql.ResultSet:int", "resultSet:i", "java.sql.SQLException", "java.sql.Timestamp"), 86);
            }
        });
        if (failures.size() < 2) {
            return false;
        }
        return 1000.0 / (double)(((Timestamp)failures.get(0)).getTime() - ((Timestamp)failures.get(1)).getTime()) > this.getThresholdRate();
    }

    @Override
    protected void recordSubmissionFailure(HttpServletRequest request) {
    }

    @Override
    protected void recordThrottle(HttpServletRequest request) {
        super.recordThrottle(request);
        String userToUse = this.constructUsername(request, this.getUsernameParameter());
        ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
        AuditPointRuntimeInfo auditPointRuntimeInfo = new AuditPointRuntimeInfo(){
            private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

            public String asString() {
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
                return (String)2.asString_aroundBody1$advice(this, joinPoint, LogAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
            }

            static {
                2.ajc$preClinit();
            }

            private static final /* synthetic */ String asString_aroundBody0(2 ajc$this, JoinPoint joinPoint) {
                return String.format("%s.recordThrottle()", ajc$this.getClass().getName());
            }

            private static final /* synthetic */ Object asString_aroundBody1$advice(2 ajc$this, JoinPoint thisJoinPoint, LogAspect ajc$aspectInstance, ProceedingJoinPoint proceedingJoinPoint) {
                String string;
                String returnVal = null;
                Logger log = LogAspect.ajc$inlineAccessMethod$org_jasig_cas_aspect_LogAspect$org_jasig_cas_aspect_LogAspect$getLog(ajc$aspectInstance, (JoinPoint)proceedingJoinPoint);
                String methodName = proceedingJoinPoint.getSignature().getName();
                try {
                    if (log.isTraceEnabled()) {
                        Object[] args = proceedingJoinPoint.getArgs();
                        String arguments = args == null || args.length == 0 ? "" : Arrays.deepToString(args);
                        log.trace("Entering method [" + methodName + " with arguments [" + arguments + "]");
                    }
                    ProceedingJoinPoint proceedingJoinPoint2 = proceedingJoinPoint;
                    string = returnVal = 2.asString_aroundBody0(ajc$this, (JoinPoint)proceedingJoinPoint2);
                }
                catch (Throwable throwable) {
                    if (log.isTraceEnabled()) {
                        log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
                    }
                    throw throwable;
                }
                if (log.isTraceEnabled()) {
                    log.trace("Leaving method [" + methodName + "] with return value [" + (returnVal != null ? returnVal.toString() : "null") + "].");
                }
                return string;
            }

            private static /* synthetic */ void ajc$preClinit() {
                Factory factory = new Factory("InspektrThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter.java", 2.class);
                ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "asString", "org.jasig.cas.web.support.InspektrThrottledSubmissionByIpAddressAndUsernameHandlerInterceptorAdapter$2", "", "", "", "java.lang.String"), 108);
            }
        };
        AuditActionContext context = new AuditActionContext(userToUse, userToUse, INSPEKTR_ACTION, this.applicationCode, new Date(), clientInfo.getClientIpAddress(), clientInfo.getServerIpAddress(), auditPointRuntimeInfo);
        this.auditTrailManager.record(context);
    }

    public final void setApplicationCode(String applicationCode) {
        this.applicationCode = applicationCode;
    }

    public final void setAuthenticationFailureCode(String authenticationFailureCode) {
        this.authenticationFailureCode = authenticationFailureCode;
    }

    protected String constructUsername(HttpServletRequest request, String usernameParameter) {
        String username = request.getParameter(usernameParameter);
        return "[username: " + (username != null ? username : "") + "]";
    }
}

