/*
 * Decompiled with CFR 0.152.
 */
package com.cfca.toolkit;

import com.cfca.toolkit.CastleException;
import com.cfca.toolkit.CastleProperties;
import com.cfca.util.pki.cipher.JCrypto;
import com.cfca.util.pki.cipher.Mechanism;
import com.cfca.util.pki.cipher.Session;
import com.cfca.util.pki.encoders.Base64;
import com.cfca.util.pki.pkcs.PKCS12;
import com.cfca.util.pki.pkcs.PKCS7SignedData;
import com.entrust.toolkit.x509.directory.JNDIDirectory;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.structures.DistributionPoint;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.utils.Base64InputStream;
import iaik.x509.X509CRL;
import iaik.x509.X509Certificate;
import iaik.x509.X509ExtensionException;
import iaik.x509.extensions.CRLDistributionPoints;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.X509CRLEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.naming.NamingException;
import javax.naming.TimeLimitExceededException;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.RecipientInformationStore;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;

public class Castle {
    private String mTrustedCAStorePass;
    private int mLdapServerPort;
    private String mLdapServerName;
    private String mCachedCRLDirPath;
    private String mUserCertFilePath;
    private String mUserCertPassword;
    private String mUserCertAlias;
    private java.security.cert.X509Certificate mUserCert;
    private PrivateKey mPrivateKey;
    private boolean mUserCertReady;
    private java.security.cert.X509Certificate mOperationCA;
    private JCrypto jcrypto = JCrypto.getInstance();
    private Session session = null;
    private PKCS12 p12 = new PKCS12();

    public Castle(CastleProperties castleProperties) {
        this.mLdapServerName = castleProperties.getmLdapServerName();
        this.mLdapServerPort = castleProperties.getmLdapServerPort();
        this.mCachedCRLDirPath = castleProperties.getmCachedCRLDirPath();
        this.mUserCertFilePath = castleProperties.getmUserCertFilePath();
        this.mUserCertPassword = castleProperties.getmUserCertPassword();
        this.mTrustedCAStorePass = "changeit";
        this.mUserCertReady = false;
        try {
            this.jcrypto.initialize("JSOFT_LIB", null);
            this.session = this.jcrypto.openSession("JSOFT_LIB");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private CertPath getCertificateChain(byte[] certBytes) throws FileNotFoundException, IOException, CastleException {
        FileInputStream caCertsStream = null;
        try {
            CertPath path;
            Certificate rootCa;
            ByteArrayInputStream bis = new ByteArrayInputStream(certBytes);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            java.security.cert.X509Certificate cert = (java.security.cert.X509Certificate)cf.generateCertificate(bis);
            String issuer = cert.getIssuerDN().getName();
            int levelNum = 0;
            int caSeq = 0;
            for (int i = 1; i <= 6; ++i) {
                if (issuer.indexOf(String.valueOf(i)) == -1) continue;
                levelNum = 2;
                caSeq = i;
                break;
            }
            if (levelNum != 2) {
                levelNum = 3;
            }
            String cacertsFileName = System.getProperty("java.home") + "/jre/lib/security/cacerts".replace('/', File.separatorChar);
            caCertsStream = new FileInputStream(cacertsFileName);
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(caCertsStream, this.mTrustedCAStorePass.toCharArray());
            ArrayList<Certificate> caCertsList = new ArrayList<Certificate>();
            caCertsList.add(cert);
            Certificate operationCa = keystore.getCertificate("cfcaOperationCA" + caSeq);
            if (operationCa == null) {
                throw new CastleException("There is none alias: cfcaOperationCA" + caSeq + " Certificate in most-trusted key store");
            }
            caCertsList.add(operationCa);
            if (levelNum == 3) {
                Certificate policyCa = keystore.getCertificate("cfcaPolicyCA");
                if (policyCa != null) {
                    caCertsList.add(policyCa);
                } else {
                    throw new CastleException("There is none alisas: cfcaPolicyCA Certiificate in most-trusted key store");
                }
            }
            if ((rootCa = keystore.getCertificate("cfcaRootCA")) == null) {
                throw new CastleException("not found root level CA Certiificate in most-trusted key store");
            }
            caCertsList.add(rootCa);
            CertPath certPath = path = cf.generateCertPath(caCertsList);
            return certPath;
        }
        catch (FileNotFoundException fnfe) {
            throw new CastleException("\u5728\u4f60\u7684java\u73af\u5883\u8def\u5f84\u4e0b\u6ca1\u6709\u627e\u5230cacerts\u6587\u4ef6");
        }
        catch (CertificateException ce) {
            throw new CastleException(ce);
        }
        catch (KeyStoreException kse) {
            throw new CastleException(kse);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new CastleException(nsae);
        }
        finally {
            if (caCertsStream != null) {
                caCertsStream.close();
            }
        }
    }

    private void getPrivateKeyAndCertificate(String mUserCertFilePath, String mUserCertPassword) throws FileNotFoundException, IOException, CertificateException, UnrecoverableKeyException, CastleException {
        FileInputStream keyStoreStream = null;
        KeyStore keyStore = null;
        try {
            File certFile = new File(mUserCertFilePath);
            String certFileName = certFile.getName();
            char[] password = mUserCertPassword.toCharArray();
            if (certFileName.toLowerCase().indexOf(".pfx") != -1 || certFileName.toLowerCase().indexOf(".keystore") != -1 || certFileName.toLowerCase().indexOf(".jks") != -1) {
                keyStoreStream = new FileInputStream(certFile);
                keyStore = certFileName.toLowerCase().indexOf(".pfx") != -1 ? KeyStore.getInstance("PKCS12", "BC") : KeyStore.getInstance("JKS");
                keyStore.load(keyStoreStream, password);
                Enumeration<String> aliasesEnum = keyStore.aliases();
                while (aliasesEnum.hasMoreElements()) {
                    String alias = aliasesEnum.nextElement();
                    if (this.mPrivateKey == null && keyStore.isKeyEntry(alias)) {
                        this.mPrivateKey = (PrivateKey)keyStore.getKey(alias, password);
                    }
                    if (this.mUserCert != null || !keyStore.isKeyEntry(alias)) continue;
                    this.mUserCert = (java.security.cert.X509Certificate)keyStore.getCertificate(alias);
                }
            } else {
                throw new CastleException("\u53ea\u652f\u6301pfx\u6587\u4ef6\u6216keystore jks\u5b58\u50a8\u7528\u6237\u8bc1\u4e66");
            }
            keyStoreStream.close();
        }
        catch (KeyStoreException kse) {
            throw new CastleException(kse);
        }
        catch (FileNotFoundException ffe) {
            throw ffe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new CastleException("not support this algorithm");
        }
        catch (UnrecoverableKeyException uke) {
            throw uke;
        }
        catch (NoSuchProviderException nspe) {
            throw new CastleException("jce provider not match" + nspe.getMessage());
        }
        catch (CertificateException ce) {
            throw ce;
        }
        if (this.mPrivateKey == null || this.mUserCert == null) {
            throw new CastleException("\u83b7\u53d6\u7528\u6237\u8bc1\u4e66\u53ca\u79c1\u94a5\u51fa\u9519");
        }
        this.mUserCertReady = true;
    }

    private String getCRLDp(byte[] certBytes) throws CodingException, X509ExtensionException, CertificateException, CastleException {
        String crlDp;
        block7: {
            crlDp = null;
            try {
                X509Certificate x509Cert = new X509Certificate(certBytes);
                byte[] crlBytes = x509Cert.getExtensionValue("2.5.29.31");
                if (crlBytes != null) {
                    ASN1Object asn = DerCoder.decode((byte[])crlBytes);
                    CRLDistributionPoints crlDP = new CRLDistributionPoints();
                    crlDP.init(asn);
                    Enumeration dpe = crlDP.getDistributionPoints();
                    block4: while (dpe.hasMoreElements()) {
                        DistributionPoint dp = (DistributionPoint)dpe.nextElement();
                        GeneralNames gns = (GeneralNames)dp.getDistributionPointName();
                        Enumeration gne = gns.getNames();
                        while (gne.hasMoreElements()) {
                            GeneralName gn = (GeneralName)gne.nextElement();
                            if (gn.getType() != GeneralName.directoryName) continue;
                            crlDp = gn.getName().toString();
                            continue block4;
                        }
                    }
                    break block7;
                }
                throw new CastleException("crl point of this certificate is  not available");
            }
            catch (CodingException ce) {
                throw ce;
            }
            catch (X509ExtensionException ee) {
                throw ee;
            }
            catch (CertificateException ce) {
                throw ce;
            }
        }
        return crlDp;
    }

    private boolean verifyCRL(java.security.cert.X509CRL crlObject) throws CertificateException, CastleException {
        FileInputStream caCertsStream = null;
        PublicKey pk = null;
        try {
            String issuer = crlObject.getIssuerDN().getName();
            if (this.mOperationCA != null && ((Object)this.mOperationCA.getSubjectDN()).equals(crlObject.getIssuerDN())) {
                pk = this.mOperationCA.getPublicKey();
            } else {
                String cacertsFileName = System.getProperty("java.home") + "/lib/security/cacerts".replace('/', File.separatorChar);
                caCertsStream = new FileInputStream(cacertsFileName);
                KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                keystore.load(caCertsStream, this.mTrustedCAStorePass.toCharArray());
                java.security.cert.X509Certificate issuerCA = null;
                if (issuer.indexOf("cfca oca".toUpperCase()) != -1) {
                    issuerCA = (java.security.cert.X509Certificate)keystore.getCertificate("cfcaOCA");
                } else if (issuer.indexOf("cfca test ca".toUpperCase()) != -1) {
                    issuerCA = (java.security.cert.X509Certificate)keystore.getCertificate("cfcaTESTCA");
                } else if (issuer.indexOf("CFCA Operation CA2") != -1) {
                    issuerCA = (java.security.cert.X509Certificate)keystore.getCertificate("operationca2");
                } else if (issuer.indexOf("CFCA Operation CA".toUpperCase()) != -1) {
                    issuerCA = (java.security.cert.X509Certificate)keystore.getCertificate("operationca");
                } else {
                    throw new CastleException("not support this issuer.");
                }
                this.mOperationCA = issuerCA;
                pk = issuerCA.getPublicKey();
            }
            crlObject.verify(pk);
        }
        catch (FileNotFoundException fnfe) {
            throw new CastleException("not found most-trusted  cacerts file");
        }
        catch (IOException ioe) {
            throw new CastleException(ioe);
        }
        catch (NoSuchProviderException nspe) {
            throw new CastleException("not found default provider");
        }
        catch (SignatureException se) {
            boolean bl = false;
            return bl;
        }
        catch (KeyStoreException kse) {
            throw new CastleException(kse);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new CastleException("not support this signature algorithms");
        }
        catch (InvalidKeyException ike) {
            throw new CastleException("signature does not match with the PublicKey used to carry out the verification");
        }
        catch (CRLException ce) {
            throw new CastleException(ce);
        }
        finally {
            if (caCertsStream != null) {
                try {
                    caCertsStream.close();
                }
                catch (IOException ioe) {
                    throw new CastleException(ioe);
                }
            }
        }
        return true;
    }

    public void initCertAppContext() throws FileNotFoundException, IOException, CertificateException, UnrecoverableKeyException, CastleException {
        if (this.mUserCertFilePath != null && this.mUserCertPassword != null) {
            this.getPrivateKeyAndCertificate(this.mUserCertFilePath, this.mUserCertPassword);
            try {
                this.p12.load(this.mUserCertFilePath);
                this.p12.decrypt(this.mUserCertPassword.toCharArray());
            }
            catch (Exception ex) {
                throw new CastleException(ex);
            }
        }
    }

    public String getDN(byte[] certBytes) throws CertificateException {
        ByteArrayInputStream bis = new ByteArrayInputStream(certBytes);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        java.security.cert.X509Certificate cert = (java.security.cert.X509Certificate)cf.generateCertificate(bis);
        return cert.getSubjectDN().getName();
    }

    public BigInteger getSerialNumber(byte[] certBytes) throws CertificateException {
        ByteArrayInputStream bis = new ByteArrayInputStream(certBytes);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        java.security.cert.X509Certificate cert = (java.security.cert.X509Certificate)cf.generateCertificate(bis);
        return cert.getSerialNumber();
    }

    public String getIssuerDN(byte[] certBytes) throws CertificateException {
        ByteArrayInputStream bis = new ByteArrayInputStream(certBytes);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        java.security.cert.X509Certificate cert = (java.security.cert.X509Certificate)cf.generateCertificate(bis);
        return cert.getIssuerDN().getName();
    }

    public Date getNotAfter(byte[] certBytes) throws CertificateException {
        ByteArrayInputStream bis = new ByteArrayInputStream(certBytes);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        java.security.cert.X509Certificate cert = (java.security.cert.X509Certificate)cf.generateCertificate(bis);
        return cert.getNotAfter();
    }

    public Date getNotBefore(byte[] certBytes) throws CertificateException {
        ByteArrayInputStream bis = new ByteArrayInputStream(certBytes);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        java.security.cert.X509Certificate cert = (java.security.cert.X509Certificate)cf.generateCertificate(bis);
        return cert.getNotBefore();
    }

    public Date getNotAfter() {
        return this.mUserCert.getNotAfter();
    }

    public Date getNotBefore() {
        return this.mUserCert.getNotBefore();
    }

    public byte[] getCertificate(String signature) throws CastleException, CertificateException {
        java.security.cert.X509Certificate cert = null;
        Base64InputStream base64is = null;
        try {
            base64is = new Base64InputStream((InputStream)new ByteArrayInputStream(signature.getBytes()));
            CMSSignedData signedData = new CMSSignedData((InputStream)base64is);
            CertStore certs = signedData.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore signersInfo = signedData.getSignerInfos();
            Collection signers = signersInfo.getSigners();
            Iterator it = signers.iterator();
            if (it.hasNext()) {
                SignerInformation signerInfo = (SignerInformation)it.next();
                Collection<? extends Certificate> certCollection = certs.getCertificates((CertSelector)signerInfo.getSID());
                Iterator<? extends Certificate> certIt = certCollection.iterator();
                cert = (java.security.cert.X509Certificate)certIt.next();
                return cert.getEncoded();
            }
            throw new CastleException("not find signer information in pkcs#7 signature");
        }
        catch (CMSException cme) {
            throw new CastleException(cme);
        }
        catch (NoSuchAlgorithmException nse) {
            throw new CastleException("error occurs when getting signer certificate from pkcs#7 signature");
        }
        catch (CertStoreException cse) {
            throw new CastleException(cse);
        }
        catch (NoSuchProviderException nse) {
            throw new CastleException("jce provider not match");
        }
        catch (CertificateException ce) {
            throw ce;
        }
    }

    public int verifyCertificate(byte[] certBytes) throws CertificateException, CastleException {
        FileInputStream caCertsStream = null;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(certBytes);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            java.security.cert.X509Certificate cert = (java.security.cert.X509Certificate)cf.generateCertificate(bis);
            cert.checkValidity();
            ArrayList<java.security.cert.X509Certificate> caCertsList = new ArrayList<java.security.cert.X509Certificate>();
            caCertsList.add(cert);
            CertPath certPath = cf.generateCertPath(caCertsList);
            String cacertsFileName = System.getProperty("java.home") + "/lib/security/cacerts".replace('/', File.separatorChar);
            caCertsStream = new FileInputStream(cacertsFileName);
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(caCertsStream, this.mTrustedCAStorePass.toCharArray());
            PKIXParameters params = new PKIXParameters(keystore);
            params.setRevocationEnabled(false);
            CertPathValidator cpv = CertPathValidator.getInstance(CertPathValidator.getDefaultType());
            PKIXCertPathValidatorResult result = (PKIXCertPathValidatorResult)cpv.validate(certPath, params);
        }
        catch (CertificateExpiredException cee) {
            int n = -2;
            return n;
        }
        catch (CertificateNotYetValidException cnyve) {
            int n = -1;
            return n;
        }
        catch (CertificateException ce) {
            throw ce;
        }
        catch (FileNotFoundException fnfe) {
            throw new CastleException("not found most-trusted  cacerts file");
        }
        catch (IOException ioe) {
            throw new CastleException(ioe);
        }
        catch (KeyStoreException kse) {
            throw new CastleException(kse);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new CastleException(nsae);
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new CastleException("most-trusted CAs keystore does not contain at least one trusted certificate entry");
        }
        catch (CertPathValidatorException cpve) {
            throw new CastleException(cpve);
        }
        finally {
            if (caCertsStream != null) {
                try {
                    caCertsStream.close();
                }
                catch (IOException ioe) {
                    throw new CastleException(ioe);
                }
            }
        }
        return 1;
    }

    public String generateEnvelope(String originalData, int encryptAlg, byte[] certBytes) throws CertificateException, CastleException {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(certBytes);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            java.security.cert.X509Certificate cert = (java.security.cert.X509Certificate)cf.generateCertificate(bis);
            CMSEnvelopedDataGenerator cdg = new CMSEnvelopedDataGenerator();
            cdg.addKeyTransRecipient(cert);
            CMSProcessableByteArray content = new CMSProcessableByteArray(originalData.getBytes());
            CMSEnvelopedData cmsEnvelope = encryptAlg == 1 ? cdg.generate((CMSProcessable)content, "1.2.840.113549.3.2", "BC") : cdg.generate((CMSProcessable)content, "1.2.840.113549.3.7", "BC");
            return new String(org.bouncycastle.util.encoders.Base64.encode((byte[])cmsEnvelope.getEncoded()));
        }
        catch (CMSException cmse) {
            throw new CastleException(cmse);
        }
        catch (NoSuchProviderException nspe) {
            throw new CastleException("jce provider not match");
        }
        catch (CertificateException ce) {
            throw ce;
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new CastleException("not support this algorithm");
        }
        catch (UnsupportedEncodingException usee) {
            throw new CastleException("not support UTF-16LE encoding charset");
        }
        catch (IOException ioe) {
            throw new CastleException("return the ASN.1 encoded representation of encryped result");
        }
    }

    public String decodeEnvelope(String sealedEnvelope) throws CastleException {
        Base64InputStream base64is = null;
        try {
            if (!this.mUserCertReady) {
                throw new CastleException("certificate to decrypt is not available");
            }
            base64is = new Base64InputStream((InputStream)new ByteArrayInputStream(sealedEnvelope.getBytes()));
            CMSEnvelopedData envelopedData = new CMSEnvelopedData((InputStream)base64is);
            RecipientInformationStore ris = envelopedData.getRecipientInfos();
            Collection rc = ris.getRecipients();
            Iterator it = rc.iterator();
            if (it.hasNext()) {
                RecipientInformation ri = (RecipientInformation)it.next();
                byte[] bytes = ri.getContent((Key)this.mPrivateKey, "BC");
                return new String(bytes);
            }
            throw new CastleException("not find decrypt information in sealedEnvelope");
        }
        catch (CMSException cmse) {
            throw new CastleException(cmse);
        }
        catch (NoSuchProviderException nspe) {
            throw new CastleException("jce provider not match");
        }
    }

    public String signData(String srcMessage) throws CastleException {
        try {
            if (!this.mUserCertReady) {
                throw new CastleException("certificate to sign is not available");
            }
            boolean[] keyUsage = this.mUserCert.getKeyUsage();
            if (!keyUsage[0]) {
                throw new CastleException("This certificate cannot be used to sign,it's keyUsage does not contain digitalSignature");
            }
            ArrayList<java.security.cert.X509Certificate> collection = new ArrayList<java.security.cert.X509Certificate>();
            collection.add(this.mUserCert);
            CollectionCertStoreParameters certStorePara = new CollectionCertStoreParameters(collection);
            CertStore certs = CertStore.getInstance("Collection", (CertStoreParameters)certStorePara, "BC");
            CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
            gen.addSigner(this.mPrivateKey, this.mUserCert, "1.3.14.3.2.26");
            gen.addCertificatesAndCRLs(certs);
            CMSProcessableByteArray content = new CMSProcessableByteArray(srcMessage.getBytes());
            CMSSignedData signedData = gen.generate((CMSProcessable)content, true, "BC");
            return new String(org.bouncycastle.util.encoders.Base64.encode((byte[])signedData.getEncoded()));
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new CastleException(nsae);
        }
        catch (NoSuchProviderException nspe) {
            throw new CastleException("jce provider not match");
        }
        catch (CertStoreException cse) {
            throw new CastleException(cse);
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new CastleException(iape);
        }
        catch (CMSException cmse) {
            throw new CastleException(cmse);
        }
        catch (UnsupportedEncodingException uee) {
            throw new CastleException("not support UTF-16LE encoding charset");
        }
        catch (IOException ioe) {
            throw new CastleException("return the ASN.1 encoded representation of encryped result");
        }
    }

    public String SignDataDetached(String srcMessage) throws CastleException {
        try {
            if (!this.mUserCertReady) {
                throw new CastleException("certificate to sign is not available");
            }
            boolean[] keyUsage = this.mUserCert.getKeyUsage();
            if (!keyUsage[0]) {
                throw new CastleException("This certificate cannot be used to sign,it's keyUsage does not contain digitalSignature");
            }
            PKCS7SignedData p7 = new PKCS7SignedData(this.session);
            Mechanism mechanism1 = new Mechanism("SHA1");
            byte[] signData = null;
            signData = p7.generateSignedData(false, PKCS7SignedData.DATA, srcMessage.getBytes(), mechanism1, this.p12.getPrivateKey(), this.p12.getCerts(), null);
            signData = p7.generateSignedDataContent(signData);
            byte[] b64 = Base64.encode((byte[])signData);
            signData = this.convertSignResult(b64);
            return new String(signData);
        }
        catch (Exception ex) {
            throw new CastleException(ex);
        }
    }

    public String signFile(String srcFileName) throws FileNotFoundException, IOException, CastleException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        String signedFileName = srcFileName + ".p7s";
        try {
            if (!this.mUserCertReady) {
                throw new CastleException("certificate to sign is not available");
            }
            boolean[] keyUsage = this.mUserCert.getKeyUsage();
            if (!keyUsage[0]) {
                throw new CastleException("This certificate cannot be used to sign,it's keyUsage does not contain digitalSignature");
            }
            ArrayList<java.security.cert.X509Certificate> collection = new ArrayList<java.security.cert.X509Certificate>();
            collection.add(this.mUserCert);
            CollectionCertStoreParameters certStorePara = new CollectionCertStoreParameters(collection);
            CertStore certs = CertStore.getInstance("Collection", (CertStoreParameters)certStorePara, "BC");
            CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
            gen.addSigner(this.mPrivateKey, this.mUserCert, "1.3.14.3.2.26");
            gen.addCertificatesAndCRLs(certs);
            fis = new FileInputStream(srcFileName);
            int fileSize = fis.available();
            byte[] data = new byte[fileSize];
            for (int bytesRead = 0; bytesRead < fileSize; bytesRead += fis.read(data, bytesRead, fileSize - bytesRead)) {
            }
            CMSProcessableByteArray content = new CMSProcessableByteArray(data);
            CMSSignedData signedData = gen.generate((CMSProcessable)content, true, "BC");
            fos = new FileOutputStream(signedFileName);
            fos.write(org.bouncycastle.util.encoders.Base64.encode((byte[])signedData.getEncoded()));
            String string = signedFileName;
            return string;
        }
        catch (FileNotFoundException fne) {
            throw fne;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new CastleException(nsae);
        }
        catch (NoSuchProviderException nspe) {
            throw new CastleException("jce provider not match");
        }
        catch (CertStoreException cse) {
            throw new CastleException(cse);
        }
        catch (InvalidAlgorithmParameterException iape) {
            throw new CastleException(iape);
        }
        catch (CMSException cmse) {
            throw new CastleException(cmse);
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
    }

    public String verifySignedData(String signedMessage) throws CastleException, CertificateExpiredException, CertificateNotYetValidException {
        Base64InputStream base64is = null;
        ByteArrayOutputStream bos = null;
        try {
            Collection<? extends Certificate> certCollection;
            Iterator<? extends Certificate> certIt;
            java.security.cert.X509Certificate cert;
            SignerInformation signerInfo;
            base64is = new Base64InputStream((InputStream)new ByteArrayInputStream(signedMessage.getBytes()));
            CMSSignedData signedData = new CMSSignedData((InputStream)base64is);
            CertStore certs = signedData.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore signersInfo = signedData.getSignerInfos();
            Collection signers = signersInfo.getSigners();
            Iterator it = signers.iterator();
            if (it.hasNext() && (signerInfo = (SignerInformation)it.next()).verify(cert = (java.security.cert.X509Certificate)(certIt = (certCollection = certs.getCertificates((CertSelector)signerInfo.getSID())).iterator()).next(), "BC")) {
                bos = new ByteArrayOutputStream();
                CMSProcessable cms = signedData.getSignedContent();
                cms.write((OutputStream)bos);
                return new String(bos.toByteArray());
            }
        }
        catch (CMSException cme) {
            throw new CastleException(cme);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new CastleException(nsae);
        }
        catch (NoSuchProviderException nspe) {
            throw new CastleException("jce provider not match");
        }
        catch (CertStoreException cse) {
            throw new CastleException(cse);
        }
        catch (CertificateExpiredException cee) {
            throw cee;
        }
        catch (CertificateNotYetValidException cne) {
            throw cne;
        }
        catch (IOException ioe) {
            throw new CastleException("errors getting original content from signed content");
        }
        return null;
    }

    public boolean VerifySignedDataDetached(String signature, String srcMessage) throws CastleException, CertificateExpiredException, CertificateNotYetValidException {
        PKCS7SignedData p7 = new PKCS7SignedData(this.session);
        boolean verify = false;
        try {
            p7.loadBase64(this.convert64SignResult(signature.getBytes()));
            verify = p7.verifyP7SignedData(srcMessage.getBytes());
        }
        catch (Exception ex) {
            throw new CastleException(ex);
        }
        return verify;
    }

    public boolean verifySignedFile(String signedFileName, String srcFileName) throws FileNotFoundException, IOException, CertificateExpiredException, CertificateNotYetValidException, CastleException {
        boolean verified = false;
        Base64InputStream base64is = null;
        FileOutputStream fos = null;
        try {
            Collection<? extends Certificate> certCollection;
            Iterator<? extends Certificate> certIt;
            java.security.cert.X509Certificate cert;
            SignerInformation signerInfo;
            base64is = new Base64InputStream((InputStream)new DataInputStream(new FileInputStream(signedFileName)));
            CMSSignedData signedData = new CMSSignedData((InputStream)base64is);
            CertStore certs = signedData.getCertificatesAndCRLs("Collection", "BC");
            SignerInformationStore signersInfo = signedData.getSignerInfos();
            Collection signers = signersInfo.getSigners();
            Iterator it = signers.iterator();
            if (it.hasNext() && (signerInfo = (SignerInformation)it.next()).verify(cert = (java.security.cert.X509Certificate)(certIt = (certCollection = certs.getCertificates((CertSelector)signerInfo.getSID())).iterator()).next(), "BC")) {
                verified = true;
                CMSProcessable cms = signedData.getSignedContent();
                fos = new FileOutputStream(srcFileName);
                cms.write((OutputStream)fos);
            }
        }
        catch (FileNotFoundException fne) {
            throw fne;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new CastleException(nsae);
        }
        catch (NoSuchProviderException nspe) {
            throw new CastleException("jce provider not match");
        }
        catch (CertStoreException cse) {
            throw new CastleException(cse);
        }
        catch (CMSException cmse) {
            throw new CastleException(cmse);
        }
        catch (CertificateExpiredException cee) {
            throw cee;
        }
        catch (CertificateNotYetValidException cne) {
            throw cne;
        }
        finally {
            if (base64is != null) {
                base64is.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
        return verified;
    }

    public int verifyCertificateByCacheCRL(byte[] certBytes) throws FileNotFoundException, IOException, CertificateException, CastleException {
        int checkResult;
        block39: {
            FileInputStream inStream = null;
            try {
                checkResult = this.verifyCertificate(certBytes);
                if (checkResult <= 0) {
                    int n = checkResult;
                    return n;
                }
                String crlDpValue = this.getCRLDp(certBytes);
                if (crlDpValue == null) {
                    throw new CastleException("crl distribute point value of this certificate is  not available");
                }
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream bis = new ByteArrayInputStream(certBytes);
                java.security.cert.X509Certificate cert = (java.security.cert.X509Certificate)cf.generateCertificate(bis);
                String issuer = cert.getIssuerDN().getName();
                BigInteger certSerialNum = cert.getSerialNumber();
                String caDirName = null;
                String caBigCRLFileName = null;
                if (issuer.indexOf("CFCA OCA") != -1) {
                    caDirName = "CFCAOCA";
                    caBigCRLFileName = "OCA.crl";
                } else if (issuer.indexOf("CFCA TEST CA") != -1) {
                    caDirName = "CFCATESTCA";
                    caBigCRLFileName = "TESTCA.crl";
                } else if (issuer.indexOf("CFCA Operation CA2") != -1) {
                    caDirName = "ca2CRLs";
                    caBigCRLFileName = "ca2.crl";
                } else if (issuer.indexOf("CFCA Operation CA") != -1) {
                    caDirName = "caCRLs";
                    caBigCRLFileName = "ca.crl";
                } else {
                    throw new CastleException("only supports ");
                }
                String crlFilePath = this.mCachedCRLDirPath + "/cfcaCRLs/".replace('/', File.separatorChar) + caDirName + File.separatorChar;
                File caCrlBigFile = new File(crlFilePath + caBigCRLFileName);
                int beginIndex = crlDpValue.indexOf(61) + 1;
                int endIndex = crlDpValue.indexOf(44);
                if (beginIndex == 0 || endIndex == -1) {
                    throw new CastleException("CRL\u5206\u5e03\u70b9\u5c5e\u6027\u4e0d\u89c4\u8303");
                }
                String certCrlFileName = crlDpValue.substring(beginIndex, endIndex) + ".crl";
                File certCrlFile = new File(crlFilePath + certCrlFileName);
                if (certCrlFile.exists()) {
                    inStream = new FileInputStream(certCrlFile);
                    java.security.cert.X509CRL crl = (java.security.cert.X509CRL)cf.generateCRL(inStream);
                    if (this.verifyCRL(crl)) {
                        X509CRLEntry x509Entry = crl.getRevokedCertificate(certSerialNum);
                        checkResult = x509Entry == null ? 1 : -3;
                        break block39;
                    }
                    int x509Entry = -4;
                    return x509Entry;
                }
                if (caCrlBigFile.exists()) {
                    inStream = new FileInputStream(caCrlBigFile);
                    cf = CertificateFactory.getInstance("X.509");
                    java.security.cert.X509CRL crl = (java.security.cert.X509CRL)cf.generateCRL(inStream);
                    if (this.verifyCRL(crl)) {
                        X509CRLEntry x509Entry = crl.getRevokedCertificate(certSerialNum);
                        checkResult = x509Entry == null ? 1 : -3;
                        break block39;
                    }
                    int n = -4;
                    return n;
                }
                throw new CastleException("under" + crlFilePath + "directory ,not found any cached crl file for this certificate");
            }
            catch (FileNotFoundException fe) {
                throw fe;
            }
            catch (SecurityException se) {
                throw se;
            }
            catch (CertificateException ce) {
                throw ce;
            }
            catch (CRLException crle) {
                throw new CastleException(crle);
            }
            catch (CodingException ce) {
                throw new CastleException(ce);
            }
            catch (X509ExtensionException ee) {
                throw new CastleException(ee);
            }
            finally {
                if (inStream != null) {
                    inStream.close();
                }
            }
        }
        return checkResult;
    }

    public int verifyCertificateByLDAP(byte[] certBytes) throws CertificateException, TimeLimitExceededException, NamingException, CastleException {
        int checkResult = -4;
        try {
            checkResult = this.verifyCertificate(certBytes);
            if (checkResult <= 0) {
                return checkResult;
            }
            BigInteger certSerialNum = this.getSerialNumber(certBytes);
            String crlDp = this.getCRLDp(certBytes);
            JNDIDirectory jndi = new JNDIDirectory(this.mLdapServerName, this.mLdapServerPort);
            X509CRL[] xCrl = jndi.getCRLs(crlDp, false);
            for (int i = 0; i < xCrl.length; ++i) {
                if (this.verifyCRL((java.security.cert.X509CRL)xCrl[i])) {
                    X509CRLEntry x509Entry = xCrl[i].getRevokedCertificate(certSerialNum);
                    if (x509Entry != null) {
                        checkResult = -3;
                        break;
                    }
                } else {
                    return -4;
                }
                checkResult = 1;
            }
        }
        catch (TimeLimitExceededException tlee) {
            throw tlee;
        }
        catch (NamingException ne) {
            throw ne;
        }
        catch (CodingException ce) {
            throw new CastleException(ce);
        }
        catch (CRLException crle) {
            throw new CastleException(crle);
        }
        catch (X509ExtensionException ee) {
            throw new CastleException(ee);
        }
        catch (CertificateException ce) {
            throw ce;
        }
        catch (CastleException ce) {
            throw ce;
        }
        return checkResult;
    }

    public byte[] Digest(String originData) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(originData.getBytes());
        return md.digest();
    }

    public boolean ChangePfxPwd(String pfxFileName, String oldPwd, String newPwd) throws FileNotFoundException, IOException, CertificateException, CastleException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        KeyStore keyStore = null;
        try {
            File pfxFile = new File(pfxFileName);
            char[] password = oldPwd.toCharArray();
            fis = new FileInputStream(pfxFile);
            keyStore = KeyStore.getInstance("PKCS12", "BC");
            keyStore.load(fis, password);
            fis.close();
            fos = new FileOutputStream(pfxFileName);
            keyStore.store(fos, newPwd.toCharArray());
            fos.close();
            return true;
        }
        catch (KeyStoreException kse) {
            throw new CastleException(kse);
        }
        catch (FileNotFoundException ffe) {
            throw ffe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (NoSuchProviderException nspe) {
            throw new CastleException("jce provider not match");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new CastleException("not support this algorithm");
        }
        catch (CertificateException ce) {
            throw ce;
        }
    }

    public byte[] GetCertFromPfx(String pfxFileName, String pfxPwd) throws FileNotFoundException, IOException, CertificateException, CastleException {
        Certificate publicCert = null;
        FileInputStream keyStoreStream = null;
        KeyStore keyStore = null;
        try {
            File pfxFile = new File(pfxFileName);
            char[] password = pfxPwd.toCharArray();
            keyStoreStream = new FileInputStream(pfxFile);
            keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(keyStoreStream, password);
            Enumeration<String> aliasesEnum = keyStore.aliases();
            if (aliasesEnum.hasMoreElements()) {
                String alias = aliasesEnum.nextElement();
                publicCert = (java.security.cert.X509Certificate)keyStore.getCertificate(alias);
            }
            keyStoreStream.close();
            return publicCert.getEncoded();
        }
        catch (KeyStoreException kse) {
            throw new CastleException(kse);
        }
        catch (FileNotFoundException ffe) {
            throw ffe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new CastleException("not support this algorithm");
        }
        catch (CertificateException ce) {
            throw ce;
        }
    }

    public String encryptPWD(String passwd) throws Exception {
        try {
            String mType = "DESede";
            Cipher cipher = Cipher.getInstance(mType, "BC");
            int cipherMode = 1;
            SecretKeySpec secretKey = new SecretKeySpec("1111110001110101".getBytes(), "DESede");
            cipher.init(cipherMode, secretKey);
            byte[] res = cipher.doFinal(passwd.getBytes());
            return new String(org.bouncycastle.util.encoders.Base64.encode((byte[])res));
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }

    public String decryptPWD(String encryptedPWD) throws Exception {
        try {
            String mType = "DESede";
            Cipher cipher = Cipher.getInstance(mType, "BC");
            int cipherMode = 2;
            SecretKeySpec secretKey = new SecretKeySpec("1111110001110101".getBytes(), "DESede");
            cipher.init(cipherMode, secretKey);
            byte[] res = cipher.doFinal(org.bouncycastle.util.encoders.Base64.decode((byte[])encryptedPWD.getBytes()));
            return new String(res);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
    }

    private byte[] convertSignResult(byte[] data) {
        byte tmp;
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((tmp = (byte)bis.read()) != -1) {
            bos.write(tmp);
        }
        byte[] base64Data = new String(bos.toByteArray()).trim().getBytes();
        bos = new ByteArrayOutputStream();
        try {
            for (int i = 0; i < base64Data.length; ++i) {
                if (i != 0 && i % 64 == 0) {
                    bos.write("\r\n".getBytes());
                }
                bos.write(base64Data[i]);
            }
            bos.write("\r\n".getBytes());
        }
        catch (Exception ex) {
            return null;
        }
        return bos.toByteArray();
    }

    private byte[] convert64SignResult(byte[] data) {
        byte tmp;
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        while ((tmp = (byte)bis.read()) != -1) {
            if (tmp == 10 || tmp == 13) continue;
            bos.write(tmp);
        }
        byte[] base64Data = new String(bos.toByteArray()).trim().getBytes();
        return base64Data;
    }

    public static void main(String[] args) throws Exception {
        CastleProperties castleProperties = new CastleProperties();
        castleProperties.setmCachedCRLDirPath("E:\\projects\\\u4eba\u884c\\\u4eba\u884c\\\u6d4b\u8bd5\\testCerts");
        castleProperties.setmLdapServerName("210.74.41.105");
        castleProperties.setmLdapServerPort(389);
        castleProperties.setmUserCertFilePath("E:\\test\\cfca\\server.pfx");
        castleProperties.setmUserCertPassword("1234");
        Castle castle = new Castle(castleProperties);
        castle.initCertAppContext();
        System.out.println(castle.getNotAfter());
        String srcMsg = "111111";
        String signature = castle.SignDataDetached(srcMsg);
        System.out.println(signature);
        FileOutputStream fos = new FileOutputStream("e:/signedData.txt");
        fos.write(signature.getBytes());
        fos.close();
        if (castle.VerifySignedDataDetached(signature, srcMsg)) {
            System.out.println("Success!");
        } else {
            System.out.println("Fail!");
        }
        System.out.println("\u52a0\u5bc6\u540e\u53e3\u4ee4\uff1a" + castle.encryptPWD("2231"));
        System.out.println("\u89e3\u5bc6\u540e\u53e3\u4ee4\uff1a" + castle.decryptPWD("M8cH5Zmquws="));
    }
}

