/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.contrib.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.contrib.ssl.AuthSSLInitializationError;
import org.apache.commons.httpclient.contrib.ssl.AuthSSLX509TrustManager;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuthSSLProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$commons$httpclient$contrib$ssl$AuthSSLProtocolSocketFactory == null ? (class$org$apache$commons$httpclient$contrib$ssl$AuthSSLProtocolSocketFactory = AuthSSLProtocolSocketFactory.class$("org.apache.commons.httpclient.contrib.ssl.AuthSSLProtocolSocketFactory")) : class$org$apache$commons$httpclient$contrib$ssl$AuthSSLProtocolSocketFactory));
    private URL keystoreUrl = null;
    private String keystorePassword = null;
    private URL truststoreUrl = null;
    private String truststorePassword = null;
    private SSLContext sslcontext = null;
    static /* synthetic */ Class class$org$apache$commons$httpclient$contrib$ssl$AuthSSLProtocolSocketFactory;

    public AuthSSLProtocolSocketFactory(URL uRL, String string, URL uRL2, String string2) {
        this.keystoreUrl = uRL;
        this.keystorePassword = string;
        this.truststoreUrl = uRL2;
        this.truststorePassword = string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore createKeyStore(URL uRL, String string) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        if (uRL == null) {
            throw new IllegalArgumentException("Keystore url may not be null");
        }
        LOG.debug((Object)"Initializing key store");
        KeyStore keyStore = KeyStore.getInstance("jks");
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            keyStore.load(inputStream, string != null ? string.toCharArray() : null);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return keyStore;
    }

    private static KeyManager[] createKeyManagers(KeyStore keyStore, String string) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (keyStore == null) {
            throw new IllegalArgumentException("Keystore may not be null");
        }
        LOG.debug((Object)"Initializing key manager");
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(keyStore, string != null ? string.toCharArray() : null);
        return keyManagerFactory.getKeyManagers();
    }

    private static TrustManager[] createTrustManagers(KeyStore keyStore) throws KeyStoreException, NoSuchAlgorithmException {
        if (keyStore == null) {
            throw new IllegalArgumentException("Keystore may not be null");
        }
        LOG.debug((Object)"Initializing trust manager");
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
        for (int i = 0; i < trustManagerArray.length; ++i) {
            if (!(trustManagerArray[i] instanceof X509TrustManager)) continue;
            trustManagerArray[i] = new AuthSSLX509TrustManager((X509TrustManager)trustManagerArray[i]);
        }
        return trustManagerArray;
    }

    private SSLContext createSSLContext() {
        try {
            Object object;
            String string;
            Enumeration<String> enumeration;
            Object object2;
            KeyManager[] keyManagerArray = null;
            TrustManager[] trustManagerArray = null;
            if (this.keystoreUrl != null) {
                object2 = AuthSSLProtocolSocketFactory.createKeyStore(this.keystoreUrl, this.keystorePassword);
                if (LOG.isDebugEnabled()) {
                    enumeration = ((KeyStore)object2).aliases();
                    while (enumeration.hasMoreElements()) {
                        string = enumeration.nextElement();
                        object = ((KeyStore)object2).getCertificateChain(string);
                        if (object == null) continue;
                        LOG.debug((Object)("Certificate chain '" + string + "':"));
                        for (int i = 0; i < ((Certificate[])object).length; ++i) {
                            if (!(object[i] instanceof X509Certificate)) continue;
                            X509Certificate x509Certificate = (X509Certificate)object[i];
                            LOG.debug((Object)(" Certificate " + (i + 1) + ":"));
                            LOG.debug((Object)("  Subject DN: " + x509Certificate.getSubjectDN()));
                            LOG.debug((Object)("  Signature Algorithm: " + x509Certificate.getSigAlgName()));
                            LOG.debug((Object)("  Valid from: " + x509Certificate.getNotBefore()));
                            LOG.debug((Object)("  Valid until: " + x509Certificate.getNotAfter()));
                            LOG.debug((Object)("  Issuer: " + x509Certificate.getIssuerDN()));
                        }
                    }
                }
                keyManagerArray = AuthSSLProtocolSocketFactory.createKeyManagers((KeyStore)object2, this.keystorePassword);
            }
            if (this.truststoreUrl != null) {
                object2 = AuthSSLProtocolSocketFactory.createKeyStore(this.truststoreUrl, this.truststorePassword);
                if (LOG.isDebugEnabled()) {
                    enumeration = ((KeyStore)object2).aliases();
                    while (enumeration.hasMoreElements()) {
                        string = enumeration.nextElement();
                        LOG.debug((Object)("Trusted certificate '" + string + "':"));
                        object = ((KeyStore)object2).getCertificate(string);
                        if (object == null || !(object instanceof X509Certificate)) continue;
                        X509Certificate x509Certificate = (X509Certificate)object;
                        LOG.debug((Object)("  Subject DN: " + x509Certificate.getSubjectDN()));
                        LOG.debug((Object)("  Signature Algorithm: " + x509Certificate.getSigAlgName()));
                        LOG.debug((Object)("  Valid from: " + x509Certificate.getNotBefore()));
                        LOG.debug((Object)("  Valid until: " + x509Certificate.getNotAfter()));
                        LOG.debug((Object)("  Issuer: " + x509Certificate.getIssuerDN()));
                    }
                }
                trustManagerArray = AuthSSLProtocolSocketFactory.createTrustManagers((KeyStore)object2);
            }
            object2 = SSLContext.getInstance("SSL");
            ((SSLContext)object2).init(keyManagerArray, trustManagerArray, null);
            return object2;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOG.error((Object)noSuchAlgorithmException.getMessage(), (Throwable)noSuchAlgorithmException);
            throw new AuthSSLInitializationError("Unsupported algorithm exception: " + noSuchAlgorithmException.getMessage());
        }
        catch (KeyStoreException keyStoreException) {
            LOG.error((Object)keyStoreException.getMessage(), (Throwable)keyStoreException);
            throw new AuthSSLInitializationError("Keystore exception: " + keyStoreException.getMessage());
        }
        catch (GeneralSecurityException generalSecurityException) {
            LOG.error((Object)generalSecurityException.getMessage(), (Throwable)generalSecurityException);
            throw new AuthSSLInitializationError("Key management exception: " + generalSecurityException.getMessage());
        }
        catch (IOException iOException) {
            LOG.error((Object)iOException.getMessage(), (Throwable)iOException);
            throw new AuthSSLInitializationError("I/O error reading keystore/truststore file: " + iOException.getMessage());
        }
    }

    private SSLContext getSSLContext() {
        if (this.sslcontext == null) {
            this.sslcontext = this.createSSLContext();
        }
        return this.sslcontext;
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2, HttpConnectionParams httpConnectionParams) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (httpConnectionParams == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int n3 = httpConnectionParams.getConnectionTimeout();
        SSLSocketFactory sSLSocketFactory = this.getSSLContext().getSocketFactory();
        if (n3 == 0) {
            return sSLSocketFactory.createSocket(string, n, inetAddress, n2);
        }
        Socket socket = sSLSocketFactory.createSocket();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n2);
        InetSocketAddress inetSocketAddress2 = new InetSocketAddress(string, n);
        socket.bind(inetSocketAddress);
        socket.connect(inetSocketAddress2, n3);
        return socket;
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException, UnknownHostException {
        return this.getSSLContext().getSocketFactory().createSocket(string, n, inetAddress, n2);
    }

    public Socket createSocket(String string, int n) throws IOException, UnknownHostException {
        return this.getSSLContext().getSocketFactory().createSocket(string, n);
    }

    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException, UnknownHostException {
        return this.getSSLContext().getSocketFactory().createSocket(socket, string, n, bl);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

