/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.print.win32;

import com.kingdee.bos.ctrl.print.win32.KDWPrinterJob;
import com.kingdee.bos.ctrl.print.win32.PrintJobAttributeException;
import com.kingdee.bos.ctrl.print.win32.PrintJobFlavorException;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.util.Vector;
import javax.print.CancelablePrintJob;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSetUtilities;
import javax.print.attribute.HashPrintJobAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintJobAttribute;
import javax.print.attribute.PrintJobAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.DocumentName;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobOriginatingUserName;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.event.PrintJobAttributeListener;
import javax.print.event.PrintJobEvent;
import javax.print.event.PrintJobListener;
import sun.print.Win32PrintService;

public class KDWin32PrintJob
implements CancelablePrintJob {
    private transient Vector jobListeners;
    private transient Vector attrListeners;
    private transient Vector listenedAttributeSets;
    private Win32PrintService service;
    private boolean fidelity;
    private boolean printing = false;
    private boolean printReturned = false;
    private PrintRequestAttributeSet reqAttrSet = null;
    private PrintJobAttributeSet jobAttrSet = null;
    private PrinterJob job;
    private Doc doc;
    private String mDestination = null;
    private InputStream instream = null;
    private Reader reader = null;
    private String jobName = "Java Printing";
    private int copies = 0;
    private MediaSizeName mediaName = null;
    private MediaSize mediaSize = null;
    private OrientationRequested orient = null;
    private long hPrintJob;
    private static final int PRINTBUFFERLEN = 8192;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;

    public KDWin32PrintJob(Win32PrintService service) {
        this.service = service;
    }

    public PrintService getPrintService() {
        return this.service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrintJobAttributeSet getAttributes() {
        KDWin32PrintJob kDWin32PrintJob = this;
        synchronized (kDWin32PrintJob) {
            if (this.jobAttrSet == null) {
                HashPrintJobAttributeSet jobSet = new HashPrintJobAttributeSet();
                return AttributeSetUtilities.unmodifiableView(jobSet);
            }
            return this.jobAttrSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrintJobListener(PrintJobListener listener) {
        KDWin32PrintJob kDWin32PrintJob = this;
        synchronized (kDWin32PrintJob) {
            if (listener == null) {
                return;
            }
            if (this.jobListeners == null) {
                this.jobListeners = new Vector();
            }
            this.jobListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrintJobListener(PrintJobListener listener) {
        KDWin32PrintJob kDWin32PrintJob = this;
        synchronized (kDWin32PrintJob) {
            if (listener == null || this.jobListeners == null) {
                return;
            }
            this.jobListeners.remove(listener);
            if (this.jobListeners.isEmpty()) {
                this.jobListeners = null;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void closeDataStreams() {
        if (this.doc == null) {
            return;
        }
        Object data = null;
        try {
            data = this.doc.getPrintData();
        }
        catch (IOException e) {
            return;
        }
        if (this.instream != null) {
            try {
                try {
                    this.instream.close();
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                Object var3_9 = null;
                this.instream = null;
                throw throwable;
            }
            {
                Object var3_10 = null;
                this.instream = null;
                return;
            }
        }
        if (this.reader != null) {
            try {
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                Object var3_11 = null;
                this.reader = null;
                throw throwable;
            }
            {
                Object var3_12 = null;
                this.reader = null;
                return;
            }
        }
        if (data instanceof InputStream) {
            try {
                ((InputStream)data).close();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }
        if (!(data instanceof Reader)) return;
        try {
            ((Reader)data).close();
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyEvent(int reason) {
        switch (reason) {
            case 101: 
            case 102: 
            case 103: 
            case 105: 
            case 106: {
                this.closeDataStreams();
            }
        }
        KDWin32PrintJob kDWin32PrintJob = this;
        synchronized (kDWin32PrintJob) {
            if (this.jobListeners != null) {
                PrintJobEvent event = new PrintJobEvent(this, reason);
                int i = 0;
                while (i < this.jobListeners.size()) {
                    PrintJobListener listener = (PrintJobListener)this.jobListeners.elementAt(i);
                    switch (reason) {
                        case 102: {
                            listener.printJobCompleted(event);
                            break;
                        }
                        case 101: {
                            listener.printJobCanceled(event);
                            break;
                        }
                        case 103: {
                            listener.printJobFailed(event);
                            break;
                        }
                        case 106: {
                            listener.printDataTransferCompleted(event);
                            break;
                        }
                        case 105: {
                            listener.printJobNoMoreEvents(event);
                            break;
                        }
                    }
                    ++i;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrintJobAttributeListener(PrintJobAttributeListener listener, PrintJobAttributeSet attributes) {
        KDWin32PrintJob kDWin32PrintJob = this;
        synchronized (kDWin32PrintJob) {
            if (listener == null) {
                return;
            }
            if (this.attrListeners == null) {
                this.attrListeners = new Vector();
                this.listenedAttributeSets = new Vector();
            }
            this.attrListeners.add(listener);
            if (attributes == null) {
                attributes = new HashPrintJobAttributeSet();
            }
            this.listenedAttributeSets.add(attributes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrintJobAttributeListener(PrintJobAttributeListener listener) {
        KDWin32PrintJob kDWin32PrintJob = this;
        synchronized (kDWin32PrintJob) {
            if (listener == null || this.attrListeners == null) {
                return;
            }
            int index = this.attrListeners.indexOf(listener);
            if (index == -1) {
                return;
            }
            this.attrListeners.remove(index);
            this.listenedAttributeSets.remove(index);
            if (this.attrListeners.isEmpty()) {
                this.attrListeners = null;
                this.listenedAttributeSets = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void print(Doc doc, PrintRequestAttributeSet attributes) throws PrintException {
        block42: {
            Object data;
            KDWin32PrintJob kDWin32PrintJob = this;
            synchronized (kDWin32PrintJob) {
                if (this.printing) {
                    throw new PrintException("already printing");
                }
                this.printing = true;
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("javax.print.attribute.standard.PrinterIsAcceptingJobs");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$0 = clazz2;
            }
            if ((PrinterIsAcceptingJobs)this.service.getAttribute((Class)clazz) == PrinterIsAcceptingJobs.NOT_ACCEPTING_JOBS) {
                throw new PrintException("Printer is not accepting job.");
            }
            this.doc = doc;
            DocFlavor flavor = doc.getDocFlavor();
            try {
                data = doc.getPrintData();
            }
            catch (IOException e) {
                this.notifyEvent(103);
                throw new PrintException("can't get print data: " + e.toString());
            }
            if (flavor == null || !this.service.isDocFlavorSupported(flavor)) {
                this.notifyEvent(103);
                throw new PrintJobFlavorException("invalid flavor", flavor);
            }
            this.initializeAttributeSets(doc, attributes);
            this.getAttributeValues(flavor);
            String repClassName = flavor.getRepresentationClassName();
            if (flavor.equals(DocFlavor.INPUT_STREAM.GIF) || flavor.equals(DocFlavor.INPUT_STREAM.JPEG) || flavor.equals(DocFlavor.INPUT_STREAM.PNG) || flavor.equals(DocFlavor.BYTE_ARRAY.GIF) || flavor.equals(DocFlavor.BYTE_ARRAY.JPEG) || flavor.equals(DocFlavor.BYTE_ARRAY.PNG) || flavor == DocFlavor.URL.GIF || flavor == DocFlavor.URL.JPEG || flavor == DocFlavor.URL.PNG) break block42;
            if (repClassName.equals("java.awt.print.Pageable")) {
                try {
                    this.pageableJob((Pageable)doc.getPrintData());
                    this.service.wakeNotifier();
                    return;
                }
                catch (ClassCastException cce) {
                    this.notifyEvent(103);
                    throw new PrintException(cce);
                }
                catch (IOException ioe) {
                    this.notifyEvent(103);
                    throw new PrintException(ioe);
                }
            }
            if (repClassName.equals("java.awt.print.Printable")) {
                try {
                    this.printableJob((Printable)doc.getPrintData());
                    this.service.wakeNotifier();
                    return;
                }
                catch (ClassCastException cce) {
                    this.notifyEvent(103);
                    throw new PrintException(cce);
                }
                catch (IOException ioe) {
                    this.notifyEvent(103);
                    throw new PrintException(ioe);
                }
            }
            if (!(repClassName.equals("[B") || repClassName.equals("java.io.InputStream") || repClassName.equals("java.net.URL"))) {
                this.notifyEvent(103);
                throw new PrintException("unrecognized class: " + repClassName);
            }
            if (repClassName.equals("java.net.URL")) {
                URL url = (URL)data;
                try {
                    this.instream = url.openStream();
                }
                catch (IOException e) {
                    this.notifyEvent(103);
                    throw new PrintException(e.toString());
                }
            }
            try {
                this.instream = doc.getStreamForBytes();
            }
            catch (IOException ioe) {
                this.notifyEvent(103);
                throw new PrintException(ioe.toString());
            }
            if (this.instream == null) {
                this.notifyEvent(103);
                throw new PrintException("No stream for data");
            }
            if (this.mDestination != null) {
                try {
                    FileOutputStream fos = new FileOutputStream(this.mDestination);
                    byte[] buffer = new byte[1024];
                    while (true) {
                        int cread;
                        if ((cread = this.instream.read(buffer, 0, buffer.length)) < 0) {
                            fos.flush();
                            fos.close();
                            break;
                        }
                        fos.write(buffer, 0, cread);
                    }
                }
                catch (FileNotFoundException fnfe) {
                    this.notifyEvent(103);
                    throw new PrintException(fnfe.toString());
                }
                catch (IOException ioe) {
                    this.notifyEvent(103);
                    throw new PrintException(ioe.toString());
                }
                this.notifyEvent(106);
                this.notifyEvent(102);
                this.service.wakeNotifier();
                return;
            }
            if (!this.startPrintRawData(this.service.getName())) {
                this.notifyEvent(103);
                throw new PrintException("Print job failed to start.");
            }
            BufferedInputStream bin = new BufferedInputStream(this.instream);
            int bread = 0;
            try {
                try {
                    block41: {
                        byte[] buffer = new byte[8192];
                        do {
                            if ((bread = bin.read(buffer, 0, 8192)) >= 0) continue;
                            bin.close();
                            if (!this.endPrintRawData()) {
                                this.notifyEvent(103);
                                throw new PrintException("Print job failed to close properly.");
                            }
                            break block41;
                        } while (this.printRawData(buffer, bread));
                        bin.close();
                        this.notifyEvent(103);
                        throw new PrintException("Problem while spooling data");
                    }
                    this.notifyEvent(106);
                }
                catch (IOException e) {
                    this.notifyEvent(103);
                    throw new PrintException(e.toString());
                }
            }
            catch (Throwable throwable) {
                Object var9_22 = null;
                this.notifyEvent(105);
                throw throwable;
            }
            {
                Object var9_23 = null;
                this.notifyEvent(105);
            }
        }
        this.service.wakeNotifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printableJob(Printable printable) throws PrintException {
        try {
            try {
                KDWin32PrintJob kDWin32PrintJob = this;
                synchronized (kDWin32PrintJob) {
                    if (this.job != null) {
                        throw new PrintException("already printing");
                    }
                    this.job = new KDWPrinterJob();
                }
                PrintService svc = this.getPrintService();
                this.job.setPrintService(svc);
                if (this.copies == 0) {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("javax.print.attribute.standard.Copies");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Copies c = (Copies)svc.getDefaultAttributeValue((Class<? extends Attribute>)clazz);
                    this.copies = c.getValue();
                }
                if (this.mediaName == null) {
                    Object media;
                    Class<?> clazz = class$2;
                    if (clazz == null) {
                        try {
                            clazz = class$2 = Class.forName("javax.print.attribute.standard.Media");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((media = svc.getDefaultAttributeValue((Class<? extends Attribute>)clazz)) instanceof MediaSizeName) {
                        this.mediaName = (MediaSizeName)media;
                        this.mediaSize = MediaSize.getMediaSizeForName(this.mediaName);
                    }
                }
                if (this.orient == null) {
                    Class<?> clazz = class$3;
                    if (clazz == null) {
                        try {
                            clazz = class$3 = Class.forName("javax.print.attribute.standard.OrientationRequested");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    this.orient = (OrientationRequested)svc.getDefaultAttributeValue((Class<? extends Attribute>)clazz);
                }
                this.job.setCopies(this.copies);
                this.job.setJobName(this.jobName);
                PageFormat pf = new PageFormat();
                if (this.mediaSize != null) {
                    Paper p = new Paper();
                    p.setSize((double)this.mediaSize.getX(25400) * 72.0, (double)this.mediaSize.getY(25400) * 72.0);
                    p.setImageableArea(72.0, 72.0, p.getWidth() - 144.0, p.getHeight() - 144.0);
                    pf.setPaper(p);
                }
                if (this.orient == OrientationRequested.REVERSE_LANDSCAPE) {
                    pf.setOrientation(2);
                } else if (this.orient == OrientationRequested.LANDSCAPE) {
                    pf.setOrientation(0);
                }
                this.job.setPrintable(printable, pf);
                this.job.print(this.reqAttrSet);
                this.notifyEvent(106);
                Object var5_6 = null;
                this.printReturned = true;
                this.notifyEvent(105);
                return;
            }
            catch (PrinterException pe) {
                this.notifyEvent(103);
                throw new PrintException(pe);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.printReturned = true;
            this.notifyEvent(105);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pageableJob(Pageable pageable) throws PrintException {
        try {
            try {
                KDWin32PrintJob kDWin32PrintJob = this;
                synchronized (kDWin32PrintJob) {
                    if (this.job != null) {
                        throw new PrintException("already printing");
                    }
                    this.job = new KDWPrinterJob();
                }
                PrintService svc = this.getPrintService();
                this.job.setPrintService(svc);
                if (this.copies == 0) {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("javax.print.attribute.standard.Copies");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Copies c = (Copies)svc.getDefaultAttributeValue((Class<? extends Attribute>)clazz);
                    this.copies = c.getValue();
                }
                this.job.setCopies(this.copies);
                this.job.setJobName(this.jobName);
                this.job.setPageable(pageable);
                this.job.print(this.reqAttrSet);
                this.notifyEvent(106);
                Object var4_5 = null;
                this.printReturned = true;
                this.notifyEvent(105);
                return;
            }
            catch (PrinterException pe) {
                this.notifyEvent(103);
                throw new PrintException(pe);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.printReturned = true;
            this.notifyEvent(105);
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void initializeAttributeSets(Doc doc, PrintRequestAttributeSet reqSet) {
        block34: {
            this.reqAttrSet = new HashPrintRequestAttributeSet();
            this.jobAttrSet = new HashPrintJobAttributeSet();
            if (reqSet != null) {
                this.reqAttrSet.addAll(reqSet);
                attrs = reqSet.toArray();
                i = 0;
                while (i < attrs.length) {
                    if (attrs[i] instanceof PrintJobAttribute) {
                        this.jobAttrSet.add(attrs[i]);
                    }
                    ++i;
                }
            }
            if ((docSet = doc.getAttributes()) != null) {
                attrs = docSet.toArray();
                i = 0;
                while (i < attrs.length) {
                    if (attrs[i] instanceof PrintRequestAttribute) {
                        this.reqAttrSet.add(attrs[i]);
                    }
                    if (attrs[i] instanceof PrintJobAttribute) {
                        this.jobAttrSet.add(attrs[i]);
                    }
                    ++i;
                }
            }
            userName = "";
            try {
                userName = System.getProperty("user.name");
            }
            catch (SecurityException var6_8) {
                // empty catch block
            }
            if (userName == null || userName.equals("")) {
                v0 = KDWin32PrintJob.class$4;
                if (v0 == null) {
                    try {
                        v0 = KDWin32PrintJob.class$4 = Class.forName("javax.print.attribute.standard.RequestingUserName");
                    }
                    catch (ClassNotFoundException v1) {
                        throw new NoClassDefFoundError(v1.getMessage());
                    }
                }
                if ((ruName = (RequestingUserName)reqSet.get(v0)) != null) {
                    this.jobAttrSet.add(new JobOriginatingUserName(ruName.getValue(), ruName.getLocale()));
                } else {
                    this.jobAttrSet.add(new JobOriginatingUserName("", null));
                }
            } else {
                this.jobAttrSet.add(new JobOriginatingUserName(userName, null));
            }
            if ((v2 = KDWin32PrintJob.class$5) == null) {
                try {
                    v2 = KDWin32PrintJob.class$5 = Class.forName("javax.print.attribute.standard.JobName");
                }
                catch (ClassNotFoundException v3) {
                    throw new NoClassDefFoundError(v3.getMessage());
                }
            }
            if (this.jobAttrSet.get(v2) != null) break block34;
            if (docSet == null) ** GOTO lbl-1000
            v4 = KDWin32PrintJob.class$6;
            if (v4 == null) {
                try {
                    v4 = KDWin32PrintJob.class$6 = Class.forName("javax.print.attribute.standard.DocumentName");
                }
                catch (ClassNotFoundException v5) {
                    throw new NoClassDefFoundError(v5.getMessage());
                }
            }
            if (docSet.get(v4) != null) {
                v6 = KDWin32PrintJob.class$6;
                if (v6 == null) {
                    try {
                        v6 = KDWin32PrintJob.class$6 = Class.forName("javax.print.attribute.standard.DocumentName");
                    }
                    catch (ClassNotFoundException v7) {
                        throw new NoClassDefFoundError(v7.getMessage());
                    }
                }
                docName = (DocumentName)docSet.get(v6);
                jobName = new JobName(docName.getValue(), docName.getLocale());
                this.jobAttrSet.add(jobName);
            } else lbl-1000:
            // 2 sources

            {
                str = "JPS Job:" + doc;
                try {
                    printData = doc.getPrintData();
                    if (printData instanceof URL) {
                        str = ((URL)doc.getPrintData()).toString();
                    }
                }
                catch (IOException var8_13) {
                    // empty catch block
                }
                jobName = new JobName(str, null);
                this.jobAttrSet.add(jobName);
            }
        }
        this.jobAttrSet = AttributeSetUtilities.unmodifiableView(this.jobAttrSet);
    }

    private void getAttributeValues(DocFlavor flavor) throws PrintException {
        Class<?> clazz = class$7;
        if (clazz == null) {
            try {
                clazz = class$7 = Class.forName("javax.print.attribute.standard.Fidelity");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fidelity = this.reqAttrSet.get(clazz) == Fidelity.FIDELITY_TRUE;
        Attribute[] attrs = this.reqAttrSet.toArray();
        int i = 0;
        while (i < attrs.length) {
            Class<?> clazz2;
            Attribute attr = attrs[i];
            Class<? extends Attribute> category = attr.getCategory();
            if (this.fidelity) {
                if (!this.service.isAttributeCategorySupported(category)) {
                    this.notifyEvent(103);
                    throw new PrintJobAttributeException("unsupported category: " + category, category, null);
                }
                if (!this.service.isAttributeValueSupported(attr, flavor, null)) {
                    this.notifyEvent(103);
                    throw new PrintJobAttributeException("unsupported attribute: " + attr, null, attr);
                }
            }
            if ((clazz2 = class$8) == null) {
                try {
                    clazz2 = Class.forName("javax.print.attribute.standard.Destination");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (category == clazz2) {
                URI uri = ((Destination)attr).getURI();
                if (!"file".equals(uri.getScheme())) {
                    this.notifyEvent(103);
                    throw new PrintException("Not a file: URI");
                }
                try {
                    this.mDestination = new File(uri).getPath();
                }
                catch (Exception e) {
                    throw new PrintException(e);
                }
                SecurityManager security = System.getSecurityManager();
                if (security != null) {
                    try {
                        security.checkWrite(this.mDestination);
                    }
                    catch (SecurityException se) {
                        this.notifyEvent(103);
                        throw new PrintException(se);
                    }
                }
            } else {
                Class<?> clazz3 = class$5;
                if (clazz3 == null) {
                    try {
                        clazz3 = Class.forName("javax.print.attribute.standard.JobName");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (category == clazz3) {
                    this.jobName = ((JobName)attr).getValue();
                } else {
                    Class<?> clazz4 = class$1;
                    if (clazz4 == null) {
                        try {
                            clazz4 = Class.forName("javax.print.attribute.standard.Copies");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (category == clazz4) {
                        this.copies = ((Copies)attr).getValue();
                    } else {
                        Class<?> clazz5 = class$2;
                        if (clazz5 == null) {
                            try {
                                clazz5 = Class.forName("javax.print.attribute.standard.Media");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if (category == clazz5) {
                            if (attr instanceof MediaSizeName) {
                                this.mediaName = (MediaSizeName)attr;
                                if (!this.service.isAttributeValueSupported(attr, null, null)) {
                                    this.mediaSize = MediaSize.getMediaSizeForName(this.mediaName);
                                }
                            }
                        } else {
                            Class<?> clazz6 = class$3;
                            if (clazz6 == null) {
                                try {
                                    clazz6 = Class.forName("javax.print.attribute.standard.OrientationRequested");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            if (category == clazz6) {
                                this.orient = (OrientationRequested)attr;
                            }
                        }
                    }
                }
            }
            ++i;
        }
    }

    private native boolean startPrintRawData(String var1);

    private native boolean printRawData(byte[] var1, int var2);

    private native boolean endPrintRawData();

    public void cancel() throws PrintException {
        KDWin32PrintJob kDWin32PrintJob = this;
        synchronized (kDWin32PrintJob) {
            if (!this.printing) {
                throw new PrintException("Job is not yet submitted.");
            }
            if (this.job != null && !this.printReturned) {
                this.job.cancel();
                this.notifyEvent(101);
                return;
            }
            throw new PrintException("Job could not be cancelled.");
        }
    }
}

