/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.fonts.truetype;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.xmlgraphics.fonts.Glyphs;
import org.docx4j.fonts.fop.fonts.BFEntry;
import org.docx4j.fonts.fop.fonts.CIDFontType;
import org.docx4j.fonts.fop.fonts.EncodingMode;
import org.docx4j.fonts.fop.fonts.FontLoader;
import org.docx4j.fonts.fop.fonts.FontResolver;
import org.docx4j.fonts.fop.fonts.FontType;
import org.docx4j.fonts.fop.fonts.MultiByteFont;
import org.docx4j.fonts.fop.fonts.NamedCharacter;
import org.docx4j.fonts.fop.fonts.SingleByteFont;
import org.docx4j.fonts.fop.fonts.truetype.FontFileReader;
import org.docx4j.fonts.fop.fonts.truetype.TTFCmapEntry;
import org.docx4j.fonts.fop.fonts.truetype.TTFFile;

public class TTFFontLoader
extends FontLoader {
    private MultiByteFont multiFont;
    private SingleByteFont singleFont;
    private String subFontName;
    private EncodingMode encodingMode;

    public TTFFontLoader(String fontFileURI, FontResolver resolver) {
        this(fontFileURI, null, true, EncodingMode.AUTO, true, resolver);
    }

    public TTFFontLoader(String fontFileURI, String subFontName, boolean embedded, EncodingMode encodingMode, boolean useKerning, FontResolver resolver) {
        super(fontFileURI, embedded, true, resolver);
        this.subFontName = subFontName;
        this.encodingMode = encodingMode;
        if (this.encodingMode == EncodingMode.AUTO) {
            this.encodingMode = EncodingMode.CID;
        }
    }

    @Override
    protected void read() throws IOException {
        this.read(this.subFontName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(String ttcFontName) throws IOException {
        InputStream in = TTFFontLoader.openFontUri(this.resolver, this.fontFileURI);
        try {
            TTFFile ttf = new TTFFile();
            FontFileReader reader = new FontFileReader(in);
            boolean supported = ttf.readFont(reader, ttcFontName);
            if (!supported) {
                throw new IOException("TrueType font is not supported: " + this.fontFileURI);
            }
            this.buildFont(ttf, ttcFontName);
            this.loaded = true;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    private void buildFont(TTFFile ttf, String ttcFontName) {
        if (ttf.isCFF()) {
            throw new UnsupportedOperationException("OpenType fonts with CFF data are not supported, yet");
        }
        boolean isCid = this.embedded;
        if (this.encodingMode == EncodingMode.SINGLE_BYTE) {
            isCid = false;
        }
        if (isCid) {
            this.multiFont = new MultiByteFont();
            this.returnFont = this.multiFont;
            this.multiFont.setTTCName(ttcFontName);
        } else {
            this.singleFont = new SingleByteFont();
            this.returnFont = this.singleFont;
        }
        this.returnFont.setResolver(this.resolver);
        this.returnFont.setFontName(ttf.getPostScriptName());
        this.returnFont.setFullName(ttf.getFullName());
        this.returnFont.setFamilyNames(ttf.getFamilyNames());
        this.returnFont.setFontSubFamilyName(ttf.getSubFamilyName());
        this.returnFont.setCapHeight(ttf.getCapHeight());
        this.returnFont.setXHeight(ttf.getXHeight());
        this.returnFont.setAscender(ttf.getLowerCaseAscent());
        this.returnFont.setDescender(ttf.getLowerCaseDescent());
        this.returnFont.setFontBBox(ttf.getFontBBox());
        this.returnFont.setFlags(ttf.getFlags());
        this.returnFont.setStemV(Integer.parseInt(ttf.getStemV()));
        this.returnFont.setItalicAngle(Integer.parseInt(ttf.getItalicAngle()));
        this.returnFont.setMissingWidth(0);
        this.returnFont.setWeight(ttf.getWeightClass());
        this.returnFont.setPanose(ttf.getPanose());
        this.returnFont.setEmbeddable(ttf.isEmbeddable());
        if (isCid) {
            this.multiFont.setCIDType(CIDFontType.CIDTYPE2);
            int[] wx = ttf.getWidths();
            this.multiFont.setWidthArray(wx);
            List entries = ttf.getCMaps();
            BFEntry[] bfentries = new BFEntry[entries.size()];
            int pos = 0;
            ListIterator iter = ttf.getCMaps().listIterator();
            while (iter.hasNext()) {
                TTFCmapEntry ce = (TTFCmapEntry)iter.next();
                bfentries[pos] = new BFEntry(ce.getUnicodeStart(), ce.getUnicodeEnd(), ce.getGlyphStartIndex());
                ++pos;
            }
            this.multiFont.setBFEntries(bfentries);
        } else {
            this.singleFont.setFontType(FontType.TRUETYPE);
            this.singleFont.setEncoding(ttf.getCharSetName());
            this.returnFont.setFirstChar(ttf.getFirstChar());
            this.returnFont.setLastChar(ttf.getLastChar());
            this.copyWidthsSingleByte(ttf);
        }
        if (this.useKerning) {
            this.copyKerning(ttf, isCid);
        }
        if (this.embedded && ttf.isEmbeddable()) {
            this.returnFont.setEmbedFileName(this.fontFileURI);
        }
    }

    private void copyWidthsSingleByte(TTFFile ttf) {
        int[] wx = ttf.getWidths();
        for (int i = this.singleFont.getFirstChar(); i <= this.singleFont.getLastChar(); ++i) {
            this.singleFont.setWidth(i, ttf.getCharWidth(i));
        }
        ListIterator iter = ttf.getCMaps().listIterator();
        while (iter.hasNext()) {
            TTFCmapEntry ce = (TTFCmapEntry)iter.next();
            if (ce.getUnicodeStart() >= 65534) continue;
            for (char u = (char)ce.getUnicodeStart(); u <= ce.getUnicodeEnd(); u = (char)(u + '\u0001')) {
                String unicode;
                String charName;
                char codePoint = this.singleFont.getEncoding().mapChar(u);
                if (codePoint > '\u0000' || (charName = Glyphs.stringToGlyph((String)(unicode = Character.toString(u)))).length() <= 0) continue;
                NamedCharacter nc = new NamedCharacter(charName, unicode);
                int glyphIndex = ce.getGlyphStartIndex() + u - ce.getUnicodeStart();
                this.singleFont.addUnencodedCharacter(nc, wx[glyphIndex]);
            }
        }
    }

    private void copyKerning(TTFFile ttf, boolean isCid) {
        Iterator iter = isCid ? ttf.getKerning().keySet().iterator() : ttf.getAnsiKerning().keySet().iterator();
        while (iter.hasNext()) {
            Integer kpx1 = (Integer)iter.next();
            Map h2 = isCid ? (Map)ttf.getKerning().get(kpx1) : (Map)ttf.getAnsiKerning().get(kpx1);
            this.returnFont.putKerningEntry(kpx1, h2);
        }
    }
}

