/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.fonts.fop.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.docx4j.Docx4jProperties;
import org.docx4j.fonts.Mapper;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.fonts.fop.fonts.FontTriplet;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.utils.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FopConfigUtil {
    protected static Logger log;
    private static final String substitutions;

    public static String createDefaultConfiguration(Mapper fontMapper, Set<String> fontsInUse) throws Docx4JException {
        StringBuilder buffer = new StringBuilder(10240);
        buffer.append("<fop version=\"1.0\"><strict-configuration>true</strict-configuration>");
        if (substitutions.length() > 0) {
            buffer.append("<fonts>");
            buffer.append(substitutions);
            buffer.append("</fonts>");
        }
        buffer.append("<renderers><renderer mime=\"application/pdf\">");
        buffer.append("<fonts>");
        FopConfigUtil.declareFonts(fontMapper, fontsInUse, buffer);
        buffer.append("</fonts></renderer></renderers></fop>");
        if (log.isDebugEnabled()) {
            log.debug("\nUsing fop config:\n " + buffer.toString() + "\n");
        }
        return buffer.toString();
    }

    protected static void declareFonts(Mapper fontMapper, Set<String> fontsInUse, StringBuilder result) {
        for (String fontName : fontsInUse) {
            PhysicalFont pf = fontMapper.get(fontName);
            String subFontAtt = "";
            if (pf == null) {
                log.warn("Document font " + fontName + " is not mapped to a physical font!");
            } else {
                if (pf.getEmbedFontInfo().getSubFontName() != null) {
                    subFontAtt = " sub-font=\"" + pf.getEmbedFontInfo().getSubFontName() + "\"";
                }
                result.append("<font embed-url=\"" + pf.getEmbeddedFile() + "\"" + subFontAtt + ">");
                FontTriplet fontTriplet = (FontTriplet)pf.getEmbedFontInfo().getFontTriplets().get(0);
                FopConfigUtil.addFontTriplet(result, fontTriplet);
                result.append("</font>");
            }
            PhysicalFont pfVariation = fontMapper.getBoldForm(fontName, pf);
            if (pfVariation == null) {
                log.debug(fontName + " no bold form");
            } else {
                result.append("<font embed-url=\"" + pfVariation.getEmbeddedFile() + "\"" + subFontAtt + ">");
                FopConfigUtil.addFontTriplet(result, pf.getName(), "normal", "bold");
                result.append("</font>");
            }
            pfVariation = fontMapper.getBoldItalicForm(fontName, pf);
            if (pfVariation == null) {
                log.debug(fontName + " no bold italic form");
            } else {
                result.append("<font embed-url=\"" + pfVariation.getEmbeddedFile() + "\"" + subFontAtt + ">");
                FopConfigUtil.addFontTriplet(result, pf.getName(), "italic", "bold");
                result.append("</font>");
            }
            pfVariation = fontMapper.getItalicForm(fontName, pf);
            if (pfVariation == null) {
                log.debug(fontName + " no italic form");
                continue;
            }
            result.append("<font embed-url=\"" + pfVariation.getEmbeddedFile() + "\"" + subFontAtt + ">");
            FopConfigUtil.addFontTriplet(result, pf.getName(), "italic", "normal");
            result.append("</font>");
        }
    }

    protected static void addFontTriplet(StringBuilder result, FontTriplet fontTriplet) {
        FopConfigUtil.addFontTriplet(result, fontTriplet.getName(), fontTriplet.getStyle(), FopConfigUtil.weightToCSS2FontWeight(fontTriplet.getWeight()));
    }

    protected static void addFontTriplet(StringBuilder result, String familyName, String style, String weight) {
        result.append("<font-triplet name=\"");
        result.append(familyName);
        result.append('\"');
        result.append(" style=\"");
        result.append(style);
        result.append('\"');
        result.append(" weight=\"");
        result.append(weight);
        result.append("\"/>");
    }

    protected static String weightToCSS2FontWeight(int i) {
        return i >= 700 ? "bold" : "normal";
    }

    static {
        String substitutionsTmp;
        log = LoggerFactory.getLogger(FopConfigUtil.class);
        String substitutionsPath = Docx4jProperties.getProperty("docx4j.fonts.fop.util.FopConfigUtil.substitutions");
        if (substitutionsPath == null) {
            substitutionsTmp = "";
        } else {
            try {
                substitutionsTmp = IOUtils.toString((InputStream)ResourceUtils.getResource(substitutionsPath));
            }
            catch (IOException e) {
                log.error("Problems with class path resource " + substitutionsPath);
                log.error(e.getMessage(), (Throwable)e);
                substitutionsTmp = "";
            }
        }
        substitutions = substitutionsTmp;
    }
}

