/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.io3;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.IOUtils;
import org.docx4j.XmlUtils;
import org.docx4j.bibliography.CTSources;
import org.docx4j.docProps.coverPageProps.CoverPageProperties;
import org.docx4j.jaxb.Context;
import org.docx4j.model.datastorage.CustomXmlDataStorage;
import org.docx4j.openpackaging.Base;
import org.docx4j.openpackaging.PackageRelsUtil;
import org.docx4j.openpackaging.URIHelper;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.contenttype.ContentTypeManager;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.exceptions.PartUnrecognisedException;
import org.docx4j.openpackaging.io.ExternalResourceUtils;
import org.docx4j.openpackaging.io.Load;
import org.docx4j.openpackaging.io3.stores.PartStore;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePropertiesPart;
import org.docx4j.openpackaging.parts.DefaultXmlPart;
import org.docx4j.openpackaging.parts.DocPropsCorePart;
import org.docx4j.openpackaging.parts.DocPropsCoverPagePart;
import org.docx4j.openpackaging.parts.DocPropsCustomPart;
import org.docx4j.openpackaging.parts.DocPropsExtendedPart;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.ThemePart;
import org.docx4j.openpackaging.parts.WordprocessingML.BibliographyPart;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPart;
import org.docx4j.openpackaging.parts.XmlPart;
import org.docx4j.openpackaging.parts.opendope.ComponentsPart;
import org.docx4j.openpackaging.parts.opendope.ConditionsPart;
import org.docx4j.openpackaging.parts.opendope.QuestionsPart;
import org.docx4j.openpackaging.parts.opendope.StandardisedAnswersPart;
import org.docx4j.openpackaging.parts.opendope.XPathsPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.opendope.answers.Answers;
import org.opendope.components.Components;
import org.opendope.conditions.Conditions;
import org.opendope.questions.Questionnaire;
import org.opendope.xpaths.Xpaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Load3
extends Load {
    private static Logger log = LoggerFactory.getLogger(Load3.class);
    private PartStore partStore;
    private OpcPackage existingPkg = null;

    public Load3(PartStore partLoader) {
        this.partStore = partLoader;
    }

    public Load3() {
        throw new RuntimeException();
    }

    public void reuseExistingOpcPackage(OpcPackage existingPkg) {
        this.existingPkg = existingPkg;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OpcPackage get() throws Docx4JException {
        long startTime = System.currentTimeMillis();
        ContentTypeManager ctm = new ContentTypeManager();
        InputStream is = null;
        try {
            is = this.partStore.loadPart("[Content_Types].xml");
            ctm.parseContentTypesFile(is);
        }
        catch (Docx4JException e) {
            try {
                throw new Docx4JException("Couldn't get [Content_Types].xml from ZipFile", e);
                catch (NullPointerException e2) {
                    throw new Docx4JException("Couldn't get [Content_Types].xml from ZipFile", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        RelationshipsPart rp = RelationshipsPart.createPackageRels();
        this.populatePackageRels(rp);
        String mainPartName = PackageRelsUtil.getNameOfMainPart(rp);
        PartName mainPartNameObj = mainPartName.startsWith("/") ? new PartName(mainPartName) : new PartName("/" + mainPartName);
        String pkgContentType = ctm.getContentType(mainPartNameObj);
        OpcPackage p = ctm.createPackage(pkgContentType);
        if (this.existingPkg == null) {
            p = ctm.createPackage(pkgContentType);
        } else {
            if (this.existingPkg.getClass() != p.getClass()) {
                throw new Docx4JException("Can't fill " + this.existingPkg.getClass().getName() + " with " + p.getClass().getName() + " contents.");
            }
            log.info("loading into (re-using) existing package object " + this.existingPkg.hashCode());
            this.existingPkg.reset();
            this.existingPkg.setPartName(new PartName("/", false));
            this.existingPkg.setContentTypeManager(ctm);
            p = this.existingPkg;
        }
        log.info("Instantiated package of type " + p.getClass().getName());
        p.setSourcePartStore(this.partStore);
        p.setRelationships(rp);
        rp.setSourceP(p);
        this.addPartsFromRelationships(p, rp, ctm);
        Load3.registerCustomXmlDataStorageParts(p);
        this.existingPkg = null;
        long endTime = System.currentTimeMillis();
        log.info("package read;  elapsed time: " + Math.round(endTime - startTime) + " ms");
        return p;
    }

    private void populatePackageRels(RelationshipsPart rp) throws Docx4JException {
        InputStream is = null;
        try {
            is = this.partStore.loadPart("_rels/.rels");
            if (is == null) {
                throw new Docx4JException("_rels/.rels appears to be missing from this package!");
            }
            rp.unmarshal(is);
        }
        catch (Exception e) {
            try {
                throw new Docx4JException("Error getting document from Zipped Part: _rels/.rels ", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
    }

    private RelationshipsPart getRelationshipsPartFromZip(Base p, String partName) throws Docx4JException {
        InputStream is;
        RelationshipsPart rp;
        block5: {
            rp = null;
            is = null;
            is = this.partStore.loadPart(partName);
            if (is != null) break block5;
            RelationshipsPart relationshipsPart = null;
            IOUtils.closeQuietly((InputStream)is);
            return relationshipsPart;
        }
        try {
            rp = p.getRelationshipsPart(true);
            rp.unmarshal(is);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new Docx4JException("Error getting document from Zipped Part:" + partName, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)is);
        return rp;
    }

    private void addPartsFromRelationships(Base source, RelationshipsPart rp, ContentTypeManager ctm) throws Docx4JException {
        OpcPackage pkg = source.getPackage();
        for (Relationship r : rp.getRelationships().getRelationship()) {
            log.debug("\n For Relationship Id=" + r.getId() + " Source is " + rp.getSourceP().getPartName() + ", Target is " + r.getTarget() + ", type: " + r.getType());
            try {
                this.getPart(pkg, rp, r, ctm);
            }
            catch (Exception e) {
                throw new Docx4JException("Failed to add parts from relationships", e);
            }
        }
    }

    private void getPart(OpcPackage pkg, RelationshipsPart rp, Relationship r, ContentTypeManager ctm) throws Docx4JException, InvalidFormatException, URISyntaxException {
        Base source = null;
        String resolvedPartUri = null;
        if (r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink")) {
            log.debug("Encountered (but not loading) hyperlink " + r.getTarget());
            return;
        }
        if (r.getTargetMode() != null && r.getTargetMode().equals("External")) {
            if (this.loadExternalTargets && r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/image")) {
                log.debug("Loading external resource " + r.getTarget() + " of type " + r.getType());
                BinaryPart bp = ExternalResourceUtils.getExternalResource(r.getTarget());
                pkg.getExternalResources().put(bp.getExternalTarget(), bp);
            } else {
                log.debug("Encountered (but not loading) external resource " + r.getTarget() + " of type " + r.getType());
            }
            return;
        }
        source = rp.getSourceP();
        resolvedPartUri = URIHelper.resolvePartUri(rp.getSourceURI(), new URI(r.getTarget())).toString();
        resolvedPartUri = resolvedPartUri.substring(1);
        String relationshipType = r.getType();
        if (pkg.handled.get(resolvedPartUri) != null) {
            Part part = pkg.getParts().getParts().get(new PartName("/" + resolvedPartUri));
            if (source.setPartShortcut(part, relationshipType)) {
                log.debug("Convenience method established from " + source.getPartName() + " to " + part.getPartName());
            }
            part.getSourceRelationships().add(r);
            return;
        }
        Part part = this.getRawPart(ctm, resolvedPartUri, r);
        if (source.setPartShortcut(part, relationshipType)) {
            log.debug("Convenience method established from " + source.getPartName() + " to " + part.getPartName());
        }
        if (part instanceof BinaryPart || part instanceof DefaultXmlPart) {
            part.setRelationshipType(relationshipType);
        }
        rp.loadPart(part, r);
        pkg.handled.put(resolvedPartUri, resolvedPartUri);
        RelationshipsPart rrp = this.getRelationshipsPart(part);
        if (rrp != null) {
            this.addPartsFromRelationships(part, rrp, ctm);
        }
    }

    public RelationshipsPart getRelationshipsPart(Part part) throws Docx4JException, InvalidFormatException {
        RelationshipsPart rrp = null;
        String relPart = PartName.getRelationshipsPartName(part.getPartName().getName().substring(1));
        rrp = this.getRelationshipsPartFromZip(part, relPart);
        part.setRelationships(rrp);
        return rrp;
    }

    public Part getRawPart(ContentTypeManager ctm, String resolvedPartUri, Relationship rel) throws Docx4JException {
        Part part;
        block22: {
            part = null;
            InputStream is = null;
            try {
                try {
                    log.debug("resolved uri: " + resolvedPartUri);
                    part = ctm.getPart("/" + resolvedPartUri, rel);
                    if (log.isDebugEnabled() && part != null) {
                        log.debug("ctm returned " + part.getClass().getName());
                    }
                    if (part instanceof ThemePart || part instanceof DocPropsCorePart || part instanceof DocPropsCustomPart || part instanceof DocPropsExtendedPart || part instanceof CustomXmlDataStoragePropertiesPart) break block22;
                    if (part instanceof JaxbXmlPart) {
                        break block22;
                    }
                    if (part instanceof BinaryPart) {
                        log.debug("Detected BinaryPart " + part.getClass().getName());
                        break block22;
                    }
                    if (part instanceof CustomXmlDataStoragePart) {
                        is = this.partStore.loadPart(resolvedPartUri);
                        try {
                            XMLInputFactory xif = XMLInputFactory.newInstance();
                            xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
                            xif.setProperty("javax.xml.stream.supportDTD", false);
                            XMLStreamReader xsr = xif.createXMLStreamReader(is);
                            Unmarshaller u = Context.jc.createUnmarshaller();
                            Object o = u.unmarshal(xsr);
                            log.debug(o.getClass().getName());
                            PartName name = part.getPartName();
                            if (o instanceof CoverPageProperties) {
                                part = new DocPropsCoverPagePart(name);
                                ((DocPropsCoverPagePart)part).setJaxbElement((CoverPageProperties)o);
                                break block22;
                            }
                            if (o instanceof Conditions) {
                                part = new ConditionsPart(name);
                                ((ConditionsPart)part).setJaxbElement((Conditions)o);
                                break block22;
                            }
                            if (o instanceof Xpaths) {
                                part = new XPathsPart(name);
                                ((XPathsPart)part).setJaxbElement((Xpaths)o);
                                break block22;
                            }
                            if (o instanceof Questionnaire) {
                                part = new QuestionsPart(name);
                                ((QuestionsPart)part).setJaxbElement((Questionnaire)o);
                                break block22;
                            }
                            if (o instanceof Answers) {
                                part = new StandardisedAnswersPart(name);
                                ((StandardisedAnswersPart)part).setJaxbElement((Answers)o);
                                break block22;
                            }
                            if (o instanceof Components) {
                                part = new ComponentsPart(name);
                                ((ComponentsPart)part).setJaxbElement((Components)o);
                                break block22;
                            }
                            if (o instanceof JAXBElement && XmlUtils.unwrap(o) instanceof CTSources) {
                                part = new BibliographyPart(name);
                                ((BibliographyPart)part).setJaxbElement((JAXBElement)o);
                                break block22;
                            }
                            log.error("TODO: handle known CustomXmlPart part  " + o.getClass().getName());
                            CustomXmlDataStorage data = Load3.getCustomXmlDataStorageClass().factory();
                            is.reset();
                            data.setDocument(is);
                            ((CustomXmlDataStoragePart)part).setData(data);
                        }
                        catch (UnmarshalException ue) {
                            log.warn("No JAXB model for this CustomXmlDataStorage part; " + ue.getMessage());
                            CustomXmlDataStorage data = Load3.getCustomXmlDataStorageClass().factory();
                            is.reset();
                            data.setDocument(is);
                            ((CustomXmlDataStoragePart)part).setData(data);
                        }
                        break block22;
                    }
                    if (part instanceof XmlPart) {
                        is = this.partStore.loadPart(resolvedPartUri);
                        ((XmlPart)part).setDocument(is);
                        break block22;
                    }
                    log.error("No suitable part found for: " + resolvedPartUri);
                    part = null;
                }
                catch (PartUnrecognisedException e) {
                    log.error("PartUnrecognisedException shouldn't happen anymore!", (Throwable)e);
                    part = this.getBinaryPart(ctm, resolvedPartUri);
                    log.warn("Using BinaryPart for " + resolvedPartUri);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new Docx4JException("Failed to getPart", ex);
            }
            finally {
                IOUtils.closeQuietly(is);
            }
        }
        if (part == null) {
            throw new Docx4JException("cannot find part " + resolvedPartUri + " from rel " + rel.getId() + "=" + rel.getTarget());
        }
        return part;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Part getBinaryPart(ContentTypeManager ctm, String resolvedPartUri) throws Docx4JException {
        BinaryPart part = null;
        InputStream is = null;
        try {
            is = this.partStore.loadPart(resolvedPartUri);
            part = new BinaryPart(new PartName("/" + resolvedPartUri));
            part.setContentType(new ContentType(ctm.getContentType(new PartName("/" + resolvedPartUri))));
            part.setBinaryData(is);
            log.info("Stored as BinaryData");
        }
        catch (Exception ioe) {
            try {
                ioe.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        IOUtils.closeQuietly((InputStream)is);
        return part;
    }
}

