/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.toc;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import org.apache.commons.lang3.StringUtils;
import org.docx4j.XmlUtils;
import org.docx4j.model.PropertyResolver;
import org.docx4j.model.listnumbering.Emulator;
import org.docx4j.model.structure.PageDimensions;
import org.docx4j.model.styles.StyleUtil;
import org.docx4j.toc.TocHelper;
import org.docx4j.toc.TocStyles;
import org.docx4j.wml.BooleanDefaultTrue;
import org.docx4j.wml.CTTabStop;
import org.docx4j.wml.FldChar;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.ParaRPr;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.RStyle;
import org.docx4j.wml.STFldCharType;
import org.docx4j.wml.STTabJc;
import org.docx4j.wml.STTabTlc;
import org.docx4j.wml.Tabs;
import org.docx4j.wml.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TocEntry {
    private static Logger log = LoggerFactory.getLogger(TocEntry.class);
    private PropertyResolver propertyResolver;
    private static final String PRESERVE = "preserve";
    private static final String PAGEREF_MASK = "PAGEREF %s \\h";
    private static final String HYPERLINK = "Hyperlink";
    private int writableWidthTwips;
    private STTabTlc leader;
    private List<R> entryValues = new ArrayList<R>();
    private String anchorValue;
    private String number = "";
    private int entryLevel = -1;
    private boolean hyperlink = false;
    private boolean pageNumber = true;
    private boolean isNumbered = false;
    private P entryP;
    private Text pageNumberText;
    ObjectFactory wmlObjectFactory = new ObjectFactory();
    private Map<String, PPrBase.Ind> styleIndent = new HashMap<String, PPrBase.Ind>();
    int numChars = 1;

    private TocEntry() {
    }

    public TocEntry(PropertyResolver propertyResolver, PageDimensions pageDimensions, STTabTlc leader) {
        this.propertyResolver = propertyResolver;
        this.writableWidthTwips = pageDimensions.getWritableWidthTwips();
        this.leader = leader;
    }

    public List<R> getEntryValue() {
        return this.entryValues;
    }

    public void setAnchorValue(String anchorValue) {
        this.anchorValue = anchorValue;
    }

    public String getAnchorValue() {
        return this.anchorValue;
    }

    public void makeHyperlink(boolean hyperlink) {
        this.hyperlink = hyperlink;
    }

    public void addPageNumber(boolean pageNumber) {
        this.pageNumber = pageNumber;
    }

    public boolean isPageNumber() {
        return this.pageNumber;
    }

    public int getEntryLevel() {
        return this.entryLevel;
    }

    public void setEntryLevel(int entryLevel) {
        this.entryLevel = entryLevel;
    }

    public P getEntryParagraph(TocStyles tocStyles) {
        if (this.entryP == null) {
            this.entryP = this.generateTocEntry(tocStyles);
        }
        return this.entryP;
    }

    public Text getEntryPageNumberText() {
        if (this.pageNumberText == null && this.entryP != null) {
            List<Object> texts = TocHelper.getAllElementsFromObject(this.entryP, Text.class);
            for (Object o : texts) {
                Text t = (Text)o;
                if (!t.getValue().isEmpty()) continue;
                this.pageNumberText = t;
            }
        }
        return this.pageNumberText;
    }

    private P generateTocEntry(TocStyles tocStyles) {
        P p3 = this.wmlObjectFactory.createP();
        p3.setPPr(this.generateTocEntryPPr(tocStyles));
        if (this.hyperlink) {
            p3.getContent().add(this.generateTocEntryHyperlink());
        } else {
            p3.getContent().addAll(this.generateTocEntryContent());
        }
        return p3;
    }

    private PPrBase.Ind getInd(String styleId) {
        if (styleId == null) {
            return null;
        }
        PPrBase.Ind ind = this.styleIndent.get(styleId);
        if (ind == null) {
            PPr ppr = this.propertyResolver.getEffectivePPr(styleId);
            if (ppr == null) {
                return null;
            }
            ind = ppr.getInd();
            this.styleIndent.put(styleId, ind);
        }
        return ind;
    }

    private PPr generateTocEntryPPr(TocStyles tocStyles) {
        String styleId = tocStyles.getStyleIdForName(String.format("toc %s", this.entryLevel + 1));
        PPr ppr3 = this.wmlObjectFactory.createPPr();
        ParaRPr pararpr2 = this.wmlObjectFactory.createParaRPr();
        ppr3.setRPr(pararpr2);
        BooleanDefaultTrue booleandefaulttrue20 = this.wmlObjectFactory.createBooleanDefaultTrue();
        pararpr2.setNoProof(booleandefaulttrue20);
        Tabs tabs2 = this.wmlObjectFactory.createTabs();
        ppr3.setTabs(tabs2);
        if (this.isNumbered) {
            CTTabStop tabstop = this.wmlObjectFactory.createCTTabStop();
            tabs2.getTab().add(tabstop);
            tabstop.setVal(STTabJc.LEFT);
            PPrBase.Ind ind = this.getInd(styleId);
            int numWidth = 110 * this.numChars;
            int paddedWidth = 330 + numWidth;
            if (ind != null && ind.getLeft() != null) {
                tabstop.setPos(BigInteger.valueOf(ind.getLeft().intValue() + paddedWidth));
            } else {
                tabstop.setPos(BigInteger.valueOf(paddedWidth));
            }
        }
        CTTabStop tabstop2 = this.wmlObjectFactory.createCTTabStop();
        tabs2.getTab().add(tabstop2);
        tabstop2.setVal(STTabJc.RIGHT);
        tabstop2.setPos(BigInteger.valueOf(this.writableWidthTwips));
        tabstop2.setLeader(this.leader);
        if (styleId == null) {
            log.warn("No style found for " + String.format("toc %s", this.entryLevel + 1));
        } else {
            PPrBase.PStyle pprbasepstyle3 = this.wmlObjectFactory.createPPrBasePStyle();
            ppr3.setPStyle(pprbasepstyle3);
            pprbasepstyle3.setVal(styleId);
        }
        return ppr3;
    }

    private JAXBElement<P.Hyperlink> generateTocEntryHyperlink() {
        P.Hyperlink phyperlink2 = this.wmlObjectFactory.createPHyperlink();
        JAXBElement<P.Hyperlink> phyperlinkWrapped2 = this.wmlObjectFactory.createPHyperlink(phyperlink2);
        phyperlink2.setAnchor(this.anchorValue);
        phyperlink2.getContent().addAll(this.generateTocEntryContent());
        return phyperlinkWrapped2;
    }

    private List<R> generateTocEntryContent() {
        List<R> rList = this.entryValues;
        this.generateTocEntryPageNumber(rList);
        return rList;
    }

    private void generateTocEntryPageNumber(List<R> rList) {
        R r14 = this.wmlObjectFactory.createR();
        rList.add(r14);
        RPr rpr12 = this.wmlObjectFactory.createRPr();
        r14.setRPr(rpr12);
        BooleanDefaultTrue booleandefaulttrue22 = this.wmlObjectFactory.createBooleanDefaultTrue();
        rpr12.setNoProof(booleandefaulttrue22);
        BooleanDefaultTrue booleandefaulttrue23 = this.wmlObjectFactory.createBooleanDefaultTrue();
        rpr12.setWebHidden(booleandefaulttrue23);
        if (this.pageNumber) {
            R.Tab rtab2 = this.wmlObjectFactory.createRTab();
            JAXBElement<R.Tab> rtabWrapped2 = this.wmlObjectFactory.createRTab(rtab2);
            r14.getContent().add(rtabWrapped2);
        }
        R r15 = this.wmlObjectFactory.createR();
        rList.add(r15);
        RPr rpr13 = this.wmlObjectFactory.createRPr();
        r15.setRPr(rpr13);
        BooleanDefaultTrue booleandefaulttrue24 = this.wmlObjectFactory.createBooleanDefaultTrue();
        rpr13.setNoProof(booleandefaulttrue24);
        BooleanDefaultTrue booleandefaulttrue25 = this.wmlObjectFactory.createBooleanDefaultTrue();
        rpr13.setWebHidden(booleandefaulttrue25);
        FldChar fldchar6 = this.wmlObjectFactory.createFldChar();
        JAXBElement<FldChar> fldcharWrapped6 = this.wmlObjectFactory.createRFldChar(fldchar6);
        r15.getContent().add(fldcharWrapped6);
        fldchar6.setFldCharType(STFldCharType.BEGIN);
        R r16 = this.wmlObjectFactory.createR();
        rList.add(r16);
        RPr rpr14 = this.wmlObjectFactory.createRPr();
        r16.setRPr(rpr14);
        BooleanDefaultTrue booleandefaulttrue26 = this.wmlObjectFactory.createBooleanDefaultTrue();
        rpr14.setNoProof(booleandefaulttrue26);
        BooleanDefaultTrue booleandefaulttrue27 = this.wmlObjectFactory.createBooleanDefaultTrue();
        rpr14.setWebHidden(booleandefaulttrue27);
        Text text7 = this.wmlObjectFactory.createText();
        JAXBElement<Text> textWrapped7 = this.wmlObjectFactory.createRInstrText(text7);
        r16.getContent().add(textWrapped7);
        text7.setValue(String.format(PAGEREF_MASK, this.anchorValue));
        text7.setSpace(PRESERVE);
        R r17 = this.wmlObjectFactory.createR();
        rList.add(r17);
        RPr rpr15 = this.wmlObjectFactory.createRPr();
        r17.setRPr(rpr15);
        BooleanDefaultTrue booleandefaulttrue28 = this.wmlObjectFactory.createBooleanDefaultTrue();
        rpr15.setNoProof(booleandefaulttrue28);
        BooleanDefaultTrue booleandefaulttrue29 = this.wmlObjectFactory.createBooleanDefaultTrue();
        rpr15.setWebHidden(booleandefaulttrue29);
        R r18 = this.wmlObjectFactory.createR();
        rList.add(r18);
        RPr rpr16 = this.wmlObjectFactory.createRPr();
        r18.setRPr(rpr16);
        BooleanDefaultTrue booleandefaulttrue30 = this.wmlObjectFactory.createBooleanDefaultTrue();
        rpr16.setNoProof(booleandefaulttrue30);
        BooleanDefaultTrue booleandefaulttrue31 = this.wmlObjectFactory.createBooleanDefaultTrue();
        rpr16.setWebHidden(booleandefaulttrue31);
        FldChar fldchar7 = this.wmlObjectFactory.createFldChar();
        JAXBElement<FldChar> fldcharWrapped7 = this.wmlObjectFactory.createRFldChar(fldchar7);
        r18.getContent().add(fldcharWrapped7);
        fldchar7.setFldCharType(STFldCharType.SEPARATE);
        R r19 = this.wmlObjectFactory.createR();
        rList.add(r19);
        RPr rpr17 = this.wmlObjectFactory.createRPr();
        r19.setRPr(rpr17);
        BooleanDefaultTrue booleandefaulttrue32 = this.wmlObjectFactory.createBooleanDefaultTrue();
        rpr17.setNoProof(booleandefaulttrue32);
        BooleanDefaultTrue booleandefaulttrue33 = this.wmlObjectFactory.createBooleanDefaultTrue();
        rpr17.setWebHidden(booleandefaulttrue33);
        Text text8 = this.wmlObjectFactory.createText();
        JAXBElement<Text> textWrapped8 = this.wmlObjectFactory.createRT(text8);
        r19.getContent().add(textWrapped8);
        text8.setValue(this.number);
        R r20 = this.wmlObjectFactory.createR();
        rList.add(r20);
        RPr rpr18 = this.wmlObjectFactory.createRPr();
        r20.setRPr(rpr18);
        BooleanDefaultTrue booleandefaulttrue34 = this.wmlObjectFactory.createBooleanDefaultTrue();
        rpr18.setNoProof(booleandefaulttrue34);
        BooleanDefaultTrue booleandefaulttrue35 = this.wmlObjectFactory.createBooleanDefaultTrue();
        rpr18.setWebHidden(booleandefaulttrue35);
        FldChar fldchar8 = this.wmlObjectFactory.createFldChar();
        JAXBElement<FldChar> fldcharWrapped8 = this.wmlObjectFactory.createRFldChar(fldchar8);
        r20.getContent().add(fldcharWrapped8);
        fldchar8.setFldCharType(STFldCharType.END);
    }

    public void setEntryValue(P sourceP) {
        Text firstText;
        String val;
        List<Object> textsFound;
        int size;
        Text lastText;
        String val2;
        int size2;
        P clonedP = XmlUtils.deepCopy(sourceP);
        List<Object> runsFound = TocHelper.getAllElementsFromObject(clonedP, R.class);
        R lastRun = null;
        for (Object o : runsFound) {
            R r = (R)o;
            List<Object> textsFound2 = TocHelper.getAllElementsFromObject(r, Text.class);
            if (textsFound2.size() <= 0) continue;
            R newR = new R();
            if (r.getRPr() == null) {
                newR.setRPr(this.wmlObjectFactory.createRPr());
            } else {
                newR.setRPr(this.getEffectiveRPr(r.getRPr()));
                this.nullify(newR.getRPr());
                if (newR.getRPr() == null) {
                    newR.setRPr(this.wmlObjectFactory.createRPr());
                }
            }
            if (this.hyperlink) {
                RStyle rstyle = this.wmlObjectFactory.createRStyle();
                newR.getRPr().setRStyle(rstyle);
                rstyle.setVal(HYPERLINK);
            }
            newR.getContent().addAll(textsFound2);
            this.entryValues.add(newR);
            lastRun = newR;
        }
        if (lastRun != null && (size2 = lastRun.getContent().size()) > 0 && (val2 = (lastText = (Text)lastRun.getContent().get(size2 - 1)).getValue()) != null) {
            lastText.setValue(StringUtils.stripEnd((String)val2, null));
        }
        R firstRun = null;
        if (runsFound.size() > 0 && (size = (textsFound = TocHelper.getAllElementsFromObject(firstRun = (R)runsFound.get(0), Text.class)).size()) > 0 && (val = (firstText = (Text)textsFound.get(0)).getValue()) != null) {
            firstText.setValue(StringUtils.stripStart((String)val, null));
        }
    }

    private RPr getEffectiveRPr(RPr expressRPr) {
        RPr resolvedRPr = null;
        if (expressRPr != null && expressRPr.getRStyle() != null) {
            String runStyleId = expressRPr.getRStyle().getVal();
            resolvedRPr = this.propertyResolver.getEffectiveRPr(runStyleId);
            expressRPr.setRStyle(null);
        }
        return StyleUtil.apply(expressRPr, resolvedRPr);
    }

    private void nullify(RPr destination) {
        if (destination == null) {
            return;
        }
        destination.setRStyle(null);
        destination.setSz(null);
        destination.setSzCs(null);
        destination.setColor(null);
        destination.setU(null);
        destination.setLang(null);
        destination.setStrike(null);
        destination.setDstrike(null);
        destination.setOutline(null);
        destination.setShadow(null);
        destination.setEmboss(null);
        destination.setImprint(null);
        destination.setSnapToGrid(null);
        destination.setSpacing(null);
        destination.setW(null);
        destination.setKern(null);
        destination.setPosition(null);
        destination.setEffect(null);
        destination.setBdr(null);
        destination.setShd(null);
        destination.setVertAlign(null);
        destination.setRtl(null);
        destination.setCs(null);
        destination.setEm(null);
        destination.setSpecVanish(null);
        destination.setOMath(null);
    }

    public void numberEntry(Emulator.ResultTriple numberTriple) {
        if (numberTriple != null && numberTriple.getNumString() != null) {
            this.isNumbered = true;
            this.numChars = numberTriple.getBullet() != null ? 1 : (numberTriple.getNumString() == null ? 0 : numberTriple.getNumString().length());
            R r = this.wmlObjectFactory.createR();
            RPr rpr = this.wmlObjectFactory.createRPr();
            r.setRPr(rpr);
            if (this.hyperlink) {
                RStyle rstyle2 = this.wmlObjectFactory.createRStyle();
                rpr.setRStyle(rstyle2);
                rstyle2.setVal(HYPERLINK);
            }
            Text t = this.wmlObjectFactory.createText();
            JAXBElement<Text> textWrapped6 = this.wmlObjectFactory.createRT(t);
            r.getContent().add(textWrapped6);
            t.setSpace(PRESERVE);
            this.entryValues.add(0, r);
            if (numberTriple.getLvl().getSuff() == null) {
                t.setValue(numberTriple.getNumString());
                this.entryValues.add(1, this.tabAfterPNumber());
            } else if (numberTriple.getLvl().getSuff().getVal().equals("space")) {
                t.setValue(numberTriple.getNumString() + " ");
            } else if (numberTriple.getLvl().getSuff().getVal().equals("nothing")) {
                t.setValue(numberTriple.getNumString());
            } else {
                t.setValue(numberTriple.getNumString());
                this.entryValues.add(1, this.tabAfterPNumber());
            }
        }
    }

    private R tabAfterPNumber() {
        R r = this.wmlObjectFactory.createR();
        R.Tab rtab = this.wmlObjectFactory.createRTab();
        JAXBElement<R.Tab> rtabWrapped = this.wmlObjectFactory.createRTab(rtab);
        r.getContent().add(rtabWrapped);
        return r;
    }
}

