/*
 * Decompiled with CFR 0.152.
 */
package org.merlin.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.merlin.io.OutputEngine;

public class IOStreamEngine
implements OutputEngine {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private InputStream in;
    private OutputStreamFactory factory;
    private byte[] buffer;
    private OutputStream out;

    public IOStreamEngine(InputStream in, OutputStreamFactory factory) {
        this(in, factory, 8192);
    }

    public IOStreamEngine(InputStream in, OutputStreamFactory factory, int bufferSize) {
        this.in = in;
        this.factory = factory;
        this.buffer = new byte[bufferSize];
    }

    @Override
    public void initialize(OutputStream out) throws IOException {
        if (this.out != null) {
            throw new IOException("Already initialized");
        }
        this.out = this.factory.getOutputStream(out);
    }

    @Override
    public void execute() throws IOException {
        if (this.out == null) {
            throw new IOException("Not yet initialized");
        }
        int amount = this.in.read(this.buffer);
        if (amount < 0) {
            this.out.close();
        } else {
            this.out.write(this.buffer, 0, amount);
        }
    }

    @Override
    public void finish() throws IOException {
        this.in.close();
    }

    public static interface OutputStreamFactory {
        public OutputStream getOutputStream(OutputStream var1) throws IOException;
    }
}

