/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.fo;

import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.FORenderer;
import org.docx4j.convert.out.FOSettings;
import org.docx4j.convert.out.common.AbstractConversionContext;
import org.docx4j.convert.out.common.AbstractWmlConversionContext;
import org.docx4j.convert.out.common.ConversionSectionWrapper;
import org.docx4j.convert.out.common.Writer;
import org.docx4j.convert.out.common.writer.AbstractPictWriter;
import org.docx4j.convert.out.fo.renderers.AbstractFORenderer;
import org.docx4j.model.structure.PageDimensions;
import org.docx4j.vml.CTShapetype;
import org.docx4j.vml.CTTextbox;
import org.docx4j.vml.VmlAllCoreAttributes;
import org.docx4j.vml.VmlShapeElements;
import org.docx4j.vml.wordprocessingDrawing.CTWrap;
import org.docx4j.vml.wordprocessingDrawing.STVerticalAnchor;
import org.docx4j.vml.wordprocessingDrawing.STWrapType;
import org.docx4j.wml.Pict;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FOPictWriterAbstract
extends AbstractPictWriter {
    protected static Logger log = LoggerFactory.getLogger(FOPictWriterAbstract.class);
    private static String XSL_FO = "http://www.w3.org/1999/XSL/Format";

    public abstract boolean foRendererSupportsFoFloat();

    public Node toNode(AbstractWmlConversionContext context, Object unmarshalledNode, Node modelContent, Writer.TransformState state, Document doc) throws TransformerException {
        Pict pict = (Pict)unmarshalledNode;
        VmlShapeElements shape = null;
        for (Object o : pict.getAnyAndAny()) {
            if (!((o = XmlUtils.unwrap(o)) instanceof VmlShapeElements) || o instanceof CTShapetype) continue;
            shape = (VmlShapeElements)o;
            log.debug("Found " + shape.getClass().getName());
            break;
        }
        if (shape == null) {
            return context.getMessageWriter().message((AbstractConversionContext)context, "Couldn't find v:shape (or v:rectangle etc) in w:pict.");
        }
        CTTextbox textBox = null;
        CTWrap w10Wrap = null;
        for (Object o : shape.getEGShapeElements()) {
            if ((o = XmlUtils.unwrap(o)) instanceof CTTextbox) {
                textBox = (CTTextbox)o;
            }
            if (!(o instanceof CTWrap)) continue;
            w10Wrap = (CTWrap)o;
        }
        if (textBox == null) {
            return context.getMessageWriter().message((AbstractConversionContext)context, "Couldn't find v:textbox in w:shape.");
        }
        Map<String, String> props = null;
        if (!(shape instanceof VmlAllCoreAttributes)) {
            log.warn(shape.getClass().getName() + " does not implement VmlAllCoreAttributes, so can't access @style if present");
            return context.getMessageWriter().message((AbstractConversionContext)context, shape.getClass().getName() + " does not implement VmlAllCoreAttributes, so can't access @style if present");
        }
        props = this.getProperties(((VmlAllCoreAttributes)shape).getStyle());
        boolean wrap = true;
        if (w10Wrap != null) {
            if (w10Wrap.getType() != null && (w10Wrap.getType().equals((Object)STWrapType.TOP_AND_BOTTOM) || w10Wrap.getType().equals((Object)STWrapType.SQUARE) || w10Wrap.getType().equals((Object)STWrapType.TIGHT) || w10Wrap.getType().equals((Object)STWrapType.THROUGH))) {
                wrap = false;
            }
            if (w10Wrap.getAnchory() != null && w10Wrap.getAnchory().equals((Object)STVerticalAnchor.PAGE)) {
                wrap = false;
            }
        }
        return this.handleVTextBox(context, modelContent, doc, shape, props, wrap);
    }

    public Node handleVTextBox(AbstractWmlConversionContext context, Node modelContent, Document doc, VmlShapeElements shape, Map<String, String> props, boolean wrap) {
        String mso_position_vertical_relative = props.get("mso-position-vertical-relative");
        String mso_position_vertical = props.get("mso-position-vertical");
        ConversionSectionWrapper csw = context.getSections().getCurrentSection();
        PageDimensions pageDimensions = csw.getPageDimensions();
        int writableWidthTwips = pageDimensions.getWritableWidthTwips();
        float writableWidthPts = writableWidthTwips / 20;
        int writableHeightTwips = pageDimensions.getWritableHeightTwips();
        float writableHeightPts = writableHeightTwips / 20;
        FORenderer foRenderer = ((FOSettings)context.getConversionSettings()).getCustomFoRenderer();
        log.debug(foRenderer.getClass().getName());
        if (wrap) {
            log.debug("textbox - wrapped text");
            if (mso_position_vertical_relative == null) {
                if (log.isWarnEnabled()) {
                    try {
                        log.warn(XmlUtils.marshaltoString((Object)shape));
                    }
                    catch (Exception e) {
                        log.warn(e.getMessage());
                    }
                }
                return context.getMessageWriter().message((AbstractConversionContext)context, "mso_position_vertical_relative==null.  What to do?");
            }
            if (mso_position_vertical_relative.equals("text")) {
                Element ret = doc.createElementNS(XSL_FO, "block");
                this.setBorders(ret);
                String margin_top = props.get("margin-top");
                if (margin_top == null) {
                    log.error("margin top prop not found.  What to do?");
                    XmlUtils.treeCopy((NodeList)modelContent.getChildNodes(), (Node)ret);
                    return ret;
                }
                float marginTop = this.parsePtsVal(margin_top);
                if (this.foRendererSupportsFoFloat()) {
                    String mso_position_horizontal_relative = props.get("mso-position-horizontal-relative");
                    String mso_position_horizontal = props.get("mso-position-horizontal");
                    if (mso_position_horizontal_relative == null) {
                        log.warn("No support for mso_position_horizontal_relative==null");
                        XmlUtils.treeCopy((NodeList)modelContent.getChildNodes(), (Node)ret);
                        return ret;
                    }
                    if (!mso_position_horizontal_relative.equals("text")) {
                        log.warn("No support for mso_position_horizontal_relative==" + mso_position_horizontal_relative.equals("text"));
                        XmlUtils.treeCopy((NodeList)modelContent.getChildNodes(), (Node)ret);
                        return ret;
                    }
                    float ml = this.parsePtsVal(props.get("margin-left"));
                    if (mso_position_horizontal == null) {
                        log.warn("No support for mso_position_horizontal==null");
                        XmlUtils.treeCopy((NodeList)modelContent.getChildNodes(), (Node)ret);
                        return ret;
                    }
                    if (mso_position_horizontal.equals("absolute")) {
                        log.warn("Degrading absolute position to left/right");
                        mso_position_horizontal = (double)(ml / writableWidthPts) <= 0.5 ? "left" : "right";
                    }
                    ret = doc.createElementNS(XSL_FO, "float");
                    this.setBorders(ret);
                    if (mso_position_horizontal.equals("left")) {
                        ret.setAttribute("float", "start");
                    } else if (mso_position_horizontal.equals("center")) {
                        log.warn("Degrading center to right");
                        ret.setAttribute("float", "end");
                    } else if (mso_position_horizontal.equals("right")) {
                        ret.setAttribute("float", "end");
                    }
                    XmlUtils.treeCopy((NodeList)modelContent.getChildNodes(), (Node)ret);
                } else if (marginTop <= 0.0f) {
                    this.marginTopZeroCase(props, ret, writableWidthPts);
                    XmlUtils.treeCopy((NodeList)modelContent.getChildNodes(), (Node)ret);
                } else {
                    ret = doc.createElementNS(XSL_FO, "table");
                    if (!this.marginTopPositiveCase(foRenderer, props, doc, ret, writableWidthPts, modelContent.getChildNodes())) {
                        ret = doc.createElementNS(XSL_FO, "block");
                        this.setBorders(ret);
                        XmlUtils.treeCopy((NodeList)modelContent.getChildNodes(), (Node)ret);
                    }
                }
                log.debug(XmlUtils.w3CDomNodeToString((Node)ret));
                return ret;
            }
            if (this.foRendererSupportsFoFloat()) {
                if (mso_position_vertical_relative.equals("page") || mso_position_vertical_relative.equals("top-margin-area") || mso_position_vertical_relative.equals("bottom-margin-area")) {
                    if (mso_position_vertical_relative.equals("page")) {
                        if (mso_position_vertical.equals("top")) {
                            Element ret = doc.createElementNS(XSL_FO, "float");
                            ret.setAttribute("float", "before");
                            this.setBorders(ret);
                            log.debug(XmlUtils.w3CDomNodeToString((Node)ret));
                            return ret;
                        }
                        if (mso_position_vertical.equals("bottom")) {
                            Element ret = doc.createElementNS(XSL_FO, "footnote");
                            Element footnoteBody = doc.createElementNS(XSL_FO, "footnote-body");
                            ret.appendChild(footnoteBody);
                            Element block = doc.createElementNS(XSL_FO, "block");
                            footnoteBody.appendChild(block);
                            this.setBorders(block);
                            XmlUtils.treeCopy((NodeList)modelContent.getChildNodes(), (Node)block);
                            return ret;
                        }
                        log.warn("No support for mso_position_vertical==" + mso_position_vertical);
                        return context.getMessageWriter().message((AbstractConversionContext)context, "TODO for fo:float capable renderer, support no-wrap + mso-position-vertical=" + mso_position_vertical);
                    }
                    if (mso_position_vertical_relative.equals("top-margin-area")) {
                        Element ret = doc.createElementNS(XSL_FO, "float");
                        ret.setAttribute("float", "before");
                        this.setBorders(ret);
                        log.debug(XmlUtils.w3CDomNodeToString((Node)ret));
                        return ret;
                    }
                    if (mso_position_vertical_relative.equals("bottom-margin-area")) {
                        Element ret = doc.createElementNS(XSL_FO, "footnote");
                        Element footnoteBody = doc.createElementNS(XSL_FO, "footnote-body");
                        ret.appendChild(footnoteBody);
                        Element block = doc.createElementNS(XSL_FO, "block");
                        footnoteBody.appendChild(block);
                        this.setBorders(block);
                        XmlUtils.treeCopy((NodeList)modelContent.getChildNodes(), (Node)block);
                        return ret;
                    }
                    return context.getMessageWriter().message((AbstractConversionContext)context, "TODO (how did we get here?) mso-position-vertical-relative=" + mso_position_vertical_relative);
                }
                return context.getMessageWriter().message((AbstractConversionContext)context, "TODO for fo:float capable renderer, support no-wrap + mso-position-vertical-relative=" + mso_position_vertical_relative);
            }
            return context.getMessageWriter().message((AbstractConversionContext)context, "TODO for fo:float INcapable renderer, support no-wrap + mso-position-vertical-relative=" + mso_position_vertical_relative);
        }
        log.debug("textbox - over/behind docx text");
        Element ret = doc.createElementNS(XSL_FO, "block-container");
        XmlUtils.treeCopy((NodeList)modelContent.getChildNodes(), (Node)ret);
        this.setBorders(ret);
        String mso_position_horizontal_relative = props.get("mso-position-horizontal-relative");
        String mso_position_horizontal = props.get("mso-position-horizontal");
        if (mso_position_horizontal_relative == null) {
            log.warn("No support for mso_position_horizontal_relative==null");
        } else if (!mso_position_horizontal_relative.equals("text")) {
            log.warn("No support for mso_position_horizontal_relative==" + mso_position_horizontal_relative.equals("text"));
        } else {
            int marginLeft;
            float boxWidth = this.parsePtsVal(props.get("width"));
            ret.setAttribute("width", props.get("width"));
            ret.setAttribute("height", props.get("height"));
            if (mso_position_horizontal == null) {
                log.warn("No support for mso_position_horizontal==null");
            } else if (mso_position_horizontal.equals("left")) {
                ret.setAttribute("left", "0pt");
            } else if (mso_position_horizontal.equals("center")) {
                marginLeft = Math.round((writableWidthPts - boxWidth) / 2.0f);
                ret.setAttribute("left", marginLeft + "pt");
            } else if (mso_position_horizontal.equals("right")) {
                marginLeft = Math.round(writableWidthPts - boxWidth);
                ret.setAttribute("left", marginLeft + "pt");
            } else if (mso_position_horizontal.equals("absolute")) {
                ret.setAttribute("margin-left", props.get("margin-left"));
            }
        }
        ret.setAttribute("z-index", props.get("z-index"));
        String margin_top = props.get("margin-top");
        if (mso_position_vertical_relative == null) {
            if (log.isWarnEnabled()) {
                log.warn(XmlUtils.marshaltoString((Object)shape));
            }
            return context.getMessageWriter().message((AbstractConversionContext)context, "mso_position_vertical_relative==null.  What to do?");
        }
        if (mso_position_vertical_relative.equals("text")) {
            ret.setAttribute("position", "absolute");
            if (margin_top != null) {
                ret.setAttribute("top", margin_top);
            }
            log.debug(XmlUtils.w3CDomNodeToString((Node)ret));
            return ret;
        }
        if (mso_position_vertical_relative.equals("page") || mso_position_vertical_relative.equals("top-margin-area") || mso_position_vertical_relative.equals("bottom-margin-area")) {
            int top;
            ret.setAttribute("position", "fixed");
            if (mso_position_vertical_relative.equals("page")) {
                if (mso_position_vertical.equals("top")) {
                    if (margin_top != null) {
                        ret.setAttribute("top", margin_top);
                    }
                } else if (mso_position_vertical.equals("bottom")) {
                    top = Math.round(writableHeightPts);
                    ret.setAttribute("top", top + "pt");
                } else {
                    log.warn("No support for mso_position_vertical==" + mso_position_vertical);
                }
                log.debug(XmlUtils.w3CDomNodeToString((Node)ret));
                return ret;
            }
            if (mso_position_vertical_relative.equals("top-margin-area")) {
                if (margin_top != null) {
                    ret.setAttribute("top", margin_top);
                }
                log.debug(XmlUtils.w3CDomNodeToString((Node)ret));
                return ret;
            }
            if (mso_position_vertical_relative.equals("bottom-margin-area")) {
                top = Math.round(writableHeightPts);
                ret.setAttribute("top", top + "pt");
                log.debug(XmlUtils.w3CDomNodeToString((Node)ret));
                return ret;
            }
            return context.getMessageWriter().message((AbstractConversionContext)context, "TODO (how did we get here?) mso-position-vertical-relative=" + mso_position_vertical_relative);
        }
        return context.getMessageWriter().message((AbstractConversionContext)context, "TODO support no-wrap + mso-position-vertical-relative=" + mso_position_vertical_relative);
    }

    private void setBorders(Element ret) {
        ret.setAttribute("border-left-style", "solid");
        ret.setAttribute("border-top-style", "solid");
        ret.setAttribute("border-bottom-style", "solid");
        ret.setAttribute("border-right-style", "solid");
    }

    private Map<String, String> getProperties(String s) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (s == null) {
            log.warn("shape has no @style");
            return map;
        }
        for (String entry : s.split(";")) {
            String[] parts = entry.split(":");
            assert (parts.length == 2) : "Invalid entry: " + entry;
            map.put(parts[0], parts[1]);
        }
        return map;
    }

    private float parsePtsVal(String pts) {
        if (pts == null) {
            log.warn("No val!");
            return -99.0f;
        }
        if (pts.contains("pt")) {
            pts = pts.substring(0, pts.indexOf("pt"));
            return Float.parseFloat(pts);
        }
        if (pts.equals("0")) {
            return 0.0f;
        }
        log.warn("Unit is not points! " + pts);
        return -99.0f;
    }

    private void marginTopZeroCase(Map<String, String> props, Element ret, float widthPts) {
        String mso_position_horizontal_relative = props.get("mso-position-horizontal-relative");
        String mso_position_horizontal = props.get("mso-position-horizontal");
        if (mso_position_horizontal_relative == null) {
            log.warn("No support for mso_position_horizontal_relative==null");
        } else if (!mso_position_horizontal_relative.equals("text")) {
            log.warn("No support for mso_position_horizontal_relative==" + mso_position_horizontal_relative.equals("text"));
        } else {
            float boxWidth = this.parsePtsVal(props.get("width"));
            if (mso_position_horizontal == null) {
                log.warn("No support for mso_position_horizontal==null");
            } else if (mso_position_horizontal.equals("left")) {
                ret.setAttribute("margin-left", "0pt");
                int marginRight = Math.round(widthPts - boxWidth);
                ret.setAttribute("margin-right", marginRight + "pt");
            } else if (mso_position_horizontal.equals("center")) {
                int marginLeft = Math.round((widthPts - boxWidth) / 2.0f);
                ret.setAttribute("margin-left", marginLeft + "pt");
                ret.setAttribute("margin-right", marginLeft + "pt");
            } else if (mso_position_horizontal.equals("right")) {
                ret.setAttribute("margin-right", "0pt");
                int marginLeft = Math.round(widthPts - boxWidth);
                ret.setAttribute("margin-left", marginLeft + "pt");
            } else if (mso_position_horizontal.equals("absolute")) {
                ret.setAttribute("margin-left", props.get("margin-left"));
                float ml = this.parsePtsVal(props.get("margin-left"));
                int mRight = Math.round(widthPts - (boxWidth + ml));
                ret.setAttribute("margin-right", mRight + "pt");
            }
        }
    }

    private boolean marginTopPositiveCase(FORenderer foRenderer, Map<String, String> props, Document doc, Element ret, float widthPts, NodeList childNodes) {
        String mso_position_horizontal_relative = props.get("mso-position-horizontal-relative");
        String mso_position_horizontal = props.get("mso-position-horizontal");
        if (mso_position_horizontal_relative == null) {
            log.warn("No support for mso_position_horizontal_relative==null");
            return false;
        }
        if (!mso_position_horizontal_relative.equals("text")) {
            log.warn("No support for mso_position_horizontal_relative==" + mso_position_horizontal_relative.equals("text"));
            return false;
        }
        float boxWidth = this.parsePtsVal(props.get("width"));
        if (mso_position_horizontal == null) {
            log.warn("No support for mso_position_horizontal==null");
            return false;
        }
        float ml = this.parsePtsVal(props.get("margin-left"));
        if (mso_position_horizontal.equals("absolute")) {
            mso_position_horizontal = (double)(ml / widthPts) < 0.334 ? "left" : ((double)(ml / widthPts) < 0.665 ? "right" : "center");
        }
        if (mso_position_horizontal.equals("left")) {
            Element tcol1 = doc.createElementNS(XSL_FO, "table-column");
            ret.appendChild(tcol1);
            tcol1.setAttribute("column-number", "1");
            int col1W = Math.round(ml + boxWidth);
            tcol1.setAttribute("column-width", col1W + "pt");
            Element tcol2 = doc.createElementNS(XSL_FO, "table-column");
            ret.appendChild(tcol2);
            tcol2.setAttribute("column-number", "2");
            int col2W = Math.round(widthPts - (float)col1W);
            tcol2.setAttribute("column-width", col2W + "pt");
            Element tbody = doc.createElementNS(XSL_FO, "table-body");
            ret.appendChild(tbody);
            Element trow = doc.createElementNS(XSL_FO, "table-row");
            tbody.appendChild(trow);
            Element tc1 = doc.createElementNS(XSL_FO, "table-cell");
            trow.appendChild(tc1);
            Element block = doc.createElementNS(XSL_FO, "block");
            this.setBorders(block);
            tc1.appendChild(block);
            XmlUtils.treeCopy((NodeList)childNodes, (Node)block);
            Element tc2 = doc.createElementNS(XSL_FO, "table-cell");
            trow.appendChild(tc2);
            Element placeholder = doc.createElementNS(XSL_FO, "block");
            placeholder.setTextContent("#TEXTBOX#");
            tc2.appendChild(placeholder);
            if (foRenderer instanceof AbstractFORenderer) {
                ((AbstractFORenderer)foRenderer).TEXTBOX_POSTPROCESSING_REQUIRED = true;
            } else {
                log.warn("TODO: implement TEXTBOX_POSTPROCESSING_REQUIRED for " + foRenderer.getClass().getName());
            }
            return true;
        }
        if (mso_position_horizontal.equals("center")) {
            log.warn("Can't support mso_position_horizontal:center");
            return false;
        }
        if (mso_position_horizontal.equals("right")) {
            Element tcol1 = doc.createElementNS(XSL_FO, "table-column");
            ret.appendChild(tcol1);
            tcol1.setAttribute("column-number", "1");
            int col1W = Math.round(widthPts - boxWidth);
            tcol1.setAttribute("column-width", col1W + "pt");
            Element tcol2 = doc.createElementNS(XSL_FO, "table-column");
            ret.appendChild(tcol2);
            tcol2.setAttribute("column-number", "2");
            int col2W = Math.round(boxWidth);
            tcol2.setAttribute("column-width", col2W + "pt");
            Element tbody = doc.createElementNS(XSL_FO, "table-body");
            ret.appendChild(tbody);
            Element trow = doc.createElementNS(XSL_FO, "table-row");
            tbody.appendChild(trow);
            Element tc1 = doc.createElementNS(XSL_FO, "table-cell");
            trow.appendChild(tc1);
            Element placeholder = doc.createElementNS(XSL_FO, "block");
            placeholder.setTextContent("#TEXTBOX#");
            tc1.appendChild(placeholder);
            Element tc2 = doc.createElementNS(XSL_FO, "table-cell");
            trow.appendChild(tc2);
            Element block = doc.createElementNS(XSL_FO, "block");
            this.setBorders(block);
            tc2.appendChild(block);
            XmlUtils.treeCopy((NodeList)childNodes, (Node)block);
            if (foRenderer instanceof AbstractFORenderer) {
                ((AbstractFORenderer)foRenderer).TEXTBOX_POSTPROCESSING_REQUIRED = true;
            } else {
                log.warn("TODO: implement TEXTBOX_POSTPROCESSING_REQUIRED for " + foRenderer.getClass().getName());
            }
            return true;
        }
        return false;
    }
}

