package com.kingdee.ebservice.itrus;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Map;


public class ItrusConfigHelper implements ItrusConfigConstants {
	
	public static final String ITRUS_PATH_PROPERTY = "eb_server";
	public static final String OSGI_INSTALL_AREA = "osgi.install.area";
	public static final String EB_CONFIG_FILE = "EBPItrusConfig.properties";
	public static final String EB_DEFAULT_CONFIG_FILE = "EBPItrusDefaultConfig.properties";
	private String itrusPath;
	
	private ItrusConfigHelper(String itrusPath){
		this.itrusPath = itrusPath;
	}
	
	public static ItrusConfigHelper getInstance(String itrusPath){
		return new ItrusConfigHelper(itrusPath);
	}
	
	//ǷCA
	public boolean isUseItrus(){
		return getCABooleanConfig("IS_USE_ITRUS");
	}
	
	
	/**
	 * ѯӦ
	 * ͻǷҪ
	 * ǷҪ
	 * @return
	 * 2015-4-29 05:45:50
	 * rd_jinlin_xie
	 */
	public boolean needQueryResponseEncryptAndDecrypt(){
		return getCABooleanConfig("QUERY_RESPONSE_ENCRYPT");
	}
	
	
	/**
	 * ѯ
	 * ͻǷҪ
	 * ǷҪ
	 * @return
	 * 2015-4-29 05:43:53
	 * rd_jinlin_xie
	 */
	public boolean needQueryRequestEncryptAndDecrypt(){
		return getCABooleanConfig("QUERY_REQUEST_DECRYPT");
	}
	
	
	/**
	 * ѯӦ
	 * ͻǷҪǩ
	 * ǷҪǩ
	 * @return
	 * 2015-4-29 05:43:01
	 * rd_jinlin_xie
	 */
	public boolean needQueryResponseSignAndVerify(){
		return getCABooleanConfig("QUERY_RESPONSE_SIGN");
	}
	

	/**
	 * ѯ
	 * ͻǷҪǩ
	 * ǷҪǩ
	 * @return
	 * 2015-4-29 05:42:06
	 * rd_jinlin_xie
	 */
	public boolean needQueryRequestSignAndVerify(){
		return getCABooleanConfig("QUERY_REQUEST_VERIFY");
	}
	
	
	/**
	 * Ӧ
	 * ͻǷҪ
	 * ǷҪ
	 * @return
	 * 2015-4-29 05:38:10
	 * rd_jinlin_xie
	 */
	public boolean needPayResponseEncryptAndDecrypt(){
		return getCABooleanConfig("PAY_RESPONSE_ENCRYPT");
	}
	
	
	/**
	 * 
	 * ͻǷҪ
	 * ǷҪ
	 * @return
	 * 2015-4-29 05:35:05
	 * rd_jinlin_xie
	 */
	public boolean needPayRequestEncryptAndDecrypt(){
		return getCABooleanConfig("PAY_REQUEST_DECRYPT");
	}
	
	
	/**
	 * Ӧ
	 * ͻǷҪǩ
	 * ǷҪǩ
	 * @return
	 * 2015-4-29 05:31:51
	 * rd_jinlin_xie
	 */
	public boolean needPayResponseSignAndVerify(){
		return getCABooleanConfig("PAY_RESPONSE_SIGN");
	}
	

	/**
	 * 
	 * ͻǷҪǩ
	 * ǷҪǩ
	 * @return
	 * 2015-4-29 05:28:00
	 * rd_jinlin_xie
	 */
	public boolean needPayRequestSignAndVerify(){
		return getCABooleanConfig("PAY_REQUEST_VERIFY");
	}
	
	//ȡȫitrus
	public Map<String, String> getAllItrusConfig(){
		return ItrusConfigUtils.getInstance(itrusPath).getAllConfigs();
	}
	
	//ȫitrus
	public void saveAllItrusConfig(Map<String, String> configsMap) throws Exception{
		ItrusConfigUtils.getInstance(itrusPath).saveAllConfigs(configsMap);
	}
	
	//ԭĬitrus
	public void recoverDefaultConfig() throws Exception{
		FileChannel in=null,out=null;
		try {  
			in = new FileInputStream(getEBItrusConfigPath() + EB_DEFAULT_CONFIG_FILE).getChannel();
			out = new FileOutputStream(getEBItrusConfigPath() + EB_CONFIG_FILE).getChannel();  
            in.transferTo(0, in.size(), out);//д  
            out.transferFrom(in, 0, in.size());//Чͬ  
            ItrusConfigUtils.getInstance(itrusPath).setInited(false);
        } catch (FileNotFoundException e) {  
        	throw new Exception("δҵĬļ", e);
        } catch (IOException e) {  
        	throw new Exception("ԭĬʧ", e);
        } finally {
        	if(in!=null){
        		try {
					in.close();
				} catch (Exception e) {
				}
        	}
        	if(out!=null){
        		try {
        			out.close();
        		} catch (Exception e) {
        		}
        	}
        }
	}

	/**
	 * itrusļе·itrusļб
	 */
	public String getItrusConfigPath() throws Exception{
		File dir = new File(itrusPath);
		if(!dir.exists()){
			throw new Exception("ЧCAļ·" + dir);
		}
		return dir.getParent();
		/*String configPath = System.getProperty(OSGI_INSTALL_AREA);
		String itrusConfigPath = new URI(configPath).getPath();
		File dir = new File(itrusConfigPath);
		if(!dir.exists()){
			dir.mkdirs();
		}
		return dir.getAbsolutePath();*/
	}
	
	/**
	 * itrusļе·
	 * @return
	 * @throws Exception
	 */
	public String getEBItrusConfigPath() throws Exception{
		return itrusPath + File.separator;
	}
	
	/**
	 * itrusļ·
	 * @return
	 * @throws Exception
	 */
	public String getEBItrusConfigFilePath() throws Exception{
		return getEBItrusConfigPath() + EB_CONFIG_FILE;
	}
	
	
	/**ؼֶbegin**/
	public String[] getBalanceRequestHeaderEncodeFields(){
		return getEncodeFields("BALANCE_HEADER");
	}
	
	public String[] getBalanceRequestBodyEncodeFields(){
		return new String[0];
	}
	
	public String[] getBalanceRequestDetailEncodeFields(){
		return getEncodeFields("BALANCE_DETAIL");
	}
	
	public String[] getBalanceResponseHeaderEncodeFields(){
		return getEncodeFields("BALANCE_HEADER");
	}
	
	public String[] getBalanceResponseBodyEncodeFields(){
		return new String[0];
	}
	
	public String[] getBalanceResponseDetailEncodeFields(){
		return getEncodeFields("BALANCE_DETAIL");
	}
	/**ؼֶend**/
	
	/**ϸؼֶbegin**/
	public String[] getDetailRequestHeaderEncodeFields(){
		return getEncodeFields("DETAIL_HEADER");
	}
	
	public String[] getDetailRequestBodyEncodeFields(){
		return getEncodeFields("DETAIL_REQUEST_BODY");
	}
	
	public String[] getDetailRequestDetailEncodeFields(){
		return getEncodeFields("DETAIL_DETAIL");
	}
	
	public String[] getDetailResponseHeaderEncodeFields(){
		return getEncodeFields("DETAIL_HEADER");
	}
	
	public String[] getDetailResponseBodyEncodeFields(){
		return getEncodeFields("DETAIL_RESPONSE_BODY");
	}
	
	public String[] getDetailResponseDetailEncodeFields(){
		return getEncodeFields("DETAIL_DETAIL");
	}
	/**ϸؼֶend**/
	
	/**ؼֶbegin**/
	public String[] getPayRequestHeaderEncodeFields(){
		return getEncodeFields("PAY_HEADER");
	}
	
	public String[] getPayRequestBodyEncodeFields(){
		return getEncodeFields("PAY_BODY");
	}
	
	public String[] getPayRequestDetailEncodeFields(){
		return getEncodeFields("PAY_DETAIL");
	}
	
	public String[] getPayResponseHeaderEncodeFields(){
		return getEncodeFields("PAY_HEADER");
	}
	
	public String[] getPayResponseBodyEncodeFields(){
		return getEncodeFields("PAY_BODY");
	}
	
	public String[] getPayResponseDetailEncodeFields(){
		return getEncodeFields("PAY_DETAIL");
	}
	/**ؼֶend**/
	
	/**״̬ѯؼֶbegin**/
	public String[] getQueryPayRequestHeaderEncodeFields(){
		return getEncodeFields("QUERY_PAY_HEADER");
	}
	
	public String[] getQueryPayRequestBodyEncodeFields(){
		return getEncodeFields("QUERY_PAY_BODY");
	}
	
	public String[] getQueryPayRequestDetailEncodeFields(){
		return getEncodeFields("QUERY_PAY_DETAIL");
	}
	
	public String[] getQueryPayResponseHeaderEncodeFields(){
		return getEncodeFields("QUERY_PAY_HEADER");
	}
	
	public String[] getQueryPayResponseBodyEncodeFields(){
		return getEncodeFields("QUERY_PAY_BODY");
	}
	
	public String[] getQueryPayResponseDetailEncodeFields(){
		return getEncodeFields("QUERY_PAY_DETAIL");
	}
	/**״̬ѯؼֶend**/
	
	/**֧ؼֶbegin**/
	public String[] getLinkPayRequestHeaderEncodeFields(){
		return getEncodeFields("LINKPAY_HEADER");
	}
	
	public String[] getLinkPayRequestBodyEncodeFields(){
		return getEncodeFields("LINKPAY_REQUEST_BODY");
	}
	
	public String[] getLinkPayRequestDetailEncodeFields(){
		return getEncodeFields("LINKPAY_DETAIL");
	}
	
	public String[] getLinkPayResponseHeaderEncodeFields(){
		return getEncodeFields("LINKPAY_HEADER");
	}
	
	public String[] getLinkPayResponseBodyEncodeFields(){
		return getEncodeFields("LINKPAY_RESPONSE_BODY");
	}
	
	public String[] getLinkPayResponseDetailEncodeFields(){
		return getEncodeFields("LINKPAY_DETAIL");
	}
	/**֧ؼֶend**/
	
	/**֧״̬ѯؼֶbegin**/
	public String[] getQueryLinkPayRequestHeaderEncodeFields(){
		return getEncodeFields("QUERY_LINKPAY_HEADER");
	}
	
	public String[] getQueryLinkPayRequestBodyEncodeFields(){
		return getEncodeFields("QUERY_LINKPAY_REQUEST_BODY");
	}
	
	public String[] getQueryLinkPayRequestDetailEncodeFields(){
		return getEncodeFields("QUERY_LINKPAY_DETAIL");
	}
	
	public String[] getQueryLinkPayResponseHeaderEncodeFields(){
		return getEncodeFields("QUERY_LINKPAY_HEADER");
	}
	
	public String[] getQueryLinkPayResponseBodyEncodeFields(){
		return getEncodeFields("QUERY_LINKPAY_RESPONSE_BODY");
	}
	
	public String[] getQueryLinkPayResponseDetailEncodeFields(){
		return getEncodeFields("QUERY_LINKPAY_DETAIL");
	}
	/**֧״̬ѯؼֶend**/
	
	/**˻ͬؼֶbegin**/
	public String[] getSyncAccountsRequestHeaderEncodeFields(){
		return getEncodeFields("SYNC_ACCOUNTS_HEADER");
	}
	
	public String[] getSyncAccountsRequestBodyEncodeFields(){
		return new String[0];
	}
	
	public String[] getSyncAccountsRequestDetailEncodeFields(){
		return getEncodeFields("SYNC_ACCOUNTS_DETAIL");
	}
	
	public String[] getSyncAccountsResponseHeaderEncodeFields(){
		return getEncodeFields("SYNC_ACCOUNTS_HEADER");
	}
	
	public String[] getSyncAccountsResponseBodyEncodeFields(){
		return new String[0];
	}
	
	public String[] getSyncAccountsResponseDetailEncodeFields(){
		return getEncodeFields("SYNC_ACCOUNTS_DETAIL");
	}
	/**˻ͬؼֶend**/
	
	/**ɾ˻ؼֶbegin**/
	public String[] getDelAccountsRequestHeaderEncodeFields(){
		return getEncodeFields("DEL_ACCOUNTS_HEADER");
	}
	
	public String[] getDelAccountsRequestBodyEncodeFields(){
		return new String[0];
	}
	
	public String[] getDelAccountsRequestDetailEncodeFields(){
		return getEncodeFields("DEL_ACCOUNTS_DETAIL");
	}
	
	public String[] getDelAccountsResponseHeaderEncodeFields(){
		return getEncodeFields("DEL_ACCOUNTS_HEADER");
	}
	
	public String[] getDelAccountsResponseBodyEncodeFields(){
		return new String[0];
	}
	
	public String[] getDelAccountsResponseDetailEncodeFields(){
		return getEncodeFields("DEL_ACCOUNTS_DETAIL");
	}
	/**ɾ˻ؼֶend**/
	
	/**ʾ½IDֶbegin**/
	public String[] getListLoginsRequestHeaderEncodeFields(){
		return getEncodeFields("LIST_LOGINS_HEADER");
	}
	
	public String[] getListLoginsRequestBodyEncodeFields(){
		return getEncodeFields("LIST_LOGINS_BODY");
	}
	
	public String[] getListLoginsRequestDetailEncodeFields(){
		return getEncodeFields("LIST_LOGINS_DETAIL");
	}
	
	public String[] getListLoginsResponseHeaderEncodeFields(){
		return getEncodeFields("LIST_LOGINS_HEADER");
	}
	
	public String[] getListLoginsResponseBodyEncodeFields(){
		return getEncodeFields("LIST_LOGINS_BODY");
	}
	
	public String[] getListLoginsResponseDetailEncodeFields(){
		return getEncodeFields("LIST_LOGINS_DETAIL");
	}
	/**ʾ½IDؼֶend**/
	
	/**ͷؼֶbegin**/
	public String[] getPositionRequestHeaderEncodeFields(){
		return getEncodeFields("POSITION_HEADER");
	}
	
	public String[] getPositionRequestBodyEncodeFields(){
		return new String[0];
	}
	
	public String[] getPositionRequestDetailEncodeFields(){
		return getEncodeFields("POSITION_REQUEST_DETAIL");
	}
	
	public String[] getPositionResponseHeaderEncodeFields(){
		return getEncodeFields("POSITION_HEADER");
	}
	
	public String[] getPositionResponseBodyEncodeFields(){
		return new String[0];
	}
	
	public String[] getPositionResponseDetailEncodeFields(){
		return getEncodeFields("POSITION_RESPONSE_DETAIL");
	}
	/**ͷؼֶend**/
	
	/**汾ؼֶbegin**/
	public String[] getVersionRequestHeaderEncodeFields(){
		return getEncodeFields("VERSION_HEADER");
	}
	
	public String[] getVersionRequestBodyEncodeFields(){
		return new String[0];
	}
	
	public String[] getVersionRequestDetailEncodeFields(){
		return getEncodeFields("VERSION_DETAIL");
	}
	
	public String[] getVersionResponseHeaderEncodeFields(){
		return getEncodeFields("VERSION_HEADER");
	}
	
	public String[] getVersionResponseBodyEncodeFields(){
		return new String[0];
	}
	
	public String[] getVersionResponseDetailEncodeFields(){
		return getEncodeFields("VERSION_DETAIL");
	}
	/**汾ؼֶend**/
	
	private String[] getEncodeFields(String key){
		String value = ItrusConfigUtils.getInstance(itrusPath).getValue("ENCODE_FIELDS_"+key.toUpperCase());
		if(null == value) {
			return new String[0];
		}
		return value.split(",");
	}
	
	private boolean getCABooleanConfig(String key){
		return ItrusConfigUtils.getInstance(itrusPath).getValueAsBoolean(key, false);
	}
	
}
