/**
 * й޹˾
 * Company:      Kingdee Software(China) Co., Ltd.
 */
package com.kingdee.ws.ca.impl;

import com.kingdee.bos.ebservice.EBException;
import com.kingdee.bos.ebservice.EBHeader;
import com.kingdee.bos.ebservice.EBRequest;
import com.kingdee.bos.ebservice.EBResponse;

/**
 * @author rd_jinlin_xie
 *2015-4-13
 *03:47:50
 */
public abstract class AbstractSignTextUnit implements ISignUnit,IEncryptDataProvider{
	private EBRequest request;
	
	private EBResponse response;
	
	public AbstractSignTextUnit(EBRequest req) {
		this.request = req;
	}
	
	public AbstractSignTextUnit(EBResponse rsp) {
		this.response = rsp;
	}
	
	/**
	 * ַΪ
	 * ebheader + requset + exception
	 * @see com.kingdee.ws.ca.impl.ISignUnit#getRequstMixSignPlainText(java.lang.Object)
	 */
	public String getRequstMixSignPlainText() {
		EBStructNode node = convertToEbRequestNode(request);
		return getHeaderSignPlainText(node.getHeader())
		+ getRequstSignPlainText(node.getBody())
		+ getEBExceptionSignPlainText(node.getException());
	}
	
	/**
	 * ӦַΪ
	 * ebheader + response + exception
	 * @see com.kingdee.ws.ca.impl.ISignUnit#getResponseMixSignPlainText(java.lang.Object)
	 */
	public String getResponseMixSignPlainText() {
		EBStructNode node = convertToEbResponseNode(response);
		return getHeaderSignPlainText(node.getHeader())
		+ getResponseSignPlainText(node.getBody())
		+ getEBExceptionSignPlainText(node.getException());
	}
	
	/**
	 * ͳһ˻ȡebͷڵַķ
	 * @see com.kingdee.ws.ca.impl.ISignUnit#getHeaderSignPlainText(com.kingdee.bos.ebservice.publish.message.EBHeader)
	 */
	public String getHeaderSignPlainText(EBHeader header) {
		return "EBHeader{clientName:" + header.getClientName()
		+ ",clientVersion:" + header.getClientVersion()
		+ ",messageType:" + header.getMessageType() + ",bizType:"
		+ header.getBizType() + ",subBizType:" + header.getSubBizType()
		+ ",operationName:" + header.getOperationName() + ",accNo:"
		+ header.getAccNo() + ",currency:" + header.getCurrency()
		+ ",requestTime:" + header.getRequestTime() + ",responseTime:"
		+ header.getResponseTime() + ",atomicServiceName:"
		+ header.getAtomicServiceName() + ",bankBizCodes:"
		+ header.getBankBizCodes() + ",bankBizNames:"
		+ header.getBankBizNames() + "}";
	}
	
	/**
	 * ͳһ˻ȡ쳣ڵַķ
	 * @see com.kingdee.ws.ca.impl.ISignUnit#getEBExceptionSignPlainText(com.kingdee.bos.ebservice.publish.message.EBException)
	 */
	public String getEBExceptionSignPlainText(EBException ex) {
		if(null == ex){
    		return "";
    	}
		return "EBException{"  + ",errorCode:"
				+ ex.getErrorCode() + ",time:" + ex.getTime() + ",source:" + ex.getSource()
				+ ",context:" + ex.getContext() + ",correlationID:"
				+ ex.getCorrelationID() + ",innerException:"
				+ ex.getInnerException() + "}";
	}
}
