/**
 * й޹˾
 * Company:      Kingdee Software(China) Co., Ltd.
 */
package com.kingdee.ws.ca.impl;

import com.kingdee.bos.ebservice.Balance;
import com.kingdee.bos.ebservice.BalanceRequestBody;
import com.kingdee.bos.ebservice.BalanceRequestExt;
import com.kingdee.bos.ebservice.BalanceResponseBody;
import com.kingdee.bos.ebservice.BalanceResponseExt;
import com.kingdee.bos.ebservice.EBHeader;
import com.kingdee.bos.ebservice.EBRequest;
import com.kingdee.bos.ebservice.EBResponse;
import com.kingdee.ebservice.itrus.ItrusConfigHelper;
import com.kingdee.ws.ca.EBExtUtils;

/**
 * @author rd_jinlin_xie
 *2015-4-13
 *05:16:22
 */
public class BalanceSignTextImpl extends AbstractSignTextUnit{
	
	private EBRequest request;
	private EBResponse response;
	private boolean isRequest;
	private ItrusConfigHelper helper;

	public BalanceSignTextImpl(EBRequest req) {
		super(req);
		this.request = req;
		isRequest = true;
		helper = EBExtUtils.getConfigHelper();
	}
	
	public BalanceSignTextImpl(EBResponse rsp) {
		super(rsp);
		this.response = rsp;
		isRequest = false;
		helper = EBExtUtils.getConfigHelper();
	}

	public String getRequstSignPlainText(Object obj) {
		if(null == obj) {
			return "";
		}
		BalanceRequestBody body = (BalanceRequestBody)obj;
    	StringBuffer sb = new StringBuffer();
    	sb.append("BalanceRequestBody{startDate:");
    	sb.append(body.getStartDate());
    	sb.append(",endDate:");
    	sb.append(body.getEndDate());
    	sb.append("}");
    	return sb.toString();
		
	}

	public String getResponseSignPlainText(Object obj) {
		if(null == obj) {
			return "";
		}
		BalanceResponseBody body = (BalanceResponseBody)obj;
    	Balance[] balances = body.getBalances();
    	if(balances.length > 0) {
    		StringBuffer sb = new StringBuffer();
    		sb.append("BalanceResponseBody{");
    		sb.append("balances:[");
    		for(int i = 0 ; i < balances.length ; i ++) {
    			//ڲʽΪ{...},{...},{...}
    			sb.append("{");
    			sb.append("balanceID:").append(balances[i].getBalanceID());
    			sb.append(",accNo:").append(balances[i].getAccNo());
    			sb.append(",currency:").append(balances[i].getCurrency());
    			sb.append(",currentBalance:").append(balances[i].getCurrentBalance());
    			sb.append(",availableBalance:").append(balances[i].getAvailableBalance());
    			sb.append(",lastDayAvlBalance:").append(balances[i].getLastDayAvlBalance());
    			sb.append(",balanceDateTime:").append(balances[i].getBalanceDateTime());
    			sb.append(",flowSerialNo:").append(balances[i].getFlowSerialNo());
    			sb.append(",rqstSerialNo:").append(balances[i].getRqstSerialNo());
    			sb.append(",rspSerialNo:").append(balances[i].getRspSerialNo());
    			if(i < balances.length -1) {
    				sb.append("},");
    			} else {
					sb.append("}");
				}
    		}
    		sb.append("]");
    		sb.append("}");
    		return sb.toString();
    	} else {
    		return "";
    	}
	}

	public EBStructNode convertToEbRequestNode(Object EBRquset) {
		BalanceRequestExt request = (BalanceRequestExt)EBRquset;
		EBStructNode node = new EBStructNode();
		node.setBody(request.getBody());
		node.setHeader(request.getHeader());
		node.setException(null);
		return node;
	}

	public EBStructNode convertToEbResponseNode(Object EBRquset) {
		BalanceResponseExt response = (BalanceResponseExt)EBRquset;
		EBStructNode node = new EBStructNode();
		node.setBody(response.getBody());
		node.setHeader(response.getHeader());
		node.setException(response.getException());
		return node;
		
	}

	public String[] getHeaderEncodeFields() {
		if(isRequest) {
			return helper.getBalanceRequestHeaderEncodeFields();
		}
		return helper.getBalanceResponseHeaderEncodeFields();
		
	}

	public String[] getBodyEncodeFields() {
		String[] result = null;
		if(isRequest) {
			result = helper.getBalanceRequestBodyEncodeFields();
		} else {
			result = helper.getBalanceResponseBodyEncodeFields();
		}
		return result;
		
	}

	public String[] getOtherEncodeFields() {
		String[] result = null;
		if(isRequest) {
			result = helper.getBalanceRequestDetailEncodeFields();
		} else {
			result = helper.getBalanceResponseDetailEncodeFields();
		}
		return result;
		
	}

	public EBHeader getHeader() {
		if(null != request) {
			return request.getHeader();
		}

		if(null != response) {
			return response.getHeader();
		}
		
		return null;
	}

	public Object getBody() {
		if(null != request) {
			return ((BalanceRequestExt)request).getBody();
		}
		
		if(null != response) {
			return ((BalanceResponseExt)response).getBody();
		}
		return null;
	}

	public Object[] getDetails() {
		
		if(null != request) {
			return null;
		}
		
		if(null != response) {
			BalanceResponseBody body = ((BalanceResponseExt)response).getBody();
			if(null == body) {
				return null;
			}
			return body.getBalances();
		}
		
		return null;
		
	}

}
