/**
 * й޹˾
 * Company:      Kingdee Software(China) Co., Ltd.
 */
package com.kingdee.ws.ca.impl;

import com.kingdee.bos.ebservice.AccountToDel;
import com.kingdee.bos.ebservice.DelAccountsBody;
import com.kingdee.bos.ebservice.DelAccountsRequestExt;
import com.kingdee.bos.ebservice.DelAccountsResponseExt;
import com.kingdee.bos.ebservice.EBHeader;
import com.kingdee.bos.ebservice.EBRequest;
import com.kingdee.bos.ebservice.EBResponse;
import com.kingdee.ebservice.itrus.ItrusConfigHelper;
import com.kingdee.ws.ca.EBExtUtils;

/**
 * @author rd_jinlin_xie
 *2015-4-15
 *09:17:01
 */
public class DelAccountsSignTextImpl extends AbstractSignTextUnit{
	
	private EBRequest request;
	private EBResponse response;
	private boolean isRequest;
	private ItrusConfigHelper helper;
	
	public DelAccountsSignTextImpl(EBRequest req) {
		super(req);
		this.request = req;
		isRequest = true;
		helper = EBExtUtils.getConfigHelper();
	}
	
	public DelAccountsSignTextImpl(EBResponse rsp) {
		super(rsp);
		this.response = rsp;
		isRequest = false;
		helper = EBExtUtils.getConfigHelper();
	}
	

	public String getRequstSignPlainText(Object obj) {
		if(null == obj) {
			return "";
		}
		DelAccountsBody body = (DelAccountsBody)obj;
		return "DelAccountsBody:{" + genDelAccountDel(body.getAccounts()) + "}";
		
	}

	public String getResponseSignPlainText(Object obj) {
		return getRequstSignPlainText(obj);
		
	}

	public EBStructNode convertToEbRequestNode(Object EBRquset) {
		DelAccountsRequestExt requset = (DelAccountsRequestExt)EBRquset;
		EBStructNode node = new EBStructNode();
		node.setBody(requset.getBody());
		node.setHeader(requset.getHeader());
		node.setException(null);
		return node;
		
	}

	public EBStructNode convertToEbResponseNode(Object EBRquset) {
		DelAccountsResponseExt response = (DelAccountsResponseExt)EBRquset;
		EBStructNode node = new EBStructNode();
		node.setBody(response.getBody());
		node.setHeader(response.getHeader());
		node.setException(response.getException());
		return node;
		
	}

	private String genDelAccountDel(AccountToDel[] accDels) {
		StringBuffer sb = new StringBuffer();
		if(accDels.length > 0) {
			for(int i = 0 ; i < accDels.length ; i ++) {
				
				sb.append("AccountToDel:{");
				sb.append("accNo:").append(accDels[i].getAccNo());
				sb.append(",delStatus:").append(accDels[i].getDelStatus());
				sb.append(",delStatusMsg:").append(accDels[i].getDelStatusMsg());
				if(i < accDels.length - 1) {
					sb.append("},");
				} else {
					sb.append("}");
				}
			}
		}
		return sb.toString();
	}

	public String[] getHeaderEncodeFields() {
		if(isRequest) {
			return helper.getDelAccountsRequestHeaderEncodeFields();
		}
		return helper.getDelAccountsResponseHeaderEncodeFields();
		
	}

	public String[] getBodyEncodeFields() {
		if(isRequest) {
			return helper.getDelAccountsRequestBodyEncodeFields();
		}
		return helper.getDelAccountsResponseBodyEncodeFields();
		
	}

	public String[] getOtherEncodeFields() {
		if(isRequest) {
			return helper.getDelAccountsRequestDetailEncodeFields();
		}
		return helper.getDelAccountsResponseDetailEncodeFields();
		
	}

	public EBHeader getHeader() {
		if(null != request) {
			return request.getHeader();
		}
		
		if(null != response) {
			return response.getHeader();
		}
		return null;
		
	}

	public Object getBody() {
		if(null != request) {
			return ((DelAccountsRequestExt)request).getBody();
		}
		
		if(null != response) {
			return ((DelAccountsResponseExt)response).getBody();
		}
		return null;
		
	}

	public Object[] getDetails() {

		if(null != request) {
			DelAccountsBody body = ((DelAccountsRequestExt)request).getBody();
			if(null == body) {
				return null;
			}
			return body.getAccounts();
		}
		
		if(null != response) {
			DelAccountsBody body = ((DelAccountsResponseExt)response).getBody();
			if(null == body) {
				return null;
			}
			return body.getAccounts();
		}
		return null;
		
	}
}
