/**
 * й޹˾
 * Company:      Kingdee Software(China) Co., Ltd.
 */
package com.kingdee.ws.ca.impl;

import com.kingdee.bos.ebservice.BalanceRequestExt;
import com.kingdee.bos.ebservice.BalanceResponseExt;
import com.kingdee.bos.ebservice.DelAccountsRequestExt;
import com.kingdee.bos.ebservice.DelAccountsResponseExt;
import com.kingdee.bos.ebservice.DetailRequestExt;
import com.kingdee.bos.ebservice.DetailResponseExt;
import com.kingdee.bos.ebservice.EBRequest;
import com.kingdee.bos.ebservice.EBResponse;
import com.kingdee.bos.ebservice.LinkPayRequestExt;
import com.kingdee.bos.ebservice.LinkPayResponseExt;
import com.kingdee.bos.ebservice.PayRequestExt;
import com.kingdee.bos.ebservice.PayResponseExt;
import com.kingdee.bos.ebservice.QueryLinkPayRequestExt;
import com.kingdee.bos.ebservice.QueryLinkPayResponseExt;
import com.kingdee.bos.ebservice.QueryPayRequestExt;
import com.kingdee.bos.ebservice.QueryPayResponseExt;
import com.kingdee.bos.ebservice.SyncAccountsRequestExt;
import com.kingdee.bos.ebservice.SyncAccountsResponseExt;

/**
 * @author rd_jinlin_xie
 *2015-4-15
 *10:00:35
 */
public class EBSignProviderUtils {
	
	public static String getEncryptedData(EBRequest req) {
		if(req instanceof BalanceRequestExt) {
			return ((BalanceRequestExt)req).getEbExt().getEncryptedData();
		} else if(req instanceof DetailRequestExt) {
			return ((DetailRequestExt)req).getEbExt().getEncryptedData();
		} else if(req instanceof PayRequestExt){
			return ((PayRequestExt)req).getEbExt().getEncryptedData();
		} else if(req instanceof QueryPayRequestExt) {
			return ((QueryPayRequestExt)req).getEbExt().getEncryptedData();
		} else if(req instanceof LinkPayRequestExt) {
			return ((LinkPayRequestExt)req).getEbExt().getEncryptedData();
		} else if(req instanceof QueryLinkPayRequestExt) {
			return ((QueryLinkPayRequestExt)req).getEbExt().getEncryptedData();
		} else if(req instanceof SyncAccountsRequestExt) {
			return ((SyncAccountsRequestExt)req).getEbExt().getEncryptedData();
		} else if(req instanceof DelAccountsRequestExt) {
			return ((DelAccountsRequestExt)req).getEbExt().getEncryptedData();
		}
		return "";
	}
	
	public static String getEncryptedData(EBResponse rsp) {
		if(rsp instanceof BalanceResponseExt) {
			return ((BalanceResponseExt)rsp).getEbExt().getEncryptedData();
		} else if(rsp instanceof DetailResponseExt) {
			return ((DetailResponseExt)rsp).getEbExt().getEncryptedData();
		} else if(rsp instanceof PayResponseExt){
			return ((PayResponseExt)rsp).getEbExt().getEncryptedData();
		} else if(rsp instanceof QueryPayResponseExt) {
			return ((QueryPayResponseExt)rsp).getEbExt().getEncryptedData();
		} else if(rsp instanceof LinkPayResponseExt) {
			return ((LinkPayResponseExt)rsp).getEbExt().getEncryptedData();
		} else if(rsp instanceof QueryLinkPayResponseExt) {
			return ((QueryLinkPayResponseExt)rsp).getEbExt().getEncryptedData();
		} else if(rsp instanceof SyncAccountsResponseExt) {
			return ((SyncAccountsResponseExt)rsp).getEbExt().getEncryptedData();
		} else if(rsp instanceof DelAccountsResponseExt) {
			return ((DelAccountsResponseExt)rsp).getEbExt().getEncryptedData();
		}
		return "";
	}
	
	public static IEncryptDataProvider getEncryDataProvider(EBRequest request) {
		IEncryptDataProvider provider = null;
		
		if(request instanceof BalanceRequestExt) {
			provider = new BalanceSignTextImpl(request);
		} else if(request instanceof DetailRequestExt) {
			provider = new DetailSignTextImpl(request);
		} else if(request instanceof PayRequestExt){
			provider = new PaySignTextImpl(request);
		} else if(request instanceof QueryPayRequestExt) {
			provider = new QueryPaySignTextImpl(request);
		} else if(request instanceof LinkPayRequestExt) {
			provider = new LinkPaySignTextImpl(request);
		} else if(request instanceof QueryLinkPayRequestExt) {
			provider = new QueryLinkPaySignTextImpl(request);
		} else if(request instanceof SyncAccountsRequestExt) {
			provider = new SyncAccountsSignTextImpl(request);
		} else if(request instanceof DelAccountsRequestExt) {
			provider = new DelAccountsSignTextImpl(request);
		}
		return provider;
	}
	
	
	public static IEncryptDataProvider getEncryDataProvider(EBResponse response) {
		IEncryptDataProvider provider = null;
		
		if(response instanceof BalanceResponseExt) {
			provider = new BalanceSignTextImpl(response);
		} else if(response instanceof DetailResponseExt) {
			provider = new DetailSignTextImpl(response);
		} else if(response instanceof PayResponseExt){
			provider = new PaySignTextImpl(response);
		} else if(response instanceof QueryPayResponseExt) {
			provider = new QueryPaySignTextImpl(response);
		} else if(response instanceof LinkPayResponseExt) {
			provider = new LinkPaySignTextImpl(response);
		} else if(response instanceof QueryLinkPayResponseExt) {
			provider = new QueryLinkPaySignTextImpl(response);
		} else if(response instanceof SyncAccountsResponseExt) {
			provider = new SyncAccountsSignTextImpl(response);
		} else if(response instanceof DelAccountsResponseExt) {
			provider = new DelAccountsSignTextImpl(response);
		}
		return provider;
	}
	
	public static void setEncryData(EBResponse rsp,String encryData) {
		if(rsp instanceof BalanceResponseExt) {
			((BalanceResponseExt)rsp).getEbExt().setEncryptedData(encryData);
		} else if(rsp instanceof DetailResponseExt) {
			((DetailResponseExt)rsp).getEbExt().setEncryptedData(encryData);
		} else if(rsp instanceof PayResponseExt){
			((PayResponseExt)rsp).getEbExt().setEncryptedData(encryData);
		} else if(rsp instanceof QueryPayResponseExt) {
			((QueryPayResponseExt)rsp).getEbExt().setEncryptedData(encryData);
		} else if(rsp instanceof LinkPayResponseExt) {
			((LinkPayResponseExt)rsp).getEbExt().setEncryptedData(encryData);
		} else if(rsp instanceof QueryLinkPayResponseExt) {
			((QueryLinkPayResponseExt)rsp).getEbExt().setEncryptedData(encryData);
		} else if(rsp instanceof SyncAccountsResponseExt) {
			((SyncAccountsResponseExt)rsp).getEbExt().setEncryptedData(encryData);
		} else if(rsp instanceof DelAccountsResponseExt) {
			((DelAccountsResponseExt)rsp).getEbExt().setEncryptedData(encryData);
		}
	}
	
	public static void setEncryData(EBRequest req,String encryData) {
		if(req instanceof BalanceRequestExt) {
			((BalanceRequestExt)req).getEbExt().setEncryptedData(encryData);
		} else if(req instanceof DetailRequestExt) {
			((DetailRequestExt)req).getEbExt().setEncryptedData(encryData);
		} else if(req instanceof PayRequestExt){
			((PayRequestExt)req).getEbExt().setEncryptedData(encryData);
		} else if(req instanceof QueryPayRequestExt) {
			((QueryPayRequestExt)req).getEbExt().setEncryptedData(encryData);
		} else if(req instanceof LinkPayRequestExt) {
			((LinkPayRequestExt)req).getEbExt().setEncryptedData(encryData);
		} else if(req instanceof QueryLinkPayRequestExt) {
			((QueryLinkPayRequestExt)req).getEbExt().setEncryptedData(encryData);
		} else if(req instanceof SyncAccountsRequestExt) {
			((SyncAccountsRequestExt)req).getEbExt().setEncryptedData(encryData);
		} else if(req instanceof DelAccountsRequestExt) {
			((DelAccountsRequestExt)req).getEbExt().setEncryptedData(encryData);
		}
	}
	
	
	public static String getSignData(EBRequest req) {
		if(req instanceof BalanceRequestExt) {
			return ((BalanceRequestExt)req).getEbExt().getSignedData();
		} else if(req instanceof DetailRequestExt) {
			return ((DetailRequestExt)req).getEbExt().getSignedData();
		} else if(req instanceof PayRequestExt){
			return ((PayRequestExt)req).getEbExt().getSignedData();
		} else if(req instanceof QueryPayRequestExt) {
			return ((QueryPayRequestExt)req).getEbExt().getSignedData();
		} else if(req instanceof LinkPayRequestExt) {
			return ((LinkPayRequestExt)req).getEbExt().getSignedData();
		} else if(req instanceof QueryLinkPayRequestExt) {
			return ((QueryLinkPayRequestExt)req).getEbExt().getSignedData();
		} else if(req instanceof SyncAccountsRequestExt) {
			return ((SyncAccountsRequestExt)req).getEbExt().getSignedData();
		} else if(req instanceof DelAccountsRequestExt) {
			return ((DelAccountsRequestExt)req).getEbExt().getSignedData();
		}
		return "";
	}
	
	public static String getSignData(EBResponse rsp) {
		if(rsp instanceof BalanceResponseExt) {
			return ((BalanceResponseExt)rsp).getEbExt().getSignedData();
		} else if(rsp instanceof DetailResponseExt) {
			return ((DetailResponseExt)rsp).getEbExt().getSignedData();
		} else if(rsp instanceof PayResponseExt){
			return ((PayResponseExt)rsp).getEbExt().getSignedData();
		} else if(rsp instanceof QueryPayResponseExt) {
			return ((QueryPayResponseExt)rsp).getEbExt().getSignedData();
		} else if(rsp instanceof LinkPayResponseExt) {
			return ((LinkPayResponseExt)rsp).getEbExt().getSignedData();
		} else if(rsp instanceof QueryLinkPayResponseExt) {
			return ((QueryLinkPayResponseExt)rsp).getEbExt().getSignedData();
		} else if(rsp instanceof SyncAccountsResponseExt) {
			return ((SyncAccountsResponseExt)rsp).getEbExt().getSignedData();
		} else if(rsp instanceof DelAccountsResponseExt) {
			return ((DelAccountsResponseExt)rsp).getEbExt().getSignedData();
		}
		return "";
	}
	
	
	public static void setSignData(EBRequest req,String signData) {
		if(req instanceof BalanceRequestExt) {
			((BalanceRequestExt)req).getEbExt().setSignedData(signData);
		} else if(req instanceof DetailRequestExt) {
			((DetailRequestExt)req).getEbExt().setSignedData(signData);
		} else if(req instanceof PayRequestExt){
			((PayRequestExt)req).getEbExt().setSignedData(signData);
		} else if(req instanceof QueryPayRequestExt) {
			((QueryPayRequestExt)req).getEbExt().setSignedData(signData);
		} else if(req instanceof LinkPayRequestExt) {
			((LinkPayRequestExt)req).getEbExt().setSignedData(signData);
		} else if(req instanceof QueryLinkPayRequestExt) {
			((QueryLinkPayRequestExt)req).getEbExt().setSignedData(signData);
		} else if(req instanceof SyncAccountsRequestExt) {
			((SyncAccountsRequestExt)req).getEbExt().setSignedData(signData);
		} else if(req instanceof DelAccountsRequestExt) {
			((DelAccountsRequestExt)req).getEbExt().setSignedData(signData);
		}
	}
	
	public static void setSignData(EBResponse rsp,String signData) {
		if(rsp instanceof BalanceResponseExt) {
			((BalanceResponseExt)rsp).getEbExt().setSignedData(signData);
		} else if(rsp instanceof DetailResponseExt) {
			((DetailResponseExt)rsp).getEbExt().setSignedData(signData);
		} else if(rsp instanceof PayResponseExt){
			((PayResponseExt)rsp).getEbExt().setSignedData(signData);
		} else if(rsp instanceof QueryPayResponseExt) {
			((QueryPayResponseExt)rsp).getEbExt().setSignedData(signData);
		} else if(rsp instanceof LinkPayResponseExt) {
			((LinkPayResponseExt)rsp).getEbExt().setSignedData(signData);
		} else if(rsp instanceof QueryLinkPayResponseExt) {
			((QueryLinkPayResponseExt)rsp).getEbExt().setSignedData(signData);
		} else if(rsp instanceof SyncAccountsResponseExt) {
			((SyncAccountsResponseExt)rsp).getEbExt().setSignedData(signData);
		} else if(rsp instanceof DelAccountsResponseExt) {
			((DelAccountsResponseExt)rsp).getEbExt().setSignedData(signData);
		}
	}
	
	public static ISignUnit getSignUnit(EBRequest request) {
		ISignUnit signText = null;
		if(request instanceof BalanceRequestExt) {
			 signText = new BalanceSignTextImpl(request);
		} else if(request instanceof DetailRequestExt) {
			signText = new DetailSignTextImpl(request);
		} else if(request instanceof PayRequestExt){
			signText = new PaySignTextImpl(request);
		} else if(request instanceof QueryPayRequestExt) {
			signText = new QueryPaySignTextImpl(request);
		} else if(request instanceof LinkPayRequestExt) {
			signText = new LinkPaySignTextImpl(request);
		} else if(request instanceof QueryLinkPayRequestExt) {
			signText = new QueryLinkPaySignTextImpl(request);
		} else if(request instanceof SyncAccountsRequestExt) {
			signText = new SyncAccountsSignTextImpl(request);
		} else if(request instanceof DelAccountsRequestExt) {
			signText = new DelAccountsSignTextImpl(request);
		}
		return signText;
	}
	
	public static ISignUnit getSignUnit(EBResponse response) {
		ISignUnit signText = null;
		if(response instanceof BalanceResponseExt) {
			 signText = new BalanceSignTextImpl(response);
		} else if(response instanceof DetailResponseExt) {
			signText = new DetailSignTextImpl(response);
		} else if(response instanceof PayResponseExt){
			signText = new PaySignTextImpl(response);
		} else if(response instanceof QueryPayResponseExt) {
			signText = new QueryPaySignTextImpl(response);
		} else if(response instanceof LinkPayResponseExt) {
			signText = new LinkPaySignTextImpl(response);
		} else if(response instanceof QueryLinkPayResponseExt) {
			signText = new QueryLinkPaySignTextImpl(response);
		} else if(response instanceof SyncAccountsResponseExt) {
			signText = new SyncAccountsSignTextImpl(response);
		} else if(response instanceof DelAccountsResponseExt) {
			signText = new DelAccountsSignTextImpl(response);
		}
		return signText;
	}
}
