/**
 * й޹˾
 * Company:      Kingdee Software(China) Co., Ltd.
 */
package com.kingdee.ws.ca.impl;

import com.kingdee.bos.ebservice.EBHeader;
import com.kingdee.bos.ebservice.EBRequest;
import com.kingdee.bos.ebservice.EBResponse;
import com.kingdee.bos.ebservice.PayBody;
import com.kingdee.bos.ebservice.PayRequestExt;
import com.kingdee.bos.ebservice.PayResponseExt;
import com.kingdee.bos.ebservice.PaymentDetail;
import com.kingdee.ebservice.itrus.ItrusConfigHelper;
import com.kingdee.ws.ca.EBExtUtils;

/**
 * @author rd_jinlin_xie
 *2015-4-13
 *07:35:10
 */
public class PaySignTextImpl extends AbstractSignTextUnit{
	
	
	private EBRequest request;
	private EBResponse response;
	private boolean isRequest;
	private ItrusConfigHelper helper;

	public PaySignTextImpl(EBRequest req) {
		super(req);
		this.request = req;
		isRequest = true;
		helper = EBExtUtils.getConfigHelper();
	}
	
	public PaySignTextImpl(EBResponse rsp) {
		super(rsp);
		this.response = rsp;
		isRequest = false;
		helper = EBExtUtils.getConfigHelper();
	}

	public String getRequstSignPlainText(Object obj) {
		if(null == obj) {
			return "";
		}
		PayBody payBody = (PayBody)obj;
		StringBuffer detailSignPlainTextStrBuffer = new StringBuffer();
		PaymentDetail[] details = payBody.getDetails();
		for (PaymentDetail detail : details) {
			detailSignPlainTextStrBuffer.append(getPayDetailSignPlainText(detail) + ",");
		}
		String detailSignPlainTextStr = "";
		if(detailSignPlainTextStrBuffer.length() > 0){
			detailSignPlainTextStr = detailSignPlainTextStrBuffer.substring(0, detailSignPlainTextStrBuffer.length() - 1);
		}
		return "PayBody{batchSeqID:" + payBody.getBatchSeqID() + ",batchBizNo:"
				+ payBody.getBatchBizNo() + ",totalCount:"
				+ payBody.getTotalCount() + ",totalAmount:"
				+ payBody.getTotalAmount() + ",verifyField:"
				+ payBody.getVerifyField() + ",feeType:" + payBody.getFeeType()
				+ ",thirdAccNo:" + payBody.getThirdAccNo()
				+ ",paymentDetail:[" + detailSignPlainTextStr + "]}";
	}

	public String getResponseSignPlainText(Object obj) {
		return getRequstSignPlainText(obj);
		
	}

	public EBStructNode convertToEbRequestNode(Object EBRquset) {
		PayRequestExt requset = (PayRequestExt)EBRquset;
		EBStructNode node = new EBStructNode();
		node.setBody(requset.getBody());
		node.setHeader(requset.getHeader());
		node.setException(null);
		return node;
		
	}

	public EBStructNode convertToEbResponseNode(Object EBRquset) {
		PayResponseExt response = (PayResponseExt)EBRquset;
		EBStructNode node = new EBStructNode();
		node.setBody(response.getBody());
		node.setHeader(response.getHeader());
		node.setException(response.getException());
		return node;
	}

	
	 private  String getPayDetailSignPlainText(PaymentDetail payDetail){
	    	if(null == payDetail){
	    		return "";
	    	}
			return "{detailSeqID:" + payDetail.getDetailSeqID() + ",detailBizNo:"
					+ payDetail.getDetailBizNo() + ",payeeAccNo:"
					+ payDetail.getPayeeAccNo() + ",payeeAccName:"
					+ payDetail.getPayeeAccName() + ",payeeType:"
					+ payDetail.getPayeeType() + ",payeeBankName:"
					+ payDetail.getPayeeBankName() + ",payeeBankAddr:"
					+ payDetail.getPayeeBankAddr() + ",payeeCountry:"
					+ payDetail.getPayeeCountry() + ",payeeProvince:"
					+ payDetail.getPayeeProvince() + ",payeeCity:"
					+ payDetail.getPayeeCity() + ",payeeAreaCode:"
					+ payDetail.getPayeeAreaCode() + ",payeeCnapsCode:"
					+ payDetail.getPayeeCnapsCode() + ",payeeSwiftCode:"
					+ payDetail.getPayeeSwiftCode() + ",amount:"
					+ payDetail.getAmount() + ",bookingDate:"
					+ payDetail.getBookingDate() + ",urgent:"
					+ payDetail.getUrgent() + ",forceManual:"
					+ payDetail.getForceManual() + ",useCode:"
					+ payDetail.getUseCode() + ",use:" + payDetail.getUse()
					+ ",desc:" + payDetail.getDesc() + ",mobile:"
					+ payDetail.getMobile() + ",email:" + payDetail.getEmail()
					+ ",verifyField:" + payDetail.getVerifyField() + ",ebSeqID:"
					+ payDetail.getEbSeqID() + ",ebStatus:"
					+ payDetail.getEbStatus() + ",ebStatusMsg:"
					+ payDetail.getEbStatusMsg() + ",bankBatchSeqID:"
					+ payDetail.getBankBatchSeqID() + ",bankStatus:"
					+ payDetail.getBankStatus() + ",bankStatusMsg:"
					+ payDetail.getBankStatusMsg() + "}";
	    }

	public String[] getHeaderEncodeFields() {
		if(isRequest) {
			return helper.getPayRequestHeaderEncodeFields();
		}
		return helper.getPayResponseHeaderEncodeFields();
		
	}

	public String[] getBodyEncodeFields() {
		if(isRequest) {
			return helper.getPayRequestBodyEncodeFields();
		}
		return helper.getPayResponseBodyEncodeFields();
		
	}

	public String[] getOtherEncodeFields() {
		if(isRequest) {
			return helper.getPayRequestDetailEncodeFields();
		}
		return helper.getPayResponseDetailEncodeFields();
		
	}

	public EBHeader getHeader() {

		if(null != request) {
			return request.getHeader();
		}
		
		if(null != response) {
			return response.getHeader();
		}
		return null;
		
	}

	public Object getBody() {

		if(null != request) {
			return ((PayRequestExt)request).getBody();
		}
		if(null != response) {
			return ((PayResponseExt)response).getBody();
		}
		return null;
		
	}

	public Object[] getDetails() {
		if(null != request) {
			PayBody body = ((PayRequestExt)request).getBody();
			if(null == body) {
				return null;
			}
			return body.getDetails();
		}
		if(null != response) {
			PayBody body = ((PayResponseExt)response).getBody();
			if(null == body) {
				return null;
			}
			return body.getDetails();
		}
		return null;
		
	}
}
