package com.kingdee.ws.ca.impl;

import java.lang.reflect.Field;

import com.kingdee.bos.ebservice.EBException;
import com.kingdee.bos.ebservice.EBHeader;
import com.kingdee.bos.ebservice.EBRequest;
import com.kingdee.bos.ebservice.EBResponse;
import com.kingdee.bos.ebservice.LinkPayResponseBody;
import com.kingdee.bos.ebservice.PayBody;
import com.kingdee.bos.ebservice.PayRequestExt;
import com.kingdee.bos.ebservice.PayResponseExt;
import com.kingdee.bos.ebservice.PaymentDetail;
import com.kingdee.bos.ebservice.QueryPayRequestBody;

public class SignPlainTextUtils {
	
    public static String getSignPlainText(EBRequest rqst){
    	StringBuffer signPlainText = new StringBuffer();
    	signPlainText.append(getHeaderSignPlainText(rqst.getHeader()));
    	if(rqst instanceof PayRequestExt){
    		PayRequestExt payRqstExt = (PayRequestExt)rqst;
    		signPlainText.append(getPayBodySignPlainText(payRqstExt.getBody()));
    	}
    	
    	return signPlainText.toString();
    }
    
    public static String getSignPlainText(EBResponse rsp){
    	StringBuffer signPlainText = new StringBuffer();
    	signPlainText.append(getHeaderSignPlainText(rsp.getHeader()));
    	signPlainText.append(getExceptionSignPlainText(rsp.getException()));
    	if(rsp instanceof PayResponseExt){
    		PayResponseExt payRspExt = (PayResponseExt)rsp;
    		signPlainText.append(getPayBodySignPlainText(payRspExt.getBody()));
    	}
    	
    	return signPlainText.toString();
    }
    
    private static String getHeaderSignPlainText(EBHeader header){
		return "EBHeader{clientName:" + header.getClientName()
				+ ",clientVersion:" + header.getClientVersion()
				+ ",messageType:" + header.getMessageType() + ",bizType:"
				+ header.getBizType() + ",subBizType:" + header.getSubBizType()
				+ ",operationName:" + header.getOperationName() + ",accNo:"
				+ header.getAccNo() + ",currency:" + header.getCurrency()
				+ ",requestTime:" + header.getRequestTime() + ",responseTime:"
				+ header.getResponseTime() + ",atomicServiceName:"
				+ header.getAtomicServiceName() + ",bankBizCodes:"
				+ header.getBankBizCodes() + ",bankBizNames:"
				+ header.getBankBizNames() + "}";
    }
    

    private static String getExceptionSignPlainText(EBException ex){
    	if(null == ex){
    		return "";
    	}
		return "EBException{message:" + ex.getMessage() + ",errorCode:"
				+ ex.getErrorCode() + ",errorClass:" + ex.getErrorClass()
				+ ",time:" + ex.getTime() + ",source:" + ex.getSource()
				+ ",context:" + ex.getContext() + ",correlationID:"
				+ ex.getCorrelationID() + ",innerException:"
				+ ex.getInnerException() + "}";
    }
    
    private static String getPayBodySignPlainText(PayBody payBody){
    	if(null == payBody){
    		return "";
    	}
		StringBuffer detailSignPlainTextStrBuffer = new StringBuffer();
		PaymentDetail[] details = payBody.getDetails();
		for (PaymentDetail detail : details) {
			detailSignPlainTextStrBuffer.append(getPayDetailSignPlainText(detail) + ",");
		}
		String detailSignPlainTextStr = "";
		if(detailSignPlainTextStrBuffer.length() > 0){
			detailSignPlainTextStr = detailSignPlainTextStrBuffer.substring(0, detailSignPlainTextStrBuffer.length() - 1);
		}
		return "PayBody{batchSeqID:" + payBody.getBatchSeqID() + ",batchBizNo:"
				+ payBody.getBatchBizNo() + ",totalCount:"
				+ payBody.getTotalCount() + ",totalAmount:"
				+ payBody.getTotalAmount() + ",verifyField:"
				+ payBody.getVerifyField() + ",feeType:" + payBody.getFeeType()
				+ ",thirdAccNo:" + payBody.getThirdAccNo()
				+ ",paymentDetail:[" + detailSignPlainTextStr + "]}";
	}
    
    private static String getPayDetailSignPlainText(PaymentDetail payDetail){
    	if(null == payDetail){
    		return "";
    	}
		return "{detailSeqID:" + payDetail.getDetailSeqID() + ",detailBizNo:"
				+ payDetail.getDetailBizNo() + ",payeeAccNo:"
				+ payDetail.getPayeeAccNo() + ",payeeAccName:"
				+ payDetail.getPayeeAccName() + ",payeeType:"
				+ payDetail.getPayeeType() + ",payeeBankName:"
				+ payDetail.getPayeeBankName() + ",payeeBankAddr:"
				+ payDetail.getPayeeBankAddr() + ",payeeCountry:"
				+ payDetail.getPayeeCountry() + ",payeeProvince:"
				+ payDetail.getPayeeProvince() + ",payeeCity:"
				+ payDetail.getPayeeCity() + ",payeeAreaCode:"
				+ payDetail.getPayeeAreaCode() + ",payeeCnapsCode:"
				+ payDetail.getPayeeCnapsCode() + ",payeeSwiftCode:"
				+ payDetail.getPayeeSwiftCode() + ",amount:"
				+ payDetail.getAmount() + ",bookingDate:"
				+ payDetail.getBookingDate() + ",urgent:"
				+ payDetail.getUrgent() + ",forceManual:"
				+ payDetail.getForceManual() + ",useCode:"
				+ payDetail.getUseCode() + ",use:" + payDetail.getUse()
				+ ",desc:" + payDetail.getDesc() + ",mobile:"
				+ payDetail.getMobile() + ",email:" + payDetail.getEmail()
				+ ",verifyField:" + payDetail.getVerifyField() + ",ebSeqID:"
				+ payDetail.getEbSeqID() + ",ebStatus:"
				+ payDetail.getEbStatus() + ",ebStatusMsg:"
				+ payDetail.getEbStatusMsg() + ",bankBatchSeqID:"
				+ payDetail.getBankBatchSeqID() + ",bankStatus:"
				+ payDetail.getBankStatus() + ",bankStatusMsg:"
				+ payDetail.getBankStatusMsg() + "}";
    }
    
    /**
     * ݶǩԭĸʽ
     * @param obj
     * @param objName
     * @return
     */
    private static String genPlainText(Object obj, String objName){
    	StringBuffer sb = new StringBuffer();
    	Class clz = obj.getClass();
    	String clzName = clz.getName();
    	clzName = clzName.substring(clzName.lastIndexOf(".")+1);
    	sb.append("\"" + clzName + "{");
    	Field[] fs = clz.getDeclaredFields();
        for(int i = 0 ; i < fs.length; i++){
        	Field f = fs[i];
        	String type = f.getType().toString();
        	if(type.endsWith("String")){
        		sb.append(f.getName() + ":\"+" + objName + "." + buildGetMethod(f.getName()) + "()+\",");
        	}
        }
        sb.append("}\"");
    	return sb.toString();
    }
    
    private static String buildGetMethod(String property){
    	return "get" + property.substring(0, 1).toUpperCase() + property.substring(1);
    }
    
    public static void main(String[] args) {
    	System.out.println(genPlainText(new PayBody(), "payBody"));
		System.out.println(genPlainText(new PaymentDetail(), "payDetail"));
		System.out.println(genPlainText(new EBException(), "ex"));
		System.out.println(genPlainText(new QueryPayRequestBody(),"QueryPayRequestBody"));
		System.out.println(genPlainText(new LinkPayResponseBody(),"body"));
	}
}
