/**
 * й޹˾
 * Company:      Kingdee Software(China) Co., Ltd.
 */
package com.kingdee.ws.ca.impl;

import com.kingdee.bos.ebservice.AccountToSync;
import com.kingdee.bos.ebservice.EBHeader;
import com.kingdee.bos.ebservice.EBRequest;
import com.kingdee.bos.ebservice.EBResponse;
import com.kingdee.bos.ebservice.SyncAccountsBody;
import com.kingdee.bos.ebservice.SyncAccountsRequestExt;
import com.kingdee.bos.ebservice.SyncAccountsResponseExt;
import com.kingdee.ebservice.itrus.ItrusConfigHelper;
import com.kingdee.ws.ca.EBExtUtils;

/**
 * @author rd_jinlin_xie
 *2015-4-14
 *10:53:13
 */
public class SyncAccountsSignTextImpl extends AbstractSignTextUnit{
	
	private EBRequest request;
	private EBResponse response;
	private boolean isRequest;
	private ItrusConfigHelper helper;

	public SyncAccountsSignTextImpl(EBRequest req) {
		super(req);
		this.request = req;
		isRequest = true;
		helper = EBExtUtils.getConfigHelper();
	}
	
	public SyncAccountsSignTextImpl(EBResponse rsp) {
		super(rsp);
		this.response = rsp;
		isRequest = false;
		helper = EBExtUtils.getConfigHelper();
	}
	

	public String getRequstSignPlainText(Object obj) {
		if(null == obj) {
			return "";
		}
		SyncAccountsBody body = (SyncAccountsBody)obj;
		StringBuffer sb = new StringBuffer();
		sb.append("SyncAccountsBody:{");
		sb.append(genAccountsText(body.getAccounts()));
		sb.append("}");
		return sb.toString();
		
	}

	public String getResponseSignPlainText(Object obj) {
		return getRequstSignPlainText(obj);
	}

	public EBStructNode convertToEbRequestNode(Object EBRquset) {
		SyncAccountsRequestExt request = (SyncAccountsRequestExt)EBRquset;
		EBStructNode node = new EBStructNode();
		node.setBody(request.getBody());
		node.setHeader(request.getHeader());
		node.setException(null);
		return node;
		
	}

	public EBStructNode convertToEbResponseNode(Object EBRquset) {
		SyncAccountsResponseExt response = (SyncAccountsResponseExt)EBRquset;
		EBStructNode node = new EBStructNode();
		node.setBody(response.getBody());
		node.setException(response.getException());
		node.setHeader(response.getHeader());
		return node;
		
	}

	private String genAccountsText(AccountToSync[] accounts) {
		StringBuffer sb = new StringBuffer();
		if(accounts.length > 0) {
			for(int i = 0 ; i < accounts.length ; i ++) {
				sb.append("AccountToSync:{");
				sb.append("accNo:").append(accounts[i].getAccNo());
				sb.append(",accName:").append(accounts[i].getAccName());
				sb.append(",currency:").append(accounts[i].getCurrency());
				sb.append(",country:").append(accounts[i].getCountry());
				sb.append(",province:").append(accounts[i].getProvince());
				sb.append(",city:").append(accounts[i].getCity());
				sb.append(",bankAreaCode:").append(accounts[i].getBankAreaCode());
				sb.append(",bankDeptCode:").append(accounts[i].getBankDeptCode());
				sb.append(",swiftCode:").append(accounts[i].getSwiftCode());
				sb.append(",bankServiceLoginId:").append(accounts[i].getBankServiceLoginId());
				sb.append(",bankServiceLoginDesc:").append(accounts[i].getBankServiceLoginDesc());
				sb.append(",syncStatus:").append(accounts[i].getSyncStatus());
				sb.append(",syncStatusMsg:").append(accounts[i].getSyncStatusMsg());
				if(i < accounts.length - 1) {
					sb.append("},");
				} else {
					sb.append("}");
				}
			}
		}
		return sb.toString();
	}

	public String[] getHeaderEncodeFields() {
		if(isRequest) {
			return helper.getSyncAccountsRequestHeaderEncodeFields();
		}
		return helper.getSyncAccountsResponseHeaderEncodeFields();
		
	}

	public String[] getBodyEncodeFields() {
		if(isRequest) {
			return helper.getSyncAccountsRequestBodyEncodeFields();
		}
		return helper.getSyncAccountsResponseBodyEncodeFields();
		
	}

	public String[] getOtherEncodeFields() {
		if(isRequest) {
			return helper.getSyncAccountsRequestDetailEncodeFields();
		}
		return helper.getSyncAccountsResponseDetailEncodeFields();
		
	}

	public EBHeader getHeader() {
		if(null != request) {
			return request.getHeader();
		}
		if(null != response) {
			return response.getHeader();
		}
		return null;
		
	}

	public Object getBody() {
		if(null != request) {
			return ((SyncAccountsRequestExt)request).getBody();
		}
		if(null != response) {
			return ((SyncAccountsResponseExt)response).getBody();
		}
		return null;
		
	}

	public Object[] getDetails() {
		if(null != request) {
			SyncAccountsBody body = ((SyncAccountsRequestExt)request).getBody();
			if(null == body) {
				return null;
			}
			return body.getAccounts();
		}
		if(null != response) {
			SyncAccountsBody body = ((SyncAccountsResponseExt)response).getBody();
			if(null == body) {
				return null;
			}
			return body.getAccounts();
		}
		return null;
		
	}
	
}
