/*
 * File:         StringUtils.java
 * Copyright:    Copyright (c) 2000
 * Company:      Kingdee Software, Ltd.
 */
package com.kingdee.ws.ca.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * õַ
 *
 * @see StreamBuffer
 * @author Taolei, Penglu
 * @version 1.0, 2000/08/15
 */
public class StringUtils
{
	/**
	 * ַָ
	 * @param line      ַ
	 * @param seperator ָ
	 */
	public static String[] split(String line, int seperator)
	{
		if (line == null)
			return null;
		line = line.trim();
		if (line.length() == 0)
			return null;
		java.util.Vector v = new java.util.Vector();
		int i = 0, j;
		while ((j = line.indexOf(seperator, i)) >= 0)
		{
			v.addElement(line.substring(i, j).trim());
			i = j + 1;
		}
		v.addElement(line.substring(i).trim());
		int size = v.size();
		String[] ps = new String[size];
		if (size > 0)
			v.copyInto(ps);
		return ps;
	}

	/**
	 * ַָ
	 * @param line      ַ
	 * @param seperator ַָ
	 */
	public static String[] split(String line, String seperator)
	{
		if (line == null)
			return null;
		line = line.trim();
		if (line.length() == 0)
			return new String[] { "" }; // Modify by Ricky 2003.10.30
		java.util.Vector v = new java.util.Vector();
		int i = 0, j;
		while ((j = line.indexOf(seperator, i)) >= 0)
		{
			v.addElement(line.substring(i, j).trim());
			i = j + seperator.length();
		}
		v.addElement(line.substring(i).trim());
		int size = v.size();
		String[] ps = new String[size];
		if (size > 0)
			v.copyInto(ps);
		return ps;
	}

	/**
	 * ַԹ̶ȸʽʾĳΪ8
	 * @see StringUtils#fixNumber(long,int)
	 */
	public static String fixNumber(long n)
	{
		return fixNumber(n, 8);
	}

	/**
	 * ַԹ̶ȸʽʾ
	 */
	public static String fixNumber(long n, int len)
	{
		char[] b = new char[len];
		for (int i = 0; i < len; i++)
			b[i] = '0';
		return new java.text.DecimalFormat(new String(b)).format(n);
	}

	/**
	 * ַԹ̶ȸʽʾĳΪ4
	 * @see StringUtils#fixNumber(int,int)
	 */
	public static String fixNumber(int n)
	{
		return fixNumber((long) n, 4);
	}

	/**
	 * ַԹ̶ȸʽʾ
	 */
	public static String fixNumber(int n, int len)
	{
		return fixNumber((long) n, len);
	}

	/**
	 * жַǷΪ null Ϊַ
	 */
	public static final boolean isEmpty(String s)
	{
		return (s == null || s.trim().length() == 0);
	}

	/**
	 * жַǷϸȣַΪ null Ϊַ
	 */
	public static boolean equals(String s1, String s2)
	{
		if (isEmpty(s1))
			return isEmpty(s2);
		return s1.equals(s2);

	}

	/**
	 * жַǷȣִСдַΪ null Ϊַ
	 */
	public static boolean equalsIgnoreCase(String s1, String s2)
	{
		if (isEmpty(s1))
			return isEmpty(s2);
		return s1.equalsIgnoreCase(s2);
	}

	public static String numStr4Java(String s, char c, char c1)
	{
		if (s == null)
			return null;
		StringBuffer stringbuffer = new StringBuffer();
		for (int i = 0; i < s.length(); i++)
		{
			char c2 = s.charAt(i);
			if (c2 != c)
				if (c2 == c1)
					stringbuffer.append('.');
				else
					stringbuffer.append(c2);
		}

		return stringbuffer.toString();
	}

	public static String takeCommasFromNumStr(String s)
	{
		if (s == null)
			return null;
		if (s.indexOf(44) == -1)
			return s;
		else
			return numStr4Java(s, ',', '.');
	}

	/**
	 *  String öת String 
	 */
	public static String[] enumeration2StringArray(
		Enumeration enumeration,
		int i)
	{
		int j = 0;
		String as[] = new String[i];
		while (enumeration.hasMoreElements())
			as[j++] = (String) enumeration.nextElement();
		return as;
	}

	/**
	 *  char˫ֽڣת byte 
	 */
	public static byte[] chars2bytes(char ac[])
	{
		byte abyte0[] = new byte[ac.length * 2];
		int i = 0;
		for (int j = 0; j < ac.length; j++)
		{
			char c = ac[j];
			char c1 = ac[j];
			abyte0[i++] = (byte) (c >> 8);
			abyte0[i++] = (byte) c1;
		}

		return abyte0;
	}

	/**
	 *  byte ת char˫ֽڣ
	 */
	public static char[] bytes2chars(byte abyte0[]) throws Exception
	{
		if (abyte0.length % 2 != 0)
			throw new Exception("Cannot convert an odd number of bytes");
		char ac[] = new char[abyte0.length / 2];
		int i = 0;
		for (int j = 0; j < ac.length; j++)
		{
			byte byte0 = abyte0[i++];
			byte byte1 = abyte0[i++];
			ac[j] = (char) (byte0 << 8 & 0xff00 | byte1 & 0xff);
		}

		return ac;
	}

	/**
	 * ַӿոʹ֮Ϊָ
	 * @param int ָ
	 */
	public static String padStringWidth(String s, int i)
	{
		StringBuffer stringbuffer = null;
		if (s != null)
		{
			stringbuffer = new StringBuffer(s);
			stringbuffer.setLength(i);
			int j = s.length();
			for (int l = j; l < i; l++)
				stringbuffer.setCharAt(l, ' ');

		} else
		{
			stringbuffer = new StringBuffer(i);
			stringbuffer.setLength(i);
			for (int k = 0; k < i; k++)
				stringbuffer.setCharAt(k, ' ');

		}
		return stringbuffer.toString();
	}

	/**
	 * @see padStringWidth(String, int)
	 */
	public static String padStringWidth(int i, int j)
	{
		return padStringWidth(String.valueOf(i), j);
	}

	/**
	 * @see padStringWidth(String, int)
	 */
	public static String padStringWidth(float f, int i)
	{
		return padStringWidth(String.valueOf(f), i);
	}

	/**
	 * @see padStringWidth(String, int)
	 */
	public static String padStringWidth(long l, int i)
	{
		return padStringWidth(String.valueOf(l), i);
	}

	/**
	 * @see padStringWidth(String, int)
	 */
	public static String padStringWidth(double d, int i)
	{
		return padStringWidth(String.valueOf(d), i);
	}

	/**
	 * ָ long ֵתΪ16ַʽ
	 */
	public static String toHexString(long x, int chars)
	{
		char[] buf = new char[chars];
		for (int charPos = chars; --charPos >= 0;)
		{
			buf[charPos] = hexDigits[(int) (x & 0x0f)];
			x >>>= 4;
		}
		return new String(buf);
	}

	private static final char[] hexDigits =
		{
			'0',
			'1',
			'2',
			'3',
			'4',
			'5',
			'6',
			'7',
			'8',
			'9',
			'a',
			'b',
			'c',
			'd',
			'e',
			'f' };

	/**
	 * ת GB2312 ַ Unicode 
	 */
	public static String GBToUnicode(String str)
	{
		try
		{
			return new String(str.getBytes("8859_1"), "GB2312");
		} catch (java.io.UnsupportedEncodingException e)
		{
			return null;
		}
	}

	/**
	 * ת Unicode ַ GB2312 
	 */
	public static String unicodeToGB(String str)
	{
		if (str == null || str.length() == 0)
			return str;

		try
		{
			return new String(str.getBytes("GB2312"), "8859_1");
		} catch (UnsupportedEncodingException e)
		{
			return null;
		}
	}

	/**
	 *  obj Ϊ nullؿַ򷵻 obj.toString()
	 */
	public static String cnulls(Object obj)
	{
		return cnulls(obj, "");
	}

	/**
	 *  obj Ϊ null defaultValue򷵻 obj.toString()
	 */
	public static String cnulls(Object obj, String defaultValue)
	{
		if (obj == null)
			return defaultValue;
		else
			return obj.toString();
	}

	/**
	 *  str Ϊ nulldefaultValue򷵻 str
	 */
	public static String cnulls(String str, String defaultValue)
	{
		if (str == null)
			return defaultValue;
		else
			return str;
	}

	/**
	 *  str Ϊ nullؿַ򷵻 str
	 */
	public static String cnulls(String str)
	{
		if (str == null)
			return "";
		else
			return str;
	}

	/**
	 * ʽ cy Ϊ 123,456.00ʽ
	 */
	public static String formatCurrency(double cy)
	{
		return NumberFormat.getCurrencyInstance().format(cy);
	}

	/**
	 * ʽdoubleֵΪ123,456.00
	 * @param int - ָʽСλ
	 */
	public static String formatNumber(double d, int n)
	{
		String pattern = "#,##0";
		if (n > 0)
		{
			pattern += ".";
			for (int i = 0; i < n; i++)
				pattern += "0";
		}
		return new DecimalFormat(pattern).format(d);
	}

	public static int compareToIgnoreCase(String str1, String str2)
	{
		return (str1.toLowerCase().compareTo(str2.toLowerCase()));
	}

	public static boolean endsWithIgnoreCase(String str, String suffix)
	{
		return (str.toLowerCase().endsWith(suffix.toLowerCase()));
	}

	public static int indexOfIgnoreCase(String str, int find)
	{
		return (str.toLowerCase().indexOf(Character.toLowerCase((char) find)));
	}

	public static int indexOfIgnoreCase(String str, int find, int start)
	{
		return (
			str.toLowerCase().indexOf(
				Character.toLowerCase((char) find),
				start));
	}

	public static int indexOfIgnoreCase(String str, String find)
	{
		return (str.toLowerCase().indexOf(find.toLowerCase()));
	}

	public static int indexOfIgnoreCase(String str, String find, int start)
	{
		return (str.toLowerCase().indexOf(find.toLowerCase(), start));
	}

	public static int lastIndexOfIgnoreCase(String str, int find)
	{
		return (
			str.toLowerCase().lastIndexOf(Character.toLowerCase((char) find)));
	}

	public static int lastIndexOfIgnoreCase(String str, int find, int start)
	{
		return (
			str.toLowerCase().lastIndexOf(
				Character.toLowerCase((char) find),
				start));
	}

	public static int lastIndexOfIgnoreCase(String str, String find)
	{
		return (str.toLowerCase().lastIndexOf(find.toLowerCase()));
	}

	public static int lastIndexOfIgnoreCase(String str, String find, int start)
	{
		return (str.toLowerCase().lastIndexOf(find.toLowerCase(), start));
	}

	public static int occurencesOf(String str, char ch)
	{
		char[] s;
		int count;

		s = new char[str.length()];
		str.getChars(0, s.length, s, 0);
		count = 0;

		for (int i = 0; i < s.length; i++)
		{
			if (s[i] == ch)
			{
				count++;
			}
		}

		return (count);
	}

	public static int occurencesOfIgnoreCase(String str, char ch)
	{
		return (occurencesOf(str.toLowerCase(), Character.toLowerCase(ch)));
	}

	/**
	 * @param str
	 * @param oldChars
	 * @param newChars
	 * @return
	 */
	public static final String replace(
		String str,
		String oldChars,
		String newChars)
	{

		int len;
		int pos;
		int lastPos;

		len = newChars.length();
		pos = str.indexOf(oldChars);
		lastPos = pos;

		while (pos > -1)
		{
			String firstPart;
			String lastPart;

			firstPart = str.substring(0, pos);
			lastPart = str.substring(pos + oldChars.length(), str.length());
			str = firstPart + newChars + lastPart;
			lastPos = pos + len;
			pos = str.indexOf(oldChars, lastPos);
		}

		return (str);
	}

	public static String replaceIgnoreCase(
		String str,
		String oldChars,
		String newChars)
	{
		String lowerStr;
		int len;
		int pos;
		int lastPos;

		lowerStr = str.toLowerCase();
		len = newChars.length();
		pos = lowerStr.indexOf(oldChars);
		lastPos = pos;

		while (pos > -1)
		{
			String firstPart;
			String lastPart;

			firstPart = str.substring(0, pos);
			lastPart = str.substring(pos + oldChars.length(), str.length());
			str = firstPart + newChars + lastPart;
			lastPos = pos + len;
			
			// lastPosposnewCharsĳȣˣһӦøΪ
			// л linhh һbug
			// pl 2005-4-4
			//pos = lowerStr.indexOf(oldChars, lastPos);
			
			pos = str.indexOf(oldChars, lastPos);
		}

		return (str);
	}

	public static boolean startsWithIgnoreCase(String str, String prefix)
	{
		return (str.toLowerCase().startsWith(prefix.toLowerCase()));
	}

	public static boolean startsWithIgnoreCase(
		String str,
		String prefix,
		int start)
	{
		return (str.toLowerCase().startsWith(prefix.toLowerCase(), start));
	}

	public static String stackToString(Throwable e)
	{
		try
		{
			StringWriter sw = new StringWriter();
			PrintWriter pw = new PrintWriter(sw);
			e.printStackTrace(pw);
			return "------\r\n" + sw.toString() + "------\r\n";
		} catch (Exception e2)
		{
			return "(bad stack2string) " + e.getMessage();
		}
	}

	public static String stackToString(Exception e)
	{
		try
		{
			StringWriter sw = new StringWriter();
			PrintWriter pw = new PrintWriter(sw);
			e.printStackTrace(pw);
			return "------\r\n" + sw.toString() + "------\r\n";
		} catch (Exception e2)
		{
			return "(bad stack2string) " + e.getMessage();
		}
	}

	/**
	 * Returns a string of hexadecimal digits from a byte array. Each
	 * byte is converted to 2 hex symbols.
	 */
	public static String byteArrayToString(byte[] ba)
	{
		int length = ba.length;
		char[] buf = new char[length * 2];
		for (int i = 0, j = 0, k; i < length;)
		{
			k = ba[i++];
			buf[j++] = HEX_DIGITS[(k >>> 4) & 0x0F];
			buf[j++] = HEX_DIGITS[k & 0x0F];
		}
		return new String(buf);
	}

	private static final char[] HEX_DIGITS =
		{
			'0',
			'1',
			'2',
			'3',
			'4',
			'5',
			'6',
			'7',
			'8',
			'9',
			'A',
			'B',
			'C',
			'D',
			'E',
			'F' };

	public static byte[] hexFromString(String hex)
	{
		int len = hex.length();
		byte[] buf = new byte[((len + 1) / 2)];

		int i = 0, j = 0;
		if ((len % 2) == 1)
			buf[j++] = (byte) fromDigit(hex.charAt(i++));

		while (i < len)
		{
			buf[j++] =
				(byte) ((fromDigit(hex.charAt(i++)) << 4)
					| fromDigit(hex.charAt(i++)));
		}
		return buf;
	}

	/**
	 * Returns the number from 0 to 15 corresponding to the hex digit <i>ch</i>.
	 */
	public static int fromDigit(char ch)
	{
		if (ch >= '0' && ch <= '9')
			return ch - '0';
		if (ch >= 'A' && ch <= 'F')
			return ch - 'A' + 10;
		if (ch >= 'a' && ch <= 'f')
			return ch - 'a' + 10;

		throw new IllegalArgumentException("invalid hex digit '" + ch + "'");
	}

	/**
	 * StringתΪXMLǵString
	 */
	public static String escapeXMLstr(String input)
	{
		if (input == null)
			return null;

		StringBuffer output = new StringBuffer("");
		int len = input.length();
		for (int i = 0; i < len; i++)
		{
			char ch = input.charAt(i);
			if (ch == '&')
				output.append("&amp;");
			else if (ch == '<')
				output.append("&lt;");
			else if (ch == '>')
				output.append("&gt;");
			else if (ch == '\'')
				output.append("&apos;");
			else if (ch == '"')
				output.append("&quot;");
			else
				output.append(ch);
		}

		return output.toString();
	}

	/**
	 * StringתΪHTMLǵString
	 */
	public static String escapeHTMLstr(String input)
	{
		if (input == null)
			return null;

		StringBuffer output = new StringBuffer("");
		int len = input.length();
		for (int i = 0; i < len; i++)
		{
			char ch = input.charAt(i);
			if (ch == '&')
				output.append("&amp;");
			else if (ch == '<')
				output.append("&lt;");
			else if (ch == '>')
				output.append("&gt;");
			else if (ch == '"')
				output.append("&quot;");
			else
				output.append(ch);
		}

		return output.toString();
	}

	public static String headCharUpperCase(String str)
	{
		if (str == null || "".equals(str))
			return str;
		String headChar = str.substring(0, 1).toUpperCase();
		if (str.length() == 1)
			return headChar;
		return headChar + str.substring(1, str.length());
	}

	public static String headCharLowerCase(String str)
	{
		if (str == null || "".equals(str))
			return str;
		String headChar = str.substring(0, 1).toLowerCase();
		if (str.length() == 1)
			return headChar;
		return headChar + str.substring(1, str.length());
	}

	public static String left(String str, int n)
	{
		return str.substring(str.length() - n);
	}

	public static String right(String str, int n)
	{
		return str.substring(str.length() - n, str.length());
	}

	private final static String[] JAVA_KEYWORDS =
		{
			"assert",
			"abstract",
			"continue",
			"for",
			"new",
			"switch",
			"boolean",
			"default",
			"goto",
			"null",
			"synchronized",
			"break",
			"do",
			"if",
			"package",
			"this",
			"byte",
			"double",
			"implements",
			"private",
			"threadsafe",
			"byvalue",
			"else",
			"import",
			"protected",
			"throw",
			"case",
			"extends",
			"instanceof",
			"public",
			"transient",
			"catch",
			"false",
			"int",
			"return",
			"true",
			"char",
			"final",
			"interface",
			"short",
			"try",
			"class",
			"finally",
			"long",
			"static",
			"void",
			"const",
			"float",
			"native",
			"super",
			"while",
			"volatile",
			"strictfp" };

	/**
	 * ǷϷJavaʶ
	 * @param s
	 * @return
	 */
	public static boolean isJavaIdentifier(String s)
	{
		if (StringUtils.isEmpty(s))
			return false;
		else
		{
			char[] chars = s.toCharArray();
			for (int i = 0; i < chars.length; i++)
			{
				if (!Character.isJavaIdentifierPart(chars[i])
					|| (i == 0 && !Character.isJavaIdentifierStart(chars[i])))
				{
					return false;
				}
			}
			if (Arrays.asList(JAVA_KEYWORDS).contains(s))
				return false;
		}
		return true;
	}

	/**
	 * ǷϷJava Class Name 
	 * @param name
	 * @return
	 */
	public static boolean isJavaClassName(String name)
	{
		if (StringUtils.isEmpty(name))
			return true;
		if (name.startsWith(" ")
			|| name.startsWith(".")
			|| name.endsWith(" ")
			|| name.endsWith("."))
		{
			return false;
		} else
		{
			String[] pks = StringUtils.split(name, ".");
			for (int i = 0; i < pks.length; i++)
			{
				if (!StringUtils.isJavaIdentifier(pks[i]))
				{
					return false;
				}
			}
		}
		return true;
	}

	/**
	 * ǷϷKSQLʶһ
	 * @param s
	 * @return
	 */
	public static boolean isKsqlIdentifierPart(String s)
	{
		if (!StringUtils.isEmpty(s))
		{
			char[] chars = s.toCharArray();
			for (int i = 0; i < chars.length; i++)
				if (!Character.isJavaIdentifierPart(chars[i]))
					return false;
		}

		return true;
	}

	/**
	 * ǷϷKSQLʶ
	 * @param s
	 * @return
	 */
	public static boolean isKsqlIdentifier(String s)
	{
		if (StringUtils.isEmpty(s))
			return false;
		else
		{
			char[] chars = s.toCharArray();
			for (int i = 0; i < chars.length; i++)
			{
				if (!Character.isJavaIdentifierPart(chars[i])
					|| (i == 0 && !Character.isJavaIdentifierStart(chars[i]))
					|| (i == 0 && chars[i] == '$'))
				{
					return false;
				}
			}
			// todo			
			//			if (KeyWord.instance().isKeyWord(s))
			//				return false;
		}
		return true;
	}

	/**
	 * ǷϷļ
	 * @param s
	 * @return
	 */
	public static boolean isFileName(String name)
	{
		if (StringUtils.isEmpty(name)
			|| name.indexOf('<') > -1
			|| name.indexOf('*') > -1
			|| name.indexOf('/') > -1
			|| name.indexOf(':') > -1
			|| name.indexOf('?') > -1
			|| name.indexOf('\\') > -1
			|| name.indexOf('\"') > -1)
			return false;

		return true;
	}

	/**
	 * תΪַ
	 * @param objArray 
	 * @param operator ָ
	 * @return ַ
	 */
	public static String arrayToString(Object[] objArray, String operator)
	{

		if (objArray != null && objArray.length > 0)
		{

			StringBuffer sb = new StringBuffer();

			for (int i = 0; i < objArray.length; i++)
			{
				sb.append(objArray[i] + operator);
			}

			if (operator != null && operator.length() > 0)
			{

				if (sb.indexOf(operator) == 0)
				{ //operatorͷ
					sb.delete(0, operator.length());
				} else if (
					sb.lastIndexOf(operator)
						== (sb.length() - operator.length()))
				{
					//operatorβ
					sb.delete(sb.length() - operator.length(), sb.length());
				}
			}

			return sb.toString();
		}

		return null;
	}

	/**
	 * ַ
	 * @param array ԭ
	 * @param appendObj Ӷ
	 * @return Ӻ
	 */
	public static String[] stringArrayAppend(String[] array, String appendObj)
	{

		if (array == null)
		{
			array = new String[0];
		}

		String[] newArray = new String[array.length + 1];

		System.arraycopy(array, 0, newArray, 0, array.length);

		newArray[newArray.length - 1] = appendObj;

		return newArray;
	}

	/**
	 * Trim
	 * @param str
	 * @return
	 */
	public static String trim(String str)
	{
		return str != null ? str.trim() : "";
	}
	
	//add by wanx
	//2004-07-30
	/**
	 * ַָ߼
	 * @param str
	 * @return
	 * String
	 */
	public static String addBracket(String str)
	{
		if (isEmpty(str))
		{
			return str;
		}
		return "(" + str + ")";
	}

	/**
	 * óдʡ
	 * 
	 * @param txt ʹĸдָӢĵʴ飬磺ExpenseReqBill
	 * @param len Ԥڵдʳ
	 * @author pl
	 */
	public static String abbreviate(String txt, int len)
	{
		String result = "";
		
		String[] str = splitByUpperCaseChar(txt);
		if (str.length<len) {
			String abb = metaphone(str[0], len - str.length + 1);
            // metaphone㷨ó0ַĳ
            if (abb.length()==0) {
                abb = str[0].substring(0, len - str.length + 1).toUpperCase();
            } 
            // end pl

            abb = abb.substring(0, 1) + abb.substring(1).toLowerCase();		
			result += abb;
			for (int i=1; i<str.length; i++)
				result += str[i].charAt(0);
		}
		else
		{			
			for (int i=0; i<len; i++)
				result += str[i].charAt(0);
		}
		
		return result;
	}
	
	/**
	 * Five values in the English language 
	 */
	private static String VOWELS = "AEIOU" ;

	/**
	 * Variable used in Metaphone algorithm
	 */
	private static String FRONTV = "EIY"   ;

	/**
	 * Variable used in Metaphone algorithm
	 */
	private static String VARSON = "CSPTG" ;

	/**
	 * ómetaphone롣ʹñmetaphone㷨
	 * 
	 * Limitations: Input format is expected to be a single ASCII word
	 * with only characters in the A - Z, a - z range, no punctuation or numbers.
	 *
	 * @param txt String to find the metaphone code for
	 * @return A metaphone code corresponding to the String supplied
	 */
	private static String metaphone(String txt, int maxCodeLen) {
		if ((txt == null) || (txt.length() == 0)) {
			return "" ;
		}
		
		if (maxCodeLen <= 0)
			return "";
		else if (maxCodeLen > txt.length())
			return txt;
		
		// single character is itself
		if (txt.length() == 1) {
			return txt.toUpperCase() ;
		}
      
		boolean hard = false ;
		char[] inwd = txt.toUpperCase().toCharArray() ;
      
		StringBuffer local = new StringBuffer(); // manipulate
		StringBuffer code = new StringBuffer() ; //   output
		// handle initial 2 characters exceptions
		switch(inwd[0]) {
		case 'K' : 
		case 'G' : 
		case 'P' : /* looking for KN, etc*/
			if (inwd[1] == 'N') {
				local.append(inwd, 1, inwd.length - 1);
			} else {
				local.append(inwd);
			}
			break;
		case 'A': /* looking for AE */
			if (inwd[1] == 'E') {
				local.append(inwd, 1, inwd.length - 1);
			} else {
				local.append(inwd);
			}
			break;
		case 'W' : /* looking for WR or WH */
			if (inwd[1] == 'R') {   // WR -> R
				local.append(inwd, 1, inwd.length - 1); 
				break ;
			}
			if (inwd[1] == 'H') {
				local.append(inwd, 1, inwd.length - 1);
				local.setCharAt(0, 'W'); // WH -> W
			} else {
				local.append(inwd);
			}
			break;
		case 'X' : /* initial X becomes S */
			inwd[0] = 'S';
			local.append(inwd);
			break ;
		default :
			local.append(inwd);
		} // now local has working string with initials fixed

		int wdsz = local.length();
		int n = 0 ;

		while ((code.length() < maxCodeLen) && 
			   (n < wdsz) ) { // max code size of 4 works well
			char symb = local.charAt(n) ;
			// remove duplicate letters except C
			if ((symb != 'C') && (isPreviousChar( local, n, symb )) ) {
				n++ ;
			} else { // not dup
				switch(symb) {
				case 'A' : case 'E' : case 'I' : case 'O' : case 'U' :
					if (n == 0) { 
						code.append(symb);
					}
					break ; // only use vowel if leading char
				case 'B' :
					if ( isPreviousChar(local, n, 'M') && 
						 isLastChar(wdsz, n) ) { // B is silent if word ends in MB
						break;
					}
					code.append(symb);
					break;
				case 'C' : // lots of C special cases
					/* discard if SCI, SCE or SCY */
					if ( isPreviousChar(local, n, 'S') && 
						 !isLastChar(wdsz, n) && 
						 (FRONTV.indexOf(local.charAt(n + 1)) >= 0) ) { 
						break;
					}
					if (regionMatch(local, n, "CIA")) { // "CIA" -> X
						code.append('X'); 
						break;
					}
					if (!isLastChar(wdsz, n) && 
						(FRONTV.indexOf(local.charAt(n + 1)) >= 0)) {
						code.append('S');
						break; // CI,CE,CY -> S
					}
					if (isPreviousChar(local, n, 'S') &&
						isNextChar(local, n, 'H') ) { // SCH->sk
						code.append('K') ; 
						break ;
					}
					if (isNextChar(local, n, 'H')) { // detect CH
						if ((n == 0) && 
							(wdsz >= 3) && 
							isVowel(local,2) ) { // CH consonant -> K consonant
							code.append('K');
						} else { 
							code.append('X'); // CHvowel -> X
						}
					} else { 
						code.append('C');
					}
					break ;
				case 'D' :
					if (!isLastChar(wdsz, n + 1) && 
						isNextChar(local, n, 'G') && 
						(FRONTV.indexOf(local.charAt(n + 2)) >= 0)) { // DGE DGI DGY -> J 
						code.append('J'); n += 2 ;
					} else { 
						code.append('D');
					}
					break ;
				case 'G' : // GH silent at end or before consonant
					if (isLastChar(wdsz, n + 1) && 
						isNextChar(local, n, 'H')) {
						break;
					}
					if (!isLastChar(wdsz, n + 1) &&  
						isNextChar(local,n,'H') && 
						!isVowel(local,n+2)) {
						break;
					}
					if ((n > 0) && 
						( regionMatch(local, n, "GN") ||
						  regionMatch(local, n, "GNED") ) ) {
						break; // silent G
					}
					if (isPreviousChar(local, n, 'G')) {
						hard = true ;
					} else {
						hard = false ;
					}
					if (!isLastChar(wdsz, n) && 
						(FRONTV.indexOf(local.charAt(n + 1)) >= 0) && 
						(!hard)) {
						code.append('J');
					} else {
						code.append('G');
					}
					break ;
				case 'H':
					if (isLastChar(wdsz, n)) {
						break ; // terminal H
					}
					if ((n > 0) && 
						(VARSON.indexOf(local.charAt(n - 1)) >= 0)) {
						break;
					}
					if (isVowel(local,n+1)) {
						code.append('H'); // Hvowel
					}
					break;
				// modify by ljc 2006-04-11 begin 
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				case '8':
				case '9':
				// modify by ljc 2006-04-11 end 					
				case 'F': 
				case 'J' : 
				case 'L' :
				case 'M': 
				case 'N' : 
				case 'R' :
					code.append(symb); 
					break;
				case 'K' :
					if (n > 0) { // not initial
						if (!isPreviousChar(local, n, 'C')) {
							code.append(symb);
						}
					} else {
						code.append(symb); // initial K
					}
					break ;
				case 'P' :
//					if (isNextChar(local,n,'H')) {
//						// PH -> F
//						code.append('F');
//					}
//					else {
//						code.append(symb);
//					}
//					break ;
					code.append(symb);					
					break ;
				case 'Q' :
					code.append('Q');
					break;
				case 'S' :
					if (regionMatch(local,n,"SH") || 
						regionMatch(local,n,"SIO") || 
						regionMatch(local,n,"SIA")) {
						code.append('X');
					} else {
						code.append('S');
					}
					break;
				case 'T' :
					if (regionMatch(local,n,"TIA") || 
						regionMatch(local,n,"TIO")) {
						code.append('X'); 
						break;
					}
					if (regionMatch(local,n,"TCH")) {
						// Silent if in "TCH"
						break;
					}
					// substitute numeral 0 for TH (resembles theta after all)
					if (regionMatch(local,n,"TH")) {
						//code.append('0');
					} else {
						code.append('T');
					}
					break ;
				case 'V' :
					code.append('V'); break ;
				case 'W' : case 'Y' : // silent if not followed by vowel
					if (!isLastChar(wdsz,n) && 
						isVowel(local,n+1)) {
						code.append(symb);
					}
					break ;
				case 'X' :
					//code.append('K'); code.append('S');
					code.append('X');
					break;
				case 'Z' :
					code.append('Z'); break ;
				} // end switch
				n++ ;
			} // end else from symb != 'C'
			if (code.length() > maxCodeLen) { 
				code.setLength(maxCodeLen); 
			}
		}
		return code.toString();
	}

	private static String[] splitByUpperCaseChar(String line)
	{
		if (line == null)
			return null;
		line = line.trim();
		if (line.length() == 0)
			return new String[] { "" };
			
		java.util.Vector v = new java.util.Vector();
		int pos = 0;
		for (int i=0; i<line.length(); i++)
		{
			char ch = line.charAt(i);
			// modify by ljc
			if (ch>='A' && ch<='Z' || ch>='0' && ch<='9')
			{
				String str = line.substring(pos, i).trim();
				if (str.length()>0)  
					v.addElement(str);
				pos = i;
			}
		}
		v.addElement(line.substring(pos).trim());
		
		int size = v.size();
		String[] words = new String[size];
		if (size > 0)
			v.copyInto(words);
		return words;
	}
	
	private static final boolean isVowel(StringBuffer string, int index) {
		return (VOWELS.indexOf(string.charAt(index)) >= 0);
	}

	private static boolean isPreviousChar(StringBuffer string, int index, char c) {
		boolean matches = false;
		if( index > 0 &&
			index < string.length() ) {
			matches = string.charAt(index - 1) == c;
		}
		return matches;
	}

	private static boolean isNextChar(StringBuffer string, int index, char c) {
		boolean matches = false;
		if( index >= 0 &&
			index < string.length() - 1 ) {
			matches = string.charAt(index + 1) == c;
		}
		return matches;
	}

	private static boolean regionMatch(StringBuffer string, int index, String test) {
		boolean matches = false;
		if( index >= 0 &&
			(index + test.length() - 1) < string.length() ) {
			String substring = string.substring( index, index + test.length());
			matches = substring.equals( test );
		}
		return matches;
	}

	private static final boolean isLastChar(int wdsz, int n) {
		return n + 1 == wdsz;
	}
	
	
	private static final int SEPERATOR_DEFAULT_SIZE = 9;  //ָٽֵ, ڴֵķֲɴﵽЧ, ½   
	/**
	 * ٷַָ
	 * added by ivan_zhang  
	 */
	public static String[] fastSplit(String line, int seperator)
	{
		if (line == null || line.length() == 0)
			return null;
		
		line = line.trim();
		
		int iSize = 0;
		int pos[]=new int[SEPERATOR_DEFAULT_SIZE];
		int iTimes = calcSeperatorTimes(line,seperator, pos);
		String arr[] = new String[iTimes+1];

		if (iTimes<=0){
			arr[0] = line;
		}else if (iTimes>SEPERATOR_DEFAULT_SIZE){
			int times = 0;
			int i=0,j;
			while ((j = line.indexOf(seperator, i)) >= 0)
			{
				arr[times]=line.substring(i, j).trim();
				i = j + 1;
				times++;
			}
			arr[times]=line.substring(i).trim();
		}else{
			arr[0] = line.substring(0, pos[0]).trim();
			for (int i=0;i<iTimes-1;i++){
				arr[i+1] = line.substring(pos[i]+1, pos[i+1]).trim();
			}
			arr[iTimes] = line.substring(pos[iTimes-1]+1).trim();
		}
		return arr;
	}
	
	/**
	 * ȡָλ
	 * @param src
	 * @param seperator
	 * @param pos
	 * @return
	 */
	private static int calcSeperatorTimes(String src, int seperator, int[] pos){
		if (src==null || src.equals("")) return 0;
		int times = 0;
		int i=0,j;
		while ((j = src.indexOf(seperator, i)) >= 0)
		{
			if (times<SEPERATOR_DEFAULT_SIZE) pos[times]=j;
			i = j + 1;
			times++;
		}
		return times;
	}

	public static String[] fastSplit(String line, String seperator)
	{
		if (line == null || line.length() == 0)
			return null;
		
		line = line.trim();
		
		int iSize = 0;
		int pos[]=new int[SEPERATOR_DEFAULT_SIZE];
		int iTimes = calcSeperatorTimes(line,seperator, pos);
		String arr[] = new String[iTimes+1];

		if (iTimes<=0){
			arr[0] = line;
		}else if (iTimes>SEPERATOR_DEFAULT_SIZE){
			int times = 0;
			int i=0,j;
			while ((j = line.indexOf(seperator, i)) >= 0)
			{
				arr[times]=line.substring(i, j).trim();
				i = j + 1;
				times++;
			}
			arr[times]=line.substring(i).trim();
		}else{
			arr[0] = line.substring(0, pos[0]).trim();
			for (int i=0;i<iTimes-1;i++){
				arr[i+1] = line.substring(pos[i]+1, pos[i+1]).trim();
			}
			arr[iTimes] = line.substring(pos[iTimes-1]+1).trim();
		}
		return arr;
		
	}
	
	/**
	 * ȡָλ
	 * @param src
	 * @param seperator
	 * @param pos
	 * @return
	 */
	private static int calcSeperatorTimes(String src, String seperator, int[] pos){
		if (src==null || src.equals("")) return 0;
		int times = 0;
		int i=0,j;
		while ((j = src.indexOf(seperator, i)) >= 0)
		{
			if (times<SEPERATOR_DEFAULT_SIZE) pos[times]=j;
			i = j + 1;
			times++;
		}
		return times;
	}
	
	/**
	 * ȡβ,pad.еĳȾΪֽһַΪ2
	 * @param str
	 * @param length ĳ
	 * @param padLeft, true-pad,false-ұpad
	 * @param pad 
	 * @return Ϊlengthַ
	 * @throws UnsupportedEncodingException 
	 */
	public static String formatLen(String str, int length, boolean padLeft, char pad,String charSetName) throws UnsupportedEncodingException{
		String newStr;
		if(str == null){
			str = "";
		}
		byte[] oldBytes = str.getBytes(charSetName);
		int oldLength = oldBytes.length;
		
	    if(oldLength == length){
	    	newStr = str;
	    }else if(oldLength > length){
	    	byte[] bytes = new byte[length];
	    	System.arraycopy(oldBytes, 0, bytes, 0, bytes.length);
	    	newStr = new String(bytes,charSetName);
		}else{
			StringBuffer buffer = new StringBuffer();
			for(int i = 0, size = length - oldLength; i < size; i++){
				buffer.append(pad);
			}
			if(padLeft){
				newStr = new String(buffer.append(str));
			}else{
				newStr = str + new String(buffer);
			}
		}
	    return newStr;
	}
	
	
	/**жһַǷ
	 * @param str
	 * @return
	 */
	public static boolean isNumeric(String str) {
		if(StringUtils.isEmpty(str)){
			return false;
		}
		Pattern pattern = Pattern.compile("[0-9]*");
		Matcher isNum = pattern.matcher(str);
		if (!isNum.matches()) {
			return false;
		}
		return true;
	}
	
	/*----add by blood----*/
	//ƴַ÷ָż
	/*public static String cat(String str1,String str2){
		StringBuffer sb = new StringBuffer();
		if(!isEmpty(str1)){
			sb.append(str1);
		}
		if(!isEmpty(str2)){
			sb.append(" ");
			sb.append(str2);
		}
		return sb.toString();
		
	}*/
	
	public static String catWithSpace(String... ss){
		return cat(" ",ss);
	}
	
	public static String cat(String seperator,String[] ss){
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < ss.length; i++) {
			if(!isEmpty(sb.toString())){
				sb.append(seperator);
			}
			if(!isEmpty(ss[i])){
				sb.append(ss[i]);
			}
		}
		return sb.toString();
		
	}
	
	
	
	public static String[] split2Lines(String str) throws IOException{
		ByteArrayInputStream bais = new ByteArrayInputStream(str.getBytes());
		BufferedReader  br = new BufferedReader(new InputStreamReader(bais));
		String line = null;
		List<String> list = new ArrayList<String>();
		do{
			line = br.readLine();
			if(null != line){
				list.add(line);
			}
		}while(null != line);
		return list.toArray(new String[0]);
	}
	
	public static String stringArrayToString(String[] array){
		return stringArrayToString(array,",");
	}
	public static String stringArrayToString(String[] array,String splitChar){
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < array.length; i++) {
			if(i!=0){
				sb.append(splitChar);
			}
			sb.append(array[i]);
		}
		return sb.toString();
	}

	
	public static String toString(Object obj){
		if(null==obj){
			return "";
		}else{
			return obj.toString();
		}
	}
	
	public static String trim(Object obj){
			return trim(toString(obj));
	}
	
	public static void main(String[] args){
		System.out.println(catWithSpace("|","a","b"));
	}
	
	
	public static Object xml2Obj(String xml){
		return "";
	}
}