/*
 * Decompiled with CFR 0.152.
 */
package elite.ast;

import elite.ast.Expression;
import elite.ast.ExpressionType;
import org.operamasks.el.parser.ELNode;

public class LambdaExpression
extends Expression {
    protected String name;
    protected String[] parameters;
    protected Expression body;

    protected LambdaExpression(String name, String[] parameters, Expression body) {
        super(ExpressionType.LAMBDA);
        this.name = name;
        this.parameters = parameters;
        this.body = body;
    }

    public String getName() {
        return this.name;
    }

    public String[] getParameters() {
        return (String[])this.parameters.clone();
    }

    public Expression getBody() {
        return this.body;
    }

    protected ELNode toInternal() {
        ELNode.DEFINE[] vars = new ELNode.DEFINE[this.parameters.length];
        for (int i = 0; i < vars.length; ++i) {
            vars[i] = new ELNode.DEFINE(0, this.parameters[i], null, null, null, true);
        }
        return new ELNode.LAMBDA(0, null, this.name, null, vars, false, this.body.getNode());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        for (int i = 0; i < this.parameters.length; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(this.parameters[i]);
        }
        buf.append("=>");
        buf.append(this.body);
        buf.append("}");
        return buf.toString();
    }
}

