/*
 * Decompiled with CFR 0.152.
 */
package elite.ast;

import elite.ast.Expression;
import elite.ast.ExpressionType;
import org.operamasks.el.parser.ELNode;

public class MapExpression
extends Expression {
    protected Expression[] keys;
    protected Expression[] values;

    protected MapExpression(Expression[] keys, Expression[] values) {
        super(ExpressionType.MAP);
        this.keys = keys;
        this.values = values;
    }

    public Expression[] getKeys() {
        return (Expression[])this.keys.clone();
    }

    public Expression[] getValues() {
        return (Expression[])this.values.clone();
    }

    protected ELNode toInternal() {
        int i;
        ELNode[] keys_node = new ELNode[this.keys.length];
        ELNode[] values_node = new ELNode[this.values.length];
        for (i = 0; i < keys_node.length; ++i) {
            keys_node[i] = this.keys[i].getNode();
        }
        for (i = 0; i < values_node.length; ++i) {
            values_node[i] = this.values[i].getNode();
        }
        return new ELNode.MAP(0, keys_node, values_node);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        for (int i = 0; i < this.keys.length; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(this.keys[i]);
            buf.append(":");
            buf.append(this.values[i]);
        }
        buf.append("}");
        return buf.toString();
    }
}

