/*
 * Decompiled with CFR 0.152.
 */
package elite.ast;

import elite.ast.Expression;
import elite.ast.ExpressionType;
import org.operamasks.el.parser.ELNode;

public class RangeExpression
extends Expression {
    protected Expression begin;
    protected Expression next;
    protected Expression end;
    protected boolean exclude;

    protected RangeExpression(Expression begin, Expression next, Expression end) {
        this(begin, next, end, false);
    }

    protected RangeExpression(Expression begin, Expression next, Expression end, boolean exclude) {
        super(ExpressionType.RANGE);
        this.begin = begin;
        this.next = next;
        this.end = end;
        this.exclude = exclude;
    }

    public Expression getBegin() {
        return this.begin;
    }

    public Expression getNext() {
        return this.next;
    }

    public Expression getEnd() {
        return this.end;
    }

    protected ELNode toInternal() {
        return new ELNode.RANGE(0, this.begin == null ? null : this.begin.getNode(), this.next == null ? null : this.next.getNode(), this.end == null ? null : this.end.getNode(), this.exclude);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        buf.append(this.begin);
        if (this.next != null) {
            buf.append(",").append(this.next);
        }
        buf.append("..");
        if (this.exclude) {
            buf.append("^");
        }
        buf.append(this.end == null ? "*" : this.end);
        buf.append("]");
        return buf.toString();
    }
}

