/*
 * Decompiled with CFR 0.152.
 */
package elite.lang;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Decimal
extends Number
implements Comparable<Decimal> {
    public static final byte MAX_SCALE = Decimal.initMaxScale();
    public static final Decimal MAX_VALUE = new Decimal(Long.MAX_VALUE, 0);
    public static final Decimal MIN_VALUE = new Decimal(Long.MIN_VALUE, 0);
    public static final Decimal ZERO = new Decimal(0L, 0);
    public static final Decimal ONE = new Decimal(1L, 0);
    private long value;
    private byte scale;
    private transient BigDecimal cachedBigDecimal = null;
    private static final long[] scaleFactor = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};

    public Decimal(BigDecimal big) throws ArithmeticException {
        this(big, true);
    }

    public Decimal(String s) throws NumberFormatException, ArithmeticException {
        this(new BigDecimal(s), true);
    }

    public Decimal(double dbl) throws ArithmeticException {
        this(new BigDecimal(dbl), true);
    }

    public static Decimal valueOf(long val, int scale) throws ArithmeticException {
        if (scale < 0 || scale > 19) {
            throw new ArithmeticException("Invalid scale");
        }
        if (scale > MAX_SCALE) {
            val = Decimal.round(val, (byte)scale, MAX_SCALE);
            scale = MAX_SCALE;
        }
        return new Decimal(val, (byte)scale);
    }

    public static Decimal valueOf(long val) {
        return new Decimal(val, 0);
    }

    public static Decimal valueOf(BigDecimal big) throws ArithmeticException {
        return new Decimal(big);
    }

    public static Decimal valueOf(String s) throws NumberFormatException, ArithmeticException {
        return new Decimal(s);
    }

    public static Decimal valueOf(double dbl) throws ArithmeticException {
        return new Decimal(dbl);
    }

    public Decimal add(Decimal val) throws ArithmeticException {
        return Decimal.internalAdd(this, val, true);
    }

    public Decimal addAndRound(Decimal val, int scale) throws ArithmeticException {
        if (scale < 0) {
            throw new ArithmeticException("Negative scale");
        }
        if (scale > MAX_SCALE) {
            scale = MAX_SCALE;
        }
        Decimal res = Decimal.internalAdd(this, val, false);
        return res.roundInPlace((byte)scale);
    }

    public Decimal addAndRound(Decimal val) throws ArithmeticException {
        return this.addAndRound(val, this.scale);
    }

    public Decimal addAndTruncate(Decimal val, int scale) throws ArithmeticException {
        if (scale < 0) {
            throw new ArithmeticException("Negative scale");
        }
        if (scale > MAX_SCALE) {
            scale = MAX_SCALE;
        }
        Decimal res = Decimal.internalAdd(this, val, false);
        return res.truncateInPlace((byte)scale);
    }

    public Decimal addAndTruncate(Decimal val) throws ArithmeticException {
        return this.addAndTruncate(val, this.scale);
    }

    public Decimal addAndRaise(Decimal val, int scale) throws ArithmeticException {
        if (scale < 0) {
            throw new ArithmeticException("Negative scale");
        }
        if (scale > MAX_SCALE) {
            scale = MAX_SCALE;
        }
        Decimal res = Decimal.internalAdd(this, val, false);
        return res.raiseInPlace((byte)scale);
    }

    public Decimal addAndRaise(Decimal val) throws ArithmeticException {
        return this.addAndRaise(val, this.scale);
    }

    public Decimal subtract(Decimal val) throws ArithmeticException {
        return Decimal.internalSubtract(this, val, true);
    }

    public Decimal subtractAndRound(Decimal val, int scale) throws ArithmeticException {
        if (scale < 0) {
            throw new ArithmeticException("Negative scale");
        }
        if (scale > MAX_SCALE) {
            scale = MAX_SCALE;
        }
        Decimal res = Decimal.internalSubtract(this, val, false);
        return res.roundInPlace((byte)scale);
    }

    public Decimal subtractAndRound(Decimal val) throws ArithmeticException {
        return this.subtractAndRound(val, this.scale);
    }

    public Decimal subtractAndTruncate(Decimal val, int scale) throws ArithmeticException {
        if (scale < 0) {
            throw new ArithmeticException("Negative scale");
        }
        if (scale > MAX_SCALE) {
            scale = MAX_SCALE;
        }
        Decimal res = Decimal.internalSubtract(this, val, false);
        return res.truncateInPlace((byte)scale);
    }

    public Decimal subtractAndTruncate(Decimal val) throws ArithmeticException {
        return this.subtractAndTruncate(val, this.scale);
    }

    public Decimal subtractAndRaise(Decimal val, int scale) throws ArithmeticException {
        if (scale < 0) {
            throw new ArithmeticException("Negative scale");
        }
        if (scale > MAX_SCALE) {
            scale = MAX_SCALE;
        }
        Decimal res = Decimal.internalSubtract(this, val, false);
        return res.raiseInPlace((byte)scale);
    }

    public Decimal subtractAndRaise(Decimal val) throws ArithmeticException {
        return this.subtractAndRaise(val, this.scale);
    }

    public Decimal multiply(Decimal val) throws ArithmeticException {
        return Decimal.internalMultiply(this, val, true);
    }

    public Decimal multiplyAndRound(Decimal val, int scale) throws ArithmeticException {
        if (scale < 0) {
            throw new ArithmeticException("Negative scale");
        }
        if (scale > MAX_SCALE) {
            scale = MAX_SCALE;
        }
        Decimal res = Decimal.internalMultiply(this, val, false);
        return res.roundInPlace((byte)scale);
    }

    public Decimal multiplyAndRound(Decimal val) throws ArithmeticException {
        return this.multiplyAndRound(val, this.scale);
    }

    public Decimal multiplyAndTruncate(Decimal val, int scale) throws ArithmeticException {
        if (scale < 0) {
            throw new ArithmeticException("Negative scale");
        }
        if (scale > MAX_SCALE) {
            scale = MAX_SCALE;
        }
        Decimal res = Decimal.internalMultiply(this, val, false);
        return res.truncateInPlace((byte)scale);
    }

    public Decimal multiplyAndTruncate(Decimal val) throws ArithmeticException {
        return this.multiplyAndTruncate(val, this.scale);
    }

    public Decimal multiplyAndRaise(Decimal val, int scale) throws ArithmeticException {
        if (scale < 0) {
            throw new ArithmeticException("Negative scale");
        }
        if (scale > MAX_SCALE) {
            scale = MAX_SCALE;
        }
        Decimal res = Decimal.internalMultiply(this, val, false);
        return res.raiseInPlace((byte)scale);
    }

    public Decimal multiplyAndRaise(Decimal val) throws ArithmeticException {
        return this.multiplyAndRaise(val, this.scale);
    }

    public Decimal divide(Decimal val) throws ArithmeticException {
        byte maxscale = MAX_SCALE;
        Decimal res = Decimal.internalDivide(this, val, maxscale + 1);
        return res.roundInPlaceWithSoftFail(maxscale);
    }

    public Decimal divideAndRound(Decimal val, int scale) throws ArithmeticException {
        if (scale < 0) {
            throw new ArithmeticException("Negative scale");
        }
        if (scale > MAX_SCALE) {
            scale = MAX_SCALE;
        }
        Decimal res = Decimal.internalDivide(this, val, (byte)(scale + 1));
        return res.roundInPlace((byte)scale);
    }

    public Decimal divideAndRound(Decimal val) throws ArithmeticException {
        return this.divideAndRound(val, this.scale);
    }

    public Decimal divideAndTruncate(Decimal val, int scale) throws ArithmeticException {
        if (scale < 0) {
            throw new ArithmeticException("Negative scale");
        }
        if (scale > MAX_SCALE) {
            scale = MAX_SCALE;
        }
        Decimal res = Decimal.internalDivide(this, val, (byte)scale);
        return res.truncateInPlace((byte)scale);
    }

    public Decimal divideAndTruncate(Decimal val) throws ArithmeticException {
        return this.divideAndTruncate(val, this.scale);
    }

    public Decimal divideAndRaise(Decimal val, int scale) throws ArithmeticException {
        if (scale < 0) {
            throw new ArithmeticException("Negative scale");
        }
        if (scale > MAX_SCALE) {
            scale = MAX_SCALE;
        }
        Decimal res = Decimal.internalDivide(this, val, (byte)(scale + 1));
        return res.raiseInPlace((byte)scale);
    }

    public Decimal divideAndRaise(Decimal val) throws ArithmeticException {
        return this.divideAndRaise(val, this.scale);
    }

    public Decimal[] divideAndRemainder(Decimal val) {
        Decimal[] result;
        result = new Decimal[]{Decimal.valueOf(this.divide(val).longValue()), this.subtract(result[0].multiply(val))};
        return result;
    }

    public Decimal remainder(Decimal val) {
        Decimal i = Decimal.valueOf(this.divide(val).longValue());
        return this.subtract(i.multiply(val));
    }

    public Decimal abs() {
        return this.value < 0L ? this.negate() : this;
    }

    public Decimal negate() {
        return new Decimal(-this.value, this.scale);
    }

    public int signum() {
        return this.value > 0L ? 1 : (this.value < 0L ? -1 : 0);
    }

    public int scale() {
        return this.scale;
    }

    public long unscaledValue() {
        return this.value;
    }

    public Decimal round(int newscale) throws ArithmeticException {
        if (newscale < 0) {
            throw new ArithmeticException("Negative scale");
        }
        newscale = Math.min(newscale, MAX_SCALE);
        return new Decimal(this.value, this.scale).roundInPlace((byte)newscale);
    }

    public Decimal truncate(int newscale) throws ArithmeticException {
        if (newscale < 0) {
            throw new ArithmeticException("Negative scale");
        }
        if (newscale > MAX_SCALE) {
            newscale = MAX_SCALE;
        }
        return new Decimal(this.value, this.scale).truncateInPlace((byte)newscale);
    }

    public Decimal raise(int newscale) throws ArithmeticException {
        if (newscale < 0) {
            throw new ArithmeticException("Negative scale");
        }
        if (newscale > MAX_SCALE) {
            newscale = MAX_SCALE;
        }
        return new Decimal(this.value, this.scale).raiseInPlace((byte)newscale);
    }

    @Override
    public int compareTo(Decimal val) {
        byte as = this.scale;
        byte bs = val.scale;
        long av = this.value;
        long bv = val.value;
        long scaled = 0L;
        boolean overflow = false;
        if (av == bv && (av == 0L || as == bs)) {
            return 0;
        }
        if ((av ^ bv) < 0L) {
            return av >= 0L ? 1 : -1;
        }
        if (as < bs) {
            scaled = av * scaleFactor[bs - as];
            if ((scaled ^ av) < 0L) {
                overflow = true;
            } else {
                av = scaled;
            }
        } else if (as > bs) {
            scaled = bv * scaleFactor[as - bs];
            if ((bv ^ scaled) < 0L) {
                overflow = true;
            } else {
                bv = scaled;
            }
        }
        if (!overflow) {
            return av > bv ? 1 : (av < bv ? -1 : 0);
        }
        BigDecimal aa = this.toBigDecimal();
        BigDecimal bb = val.toBigDecimal();
        return aa.compareTo(bb);
    }

    public boolean greater(Decimal val) {
        return this.compareTo(val) > 0;
    }

    public boolean greaterEqual(Decimal val) {
        return this.compareTo(val) >= 0;
    }

    public boolean greaterThanZero() {
        return this.value > 0L;
    }

    public boolean less(Decimal val) {
        return this.compareTo(val) < 0;
    }

    public boolean lessEqual(Decimal val) {
        return this.compareTo(val) <= 0;
    }

    public boolean lessThanZero() {
        return this.value < 0L;
    }

    public boolean isEqual(Decimal val) {
        return this.compareTo(val) == 0;
    }

    public boolean isZero() {
        return this.value == 0L;
    }

    public boolean isOne() {
        return scaleFactor[this.scale] == this.value;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Decimal)) {
            return false;
        }
        Decimal x = (Decimal)obj;
        return this.value == x.value && this.scale == x.scale;
    }

    public Decimal min(Decimal val) {
        return this.compareTo(val) < 0 ? this : val;
    }

    public Decimal max(Decimal val) {
        return this.compareTo(val) > 0 ? this : val;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public String format() {
        return this.format(Locale.getDefault());
    }

    public String format(Locale locale) {
        return this.format(NumberFormat.getInstance(locale));
    }

    public String format(NumberFormat nf) {
        long factor = scaleFactor[this.scale];
        long lhs = this.value / factor;
        long rhs = this.value - lhs * factor;
        if (rhs < 0L) {
            rhs = -rhs;
        }
        nf.setMaximumFractionDigits(0);
        nf.setMinimumFractionDigits(0);
        StringBuffer lhsStr = new StringBuffer();
        FieldPosition lhsPos = new FieldPosition(0);
        lhsStr = nf.format(lhs, lhsStr, lhsPos);
        if (this.scale != 0) {
            double rhsd = (double)rhs / (double)factor;
            nf.setMaximumFractionDigits(this.scale);
            nf.setMinimumFractionDigits(this.scale);
            StringBuffer rhsStr = new StringBuffer();
            FieldPosition rhsPos = new FieldPosition(1);
            rhsStr = nf.format(rhsd, rhsStr, rhsPos);
            lhsStr.insert(lhsPos.getEndIndex(), rhsStr.toString().substring(rhsPos.getBeginIndex() - 1, rhsPos.getEndIndex()));
        }
        return lhsStr.toString();
    }

    public String toString() {
        long factor = scaleFactor[this.scale];
        long lhs = this.value / factor;
        long rhs = this.value - lhs * factor;
        StringBuffer lhsStr = new StringBuffer();
        if (lhs == 0L && rhs < 0L) {
            lhsStr.append("-0");
        } else {
            lhsStr.append(lhs);
        }
        if (this.scale != 0) {
            StringBuffer rhsStr = new StringBuffer();
            if (lhs <= 0L && rhs < 0L) {
                rhs = -rhs;
            }
            rhsStr.append(rhs);
            int diff = this.scale - rhsStr.length();
            while (--diff >= 0) {
                rhsStr.insert(0, "0");
            }
            lhsStr.append(".").append(rhsStr);
        }
        return lhsStr.toString();
    }

    public BigDecimal toBigDecimal() {
        if (this.cachedBigDecimal == null) {
            this.cachedBigDecimal = BigDecimal.valueOf(this.value, this.scale);
        }
        return this.cachedBigDecimal;
    }

    @Override
    public int intValue() {
        return (int)(this.value / scaleFactor[this.scale]);
    }

    @Override
    public long longValue() {
        return this.value / scaleFactor[this.scale];
    }

    @Override
    public float floatValue() {
        return (float)this.value / (float)scaleFactor[this.scale];
    }

    @Override
    public double doubleValue() {
        return (double)this.value / (double)scaleFactor[this.scale];
    }

    private Decimal(long value, byte scale) {
        this.value = value;
        this.scale = scale;
    }

    private Decimal(BigDecimal big, boolean checkScale) throws ArithmeticException {
        if (big.signum() == 0) {
            this.value = 0L;
            this.scale = 0;
            return;
        }
        BigInteger bigInt = big.toBigInteger();
        if (bigInt.bitLength() >= 64) {
            throw new ArithmeticException("Overflow");
        }
        long val = bigInt.longValue();
        int scale = big.scale();
        byte digits = Decimal.totalDigits(val);
        int numToMoveRight = 19 - digits;
        if (numToMoveRight > scale) {
            numToMoveRight = scale;
        }
        big = big.movePointRight(numToMoveRight);
        val = big.longValue();
        scale = numToMoveRight;
        if (val < 0L && big.signum() > 0 || val > 0L && big.signum() < 0) {
            val = big.movePointLeft(1).longValue();
            --scale;
        }
        if (checkScale && scale > MAX_SCALE) {
            val = Decimal.round(val, (byte)scale, MAX_SCALE);
            scale = MAX_SCALE;
        }
        this.value = val;
        this.scale = (byte)scale;
    }

    private static Decimal internalAdd(Decimal a, Decimal b, boolean checkScale) throws ArithmeticException {
        byte as = a.scale;
        byte bs = b.scale;
        long av = a.value;
        long bv = b.value;
        long scaled = 0L;
        long sum = 0L;
        boolean overflow = false;
        if (as < bs) {
            scaled = av * scaleFactor[bs - as];
            if ((av ^ scaled) < 0L) {
                overflow = true;
            } else {
                av = scaled;
                as = bs;
            }
        } else if (as > bs) {
            scaled = bv * scaleFactor[as - bs];
            if ((bv ^ scaled) < 0L) {
                overflow = true;
            } else {
                bv = scaled;
            }
        }
        if (!overflow) {
            sum = av + bv;
            if ((av ^ bv) < 0L || (av ^ sum) >= 0L) {
                if (checkScale && as > MAX_SCALE) {
                    sum = Decimal.round(sum, as, MAX_SCALE);
                    as = MAX_SCALE;
                }
                return new Decimal(sum, as);
            }
        }
        BigDecimal aa = a.toBigDecimal();
        BigDecimal bb = b.toBigDecimal();
        return new Decimal(aa.add(bb), checkScale);
    }

    private static Decimal internalSubtract(Decimal a, Decimal b, boolean checkScale) throws ArithmeticException {
        byte as = a.scale;
        byte bs = b.scale;
        long av = a.value;
        long bv = b.value;
        long scaled = 0L;
        long diff = 0L;
        boolean overflow = false;
        if (as < bs) {
            scaled = av * scaleFactor[bs - as];
            if ((av ^ scaled) < 0L) {
                overflow = true;
            } else {
                av = scaled;
                as = bs;
            }
        } else if (as > bs) {
            scaled = bv * scaleFactor[as - bs];
            if ((bv ^ scaled) < 0L) {
                overflow = true;
            } else {
                bv = scaled;
            }
        }
        if (!overflow) {
            diff = av - bv;
            if ((av ^ bv) >= 0L || (av ^ diff) >= 0L) {
                if (checkScale && as > MAX_SCALE) {
                    diff = Decimal.round(diff, as, MAX_SCALE);
                    as = MAX_SCALE;
                }
                return new Decimal(diff, as);
            }
        }
        BigDecimal aa = a.toBigDecimal();
        BigDecimal bb = b.toBigDecimal();
        return new Decimal(aa.subtract(bb), checkScale);
    }

    private static Decimal internalMultiply(Decimal a, Decimal b, boolean checkScale) throws ArithmeticException {
        if (a.isZero() || b.isZero()) {
            return Decimal.valueOf(0L);
        }
        byte as = a.scale;
        byte bs = b.scale;
        long av = a.value;
        long bv = b.value;
        boolean done = false;
        while (!done && av != 0L && as > 0) {
            if (av % 10L == 0L) {
                av /= 10L;
                as = (byte)(as - 1);
                continue;
            }
            done = true;
        }
        done = false;
        while (!done && bv != 0L && bs > 0) {
            if (bv % 10L == 0L) {
                bv /= 10L;
                bs = (byte)(bs - 1);
                continue;
            }
            done = true;
        }
        if (Decimal.bitLength(av) + Decimal.bitLength(bv) > 63) {
            BigDecimal aa = a.toBigDecimal();
            BigDecimal bb = b.toBigDecimal();
            return new Decimal(aa.multiply(bb), checkScale);
        }
        long res = av * bv;
        byte newscale = (byte)(as + bs);
        if (checkScale && newscale > MAX_SCALE) {
            res = Decimal.round(res, newscale, MAX_SCALE);
            newscale = MAX_SCALE;
        }
        return new Decimal(res, newscale);
    }

    private static Decimal internalDivide(Decimal a, Decimal b, int desiredScale) throws ArithmeticException {
        if (b.isZero()) {
            throw new ArithmeticException("Divide by zero");
        }
        if (a.isZero()) {
            return Decimal.valueOf(0L);
        }
        byte as = a.scale;
        byte bs = b.scale;
        long av = a.value;
        long bv = b.value;
        boolean done = false;
        while (!done && av != 0L && as > 0) {
            if (av % 10L == 0L) {
                av /= 10L;
                as = (byte)(as - 1);
                continue;
            }
            done = true;
        }
        done = false;
        while (!done && bv != 0L && bs > 0) {
            if (bv % 10L == 0L) {
                bv /= 10L;
                bs = (byte)(bs - 1);
                continue;
            }
            done = true;
        }
        if (!Decimal.divResultOverflow(av, as, bv, bs)) {
            Decimal result = null;
            result = Decimal.divideByPowerOfTen(av, as, bv, bs);
            if (result != null) {
                return result;
            }
            result = Decimal.divideByLong(av, as, bv, bs, desiredScale);
            if (result != null) {
                return result;
            }
        }
        BigDecimal aa = a.toBigDecimal();
        BigDecimal bb = b.toBigDecimal();
        BigDecimal cc = aa.divide(bb, desiredScale, 1);
        return new Decimal(cc);
    }

    private static boolean divResultOverflow(long av, byte as, long bv, byte bs) {
        byte avDigits = Decimal.totalDigits(av);
        byte bvDigits = Decimal.totalDigits(bv);
        return bs > as ? (avDigits = (byte)(avDigits + (bs - as))) > 18 : as > bs && (bvDigits = (byte)(bvDigits + (as - bs))) > 18;
    }

    private static Decimal divideByPowerOfTen(long av, byte as, long bv, byte bs) {
        int i = -1;
        for (i = 0; i < 19 && scaleFactor[i] != bv; i = (int)((byte)(i + 1))) {
            if (scaleFactor[i] <= bv) continue;
            return null;
        }
        if (i == 19) {
            return null;
        }
        byte diff = (byte)(i - bs);
        byte newas = (byte)(diff + as);
        if (newas >= 0) {
            return new Decimal(av, newas);
        }
        byte realas = (byte)Math.abs(newas);
        return new Decimal(av * scaleFactor[realas], 0);
    }

    private static Decimal divideByLong(long av, byte as, long bv, byte bs, int desiredScale) {
        byte multfactor = (byte)desiredScale;
        if (bs > as) {
            av *= scaleFactor[bs - as];
            as = bs;
        } else if (as > bs) {
            byte diff = (byte)(as - bs);
            if (multfactor - diff >= 0) {
                multfactor = (byte)(multfactor - diff);
            } else {
                byte newdiff = (byte)(diff - multfactor);
                multfactor = 0;
                bv *= scaleFactor[newdiff];
                bs = (byte)(bs + newdiff);
            }
        }
        byte digitsConsumedByA = (byte)(Decimal.totalDigits(av) + multfactor);
        if (digitsConsumedByA > 18) {
            boolean done = false;
            while (!done && av != 0L && bv != 0L) {
                if (av % 10L == 0L && bv % 10L == 0L) {
                    av /= 10L;
                    bv /= 10L;
                    as = (byte)(as - 1);
                    bs = (byte)(bs - 1);
                    continue;
                }
                done = true;
            }
            while (multfactor > 0 && bv != 0L && bv % 10L == 0L) {
                bv /= 10L;
                bs = (byte)(bs - 1);
                multfactor = (byte)(multfactor - 1);
            }
            digitsConsumedByA = (byte)(Decimal.totalDigits(av) + multfactor);
            if (digitsConsumedByA > 18) {
                return null;
            }
        }
        return new Decimal((av *= scaleFactor[multfactor]) / bv, (byte)desiredScale);
    }

    private static byte totalDigits(long value) {
        int count = 0;
        for (value = Math.abs(value); value > 0L; value /= 10L) {
            ++count;
        }
        return (byte)count;
    }

    private static int bitLength(long value) {
        int length = 0;
        for (value = Math.abs(value); value != 0L; value >>>= 1) {
            ++length;
        }
        return length;
    }

    private static long truncate(long v, byte cs, byte ds) throws ArithmeticException {
        if (cs == ds) {
            return v;
        }
        long resultv = ds < cs ? v / scaleFactor[cs - ds] : v * scaleFactor[ds - cs];
        if ((v ^ resultv) < 0L) {
            throw new ArithmeticException("Overflow");
        }
        return resultv;
    }

    private Decimal truncateInPlace(byte ds) throws ArithmeticException {
        this.value = Decimal.truncate(this.value, this.scale, ds);
        this.scale = ds;
        return this;
    }

    private static long round(long v, byte cs, byte ds) throws ArithmeticException {
        long resultv;
        if (cs == ds) {
            return v;
        }
        if (ds < cs) {
            byte diff = (byte)(cs - ds);
            long vtemp = v / scaleFactor[diff - 1];
            int mod10 = (int)Math.abs(vtemp % 10L);
            resultv = mod10 < 5 ? v / scaleFactor[diff] : (vtemp >= 0L ? v / scaleFactor[diff] + 1L : v / scaleFactor[diff] - 1L);
        } else {
            resultv = v * scaleFactor[ds - cs];
            if ((v ^ resultv) < 0L) {
                throw new ArithmeticException("Overflow");
            }
        }
        return resultv;
    }

    private Decimal roundInPlace(byte ds) throws ArithmeticException {
        this.value = Decimal.round(this.value, this.scale, ds);
        this.scale = ds;
        return this;
    }

    private Decimal roundInPlaceWithSoftFail(byte ds) throws ArithmeticException {
        byte cs = this.scale;
        if (cs == ds) {
            return this;
        }
        long v = this.value;
        long resultv = 0L;
        if (ds < cs) {
            byte diff = (byte)(cs - ds);
            long vtemp = v / scaleFactor[diff - 1];
            int mod10 = (int)Math.abs(vtemp % 10L);
            resultv = mod10 < 5 ? v / scaleFactor[diff] : (vtemp >= 0L ? v / scaleFactor[diff] + 1L : v / scaleFactor[diff] - 1L);
            this.value = resultv;
            this.scale = ds;
        } else {
            byte numDigitsShouldAdd;
            byte numDigitsCur = Decimal.totalDigits(v);
            if (numDigitsCur + (numDigitsShouldAdd = (byte)(ds - cs)) > 19) {
                numDigitsShouldAdd = (byte)(19 - numDigitsCur);
            }
            if (((resultv = v * scaleFactor[numDigitsShouldAdd]) ^ v) < 0L) {
                numDigitsShouldAdd = (byte)(numDigitsShouldAdd - 1);
                resultv = v * scaleFactor[numDigitsShouldAdd];
            }
            this.value = resultv;
            this.scale = (byte)(cs + numDigitsShouldAdd);
        }
        return this;
    }

    private static long raise(long v, byte cs, byte ds) throws ArithmeticException {
        long resultv;
        if (cs == ds) {
            return v;
        }
        if (ds < cs) {
            byte diff = (byte)(cs - ds);
            long factor = scaleFactor[diff];
            long vtemp = v / factor;
            long remain = Math.abs(v - vtemp * factor);
            resultv = remain <= 0L ? vtemp : (vtemp >= 0L ? vtemp + 1L : vtemp - 1L);
        } else {
            resultv = v * scaleFactor[ds - cs];
            if ((resultv ^ v) < 0L) {
                throw new ArithmeticException("Overflow");
            }
        }
        return resultv;
    }

    private Decimal raiseInPlace(byte ds) throws ArithmeticException {
        this.value = Decimal.raise(this.value, this.scale, ds);
        this.scale = ds;
        return this;
    }

    static final byte initMaxScale() {
        int s = Integer.getInteger("decimal.max.scale", 8);
        if (s < 0 || s > 18) {
            s = 8;
        }
        return (byte)s;
    }
}

