/*
 * Decompiled with CFR 0.152.
 */
package elite.lang;

import elite.lang.Builtin;
import elite.lang.Decimal;
import elite.lang.Rational;
import elite.lang.annotation.Expando;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import javax.el.ELContext;
import javax.measure.Measure;
import javax.measure.MeasureFormat;
import javax.measure.converter.AddConverter;
import javax.measure.converter.RationalConverter;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Quantity;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;
import org.operamasks.el.eval.ELEngine;
import org.operamasks.util.SimpleCache;

public final class Measures {
    private static SimpleCache<String, Unit> cache = new SimpleCache(200);

    private Measures() {
    }

    @Expando(name="+")
    public static Unit __unit__plus__(Unit unit, Unit that) {
        return unit.compound(that);
    }

    @Expando(name="+")
    public static Unit __unit__plus__(Unit unit, Number offset) {
        return unit.plus(offset.doubleValue());
    }

    @Expando(name="*")
    public static Unit __unit_times__(Unit unit, Unit that) {
        return unit.times(that);
    }

    @Expando(name="*")
    public static Unit __unit_times__(Unit unit, double factor) {
        return unit.times(factor);
    }

    @Expando(name="*")
    public static Unit __unit_times__(Unit unit, long factor) {
        return unit.times(factor);
    }

    @Expando(name="*")
    public static Unit __unit_times__(Unit unit, Rational r) {
        long dividend = r.getNumerator().longValue();
        long divisor = r.getDenominator().longValue();
        return unit.transform((UnitConverter)new RationalConverter(dividend, divisor));
    }

    @Expando(name="/")
    public static Unit __unit_divide__(Unit unit, Unit that) {
        return unit.divide(that);
    }

    @Expando(name="/")
    public static Unit __unit_divide__(Unit unit, double divisor) {
        return unit.divide(divisor);
    }

    @Expando(name="/")
    public static Unit __unit_divide__(Unit unit, long divisor) {
        return unit.divide(divisor);
    }

    @Expando(name="/")
    public static Unit __unit_divide__(Unit unit, Rational r) {
        long dividend = r.getDenominator().longValue();
        long divisor = r.getNumerator().longValue();
        return unit.transform((UnitConverter)new RationalConverter(dividend, divisor));
    }

    @Expando(name="^")
    public static Unit __unit_pow__(Unit unit, Number n) {
        if (n instanceof Rational) {
            int numer = ((Rational)n).getNumerator().intValue();
            int denom = ((Rational)n).getDenominator().intValue();
            if (numer == 0) {
                return Unit.ONE;
            }
            if (numer == denom) {
                return unit;
            }
            if (denom == 1) {
                return unit.pow(numer);
            }
            if (numer == 1) {
                return unit.root(denom);
            }
            return unit.pow(numer).root(denom);
        }
        return unit.pow(n.intValue());
    }

    @Expando(name="+")
    public static Measure __measure_plus__(ELContext elctx, Measure self, Measure that) {
        Object value = self.getValue();
        Unit unit = self.getUnit();
        if (unit.equals((Object)that.getUnit())) {
            return Measures.getMeasure(Builtin.__add__(elctx, value, that.getValue()), unit);
        }
        return Measures.getMeasure(Builtin.__add__(elctx, value, that.to(unit).getValue()), unit);
    }

    @Expando(name="+")
    public static Measure __measure_plus__(ELContext elctx, Measure self, Object that) {
        return Measures.getMeasure(Builtin.__add__(elctx, self.getValue(), that), self.getUnit());
    }

    @Expando(name="-")
    public static Measure __measure_minus__(ELContext elctx, Measure self, Measure that) {
        Object value = self.getValue();
        Unit unit = self.getUnit();
        if (unit.equals((Object)that.getUnit())) {
            return Measures.getMeasure(Builtin.__sub__(elctx, value, that.getValue()), unit);
        }
        return Measures.getMeasure(Builtin.__sub__(elctx, value, that.to(unit).getValue()), unit);
    }

    @Expando(name="-")
    public static Measure __measure_minus__(ELContext elctx, Measure self, Object that) {
        return Measures.getMeasure(Builtin.__sub__(elctx, self.getValue(), that), self.getUnit());
    }

    @Expando(name="*")
    public static Measure __measure_times__(ELContext elctx, Measure self, Measure that) {
        return Measures.getMeasure(Builtin.__mul__(elctx, self.getValue(), that.getValue()), self.getUnit().times(that.getUnit()));
    }

    @Expando(name="*")
    public static Measure __measure_times__(ELContext elctx, Measure self, Object that) {
        return Measures.getMeasure(Builtin.__mul__(elctx, self.getValue(), that), self.getUnit());
    }

    @Expando(name="/")
    public static Measure __measure_divide__(ELContext elctx, Measure self, Measure that) {
        return Measures.getMeasure(Builtin.__div__(elctx, self.getValue(), that.getValue()), self.getUnit().divide(that.getUnit()));
    }

    @Expando(name="/")
    public static Measure __measure_divide__(ELContext elctx, Measure self, Object that) {
        return Measures.getMeasure(Builtin.__div__(elctx, self.getValue(), that), self.getUnit());
    }

    @Expando(name="^")
    public static Measure __measure_pow__(ELContext elctx, Measure self, Number n) {
        Object value = Builtin.__pow__(elctx, self.getValue(), n);
        Unit unit = Measures.__unit_pow__(self.getUnit(), n);
        return Measures.getMeasure(value, unit);
    }

    @Expando(name="__call__")
    public static Object __measure_convert__(Unit unit, Measure measure) {
        return measure.to(unit);
    }

    @Expando(name="__call__")
    public static Object __measure_convert__(Unit unit, Unit that) {
        return that.getConverterTo(unit);
    }

    @Expando(name="__call__")
    public static Object __unit_convert__(UnitConverter cvt, Number value) {
        return cvt.convert(value.doubleValue());
    }

    @Expando
    public static String format(Measure value) {
        return MeasureFormat.getInstance().format((Object)value);
    }

    @Expando
    public static String format(ELContext elctx, Measure value, String pattern) {
        Locale locale = Builtin.getLocale(elctx);
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
        DecimalFormat numberFormat = new DecimalFormat(pattern, symbols);
        UnitFormat unitFormat = UnitFormat.getInstance((Locale)locale);
        return MeasureFormat.getInstance((NumberFormat)numberFormat, (UnitFormat)unitFormat).format((Object)value);
    }

    @Expando
    public static void label(ELContext elctx, Unit unit, String name) {
        UnitFormat.getInstance((Locale)Builtin.getLocale(elctx)).label(unit, name);
    }

    @Expando
    public static void alias(ELContext elctx, Unit unit, String name) {
        UnitFormat.getInstance((Locale)Builtin.getLocale(elctx)).alias(unit, name);
    }

    public static Unit getUnit(ELContext elctx, String symbol) {
        Unit unit = cache.get(symbol);
        if (unit != null) {
            return unit;
        }
        try {
            unit = UnitFormat.getInstance((Locale)Builtin.getLocale(elctx)).parseProductUnit((CharSequence)symbol, new ParsePosition(0));
        }
        catch (ParseException ex) {
            return null;
        }
        cache.put(symbol, unit);
        return unit;
    }

    public static Measure getMeasure(Object v, Unit u) {
        if (v instanceof Number) {
            if (v instanceof BigDecimal) {
                return javax.measure.DecimalMeasure.valueOf((BigDecimal)((BigDecimal)v), (Unit)u);
            }
            if (v instanceof BigInteger) {
                return javax.measure.DecimalMeasure.valueOf((BigDecimal)new BigDecimal((BigInteger)v), (Unit)u);
            }
            if (v instanceof Decimal) {
                return new DecimalMeasure((Decimal)v, u);
            }
            if (v instanceof Rational) {
                return new RationalMeasure((Rational)v, u);
            }
            if (v instanceof Double || v instanceof Float || v instanceof Long || v instanceof Integer || v instanceof Short || v instanceof Byte) {
                return Measure.valueOf((double)((Number)v).doubleValue(), (Unit)u);
            }
            return new NumberMeasure((Number)v, u);
        }
        return new ObjectMeasure(v, u);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjectMeasure<Q extends Quantity>
    extends Measure<Object, Q> {
        private final Object value;
        private final Unit<Q> unit;

        public ObjectMeasure(Object value, Unit<Q> unit) {
            this.value = value;
            this.unit = unit;
        }

        public Object getValue() {
            return this.value;
        }

        public Unit<Q> getUnit() {
            return this.unit;
        }

        public Measure<Object, Q> to(Unit<Q> unit) {
            if (unit == this.unit || unit.equals(this.unit)) {
                return this;
            }
            ELContext elctx = ELEngine.getCurrentELContext();
            UnitConverter cvtr = this.unit.getConverterTo(unit);
            if (cvtr instanceof RationalConverter) {
                RationalConverter factor = (RationalConverter)cvtr;
                long dividend = factor.getDividend();
                long divisor = factor.getDivisor();
                Object result = Builtin.__div__(elctx, Builtin.__mul__(elctx, this.value, dividend), divisor);
                return new ObjectMeasure<Q>(result, unit);
            }
            if (cvtr.isLinear()) {
                double factor = cvtr.convert(1.0);
                Object result = Builtin.__mul__(elctx, this.value, factor);
                return new ObjectMeasure<Q>(result, unit);
            }
            if (cvtr instanceof AddConverter) {
                double offset = ((AddConverter)cvtr).getOffset();
                Object result = Builtin.__add__(elctx, this.value, offset);
                return new ObjectMeasure<Q>(result, unit);
            }
            throw new UnsupportedOperationException();
        }

        public double doubleValue(Unit<Q> unit) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NumberMeasure<Q extends Quantity>
    extends Measure<Number, Q> {
        private final Number value;
        private final Unit<Q> unit;

        public NumberMeasure(Number value, Unit<Q> unit) {
            this.value = value;
            this.unit = unit;
        }

        public Number getValue() {
            return this.value;
        }

        public Unit<Q> getUnit() {
            return this.unit;
        }

        public Measure<Number, Q> to(Unit<Q> unit) {
            if (unit == this.unit || unit.equals(this.unit)) {
                return this;
            }
            ELContext elctx = ELEngine.getCurrentELContext();
            UnitConverter cvtr = this.unit.getConverterTo(unit);
            if (cvtr instanceof RationalConverter) {
                RationalConverter factor = (RationalConverter)cvtr;
                long dividend = factor.getDividend();
                long divisor = factor.getDivisor();
                Object result = Builtin.__div__(elctx, Builtin.__mul__(elctx, this.value, dividend), divisor);
                return new NumberMeasure<Q>((Number)result, unit);
            }
            if (cvtr.isLinear()) {
                double factor = cvtr.convert(1.0);
                Object result = Builtin.__mul__(elctx, this.value, factor);
                return new NumberMeasure<Q>((Number)result, unit);
            }
            if (cvtr instanceof AddConverter) {
                double offset = ((AddConverter)cvtr).getOffset();
                Object result = Builtin.__add__(elctx, this.value, offset);
                return new NumberMeasure<Q>((Number)result, unit);
            }
            return new NumberMeasure<Q>(cvtr.convert(this.value.doubleValue()), unit);
        }

        public double doubleValue(Unit<Q> unit) {
            if (unit == this.unit || unit.equals(this.unit)) {
                return this.value.doubleValue();
            }
            return this.unit.getConverterTo(unit).convert(this.value.doubleValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RationalMeasure<Q extends Quantity>
    extends Measure<Rational, Q> {
        private final Rational value;
        private final Unit<Q> unit;

        public RationalMeasure(Rational value, Unit<Q> unit) {
            this.value = value;
            this.unit = unit;
        }

        public Rational getValue() {
            return this.value;
        }

        public Unit<Q> getUnit() {
            return this.unit;
        }

        public Measure<Rational, Q> to(Unit<Q> unit) {
            if (unit == this.unit || unit.equals(this.unit)) {
                return this;
            }
            UnitConverter cvtr = this.unit.getConverterTo(unit);
            if (cvtr instanceof RationalConverter) {
                RationalConverter factor = (RationalConverter)cvtr;
                long dividend = factor.getDividend();
                long divisor = factor.getDivisor();
                Rational result = this.value.multiply(Rational.make(dividend, divisor));
                return new RationalMeasure<Q>(result, unit);
            }
            if (cvtr.isLinear()) {
                Rational factor = Rational.valueOf((Number)cvtr.convert(1.0));
                Rational result = this.value.multiply(factor);
                return new RationalMeasure<Q>(result, unit);
            }
            if (cvtr instanceof AddConverter) {
                Rational offset = Rational.valueOf((Number)((AddConverter)cvtr).getOffset());
                Rational result = this.value.add(offset);
                return new RationalMeasure<Q>(result, unit);
            }
            Rational result = Rational.valueOf((Number)cvtr.convert(this.value.doubleValue()));
            return new RationalMeasure<Q>(result, unit);
        }

        public double doubleValue(Unit<Q> unit) {
            if (unit == this.unit || unit.equals(this.unit)) {
                return this.value.doubleValue();
            }
            return this.unit.getConverterTo(unit).convert(this.value.doubleValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DecimalMeasure<Q extends Quantity>
    extends Measure<Decimal, Q> {
        private final Decimal value;
        private final Unit<Q> unit;

        public DecimalMeasure(Decimal value, Unit<Q> unit) {
            this.value = value;
            this.unit = unit;
        }

        public Decimal getValue() {
            return this.value;
        }

        public Unit<Q> getUnit() {
            return this.unit;
        }

        public Measure<Decimal, Q> to(Unit<Q> unit) {
            if (unit == this.unit || unit.equals(this.unit)) {
                return this;
            }
            UnitConverter cvtr = this.unit.getConverterTo(unit);
            if (cvtr instanceof RationalConverter) {
                RationalConverter factor = (RationalConverter)cvtr;
                Decimal dividend = Decimal.valueOf(factor.getDividend());
                Decimal divisor = Decimal.valueOf(factor.getDivisor());
                Decimal result = this.value.multiply(dividend).divide(divisor);
                return new DecimalMeasure<Q>(result, unit);
            }
            if (cvtr.isLinear()) {
                Decimal factor = Decimal.valueOf(cvtr.convert(1.0));
                Decimal result = this.value.multiply(factor);
                return new DecimalMeasure<Q>(result, unit);
            }
            if (cvtr instanceof AddConverter) {
                Decimal offset = Decimal.valueOf(((AddConverter)cvtr).getOffset());
                Decimal result = this.value.add(offset);
                return new DecimalMeasure<Q>(result, unit);
            }
            Decimal result = Decimal.valueOf(cvtr.convert(this.value.doubleValue()));
            return new DecimalMeasure<Q>(result, unit);
        }

        public double doubleValue(Unit<Q> unit) {
            if (unit == this.unit || unit.equals(this.unit)) {
                return this.value.doubleValue();
            }
            return this.unit.getConverterTo(unit).convert(this.value.doubleValue());
        }
    }
}

