/*
 * Decompiled with CFR 0.152.
 */
package elite.lang;

import elite.lang.TimeSpan;
import elite.lang.Timestamp;
import java.io.Serializable;

public class TimePeriod
implements Serializable {
    private Timestamp startTime;
    private Timestamp endTime;
    private static final long serialVersionUID = 1581418757449722066L;

    public TimePeriod(Timestamp startTime, Timestamp endTime) {
        if (startTime == null || endTime == null) {
            throw new NullPointerException();
        }
        if (!endTime.after(startTime)) {
            throw new IllegalArgumentException("Start time is later than end time");
        }
        this.initialize(startTime, endTime, null);
    }

    public TimePeriod(Timestamp startTime, TimeSpan duration) {
        if (startTime == null || duration == null) {
            throw new NullPointerException();
        }
        this.initialize(startTime, null, duration);
    }

    public TimePeriod(TimeSpan duration, Timestamp endTime) {
        if (duration == null || endTime == null) {
            throw new NullPointerException();
        }
        this.initialize(null, endTime, duration);
    }

    private void initialize(Timestamp startTime, Timestamp endTime, TimeSpan duration) {
        if (duration != null) {
            if (duration.getTotalMilliSeconds() <= 0L) {
                throw new IllegalArgumentException("Duration must be greater than zero.");
            }
            if (startTime == null) {
                startTime = endTime.subtract(duration);
            } else if (endTime == null) {
                endTime = startTime.add(duration);
            }
        }
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public Timestamp getStartTime() {
        return this.startTime;
    }

    public Timestamp getEndTime() {
        return this.endTime;
    }

    public TimeSpan getDuration() {
        return TimeSpan.difference(this.endTime, this.startTime);
    }

    public TimeSpan getDateDuration() {
        return TimeSpan.dateDifference(this.endTime, this.startTime);
    }

    public TimeSpan getTimeDuration() {
        return TimeSpan.timeDifference(this.endTime, this.startTime);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TimePeriod) {
            TimePeriod that = (TimePeriod)obj;
            return this.startTime.equals(that.getStartTime()) && this.endTime.equals(that.getStartTime());
        }
        return false;
    }

    public int hashCode() {
        return this.startTime.hashCode() ^ this.endTime.hashCode();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Start time: ").append(this.startTime.toString()).append(" End Time: ").append(this.endTime.toString()).append(" Duration: ").append(this.getDuration().toString());
        return buf.toString();
    }
}

