/*
 * Decompiled with CFR 0.152.
 */
package elite.lang;

import elite.lang.TimeSpan;
import elite.lang.annotation.Expando;
import java.io.Serializable;
import java.sql.Time;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Timestamp
implements Serializable,
Comparable<Timestamp> {
    private final long time;
    private static final Calendar staticCal = new GregorianCalendar();
    private static final long serialVersionUID = 5445487933804595589L;

    public Timestamp() {
        this(System.currentTimeMillis());
    }

    public Timestamp(long millis) {
        this.time = millis;
    }

    public Timestamp(Date date) {
        this(date.getTime());
    }

    public Timestamp(int year, int month, int date) {
        this(year, month, date, 0, 0, 0, TimeZone.getDefault());
    }

    public Timestamp(int year, int month, int date, TimeZone tz) {
        this(year, month, date, 0, 0, 0, tz);
    }

    public Timestamp(int year, int month, int date, int hrs, int min, int sec) {
        this(year, month, date, hrs, min, sec, TimeZone.getDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp(int year, int month, int date, int hrs, int min, int sec, TimeZone tz) {
        Calendar calendar = staticCal;
        synchronized (calendar) {
            TimeZone defaultZone = TimeZone.getDefault();
            staticCal.setTimeZone(tz);
            staticCal.clear();
            staticCal.set(year, month - 1, date, hrs, min, sec);
            this.time = staticCal.getTime().getTime();
            staticCal.setTimeZone(defaultZone);
        }
    }

    public int getYear() {
        return this.getField(1);
    }

    public int getMonth() {
        return this.getField(2) + 1;
    }

    public int getDate() {
        return this.getField(5);
    }

    public int getDayOfWeek() {
        return this.getField(7) - 1;
    }

    public int getDayOfYear() {
        return this.getField(6);
    }

    public int getHours() {
        return this.getField(11);
    }

    public int getMinutes() {
        return this.getField(12);
    }

    public int getSeconds() {
        return this.getField(13);
    }

    public long getTimeInMillis() {
        return this.time;
    }

    public Date getTime() {
        return new Date(this.getTimeInMillis());
    }

    public Timestamp truncate() {
        return new Timestamp(this.getYear(), this.getMonth(), this.getDate());
    }

    @Override
    public int compareTo(Timestamp that) {
        long diff = this.getTimeInMillis() - that.getTimeInMillis();
        return diff == 0L ? 0 : (diff > 0L ? 1 : -1);
    }

    public boolean before(Timestamp that) {
        return this.getTimeInMillis() < that.getTimeInMillis();
    }

    public boolean after(Timestamp that) {
        return this.getTimeInMillis() > that.getTimeInMillis();
    }

    public boolean equals(Object obj) {
        return obj instanceof Timestamp && this.getTimeInMillis() == ((Timestamp)obj).getTimeInMillis();
    }

    public int hashCode() {
        return (int)(this.time ^ this.time >>> 32);
    }

    public int dateCompareTo(Timestamp that) {
        int thatDate;
        int thatMonth;
        int thatYear;
        int thisYear = this.getYear();
        if (thisYear > (thatYear = that.getYear())) {
            return 1;
        }
        if (thisYear < thatYear) {
            return -1;
        }
        int thisMonth = this.getMonth();
        if (thisMonth > (thatMonth = that.getMonth())) {
            return 1;
        }
        if (thisMonth < thatMonth) {
            return -1;
        }
        int thisDate = this.getDate();
        if (thisDate > (thatDate = that.getDate())) {
            return 1;
        }
        if (thisDate < thatDate) {
            return -1;
        }
        return 0;
    }

    public boolean dateBefore(Timestamp that) {
        return this.dateCompareTo(that) < 0;
    }

    public boolean dateAfter(Timestamp that) {
        return this.dateCompareTo(that) > 0;
    }

    public boolean dateEquals(Timestamp that) {
        return this.dateCompareTo(that) == 0;
    }

    public int timeCompareTo(Timestamp that) {
        int thatSeconds;
        int thatMinutes;
        int thatHours;
        int thisHours = this.getHours();
        if (thisHours > (thatHours = that.getHours())) {
            return 1;
        }
        if (thisHours < thatHours) {
            return -1;
        }
        int thisMinutes = this.getMinutes();
        if (thisMinutes > (thatMinutes = that.getMinutes())) {
            return 1;
        }
        if (thisMinutes < thatMinutes) {
            return -1;
        }
        int thisSeconds = this.getSeconds();
        if (thisSeconds > (thatSeconds = that.getSeconds())) {
            return 1;
        }
        if (thisSeconds < thatSeconds) {
            return -1;
        }
        return 0;
    }

    public boolean timeBefore(Timestamp that) {
        return this.timeCompareTo(that) < 0;
    }

    public boolean timeAfter(Timestamp that) {
        return this.timeCompareTo(that) > 0;
    }

    public boolean timeEquals(Timestamp that) {
        return this.timeCompareTo(that) == 0;
    }

    @Expando(name="+")
    public Timestamp add(TimeSpan span) {
        return new Timestamp(this.getTimeInMillis() + span.getTotalMilliSeconds());
    }

    @Expando(name="-")
    public Timestamp subtract(TimeSpan span) {
        return new Timestamp(this.getTimeInMillis() - span.getTotalMilliSeconds());
    }

    @Expando(name="-")
    public TimeSpan subtract(Timestamp that) {
        return TimeSpan.difference(this, that);
    }

    public Timestamp addYears(int years) {
        return this.addField(1, years);
    }

    public Timestamp addMonths(int months) {
        return this.addField(2, months);
    }

    public Timestamp addDays(int days) {
        return this.addField(5, days);
    }

    public Timestamp addHours(int hours) {
        return this.addField(11, hours);
    }

    public Timestamp addMinutes(int minutes) {
        return this.addField(12, minutes);
    }

    public Timestamp addSeconds(int seconds) {
        return this.addField(13, seconds);
    }

    public String formatDate() {
        return this.formatDate(TimeZone.getDefault(), Locale.getDefault());
    }

    public String formatDate(TimeZone tz) {
        return this.formatDate(tz, Locale.getDefault());
    }

    public String formatDate(Locale lc) {
        return this.formatDate(TimeZone.getDefault(), lc);
    }

    public String formatDate(TimeZone tz, Locale lc) {
        DateFormat format = DateFormat.getDateInstance(2, lc);
        format.setTimeZone(tz);
        return format.format(this.getTime());
    }

    public String formatTime() {
        return this.formatTime(TimeZone.getDefault(), Locale.getDefault());
    }

    public String formatTime(TimeZone tz) {
        return this.formatTime(tz, Locale.getDefault());
    }

    public String formatTime(Locale lc) {
        return this.formatTime(TimeZone.getDefault(), lc);
    }

    public String formatTime(TimeZone tz, Locale lc) {
        DateFormat format = DateFormat.getTimeInstance(2, lc);
        format.setTimeZone(tz);
        return format.format(this.getTime());
    }

    public String format() {
        return this.format(TimeZone.getDefault(), Locale.getDefault());
    }

    public String format(TimeZone tz) {
        return this.format(tz, Locale.getDefault());
    }

    public String format(Locale lc) {
        return this.format(TimeZone.getDefault(), lc);
    }

    public String format(TimeZone tz, Locale lc) {
        DateFormat format = DateFormat.getDateTimeInstance(2, 2, lc);
        format.setTimeZone(tz);
        return format.format(this.getTime());
    }

    public String toString() {
        return this.format();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTimeZoneOffset() {
        Calendar calendar = staticCal;
        synchronized (calendar) {
            staticCal.setTime(this.getTime());
            return staticCal.get(15) + staticCal.get(16);
        }
    }

    public java.sql.Date getSQLDate() {
        return new java.sql.Date(this.getTimeInMillis());
    }

    public Time getSQLTime() {
        return new Time(this.getTimeInMillis());
    }

    public java.sql.Timestamp getSQLTimestamp() {
        return new java.sql.Timestamp(this.getTimeInMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getField(int field) {
        Calendar calendar = staticCal;
        synchronized (calendar) {
            staticCal.setTime(this.getTime());
            return staticCal.get(field);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timestamp addField(int field, int amount) {
        Calendar calendar = staticCal;
        synchronized (calendar) {
            staticCal.setTime(this.getTime());
            staticCal.add(field, amount);
            return new Timestamp(staticCal.getTime().getTime());
        }
    }
}

