/*
 * Decompiled with CFR 0.152.
 */
package elite.xml;

import elite.lang.Closure;
import elite.xml.FilterVirtualNode;
import elite.xml.VirtualNode;
import elite.xml.XmlNode;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.el.ELContext;
import javax.el.PropertyNotWritableException;
import org.operamasks.el.resources.Resources;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DescendantVirtualNode
extends VirtualNode
implements Iterable<XmlNode> {
    static final String WILDCARD = "*";
    protected XmlNode real;

    DescendantVirtualNode(XmlNode parent, String name) {
        super(parent, name);
    }

    @Override
    protected XmlNode realize(boolean create) {
        if (this.name.equals(WILDCARD)) {
            return null;
        }
        if (this.real == null) {
            this.real = XmlNode.valueOf(this.descendant(0));
        }
        return this.real;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object getValue(ELContext elctx, Object property) {
        Node child;
        if (property instanceof String) {
            if (!WILDCARD.equals(this.name)) return super.getValue(elctx, property);
            String name = (String)property;
            if (name.startsWith("@")) return null;
            elctx.setPropertyResolved(true);
            return new DescendantVirtualNode(this.parent, name);
        }
        if (!(property instanceof Number) || (child = this.descendant(((Number)property).intValue())) == null) return null;
        elctx.setPropertyResolved(true);
        return XmlNode.valueOf(child);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Class<?> getType(ELContext elctx, Object property) {
        if (property instanceof String) {
            String name = (String)property;
            if (!WILDCARD.equals(this.name)) return super.getType(elctx, property);
            if (name.startsWith("@")) return null;
            elctx.setPropertyResolved(true);
            return XmlNode.class;
        }
        if (!(property instanceof Number)) return null;
        elctx.setPropertyResolved(true);
        return XmlNode.class;
    }

    @Override
    public boolean isReadOnly(ELContext elctx, Object property) {
        if (property instanceof String) {
            if (WILDCARD.equals(this.name)) {
                elctx.setPropertyResolved(true);
                return true;
            }
            return super.isReadOnly(elctx, property);
        }
        if (property instanceof Number) {
            elctx.setPropertyResolved(true);
            return true;
        }
        return false;
    }

    @Override
    public void setValue(ELContext elctx, Object property, Object value) {
        if (property instanceof String) {
            if (WILDCARD.equals(this.name)) {
                throw new PropertyNotWritableException(Resources._T("EL_PROPERTY_NOT_WRITABLE", "XmlNode", property));
            }
            super.setValue(elctx, property, value);
        } else if (property instanceof Number) {
            throw new PropertyNotWritableException(Resources._T("EL_PROPERTY_NOT_WRITABLE", "XmlNode", property));
        }
    }

    public XmlNode filter(Closure pred) {
        return new FilterVirtualNode(this.parent, this, pred);
    }

    @Override
    public Iterator<XmlNode> iterator() {
        Element elem = (Element)this.parent.toDOM();
        if (elem != null) {
            return new NodeListItr(elem.getElementsByTagName(this.name));
        }
        return Collections.emptyList().iterator();
    }

    private Node descendant(int index) {
        Element elem = (Element)this.parent.toDOM();
        if (elem != null) {
            NodeList nlist = elem.getElementsByTagName(this.name);
            return nlist.item(index);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeListItr
    implements Iterator<XmlNode> {
        private NodeList nlist;
        private int length;
        private int index;

        NodeListItr(NodeList nlist) {
            this.nlist = nlist;
            this.length = nlist.getLength();
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.length;
        }

        @Override
        public XmlNode next() {
            Node child = this.nlist.item(this.index);
            if (child == null) {
                throw new NoSuchElementException();
            }
            ++this.index;
            return XmlNode.valueOf(child);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

