/*
 * Decompiled with CFR 0.152.
 */
package elite.xml;

import elite.lang.Closure;
import elite.xml.ContainerVirtualNode;
import elite.xml.DescendantVirtualNode;
import elite.xml.XmlNode;
import javax.el.ELContext;
import javax.el.MethodInfo;
import javax.el.MethodNotFoundException;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class VirtualNode
extends XmlNode {
    protected final XmlNode parent;
    protected final String name;

    VirtualNode(XmlNode parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    @Override
    public Object getValue(ELContext elctx, Object property) {
        if (property instanceof String) {
            XmlNode real = this.realize(false);
            if (real != null) {
                return real.getValue(elctx, property);
            }
            String name = (String)property;
            if (name.startsWith("@")) {
                return null;
            }
            if (name.equals("_")) {
                elctx.setPropertyResolved(true);
                return new DescendantVirtualNode(this, "*");
            }
            elctx.setPropertyResolved(true);
            return new ContainerVirtualNode(this, name);
        }
        return null;
    }

    @Override
    public Class<?> getType(ELContext elctx, Object property) {
        if (property instanceof String) {
            XmlNode real = this.realize(false);
            if (real != null) {
                return real.getType(elctx, property);
            }
            String name = (String)property;
            if (name.startsWith("@")) {
                return null;
            }
            elctx.setPropertyResolved(true);
            return XmlNode.class;
        }
        return null;
    }

    @Override
    public boolean isReadOnly(ELContext elctx, Object property) {
        if (property instanceof String) {
            elctx.setPropertyResolved(true);
        }
        return false;
    }

    @Override
    public void setValue(ELContext elctx, Object property, Object value) {
        XmlNode real;
        if (property instanceof String && (real = this.realize(value != null)) != null) {
            real.setValue(elctx, property, value);
        }
    }

    @Override
    public MethodInfo getMethodInfo(ELContext ctx, String name) throws MethodNotFoundException {
        XmlNode real = this.realize(false);
        if (real == null) {
            throw new MethodNotFoundException("method not found: " + name);
        }
        return real.getMethodInfo(ctx, name);
    }

    @Override
    public Object invoke(ELContext ctx, String name, Closure[] args) throws MethodNotFoundException {
        XmlNode real = this.realize(false);
        if (real == null) {
            throw new MethodNotFoundException("method not found: " + name);
        }
        return real.invoke(ctx, name, args);
    }

    protected boolean ischild(Node n) {
        return n.getNodeType() == 1 && this.name.equals(n.getNodeName());
    }

    protected Node firstChild(Node parent) {
        for (Node n = parent.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!this.ischild(n)) continue;
            return n;
        }
        return null;
    }

    protected Node lastChild(Node parent) {
        for (Node n = parent.getLastChild(); n != null; n = n.getPreviousSibling()) {
            if (!this.ischild(n)) continue;
            return n;
        }
        return null;
    }

    protected Node child(Node parent, int index) {
        int i = index;
        for (Node n = parent.getFirstChild(); i >= 0 && n != null; n = n.getNextSibling()) {
            if (!this.ischild(n)) continue;
            if (i == 0) {
                return n;
            }
            --i;
        }
        if (i == 0) {
            return null;
        }
        throw new IndexOutOfBoundsException("" + index);
    }

    @Override
    public Object coerce(Class type) {
        XmlNode real = this.realize(false);
        return real == null ? null : real.coerce(type);
    }

    @Override
    public Node toDOM() {
        XmlNode real = this.realize(false);
        return real == null ? null : real.toDOM();
    }

    public String toString() {
        XmlNode real = this.realize(false);
        return real == null ? null : real.toString();
    }

    @Override
    public String toXMLString() {
        XmlNode real = this.realize(false);
        return real == null ? null : real.toXMLString();
    }
}

