/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.compat;

import java.beans.FeatureDescriptor;
import java.lang.reflect.Method;
import java.util.Iterator;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.servlet.jsp.el.ELException;
import javax.servlet.jsp.el.Expression;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.FunctionMapper;
import javax.servlet.jsp.el.VariableResolver;
import org.operamasks.el.compat.VariableResolverImpl;
import org.operamasks.el.eval.ELContextImpl;

public class ExpressionEvaluatorImpl
extends ExpressionEvaluator {
    private ExpressionFactory factory;

    public ExpressionEvaluatorImpl(ExpressionFactory factory) {
        this.factory = factory;
    }

    public Expression parseExpression(String expression, Class expectedType, FunctionMapper fnMapper) throws ELException {
        ELContextImpl context = new ELContextImpl(new ELResolverWrapper(null));
        if (fnMapper != null) {
            context.setFunctionMapper(new FunctionMapperWrapper(fnMapper));
        }
        try {
            ValueExpression expr = this.factory.createValueExpression((ELContext)context, expression, expectedType);
            return new ExpressionWrapper(expr);
        }
        catch (javax.el.ELException ex) {
            ELException ex2 = new ELException(ex.getMessage());
            ex2.setStackTrace(ex.getStackTrace());
            throw ex2;
        }
    }

    public Object evaluate(String expression, Class expectedType, VariableResolver varResolver, FunctionMapper fnMapper) throws ELException {
        ELContextImpl context = varResolver instanceof VariableResolverImpl ? (ELContextImpl)((VariableResolverImpl)varResolver).getELContext() : new ELContextImpl(new ELResolverWrapper(varResolver));
        javax.el.FunctionMapper oldMapper = context.getFunctionMapper();
        if (fnMapper != null) {
            context.setFunctionMapper(new FunctionMapperWrapper(fnMapper));
        } else {
            context.setFunctionMapper(null);
        }
        try {
            ValueExpression expr = this.factory.createValueExpression((ELContext)context, expression, expectedType);
            Object object = expr.getValue((ELContext)context);
            return object;
        }
        catch (javax.el.ELException ex) {
            ELException ex2 = new ELException(ex.getMessage());
            ex2.setStackTrace(ex.getStackTrace());
            throw ex2;
        }
        finally {
            context.setFunctionMapper(oldMapper);
        }
    }

    private static class FunctionMapperWrapper
    extends javax.el.FunctionMapper {
        private FunctionMapper mapper;

        public FunctionMapperWrapper(FunctionMapper mapper) {
            this.mapper = mapper;
        }

        public Method resolveFunction(String prefix, String localName) {
            return this.mapper.resolveFunction(prefix, localName);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ELResolverWrapper
    extends ELResolver {
        private VariableResolver resolver;

        ELResolverWrapper(VariableResolver resolver) {
            this.resolver = resolver;
        }

        public Object getValue(ELContext context, Object base, Object property) {
            if (this.resolver != null && base == null) {
                try {
                    context.setPropertyResolved(true);
                    return this.resolver.resolveVariable((String)property);
                }
                catch (ELException ex) {
                    javax.el.ELException ex2 = new javax.el.ELException(ex.getMessage());
                    ex2.setStackTrace(ex.getStackTrace());
                    throw ex2;
                }
            }
            return null;
        }

        public Class<?> getType(ELContext context, Object base, Object property) {
            throw new UnsupportedOperationException();
        }

        public void setValue(ELContext context, Object base, Object property, Object value) {
            throw new UnsupportedOperationException();
        }

        public boolean isReadOnly(ELContext context, Object base, Object property) {
            throw new UnsupportedOperationException();
        }

        public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
            throw new UnsupportedOperationException();
        }

        public Class<?> getCommonPropertyType(ELContext context, Object base) {
            throw new UnsupportedOperationException();
        }
    }

    private static class ExpressionWrapper
    extends Expression {
        private ValueExpression expr;

        public ExpressionWrapper(ValueExpression expr) {
            this.expr = expr;
        }

        public Object evaluate(VariableResolver varResolver) throws ELException {
            ELContextImpl context = varResolver instanceof VariableResolverImpl ? (ELContextImpl)((VariableResolverImpl)varResolver).getELContext() : new ELContextImpl(new ELResolverWrapper(varResolver));
            try {
                return this.expr.getValue((ELContext)context);
            }
            catch (javax.el.ELException ex) {
                ELException ex2 = new ELException(ex.getMessage());
                ex2.setStackTrace(ex.getStackTrace());
                throw ex2;
            }
        }
    }
}

