/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.eval;

import java.util.Locale;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.FunctionMapper;
import javax.el.VariableMapper;
import org.operamasks.el.eval.ELContextImpl;
import org.operamasks.el.eval.ELEngine;

public class DelegatingELContext
extends ELContext {
    private ELContext delegate;
    private Thread thread;

    DelegatingELContext(ELContext delegate) {
        this.delegate = delegate;
        this.thread = Thread.currentThread();
    }

    public ELContext getDelegate() {
        return this.delegate;
    }

    public Thread getThread() {
        return this.thread;
    }

    public static ELContext get(ELContext delegate) {
        if (delegate == null) {
            return ELEngine.getCurrentELContext();
        }
        Thread thread = Thread.currentThread();
        if (delegate instanceof ELContextImpl && thread == ((ELContextImpl)delegate).getThread()) {
            return delegate;
        }
        if (delegate instanceof DelegatingELContext && thread == ((DelegatingELContext)delegate).getThread()) {
            return delegate;
        }
        return new DelegatingELContext(delegate);
    }

    public void putContext(Class key, Object contextObject) {
        this.delegate.putContext(key, contextObject);
    }

    public Object getContext(Class key) {
        return this.delegate.getContext(key);
    }

    public ELResolver getELResolver() {
        return this.delegate.getELResolver();
    }

    public FunctionMapper getFunctionMapper() {
        return this.delegate.getFunctionMapper();
    }

    public Locale getLocale() {
        return this.delegate.getLocale();
    }

    public void setLocale(Locale locale) {
        this.delegate.setLocale(locale);
    }

    public VariableMapper getVariableMapper() {
        return this.delegate.getVariableMapper();
    }
}

