/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.eval;

import elite.lang.Closure;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.FunctionMapper;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import org.operamasks.el.eval.EvaluationContext;
import org.operamasks.el.eval.Frame;
import org.operamasks.el.eval.FunctionMapperBuilder;
import org.operamasks.el.eval.StackTrace;
import org.operamasks.el.eval.closure.FieldClosure;
import org.operamasks.el.eval.closure.LiteralClosure;
import org.operamasks.el.parser.ELNode;
import org.operamasks.el.parser.Position;
import org.operamasks.el.resolver.ClassResolver;
import org.operamasks.el.resolver.MethodResolver;
import org.operamasks.util.Utils;

public class ELProgram
implements Serializable {
    private List<Module> mods = new ArrayList<Module>();
    private List<String> libs = new ArrayList<String>();
    private List<String> imps = new ArrayList<String>();
    private List<ELNode> defs = new ArrayList<ELNode>();
    private List<ELNode> exps = new ArrayList<ELNode>();
    private static final long serialVersionUID = 3112245719728771823L;

    public void addModule(String name, String prefix) {
        Module module = new Module(name, prefix);
        if (!this.mods.contains(module)) {
            this.mods.add(module);
        }
    }

    public void addLibrary(String name) {
        if (!this.libs.contains(name)) {
            this.libs.add(name);
        }
    }

    public void addImport(String imp) {
        if (!this.imps.contains(imp)) {
            this.imps.add(imp);
        }
    }

    public void addExpression(ELNode exp) {
        (ELProgram.isDef(exp) ? this.defs : this.exps).add(exp);
    }

    private static boolean isDef(ELNode node) {
        if (node instanceof ELNode.DEFINE) {
            ELNode exp = ((ELNode.DEFINE)node).expr;
            return exp instanceof ELNode.LAMBDA || exp instanceof ELNode.CLASSDEF;
        }
        return false;
    }

    public Object execute(ELContext elctx) {
        return this.execute(elctx, null, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(ELContext elctx, String file, int line) {
        FunctionMapper fm = elctx.getFunctionMapper();
        VariableMapper vm = elctx.getVariableMapper();
        if (fm != null) {
            FunctionMapperBuilder fmb = new FunctionMapperBuilder(fm);
            for (ELNode node : this.exps) {
                node.applyFunctionMapper(fmb);
            }
            fm = fmb.build();
        }
        EvaluationContext env = new EvaluationContext(elctx, fm, vm);
        Frame frame = StackTrace.addFrame(elctx, "__toplevel__", file, Position.make(line, 1));
        try {
            this.importModules(elctx);
            this.importFunctions(elctx);
            this.importPackages(elctx);
            for (ELNode node : this.defs) {
                frame.setPos(node.pos);
                node.getValue(env);
            }
            Object result = null;
            for (ELNode node : this.exps) {
                frame.setPos(node.pos);
                result = node.getValue(env);
            }
            Object object = result;
            return object;
        }
        finally {
            StackTrace.removeFrame(elctx);
        }
    }

    private void importModules(ELContext elctx) {
        if (!this.mods.isEmpty()) {
            MethodResolver resolver = MethodResolver.getInstance(elctx);
            for (Module mod : this.mods) {
                Class cls = ELProgram.findClass(mod.name);
                resolver.addModule(elctx, cls, mod.prefix);
                for (Field field : cls.getFields()) {
                    ELProgram.importField(elctx, field, mod.prefix);
                }
            }
        }
    }

    private void importFunctions(ELContext elctx) {
        if (!this.libs.isEmpty()) {
            MethodResolver resolver = MethodResolver.getInstance(elctx);
            for (String name : this.libs) {
                int sep = name.lastIndexOf(46);
                if (sep == -1) {
                    throw new ELException("Invalid import directive: " + name);
                }
                String clsname = name.substring(0, sep);
                name = name.substring(sep + 1);
                Class cls = ELProgram.findClass(clsname);
                if (name.equals("*")) {
                    resolver.addGlobalMethods(cls);
                    for (AccessibleObject accessibleObject : cls.getFields()) {
                        ELProgram.importField(elctx, (Field)accessibleObject, null);
                    }
                    continue;
                }
                for (AccessibleObject accessibleObject : cls.getMethods()) {
                    if (!Modifier.isStatic(((Method)accessibleObject).getModifiers()) || !name.equals(((Method)accessibleObject).getName())) continue;
                    resolver.addGlobalMethod((Method)accessibleObject);
                }
                try {
                    ELProgram.importField(elctx, cls.getField(name), null);
                }
                catch (NoSuchFieldException ex) {
                }
            }
        }
    }

    private static void importField(ELContext elctx, Field field, String prefix) {
        if (Modifier.isStatic(field.getModifiers())) {
            try {
                field.setAccessible(true);
                String name = field.getName();
                if (prefix != null) {
                    name = prefix + ":" + name;
                }
                Closure closure = Modifier.isFinal(field.getModifiers()) ? new LiteralClosure(field.get(null), true) : new FieldClosure(field);
                elctx.getVariableMapper().setVariable(name, (ValueExpression)closure);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private void importPackages(ELContext elctx) {
        if (!this.imps.isEmpty()) {
            ClassResolver resolver = ClassResolver.getInstance(elctx);
            for (String imp : this.imps) {
                resolver.addImport(imp);
            }
        }
    }

    private static Class findClass(String name) {
        try {
            return Utils.findClass(name);
        }
        catch (ClassNotFoundException ex) {
            throw new ELException((Throwable)ex);
        }
    }

    static class Module {
        String name;
        String prefix;

        Module(String name, String prefix) {
            this.name = name;
            this.prefix = prefix;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Module) {
                Module other = (Module)obj;
                return this.name.equals(other.name) && (this.prefix == null ? other.prefix == null : this.prefix.equals(other.prefix));
            }
            return false;
        }
    }
}

