/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.eval;

import elite.lang.Closure;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.faces.context.FacesContext;

public class ELUtils {
    public static final Class[] NO_ARGS = new Class[0];
    public static final Object[] NO_VALUES = new Object[0];
    public static final Closure[] NO_PARAMS = new Closure[0];
    public static final Object NO_RESULT = new Object();
    static final boolean facesContextPresent = ELUtils.classPresent("javax.faces.context.FacesContext");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^[-+]?(\\d+|\\d+\\.\\d*|\\d*\\.\\d+)([eE][-+]?\\d+)?$");

    private ELUtils() {
    }

    public static Locale getCurrentLocale() {
        FacesContext context;
        if (facesContextPresent && (context = FacesContext.getCurrentInstance()) != null && context.getViewRoot() != null) {
            return context.getViewRoot().getLocale();
        }
        return Locale.getDefault();
    }

    public static boolean classPresent(String name) {
        try {
            Class.forName(name);
        }
        catch (Throwable ex) {
            return false;
        }
        return true;
    }

    public static String getQuotedString(String str) {
        StringBuffer buf = new StringBuffer();
        buf.append('\"');
        block7: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\t': {
                    buf.append("\\t");
                    continue block7;
                }
                case '\n': {
                    buf.append("\\n");
                    continue block7;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block7;
                }
                case '\"': {
                    buf.append("\\\"");
                    continue block7;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block7;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        buf.append('\"');
        return buf.toString();
    }

    public static boolean looksLikeNumber(Object v) {
        if (v instanceof Number) {
            return true;
        }
        if (v instanceof CharSequence) {
            return NUMBER_PATTERN.matcher((CharSequence)v).matches();
        }
        return false;
    }

    public static boolean looksLikeFloat(Object v) {
        if (v instanceof CharSequence) {
            CharSequence s = (CharSequence)v;
            int len = s.length();
            for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                if (c != '.' && c != 'e' && c != 'E') continue;
                return true;
            }
        }
        return false;
    }

    public static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    public static String decapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        return Character.toLowerCase(name.charAt(0)) + name.substring(1);
    }

    public static String getMethodDescriptor(Method method) {
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        for (Class<?> type : method.getParameterTypes()) {
            ELUtils.getClassDescriptor(buf, type);
        }
        buf.append(')');
        ELUtils.getClassDescriptor(buf, method.getReturnType());
        return buf.toString();
    }

    public static String getClassDescriptor(Class c) {
        StringBuilder buf = new StringBuilder();
        ELUtils.getClassDescriptor(buf, c);
        return buf.toString();
    }

    public static void getClassDescriptor(StringBuilder buf, Class c) {
        Class<?> d = c;
        while (true) {
            if (d.isPrimitive()) {
                int car;
                if (d == Void.TYPE) {
                    car = 86;
                } else if (d == Boolean.TYPE) {
                    car = 90;
                } else if (d == Character.TYPE) {
                    car = 67;
                } else if (d == Byte.TYPE) {
                    car = 66;
                } else if (d == Short.TYPE) {
                    car = 83;
                } else if (d == Integer.TYPE) {
                    car = 73;
                } else if (d == Long.TYPE) {
                    car = 74;
                } else if (d == Float.TYPE) {
                    car = 70;
                } else if (d == Double.TYPE) {
                    car = 68;
                } else {
                    throw new AssertionError();
                }
                buf.append((char)car);
                return;
            }
            if (!d.isArray()) break;
            buf.append('[');
            d = d.getComponentType();
        }
        buf.append('L');
        buf.append(d.getName().replace('.', '/'));
        buf.append(';');
    }
}

