/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.eval;

import java.io.Serializable;
import javax.el.ELContext;
import org.operamasks.el.eval.ELEngine;
import org.operamasks.el.parser.Position;

public class Frame
implements Serializable {
    private String procName;
    private String fileName;
    private int pos;
    private Frame next;
    private ELContext previousContext;

    public Frame(String procName, String fileName, int pos, Frame next) {
        this.procName = procName;
        this.fileName = fileName;
        this.pos = pos;
        this.next = next;
    }

    public String getProcName() {
        return this.procName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return Position.line(this.pos);
    }

    public int getColumnNumber() {
        return Position.column(this.pos);
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public Frame getNext() {
        return this.next;
    }

    void enter(ELContext elctx) {
        this.previousContext = ELEngine.setCurrentELContext(elctx);
    }

    Frame exit() {
        ELEngine.setCurrentELContext(this.previousContext);
        return this.next;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.procName != null) {
            buf.append(this.procName);
        }
        buf.append("(");
        if (this.fileName != null) {
            buf.append(this.fileName).append(":");
        }
        buf.append(this.getLineNumber());
        buf.append(")");
        return buf.toString();
    }
}

