/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.eval;

import elite.lang.Rational;
import java.io.Serializable;
import java.math.MathContext;
import javax.el.ELContext;
import javax.el.PropertyNotFoundException;
import javax.el.ValueExpression;
import org.operamasks.el.eval.PropertyDelegate;
import org.operamasks.el.eval.closure.LiteralClosure;
import org.operamasks.el.eval.closure.MethodClosure;
import org.operamasks.el.resolver.MethodResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalScope
implements PropertyDelegate,
Serializable {
    public static final GlobalScope SINGLETON = new GlobalScope();

    private GlobalScope() {
    }

    public Object getContext(ELContext elctx, Class key) {
        return elctx.getContext(key);
    }

    public void putContext(ELContext elctx, Class key, Object value) {
        elctx.putContext(key, value);
    }

    public static MathContext getMathContext(ELContext elctx) {
        return (MathContext)elctx.getContext(MathContext.class);
    }

    public static void setMathContext(ELContext elctx, MathContext mc) {
        elctx.putContext(MathContext.class, (Object)mc);
    }

    public static boolean isRationalEnabled(ELContext elctx) {
        return Boolean.TRUE.equals(elctx.getContext(Rational.class));
    }

    public static void setRationalEnabled(ELContext elctx, boolean value) {
        elctx.putContext(Rational.class, (Object)value);
    }

    @Override
    public Object getValue(ELContext elctx, Object property) {
        String name = (String)property;
        ValueExpression ve = elctx.getVariableMapper().resolveVariable(name);
        if (ve != null) {
            Object result = ve.getValue(elctx);
            elctx.setPropertyResolved(true);
            return result;
        }
        MethodResolver resolver = MethodResolver.getInstance(elctx);
        MethodClosure closure = resolver.resolveGlobalMethod(name);
        if (closure != null) {
            elctx.setPropertyResolved(true);
            return closure;
        }
        throw new PropertyNotFoundException();
    }

    @Override
    public Class<?> getType(ELContext elctx, Object property) {
        String name = (String)property;
        ValueExpression ve = elctx.getVariableMapper().resolveVariable(name);
        if (ve != null) {
            Class result = ve.getType(elctx);
            elctx.setPropertyResolved(true);
            return result;
        }
        MethodResolver resolver = MethodResolver.getInstance(elctx);
        if (resolver.resolveGlobalMethod(name) != null) {
            elctx.setPropertyResolved(true);
            return MethodClosure.class;
        }
        throw new PropertyNotFoundException();
    }

    @Override
    public void setValue(ELContext elctx, Object property, Object value) {
        String name = (String)property;
        ValueExpression ve = elctx.getVariableMapper().resolveVariable(name);
        if (ve != null) {
            ve.setValue(elctx, value);
            elctx.setPropertyResolved(true);
            return;
        }
        elctx.getVariableMapper().setVariable(name, (ValueExpression)new LiteralClosure(value));
        elctx.setPropertyResolved(true);
    }

    @Override
    public boolean isReadOnly(ELContext elctx, Object property) {
        elctx.setPropertyResolved(true);
        return false;
    }

    private Object readResolve() {
        return SINGLETON;
    }
}

