/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.eval;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.el.ELContext;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;
import org.operamasks.el.eval.TypeCoercion;
import org.operamasks.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiteralValueExpression
extends ValueExpression
implements Serializable {
    private static final long serialVersionUID = 5835790517485442464L;
    private Object value;
    private Class<?> expectedType;

    public LiteralValueExpression(Object value, Class<?> expectedType) {
        this.value = value;
        this.expectedType = expectedType;
    }

    public Object getValue(ELContext context) {
        if (this.expectedType == null || this.expectedType == Object.class) {
            return this.value;
        }
        return TypeCoercion.coerce(context, this.value, this.expectedType);
    }

    public void setValue(ELContext context, Object value) {
        throw new PropertyNotWritableException();
    }

    public boolean isReadOnly(ELContext context) {
        return true;
    }

    public Class<?> getType(ELContext context) {
        return this.value == null ? null : this.value.getClass();
    }

    public Class<?> getExpectedType() {
        return this.expectedType;
    }

    public String getExpressionString() {
        return this.value == null ? null : this.value.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LiteralValueExpression) {
            LiteralValueExpression other = (LiteralValueExpression)obj;
            if (this.value == null) {
                return other.value == null;
            }
            return this.value.equals(other.value);
        }
        return false;
    }

    public int hashCode() {
        return this.value == null ? 0 : this.value.hashCode();
    }

    public boolean isLiteralText() {
        return true;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.value);
        out.writeUTF(this.expectedType == null ? "" : this.expectedType.getName());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.value = in.readObject();
        String type = in.readUTF();
        this.expectedType = type.length() == 0 ? null : Utils.findClass(type);
    }
}

