/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.eval;

import elite.lang.Range;
import elite.lang.Seq;
import java.io.Serializable;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import org.operamasks.el.eval.seq.AbstractSeq;
import org.operamasks.el.eval.seq.EmptySeq;

public class Ranges {
    public static Seq createRange(long begin, long end, long step) {
        if (step == 1L) {
            if (begin > end) {
                return EmptySeq.make();
            }
            if (begin == end) {
                return new Singleton(begin);
            }
            return new Ascending(begin, end);
        }
        if (step == -1L) {
            if (begin < end) {
                return EmptySeq.make();
            }
            if (begin == end) {
                return new Singleton(begin);
            }
            return new Descending(begin, end);
        }
        if (step > 0L) {
            if (begin > end) {
                return EmptySeq.make();
            }
            if (begin + step > end) {
                return new Singleton(begin);
            }
            return new StepUp(begin, end, step);
        }
        if (step < 0L) {
            if (begin < end) {
                return EmptySeq.make();
            }
            if (end + step > begin) {
                return new Singleton(begin);
            }
            return new StepDown(begin, end, -step);
        }
        throw new IllegalArgumentException("illegal range step: " + step);
    }

    public static Seq createUnboundedRange(long begin, long step) {
        if (step > 0L) {
            return new UnboundedStepUp(begin, step);
        }
        if (step < 0L) {
            return new UnboundedStepDown(begin, -step);
        }
        throw new IllegalArgumentException("illegal range step: " + step);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnboundedStepDown
    extends AbstractRange {
        private final long begin;
        private final long step;
        private static final long serialVersionUID = -5903447967490555464L;

        public UnboundedStepDown(long begin, long step) {
            this.begin = begin;
            this.step = step;
        }

        @Override
        public long getBegin() {
            return this.begin;
        }

        @Override
        public long getEnd() {
            return Long.MIN_VALUE;
        }

        @Override
        public long getStep() {
            return -this.step;
        }

        @Override
        public boolean isExcludeEnd() {
            return false;
        }

        @Override
        public boolean isUnbound() {
            return true;
        }

        @Override
        public int size() {
            return Integer.MAX_VALUE;
        }

        @Override
        public Long get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("Index: " + index);
            }
            return this.begin - (long)index * this.step;
        }

        @Override
        protected int indexOf(long num) {
            if (num > this.begin) {
                return -1;
            }
            if ((this.begin - num) % this.step != 0L) {
                return -1;
            }
            return (int)((this.begin - num) / this.step);
        }

        @Override
        public String toString() {
            return "[" + this.begin + "," + (this.begin - this.step) + "..*]";
        }

        @Override
        public Iterator<Long> iterator() {
            return new Iterator<Long>(){
                private long next;
                {
                    this.next = UnboundedStepDown.this.begin;
                }

                @Override
                public boolean hasNext() {
                    return true;
                }

                @Override
                public Long next() {
                    long i = this.next;
                    this.next -= UnboundedStepDown.this.step;
                    return i;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public ListIterator<Long> listIterator(final int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("Index: " + index);
            }
            return new ListIterator<Long>(){
                private int cursor;
                {
                    this.cursor = index;
                }

                @Override
                public boolean hasNext() {
                    return true;
                }

                @Override
                public Long next() {
                    return UnboundedStepDown.this.begin - (long)this.cursor++ * UnboundedStepDown.this.step;
                }

                @Override
                public boolean hasPrevious() {
                    return this.cursor != 0;
                }

                @Override
                public Long previous() {
                    if (this.cursor == 0) {
                        throw new NoSuchElementException();
                    }
                    return UnboundedStepDown.this.begin - (long)(--this.cursor) * UnboundedStepDown.this.step;
                }

                @Override
                public int nextIndex() {
                    return this.cursor;
                }

                @Override
                public int previousIndex() {
                    return this.cursor - 1;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void set(Long o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void add(Long o) {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnboundedStepUp
    extends AbstractRange {
        private final long begin;
        private final long step;
        private static final long serialVersionUID = -3185000032254546767L;

        public UnboundedStepUp(long begin, long step) {
            this.begin = begin;
            this.step = step;
        }

        @Override
        public long getBegin() {
            return this.begin;
        }

        @Override
        public long getEnd() {
            return Long.MAX_VALUE;
        }

        @Override
        public long getStep() {
            return this.step;
        }

        @Override
        public boolean isExcludeEnd() {
            return false;
        }

        @Override
        public boolean isUnbound() {
            return true;
        }

        @Override
        public int size() {
            return Integer.MAX_VALUE;
        }

        @Override
        public Long get(int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("Index: " + index);
            }
            return this.begin + (long)index * this.step;
        }

        @Override
        protected int indexOf(long num) {
            if (num < this.begin) {
                return -1;
            }
            if ((num - this.begin) % this.step != 0L) {
                return -1;
            }
            return (int)((num - this.begin) / this.step);
        }

        @Override
        public String toString() {
            if (this.step == 1L) {
                return "[" + this.begin + "..*]";
            }
            return "[" + this.begin + "," + (this.begin + this.step) + "..*]";
        }

        @Override
        public Iterator<Long> iterator() {
            return new Iterator<Long>(){
                private long next;
                {
                    this.next = UnboundedStepUp.this.begin;
                }

                @Override
                public boolean hasNext() {
                    return true;
                }

                @Override
                public Long next() {
                    long i = this.next;
                    this.next += UnboundedStepUp.this.step;
                    return i;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public ListIterator<Long> listIterator(final int index) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("Index: " + index);
            }
            return new ListIterator<Long>(){
                private int cursor;
                {
                    this.cursor = index;
                }

                @Override
                public boolean hasNext() {
                    return true;
                }

                @Override
                public Long next() {
                    return UnboundedStepUp.this.begin + (long)this.cursor++ * UnboundedStepUp.this.step;
                }

                @Override
                public boolean hasPrevious() {
                    return this.cursor != 0;
                }

                @Override
                public Long previous() {
                    if (this.cursor == 0) {
                        throw new NoSuchElementException();
                    }
                    return UnboundedStepUp.this.begin + (long)(--this.cursor) * UnboundedStepUp.this.step;
                }

                @Override
                public int nextIndex() {
                    return this.cursor;
                }

                @Override
                public int previousIndex() {
                    return this.cursor - 1;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void set(Long o) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void add(Long o) {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public static class StepDown
    extends AbstractRange {
        private static final long serialVersionUID = -6482548072796361895L;
        private final long begin;
        private final long end;
        private final long step;

        public StepDown(long begin, long end, long step) {
            this.begin = begin;
            this.end = end;
            this.step = step;
        }

        public long getBegin() {
            return this.begin;
        }

        public long getEnd() {
            return this.end;
        }

        public long getStep() {
            return -this.step;
        }

        public boolean isExcludeEnd() {
            return false;
        }

        public boolean isUnbound() {
            return false;
        }

        public int size() {
            return (int)((this.begin - this.end + this.step) / this.step);
        }

        public Long get(int index) {
            long num = this.begin - (long)index * this.step;
            if (num < this.end || num > this.begin) {
                throw new IndexOutOfBoundsException(num + " not in range " + this);
            }
            return num;
        }

        protected int indexOf(long num) {
            if (num < this.end || num > this.begin) {
                return -1;
            }
            if ((this.begin - num) % this.step != 0L) {
                return -1;
            }
            return (int)((this.begin - num) / this.step);
        }

        public String toString() {
            return "[" + this.begin + "," + (this.begin - this.step) + ".." + this.end + "]";
        }
    }

    public static class StepUp
    extends AbstractRange {
        private static final long serialVersionUID = -575647382944213405L;
        private final long begin;
        private final long end;
        private final long step;

        public StepUp(long begin, long end, long step) {
            this.begin = begin;
            this.end = end;
            this.step = step;
        }

        public long getBegin() {
            return this.begin;
        }

        public long getEnd() {
            return this.end;
        }

        public long getStep() {
            return this.step;
        }

        public boolean isExcludeEnd() {
            return false;
        }

        public boolean isUnbound() {
            return false;
        }

        public int size() {
            return (int)((this.end - this.begin + this.step) / this.step);
        }

        public Long get(int index) {
            long num = this.begin + (long)index * this.step;
            if (num < this.begin || num > this.end) {
                throw new IndexOutOfBoundsException(num + " not in range " + this);
            }
            return num;
        }

        protected int indexOf(long num) {
            if (num < this.begin || num > this.end) {
                return -1;
            }
            if ((num - this.begin) % this.step != 0L) {
                return -1;
            }
            return (int)((num - this.begin) / this.step);
        }

        public String toString() {
            return "[" + this.begin + "," + (this.begin + this.step) + ".." + this.end + "]";
        }
    }

    public static class Descending
    extends AbstractRange {
        private static final long serialVersionUID = -5305644628530230136L;
        private final long begin;
        private final long end;

        public Descending(long begin, long end) {
            this.begin = begin;
            this.end = end;
        }

        public long getBegin() {
            return this.begin;
        }

        public long getEnd() {
            return this.end;
        }

        public long getStep() {
            return -1L;
        }

        public boolean isExcludeEnd() {
            return false;
        }

        public boolean isUnbound() {
            return false;
        }

        public int size() {
            return (int)(this.begin - this.end + 1L);
        }

        public Long get(int index) {
            long num = this.begin - (long)index;
            if (num < this.end || num > this.begin) {
                throw new IndexOutOfBoundsException(num + " not in range " + this);
            }
            return num;
        }

        protected int indexOf(long num) {
            if (num < this.end || num > this.begin) {
                return -1;
            }
            return (int)(this.begin - num);
        }

        public String toString() {
            return "[" + this.begin + "," + (this.begin - 1L) + ".." + this.end + "]";
        }
    }

    public static class Ascending
    extends AbstractRange {
        private static final long serialVersionUID = -6020526239222455654L;
        private final long begin;
        private final long end;

        public Ascending(long begin, long end) {
            this.begin = begin;
            this.end = end;
        }

        public long getBegin() {
            return this.begin;
        }

        public long getEnd() {
            return this.end;
        }

        public long getStep() {
            return 1L;
        }

        public boolean isExcludeEnd() {
            return false;
        }

        public boolean isUnbound() {
            return false;
        }

        public int size() {
            return (int)(this.end - this.begin + 1L);
        }

        public Long get(int index) {
            long num = this.begin + (long)index;
            if (num < this.begin || num > this.end) {
                throw new IndexOutOfBoundsException(num + " not in range " + this);
            }
            return num;
        }

        protected int indexOf(long num) {
            if (num < this.begin || num > this.end) {
                return -1;
            }
            return (int)(num - this.begin);
        }

        public String toString() {
            return "[" + this.begin + ".." + this.end + "]";
        }
    }

    public static class Singleton
    extends AbstractRange {
        private final long n;
        private static final long serialVersionUID = 2865107437677054850L;

        public Singleton(long n) {
            this.n = n;
        }

        public long getBegin() {
            return this.n;
        }

        public long getEnd() {
            return this.n;
        }

        public long getStep() {
            return 1L;
        }

        public boolean isExcludeEnd() {
            return false;
        }

        public boolean isUnbound() {
            return false;
        }

        public int size() {
            return 1;
        }

        public Long get(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("Index: " + index + ", size: 1");
            }
            return this.n;
        }

        protected int indexOf(long n) {
            return n == this.n ? 0 : -1;
        }

        public String toString() {
            return "[" + this.n + ".." + this.n + "]";
        }
    }

    private static abstract class AbstractRange
    extends AbstractSeq
    implements Range,
    RandomAccess,
    Serializable {
        private AbstractRange() {
        }

        public Object get() {
            return this.getBegin();
        }

        public Seq tail() {
            if (this.isUnbound()) {
                return Ranges.createUnboundedRange(this.getBegin() + this.getStep(), this.getStep());
            }
            return Ranges.createRange(this.getBegin() + this.getStep(), this.getEnd(), this.getStep());
        }

        public Seq last() {
            if (this.isUnbound()) {
                throw new UnsupportedOperationException();
            }
            long begin = this.getBegin();
            long end = this.getEnd();
            long step = this.getStep();
            end = begin + (end - begin) / step * step;
            return new Singleton(end);
        }

        public Seq reverse() {
            if (this.isUnbound()) {
                throw new UnsupportedOperationException();
            }
            return Ranges.createRange(this.getEnd(), this.getBegin(), -this.getStep());
        }

        public int indexOf(Object o) {
            long num;
            if (o instanceof Number) {
                num = ((Number)o).longValue();
            } else if (o instanceof Character) {
                num = ((Character)o).charValue();
            } else {
                return -1;
            }
            return this.indexOf(num);
        }

        public boolean contains(Object o) {
            return this.indexOf(o) != -1;
        }

        protected abstract int indexOf(long var1);
    }
}

