/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.eval;

import javax.el.ELContext;
import org.operamasks.el.eval.Frame;

public class StackTrace {
    Frame frame;

    private StackTrace() {
    }

    static StackTrace getInstance(ELContext elctx) {
        ThreadLocal tls = (ThreadLocal)elctx.getContext(StackTrace.class);
        if (tls == null) {
            tls = new ThreadLocal<StackTrace>(){

                @Override
                protected StackTrace initialValue() {
                    return new StackTrace();
                }
            };
            elctx.putContext(StackTrace.class, (Object)tls);
        }
        return (StackTrace)tls.get();
    }

    public static Frame addFrame(ELContext elctx, String procName, String fileName, int pos) {
        StackTrace trace = StackTrace.getInstance(elctx);
        trace.frame = new Frame(procName, fileName, pos, trace.frame);
        trace.frame.enter(elctx);
        return trace.frame;
    }

    public static void removeFrame(ELContext elctx) {
        StackTrace trace = StackTrace.getInstance(elctx);
        trace.frame = trace.frame.exit();
    }

    public static Frame getFrame(ELContext elctx) {
        StackTrace trace = StackTrace.getInstance(elctx);
        return trace.frame;
    }
}

