/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.eval.closure;

import elite.lang.Annotation;
import elite.lang.Closure;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.FunctionMapper;
import javax.el.MethodInfo;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import org.operamasks.el.eval.ELEngine;
import org.operamasks.el.eval.EvaluationContext;
import org.operamasks.el.eval.EvaluationException;
import org.operamasks.el.eval.MethodResolvable;
import org.operamasks.el.eval.PropertyResolvable;
import org.operamasks.el.eval.StackTrace;
import org.operamasks.el.eval.TypeCoercion;
import org.operamasks.el.eval.VariableMapperImpl;
import org.operamasks.el.eval.closure.AbstractClosure;
import org.operamasks.el.eval.closure.AnnotatedClosure;
import org.operamasks.el.eval.closure.BasicThisObject;
import org.operamasks.el.eval.closure.ClosureObject;
import org.operamasks.el.eval.closure.DefaultClosureObject;
import org.operamasks.el.eval.closure.DelayClosure;
import org.operamasks.el.eval.closure.DelegatedThisObject;
import org.operamasks.el.eval.closure.DerivedThisObject;
import org.operamasks.el.eval.closure.NamedClosure;
import org.operamasks.el.eval.closure.ProxiedThisObject;
import org.operamasks.el.eval.closure.ThisObject;
import org.operamasks.el.parser.ELNode;
import org.operamasks.el.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDefinition
extends AnnotatedClosure
implements PropertyResolvable,
MethodResolvable,
Serializable {
    private transient EvaluationContext env;
    private ELNode.CLASSDEF cdef;
    private FunctionMapper fm;
    private VariableMapper vm;
    private transient Object basecls;
    private transient Class[] interfaces;
    private VariableMapper cvmap;
    private Map<String, Closure> expando;
    private static final long serialVersionUID = 2605237093923769160L;
    public static final String INIT_PROC = "__init__";
    public static final String CLINIT_PROC = "__clinit__";
    private volatile int init_state = 0;
    private transient Thread init_thread = null;
    private transient Object singleton = null;
    private static final int NOT_INITIALIZED = 0;
    private static final int INITIALIZE_PENDING = 1;
    private static final int INITIALIZED = 2;
    private static final ThreadLocal<ClassDefinition[]> invoke_scope = new ThreadLocal<ClassDefinition[]>(){

        @Override
        protected ClassDefinition[] initialValue() {
            return new ClassDefinition[1];
        }
    };

    public ClassDefinition(EvaluationContext env, ELNode.CLASSDEF cdef) {
        this.env = env;
        this.cdef = cdef;
        this.fm = env.getFunctionMapper();
        this.vm = null;
        this.expando = new LinkedHashMap<String, Closure>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(ELContext elctx) {
        if (this.init_state == 2) {
            return;
        }
        ClassDefinition classDefinition = this;
        synchronized (classDefinition) {
            while (true) {
                if (this.init_state == 2) {
                    this.notify();
                    return;
                }
                if (this.init_state == 0) break;
                if (this.init_thread == Thread.currentThread()) {
                    return;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    this.notify();
                    throw new ExceptionInInitializerError(ex);
                }
            }
            this.init_state = 1;
            this.init_thread = Thread.currentThread();
        }
        try {
            EvaluationContext ctx = this.getContext(elctx);
            if (this.cdef.base != null) {
                this.basecls = ELEngine.resolveClass(ctx, this.cdef.base);
            }
            if (this.cdef.ifaces != null) {
                this.interfaces = new Class[this.cdef.ifaces.length];
                for (int i = 0; i < this.interfaces.length; ++i) {
                    this.interfaces[i] = ELEngine.resolveJavaClass(elctx, this.cdef.ifaces[i]);
                    if (this.interfaces[i].isInterface()) continue;
                    throw new EvaluationException(elctx, "interface expected: " + this.cdef.ifaces[i]);
                }
            }
            if (this.basecls instanceof ClassDefinition) {
                ClassDefinition base = (ClassDefinition)this.basecls;
                if (base.isFinal()) {
                    throw new EvaluationException(elctx, Resources._T("EL_SUBCLASS_FINAL", this.cdef.base));
                }
                base.init(elctx);
            } else if (this.basecls != null && this.basecls != Object.class) {
                Class base = (Class)this.basecls;
                if (base.isInterface()) {
                    if (this.interfaces != null) {
                        throw new EvaluationException(elctx, "class expected: " + this.cdef.base);
                    }
                    this.basecls = null;
                    this.interfaces = new Class[]{base};
                } else if (Modifier.isFinal(base.getModifiers())) {
                    throw new EvaluationException(elctx, Resources._T("EL_SUBCLASS_FINAL", this.cdef.base));
                }
            } else {
                this.basecls = null;
            }
            if (this.cdef.cvars.length == 0) {
                ClassDefinition base = this;
                synchronized (base) {
                    this.init_state = 2;
                    this.init_thread = null;
                    this.notify();
                    return;
                }
            }
            this.cvmap = new VariableMapperImpl();
            this.cvmap.setVariable(this.cdef.id, (ValueExpression)this);
            for (ELNode.DEFINE def : this.cdef.cvars) {
                Closure cvar = def.defineClosure(this.env);
                cvar._setenv(elctx, new ClassEnvironment(this));
                this.cvmap.setVariable(def.id, (ValueExpression)cvar);
            }
            Closure clinit = (Closure)this.cvmap.resolveVariable(CLINIT_PROC);
            if (clinit != null) {
                clinit.call(elctx, new Object[0]);
                this.cvmap.setVariable(CLINIT_PROC, null);
            }
        }
        catch (Throwable ex) {
            ClassDefinition classDefinition2 = this;
            synchronized (classDefinition2) {
                this.cvmap = null;
                this.basecls = null;
                this.interfaces = null;
                this.init_state = 0;
                this.init_thread = null;
                this.notify();
                throw new ExceptionInInitializerError(ex);
            }
        }
        classDefinition = this;
        synchronized (classDefinition) {
            this.init_state = 2;
            this.init_thread = null;
            this.notify();
        }
    }

    @Override
    public EvaluationContext getContext() {
        return this.env;
    }

    @Override
    public EvaluationContext getContext(ELContext elctx) {
        if (this.env == null) {
            if (elctx == null) {
                elctx = ELEngine.getCurrentELContext();
            }
            this.env = new EvaluationContext(elctx, this.fm, this.vm);
        } else if (elctx != null) {
            this.env.setELContext(elctx);
        }
        return this.env;
    }

    @Override
    public void _setenv(ELContext elctx, VariableMapper env) {
        this.env = this.getContext(elctx).pushContext(env);
    }

    public String getName() {
        return this.cdef.id;
    }

    public ClassDefinition getBaseClass(ELContext elctx) {
        if (this.cdef.base != null) {
            this.init(elctx);
            if (this.basecls instanceof ClassDefinition) {
                return (ClassDefinition)this.basecls;
            }
        }
        return null;
    }

    public boolean isAssignableFrom(ELContext elctx, ClassDefinition cls) {
        while (cls != null) {
            if (cls.equals(this)) {
                return true;
            }
            cls = cls.getBaseClass(elctx);
        }
        return false;
    }

    public boolean isInstance(ELContext elctx, Object obj) {
        if (obj instanceof ClosureObject) {
            return this.isAssignableFrom(elctx, ((ClosureObject)obj).get_class());
        }
        return false;
    }

    public void attach(String name, Closure closure) {
        this.expando.put(name, closure);
    }

    public void detach(String name) {
        this.expando.remove(name);
    }

    public Closure getExpandoClosure(String name) {
        return this.expando.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object _new(ELContext elctx, Closure ... args) {
        if (this.getAnnotation("Singleton") != null) {
            ClassDefinition classDefinition = this;
            synchronized (classDefinition) {
                if (this.singleton == null) {
                    this.singleton = this.newInstance(elctx, args);
                }
                return this.singleton;
            }
        }
        return this.newInstance(elctx, args);
    }

    private Object newInstance(ELContext elctx, Closure[] args) {
        this.init(elctx);
        ThisObject thisObj = this.createThisObject(elctx, this);
        DefaultClosureObject outer = new DefaultClosureObject(thisObj);
        thisObj.setOwner(outer);
        thisObj.init(elctx, args);
        return thisObj.createProxy(elctx);
    }

    private ThisObject createThisObject(ELContext elctx, ClassDefinition orig) {
        StackTrace.addFrame(elctx, this.cdef.id, this.cdef.file, this.cdef.pos);
        try {
            EvaluationContext ctx = this.getContext(elctx);
            ThisObject baseObj = null;
            if (this.basecls instanceof ClassDefinition) {
                if (orig.equals(this.basecls)) {
                    throw new EvaluationException(elctx, Resources._T("EL_CIRCULAR_CLASS_DEFINITION"));
                }
                baseObj = ((ClassDefinition)this.basecls).createThisObject(elctx, orig);
            }
            LinkedHashMap<String, Closure> vmap = new LinkedHashMap<String, Closure>();
            for (ELNode.DEFINE def : this.cdef.ivars) {
                vmap.put(def.id, def.defineClosure(ctx));
            }
            this.addMixins(elctx, vmap);
            ThisObject thisObj = baseObj != null ? new DerivedThisObject(elctx, this, vmap, baseObj) : (this.basecls != null ? new ProxiedThisObject(elctx, this, vmap, (Class)this.basecls) : new BasicThisObject(elctx, this, vmap));
            if (this.interfaces != null) {
                for (Class c : this.interfaces) {
                    thisObj.addInterface(c);
                }
            }
            this.initialize(thisObj);
            Closure[] delegates = this.getDelegates(vmap);
            if (delegates != null) {
                thisObj = new DelegatedThisObject(thisObj, delegates);
            }
            BasicThisObject basicThisObject = thisObj;
            return basicThisObject;
        }
        catch (EvaluationException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw new EvaluationException(elctx, ex);
        }
        finally {
            StackTrace.removeFrame(elctx);
        }
    }

    private void addMixins(ELContext elctx, Map<String, Closure> vmap) {
        for (Annotation at : this.getAnnotations()) {
            if (!at.getAnnotationType().equals("Mixin")) continue;
            Object value = at.getAttribute("value");
            if (value instanceof List) {
                for (Object e : (List)value) {
                    this.mixin(elctx, e, null, vmap);
                }
                continue;
            }
            if (value == null) continue;
            Map rename = (Map)at.getAttribute("rename");
            this.mixin(elctx, value, rename, vmap);
        }
    }

    private void mixin(ELContext elctx, Object obj, Map rename, Map<String, Closure> vmap) {
        ClosureObject mixin;
        if (obj instanceof ClosureObject) {
            mixin = (ClosureObject)obj;
        } else if (obj instanceof ClassDefinition) {
            mixin = (ClosureObject)((ClassDefinition)obj)._new(elctx, new Closure[0]);
        } else {
            throw new EvaluationException(elctx, "Invalid mixin object: " + obj);
        }
        for (Map.Entry<String, Closure> e : mixin.get_closures(elctx).entrySet()) {
            String name = e.getKey();
            if (rename != null && rename.containsKey(name) && (name = (String)rename.get(name)) == null || vmap.containsKey(name)) continue;
            vmap.put(name, e.getValue());
        }
    }

    private Closure[] getDelegates(Map<String, Closure> vmap) {
        ArrayList<Closure> delegates = null;
        for (Closure c : vmap.values()) {
            if (!c.isAnnotationPresent("delegate")) continue;
            if (delegates == null) {
                delegates = new ArrayList<Closure>();
            }
            delegates.add(c);
        }
        if (delegates == null) {
            return null;
        }
        return delegates.toArray(new Closure[delegates.size()]);
    }

    private void initialize(ThisObject thisObj) {
        Map<String, Closure> vmap = thisObj.getClosureMap();
        Closure initproc = vmap.get(this.cdef.id);
        if (this.cdef.vars != null) {
            initproc = new InitProc(thisObj, initproc);
        }
        if (initproc != null) {
            vmap.put(INIT_PROC, initproc);
            vmap.remove(this.cdef.id);
        }
        if (vmap.containsKey("==") && !vmap.containsKey("equals")) {
            vmap.put("equals", vmap.get("=="));
        }
        if (this.cdef.vars != null) {
            if (!vmap.containsKey("toString")) {
                vmap.put("toString", new ToStringProc(thisObj));
            }
            if (!vmap.containsKey("equals")) {
                vmap.put("equals", new EqualsProc(thisObj));
            }
            if (!vmap.containsKey("hashCode")) {
                vmap.put("hashCode", new HashCodeProc(thisObj));
            }
        }
        if (vmap.containsKey("equals") && vmap.containsKey("<") && !vmap.containsKey("compareTo")) {
            thisObj.addInterface(Comparable.class);
            vmap.put("compareTo", new CompareToProc(thisObj));
        }
    }

    public boolean matches(EvaluationContext context, Object obj, ELNode[] args, String[] keys) {
        ELContext elctx = context.getELContext();
        ELNode.DEFINE[] vars = this.cdef.vars;
        int argc = args.length;
        if (!this.isInstance(elctx, obj)) {
            return false;
        }
        if (argc == 0) {
            return true;
        }
        if (keys == null && (vars == null || vars.length != argc)) {
            return false;
        }
        ClosureObject thiz = ((ClosureObject)obj).get_this();
        if (keys != null) {
            for (int i = 0; i < argc; ++i) {
                if (ClassDefinition.isWildcard(args[i])) continue;
                Closure c = thiz.get_closure(elctx, keys[i]);
                if (c == null) {
                    return false;
                }
                if (((ELNode.Pattern)((Object)args[i])).matches(context, c.getValue(elctx))) continue;
                return false;
            }
        } else {
            for (int i = 0; i < argc; ++i) {
                Object value;
                if (ClassDefinition.isWildcard(args[i]) || ((ELNode.Pattern)((Object)args[i])).matches(context, value = thiz.get_closure(elctx, vars[i].id).getValue(elctx))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isWildcard(ELNode pattern) {
        if (pattern instanceof ELNode.DEFINE) {
            ELNode.DEFINE var = (ELNode.DEFINE)pattern;
            return "_".equals(var.id) && var.type == null && var.expr == null;
        }
        return false;
    }

    public Closure getClosure(ELContext elctx, String name) {
        this.init(elctx);
        for (ClassDefinition cdef = this; cdef != null; cdef = cdef.getBaseClass(elctx)) {
            Closure c;
            if (cdef.cvmap == null || (c = (Closure)cdef.cvmap.resolveVariable(name)) == null || !c.isPublic()) continue;
            return c;
        }
        return null;
    }

    protected Closure getPrivateClosure(ELContext elctx, String name) {
        Closure c;
        if (this.cvmap != null && (c = (Closure)this.cvmap.resolveVariable(name)) != null) {
            return c;
        }
        ClassDefinition base = this;
        while ((base = base.getBaseClass(elctx)) != null) {
            Closure c2;
            if (base.cvmap == null || (c2 = (Closure)base.cvmap.resolveVariable(name)) == null || c2.isPrivate()) continue;
            return c2;
        }
        return null;
    }

    @Override
    public Object getValue(ELContext elctx, Object property) {
        Closure c;
        if (property instanceof String && (c = this.getClosure(elctx, (String)property)) != null) {
            Object r = c.getValue(elctx);
            elctx.setPropertyResolved(true);
            return r;
        }
        return null;
    }

    @Override
    public Class<?> getType(ELContext elctx, Object property) {
        Closure c;
        if (property instanceof String && (c = this.getClosure(elctx, (String)property)) != null) {
            Class r = c.getType(elctx);
            elctx.setPropertyResolved(true);
            return r;
        }
        return null;
    }

    @Override
    public void setValue(ELContext elctx, Object property, Object value) {
        Closure c;
        if (property instanceof String && (c = this.getClosure(elctx, (String)property)) != null) {
            c.setValue(elctx, value);
            elctx.setPropertyResolved(true);
        }
    }

    @Override
    public boolean isReadOnly(ELContext elctx, Object property) {
        Closure c;
        if (property instanceof String && (c = this.getClosure(elctx, (String)property)) != null) {
            boolean r = c.isReadOnly(elctx);
            elctx.setPropertyResolved(true);
            return r;
        }
        return false;
    }

    @Override
    public MethodInfo getMethodInfo(ELContext elctx, String name) {
        Closure c = this.getClosure(elctx, name);
        if (c != null) {
            return c.getMethodInfo(elctx);
        }
        throw new EvaluationException(elctx, Resources._T("EL_METHOD_NOT_FOUND", this.cdef.id, name));
    }

    @Override
    public Object invoke(ELContext elctx, String name, Closure[] args) {
        Closure proc = this.getClosure(elctx, name);
        if (proc != null) {
            return this.invokeInScope(elctx, proc, args);
        }
        throw new EvaluationException(elctx, Resources._T("EL_METHOD_NOT_FOUND", this.cdef.id, name));
    }

    @Override
    public Object invoke(ELContext elctx, Closure[] args) {
        Closure proc = this.getClosure(elctx, "valueOf");
        if (proc != null) {
            return this.invokeInScope(elctx, proc, args);
        }
        return this._new(elctx, args);
    }

    @Override
    public int arity(ELContext elctx) {
        Closure proc = this.getClosure(elctx, "valueOf");
        if (proc != null) {
            return proc.arity(elctx);
        }
        if (this.cdef.vars != null) {
            return this.cdef.vars.length;
        }
        return -1;
    }

    @Override
    public MethodInfo getMethodInfo(ELContext elctx) {
        Closure proc = this.getClosure(elctx, "valueOf");
        if (proc != null) {
            return proc.getMethodInfo(elctx);
        }
        if (this.cdef.vars != null) {
            Object[] args = new Class[this.cdef.vars.length];
            Arrays.fill(args, Object.class);
            return new MethodInfo("valueOf", Object.class, (Class[])args);
        }
        throw new EvaluationException(elctx, Resources._T("EL_METHOD_NOT_FOUND", this.cdef.id, "valueOf"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeInScope(ELContext elctx, Closure proc, Closure[] args) {
        if (proc instanceof BasicThisObject.ExpandoClosure) {
            return proc.invoke(elctx, args);
        }
        for (Closure c : args) {
            Object value;
            if (!(c instanceof DelayClosure) || !((value = c.getValue(elctx)) instanceof ELNode.VarArgList)) continue;
            ((ELNode.VarArgList)value).force(elctx);
        }
        ClassDefinition[] scope = invoke_scope.get();
        ClassDefinition prev = scope[0];
        scope[0] = this;
        try {
            Object object = proc.invoke(elctx, args);
            return object;
        }
        finally {
            scope[0] = prev;
        }
    }

    public boolean inScope(ELContext elctx) {
        ClassDefinition scope = invoke_scope.get()[0];
        if (scope == null) {
            return false;
        }
        if (scope == this) {
            return true;
        }
        return scope.isAssignableFrom(elctx, this);
    }

    public Object getValue(ELContext context) {
        return this;
    }

    public void setValue(ELContext context, Object value) {
        throw new PropertyNotWritableException();
    }

    public boolean isReadOnly(ELContext context) {
        return true;
    }

    public Class<?> getType(ELContext context) {
        return ClassDefinition.class;
    }

    public Class<?> getExpectedType() {
        return ClassDefinition.class;
    }

    public String getExpressionString() {
        return null;
    }

    public boolean isLiteralText() {
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ClassDefinition) {
            ClassDefinition other = (ClassDefinition)obj;
            return this.cdef == other.cdef;
        }
        return false;
    }

    public int hashCode() {
        return this.cdef.hashCode();
    }

    public String toString() {
        return "#<class:" + this.cdef.id + ">";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.env != null) {
            this.vm = VariableMapperBuilder.build(this.env, this.cdef);
        }
        out.defaultWriteObject();
    }

    private static class VariableMapperBuilder
    extends VariableMapper {
        EvaluationContext source;
        VariableMapper target;

        private VariableMapperBuilder(EvaluationContext source) {
            this.source = source;
        }

        public ValueExpression resolveVariable(String name) {
            ValueExpression value = this.source.resolveVariable(name);
            if (value != null) {
                if (this.target == null) {
                    this.target = new VariableMapperImpl();
                }
                this.target.setVariable(name, value);
            }
            return value;
        }

        public ValueExpression setVariable(String name, ValueExpression value) {
            throw new IllegalStateException();
        }

        public static VariableMapper build(EvaluationContext context, ELNode node) {
            VariableMapperBuilder vmb = new VariableMapperBuilder(context);
            node.applyVariableMapper(vmb);
            return vmb.target;
        }
    }

    static class ClassEnvironment
    extends VariableMapper {
        protected ClassDefinition cdef;

        ClassEnvironment(ClassDefinition cdef) {
            this.cdef = cdef;
        }

        public ValueExpression resolveVariable(String name) {
            ELContext elctx = this.cdef.getContext().getELContext();
            return this.cdef.getPrivateClosure(elctx, name);
        }

        public ValueExpression setVariable(String name, ValueExpression value) {
            return null;
        }
    }

    private static class CompareToProc
    extends AbstractClosure {
        private ThisObject thiz;

        CompareToProc(ThisObject obj) {
            this.thiz = obj;
        }

        public Object invoke(ELContext elctx, Closure[] args) {
            if (TypeCoercion.coerceToBoolean(this.thiz.invokePublic(elctx, "equals", args)).booleanValue()) {
                return 0;
            }
            if (TypeCoercion.coerceToBoolean(this.thiz.invokePublic(elctx, "<", args)).booleanValue()) {
                return -1;
            }
            return 1;
        }

        public int arity(ELContext elctx) {
            return 1;
        }

        public boolean isProcedure() {
            return true;
        }

        public String toString() {
            return "#<procedure:compareTo>";
        }
    }

    private static class HashCodeProc
    extends AbstractClosure {
        private ThisObject thiz;

        HashCodeProc(ThisObject obj) {
            this.thiz = obj;
        }

        public Object invoke(ELContext elctx, Closure[] args) {
            if (args.length != 0) {
                throw new EvaluationException(elctx, Resources._T("EL_FN_BAD_ARG_COUNT", "hashCode", 0, args.length));
            }
            int hash = 0;
            for (ELNode.DEFINE var : ((ClassDefinition)this.thiz.get_class()).cdef.vars) {
                Object value = this.thiz.get_closure(elctx, var.id).getValue(elctx);
                hash = 31 * hash + (value == null ? 0 : value.hashCode());
            }
            return hash;
        }

        public int arity(ELContext elctx) {
            return 0;
        }

        public boolean isProcedure() {
            return true;
        }

        public String toString() {
            return "#<procedure:hashCode>";
        }
    }

    private static class EqualsProc
    extends AbstractClosure {
        private ThisObject thiz;

        EqualsProc(ThisObject obj) {
            this.thiz = obj;
        }

        public Object invoke(ELContext elctx, Closure[] args) {
            Object obj;
            if (args.length != 1) {
                throw new EvaluationException(elctx, Resources._T("EL_FN_BAD_ARG_COUNT", "equals", 1, args.length));
            }
            ClassDefinition cls = this.thiz.get_class();
            if (!cls.isInstance(elctx, obj = args[0].getValue(elctx))) {
                return Boolean.FALSE;
            }
            ClosureObject that = ((ClosureObject)obj).get_this();
            for (ELNode.DEFINE var : ((ClassDefinition)cls).cdef.vars) {
                Object v2;
                Object v1 = this.thiz.get_closure(elctx, var.id).getValue(elctx);
                if (ELNode.EQ.equals(elctx, v1, v2 = that.get_closure(elctx, var.id).getValue(elctx))) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }

        public int arity(ELContext elctx) {
            return 1;
        }

        public boolean isProcedure() {
            return true;
        }

        public String toString() {
            return "#<procedure:equals>";
        }
    }

    private static class ToStringProc
    extends AbstractClosure {
        private ThisObject thiz;

        ToStringProc(ThisObject obj) {
            this.thiz = obj;
        }

        public Object invoke(ELContext elctx, Closure[] args) {
            if (args.length != 0) {
                throw new EvaluationException(elctx, Resources._T("EL_FN_BAD_ARG_COUNT", "toString", 0, args.length));
            }
            ClassDefinition cls = this.thiz.get_class();
            ELNode.DEFINE[] vars = ((ClassDefinition)cls).cdef.vars;
            StringBuilder buf = new StringBuilder();
            buf.append(((ClassDefinition)cls).cdef.id);
            buf.append("(");
            for (int i = 0; i < vars.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(vars[i].id);
                buf.append("=");
                Object value = this.thiz.get_closure(elctx, vars[i].id).getValue(elctx);
                if (value instanceof String) {
                    TypeCoercion.escape(buf, (String)value);
                    continue;
                }
                buf.append(TypeCoercion.coerceToString(value));
            }
            buf.append(")");
            return buf.toString();
        }

        public int arity(ELContext elctx) {
            return 0;
        }

        public boolean isProcedure() {
            return true;
        }

        public String toString() {
            return "#<procedure:toString>";
        }
    }

    private static class InitProc
    extends AbstractClosure {
        private ThisObject obj;
        private Closure init;

        InitProc(ThisObject obj, Closure init) {
            this.obj = obj;
            this.init = init;
        }

        public Object invoke(ELContext elctx, Closure[] args) {
            ClassDefinition cls = this.obj.get_class();
            StackTrace.addFrame(elctx, ((ClassDefinition)cls).cdef.id + ".__init__", ((ClassDefinition)cls).cdef.file, ((ClassDefinition)cls).cdef.pos);
            try {
                EvaluationContext ctx = cls.getContext(elctx);
                ELNode.DEFINE[] vars = ((ClassDefinition)cls).cdef.vars;
                int argc = args.length;
                int nvars = vars.length;
                Closure[] xargs = null;
                if (argc < nvars) {
                    xargs = new Closure[nvars];
                } else if (argc > nvars) {
                    throw new EvaluationException(elctx, Resources._T("EL_FN_BAD_ARG_COUNT", ((ClassDefinition)cls).cdef.id, nvars, argc));
                }
                for (int i = 0; i < argc; ++i) {
                    if (!(args[i] instanceof NamedClosure)) continue;
                    NamedClosure c = (NamedClosure)args[i];
                    int j = InitProc.indexOfVar(c.name(), vars);
                    if (j == -1) {
                        throw new EvaluationException(elctx, Resources._T("EL_UNKNOWN_ARG_NAME", c.name()));
                    }
                    if (xargs == null) {
                        xargs = new Closure[argc];
                    }
                    xargs[j] = c.getDelegate();
                }
                if (xargs != null) {
                    int j = 0;
                    for (int i = 0; i < argc; ++i) {
                        if (args[i] instanceof NamedClosure) continue;
                        while (xargs[j] != null) {
                            ++j;
                        }
                        xargs[j++] = args[i];
                    }
                    args = xargs;
                }
                Map<String, Closure> vmap = this.obj.getClosureMap();
                for (int i = 0; i < nvars; ++i) {
                    Object val;
                    if (args[i] != null) {
                        val = args[i].getValue(elctx);
                    } else if (vars[i].expr != null) {
                        val = vars[i].expr.getValue(ctx);
                    } else {
                        throw new EvaluationException(elctx, Resources._T("EL_MISSING_ARG_VALUE", vars[i].id));
                    }
                    vmap.put(vars[i].id, vars[i].defineClosure(ctx, val));
                }
                if (this.init != null) {
                    this.init.call(elctx, new Object[0]);
                }
                vmap.remove(ClassDefinition.INIT_PROC);
                Object var10_16 = null;
                return var10_16;
            }
            catch (EvaluationException ex) {
                throw ex;
            }
            catch (RuntimeException ex) {
                throw new EvaluationException(elctx, ex);
            }
            finally {
                StackTrace.removeFrame(elctx);
            }
        }

        public int arity(ELContext elctx) {
            return ((ClassDefinition)this.obj.get_class()).cdef.vars.length;
        }

        private static int indexOfVar(String name, ELNode.DEFINE[] vars) {
            for (int i = 0; i < vars.length; ++i) {
                if (!name.equals(vars[i].id)) continue;
                return i;
            }
            return -1;
        }
    }
}

